/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ZAF.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.List;

public class ZAFStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private int ZAF_areaSubTryCount;

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean flag = super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList);
        if (!flag && this.m_areaSubTryCount > 27) {
            boolean separateAreaFields = parsedAddress.isSeparateAreaFields();
            List<DictionaryAreaTermItem> areaList = null;
            switch (this.ZAF_areaSubTryCount) {
                case 0: {
                    AddressWord[] lookUpAreaWords;
                    ++this.ZAF_areaSubTryCount;
                    if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                        lookUpAreaWords = null;
                        lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.85, dataManager, options);
                    }
                    if (this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                        lookUpAreaWords = null;
                        lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.85, dataManager, options);
                    }
                    if (this.isSacSearchableField(FieldType.POST_CODE_FIELD_TYPE)) {
                        this.findPCAreaList(dataManager, parsedAddress, false, options);
                    }
                    flag = true;
                    break;
                }
                case 1: {
                    ++this.ZAF_areaSubTryCount;
                    if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                    AddressWord[] lookUpAreaWords = null;
                    if (separateAreaFields) {
                        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                        if (words == null || words.length == 0) {
                            words = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                        }
                        lookUpAreaWords = this.getSplitWords(words);
                    } else {
                        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        lookUpAreaWords = this.getSplitWords(words);
                    }
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                    break;
                }
                case 2: {
                    ++this.ZAF_areaSubTryCount;
                    if (!this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) break;
                    AddressWord[] lookUpAreaWords = null;
                    if (separateAreaFields) {
                        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                        lookUpAreaWords = this.getCombinedPossibles(words);
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                        if (areaList != null) break;
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                        break;
                    }
                    AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    lookUpAreaWords = this.getCombinedPossibles(words);
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                    if (areaList != null) break;
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                    break;
                }
                case 3: {
                    ++this.ZAF_areaSubTryCount;
                    if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                    AddressWord[] lookUpAreaWords = null;
                    if (separateAreaFields) {
                        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                        lookUpAreaWords = this.getCombinedPossibles(words);
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                        if (areaList != null) break;
                        areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                        break;
                    }
                    AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    lookUpAreaWords = this.getCombinedPossibles(words);
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                    if (areaList != null) break;
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, this.getMinimumAreaSearchQuality(), dataManager, options);
                    break;
                }
                default: {
                    flag = false;
                }
            }
            if (areaList != null && areaList.size() > 0) {
                this.setSearchAreaList(areaList);
                flag = true;
            }
        }
        return flag;
    }
}

