/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;

public class AddressNumberScore
extends FieldScore {
    public static final int OFFSET_TO_START = 1;
    public static final int OFFSET_TO_END = 2;
    private AddressNumber m_inputAddressNumber;
    private AddressNumber m_candAddressNumber;
    private int m_offset;
    private boolean m_number1Matched;
    private boolean m_suffix1Matched;
    private boolean m_number2Matched;
    private boolean m_suffix2Matched;
    private int m_offsetPosition;
    private boolean m_typeMatched;
    private boolean m_matchedWithPreferredInputNumber;
    private int maxAddressNumberOffset = 0;

    public boolean isMatched() {
        return this.m_matched;
    }

    public void setMatched(boolean matched) {
        this.m_matched = matched;
    }

    public boolean isTypeMatch() {
        return this.m_typeMatched;
    }

    public void setTypeMatch(boolean matched) {
        this.m_typeMatched = matched;
    }

    public AddressNumber getInputAddressNumber() {
        return this.m_inputAddressNumber;
    }

    public void setInputAddressNumber(AddressNumber addressNumber) {
        this.m_inputAddressNumber = addressNumber;
    }

    public AddressNumber getCandidateAddressNumber() {
        return this.m_candAddressNumber;
    }

    public void setCandidateAddressNumber(AddressNumber addrNum) {
        this.m_candAddressNumber = addrNum;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public boolean isNumber1Matched() {
        return this.m_number1Matched;
    }

    public void setNumber1Matched(boolean matched) {
        this.m_number1Matched = matched;
    }

    public boolean isSuffix1Matched() {
        return this.m_suffix1Matched;
    }

    public void setSuffix1Matched(boolean matched) {
        this.m_suffix1Matched = matched;
    }

    public boolean isNumber2Matched() {
        return this.m_number2Matched;
    }

    public void setNumber2Matched(boolean matched) {
        this.m_number2Matched = matched;
    }

    public boolean isSuffix2Matched() {
        return this.m_suffix2Matched;
    }

    public void setSuffix2Matched(boolean matched) {
        this.m_suffix2Matched = matched;
    }

    public void setMatchedWithPreferredInputNumber(boolean b) {
        this.m_matchedWithPreferredInputNumber = b;
    }

    public boolean isMatchedWithPreferredInputNumber() {
        return this.m_matchedWithPreferredInputNumber;
    }

    @Override
    public int compareTo(FieldScore other) {
        if (!(other instanceof AddressNumberScore)) {
            return super.compareTo(other);
        }
        return this.compare(this, (AddressNumberScore)other);
    }

    @Override
    public int compare(AddressNumberScore o1, AddressNumberScore o2) {
        if (o1.m_matched == o2.m_matched) {
            if (o1.m_matched) {
                if (o1.m_number1Matched != o2.m_number1Matched) {
                    if (o1.m_number1Matched) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.m_number2Matched != o2.m_number2Matched) {
                    if (o1.m_number2Matched) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.m_suffix1Matched != o2.m_suffix1Matched) {
                    if (o1.m_suffix1Matched) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.m_suffix2Matched != o2.m_suffix2Matched) {
                    if (o1.m_suffix2Matched) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.m_matchedWithPreferredInputNumber != o2.m_matchedWithPreferredInputNumber) {
                    if (o1.m_matchedWithPreferredInputNumber) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (o1.isTypeMatch() != o2.isTypeMatch()) {
                if (o1.isTypeMatch()) {
                    return 1;
                }
                return -1;
            }
            if (o1.m_offset > 0 && o2.m_offset > 0) {
                return o2.m_offset - o1.m_offset;
            }
            if (o1.m_offset > 0) {
                return 1;
            }
            if (o2.m_offset > 0) {
                return -1;
            }
            return 0;
        }
        if (o1.m_matched) {
            return 1;
        }
        return -1;
    }

    public void setOffsetPosition(int pos) {
        this.m_offsetPosition = pos;
    }

    public int getOffsetPosition() {
        return this.m_offsetPosition;
    }

    public double calculateAndSetScoreValue(MatchingOptions matchingOptions) {
        double score = 0.0;
        if (this.isMatched()) {
            score = 1.0;
        } else {
            int offset = this.getOffset();
            if (this.isTypeMatch()) {
                score += 0.46;
            }
            if (offset > 0) {
                this.maxAddressNumberOffset = matchingOptions.getMaxAddressNumberOffsetAllowed();
                double maxOffsetAllowed = this.maxAddressNumberOffset;
                if (maxOffsetAllowed > 0.0 && (double)offset < maxOffsetAllowed) {
                    double d = (maxOffsetAllowed - (double)offset) / maxOffsetAllowed;
                    score += d * 0.45;
                }
            }
        }
        this.m_value = score;
        return score;
    }

    public int getMaxAddressNumberOffset() {
        return this.maxAddressNumberOffset;
    }

    @Override
    public int matchedCandidateWordCount() {
        return this.perfectCandidateWordCount();
    }

    @Override
    public int candidateWordCount() {
        if (this.m_candAddressNumber != null) {
            int wordCount = 0;
            if (this.m_candAddressNumber.getHnrNumber1() > 0) {
                ++wordCount;
            }
            if (this.m_candAddressNumber.getHnrSuffix1() != null) {
                ++wordCount;
            }
            if (this.m_candAddressNumber.getHnrNumber2() > 0) {
                ++wordCount;
            }
            if (this.m_candAddressNumber.getHnrSuffix2() != null) {
                ++wordCount;
            }
            return wordCount;
        }
        return this.m_candidateFieldPresent ? 1 : 0;
    }

    @Override
    public int perfectCandidateWordCount() {
        if (this.m_candAddressNumber != null) {
            int wordCount = 0;
            if (this.isNumber1Matched()) {
                ++wordCount;
            }
            if (this.isSuffix1Matched()) {
                ++wordCount;
            }
            if (this.isNumber2Matched()) {
                ++wordCount;
            }
            if (this.isSuffix2Matched()) {
                ++wordCount;
            }
            return wordCount;
        }
        return this.m_matched ? 1 : 0;
    }

    @Override
    public void resetFieldMatch() {
        super.resetFieldMatch();
        this.m_offset = 0;
        this.m_number1Matched = false;
        this.m_suffix1Matched = false;
        this.m_number2Matched = false;
        this.m_suffix2Matched = false;
        this.m_typeMatched = false;
        this.m_matchedWithPreferredInputNumber = false;
    }
}

