/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CGGECandidateFilter
extends DatasetInfoComponent
implements ICGGECandidateFilter {
    private String m_country;
    private String m_language;
    private double m_candidateCutoff;
    private double m_streetCutoff;
    private double m_postalCutoff;
    private double m_relativeCutoff;
    private static final String KEY_CAND_CUTOFF = "candidate_minimum_quality";
    private static final String KEY_RELATIVE_CUTOFF = "candidate_relative_minimum_quality";
    private static final String KEY_STREET_CUTOFF = "street_minimum_quality";
    private static final String KEY_POSTAL_CUTOFF = "postal_minimum_quality";
    private static final AddressNumberScore UNSCORED_ADDRESS_NUM_SCORE = new AddressNumberScore();
    private HashMap<Integer, CGGECandidateFilter> m_candidateFilterMap;

    private synchronized CGGECandidateFilter getFilter(int type) throws CGGEInternalException {
        CGGECandidateFilter filter = null;
        if (this.m_candidateFilterMap != null) {
            filter = this.m_candidateFilterMap.get(type);
        }
        if (filter == null) {
            String typeName = GeocodeOptions.getGeocodeTypeName(type);
            Properties prop = this.getConfiguration(this.m_country, this.m_language, "_CandidateFilterSettings", typeName, null);
            filter = new CGGECandidateFilter();
            filter.m_candidateCutoff = PropertiesUtil.getDoublePropetyValue(prop, KEY_CAND_CUTOFF);
            filter.m_relativeCutoff = PropertiesUtil.getDoublePropetyValue(prop, KEY_RELATIVE_CUTOFF);
            filter.m_streetCutoff = PropertiesUtil.getDoublePropetyValue(prop, KEY_STREET_CUTOFF);
            filter.m_postalCutoff = PropertiesUtil.getDoublePropetyValue(prop, KEY_POSTAL_CUTOFF);
            if (this.m_candidateFilterMap == null) {
                this.m_candidateFilterMap = new HashMap(3);
            }
            this.m_candidateFilterMap.put(type, filter);
        }
        return filter;
    }

    protected void filterIntersectionCandidates(InternalCandidateList candList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        int candSize;
        int n = candSize = candList != null ? candList.getCandidateCount() : 0;
        if (candSize > 1) {
            List<InternalScoringAddress> cands = candList.getCandidateList();
            InternalScoringAddress firstCand = cands.get(0);
            for (int candNdx = 1; candNdx < cands.size(); ++candNdx) {
                InternalScoringAddress cand = cands.get(candNdx);
                if (cand.getCombinedScore() > firstCand.getCombinedScore() || cand.getCombinedPostalScore() > firstCand.getCombinedPostalScore() || cand.getCombinedStreetScore() > firstCand.getCombinedStreetScore() || cand.getCombinedScore() == firstCand.getCombinedScore() && cand.getCombinedPostalScore() == firstCand.getCombinedPostalScore() && cand.getCombinedStreetScore() == firstCand.getCombinedStreetScore()) continue;
                cands.remove(candNdx);
                --candNdx;
            }
            int closeMatches = 0;
            for (int candNdx = 0; candNdx < cands.size(); ++candNdx) {
                if (!cands.get(candNdx).isCloseMatch()) continue;
                ++closeMatches;
            }
            candList.setNumberOfCloseMatches(closeMatches);
        }
    }

    @Override
    public void filterCandidates(InternalCandidateList candList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        int candSize;
        int n = candSize = candList != null ? candList.getCandidateCount() : 0;
        if (candSize > 0) {
            if (addr.isIntersectionCase()) {
                this.filterIntersectionCandidates(candList, addr, options);
            } else {
                CGGECandidateFilter filter = null;
                int type = -1;
                double cutoff = 0.0;
                double relativeCutoff = 0.0;
                double postalCutoff = 0.0;
                double streetCutoff = 0.0;
                double bestScore = 0.0;
                int closeMatchCount = candList.getNumberOfCloseMatches();
                Iterator<InternalScoringAddress> it = candList.getCandidateList().iterator();
                while (it.hasNext()) {
                    InternalScoringAddress candAddr = it.next();
                    if (filter == null || candAddr.getAddressType() != type) {
                        filter = this.getFilter(options.getGeocodeType());
                        type = candAddr.getAddressType();
                        cutoff = filter.m_candidateCutoff;
                        relativeCutoff = filter.m_relativeCutoff;
                        postalCutoff = filter.m_postalCutoff;
                        streetCutoff = filter.m_streetCutoff;
                    }
                    double candCombinedScore = candAddr.getCombinedScore();
                    boolean remove = false;
                    if (candCombinedScore < cutoff) {
                        remove = true;
                    } else if (candAddr.getCombinedStreetScore() < streetCutoff) {
                        remove = true;
                    } else if (candAddr.getCombinedPostalScore() < postalCutoff) {
                        remove = true;
                    } else if (bestScore > 1.0E-4) {
                        if (candCombinedScore < bestScore * relativeCutoff) {
                            remove = true;
                        }
                    } else {
                        bestScore = candAddr.getCombinedScore();
                    }
                    if (!remove) continue;
                    it.remove();
                    if (closeMatchCount <= 0 || !candAddr.isCloseMatch()) continue;
                    --closeMatchCount;
                }
                candList.setNumberOfCloseMatches(closeMatchCount);
            }
        }
    }

    @Override
    public void filterMultipleCCOnDiffDataSets(InternalCandidateList m_candidateList) {
        String firstCandDatasetKey = m_candidateList.getCandidateList().get(0).getDataSetInfo().getDataSetInfoKey();
        for (int i = 1; i < m_candidateList.getCandidateList().size(); ++i) {
            if (!m_candidateList.getCandidateList().get(i).isCloseMatch()) continue;
            String secondCandDatasetKey = m_candidateList.getCandidateList().get(i).getDataSetInfo().getDataSetInfoKey();
            if (firstCandDatasetKey == null || firstCandDatasetKey.equalsIgnoreCase(secondCandDatasetKey)) continue;
            m_candidateList.getCandidateList().get(i).setCloseMatch(false);
            m_candidateList.setNumberOfCloseMatches(m_candidateList.getNumberOfCloseMatches() - 1);
        }
    }

    @Override
    public void filterMultipleCloseCandidates(InternalCandidateList internalCandList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        block10: {
            InternalScoringAddress cand;
            int perfectFields;
            int closeMatchCount;
            boolean intersectionCandidate = addr.isIntersectionCase();
            if (intersectionCandidate && options.getGeocodeType() == 1) break block10;
            int n = closeMatchCount = internalCandList == null ? 0 : internalCandList.getNumberOfCloseMatches();
            if (closeMatchCount <= 1) break block10;
            List<InternalScoringAddress> candList = internalCandList.getCandidateList();
            InternalScoringAddress bestCand = candList.get(0);
            InternalScoringRange bestRange = bestCand.getMatchedRange();
            int prefectFieldsForBest = bestCand.getMatchedFieldCount();
            int prefectWordsForBest = CGGECandidateFilter.perfectWordCount(bestCand);
            AddressNumberScore bestAddressNumScore = this.getNonNullAddressNumberScore(bestRange);
            int bestCandFieldCount = bestCand.getFields() != null ? bestCand.getFields().size() : 0;
            int newCloseMatchCount = 1;
            int candNdx = 1;
            while (candNdx < closeMatchCount && (perfectFields = (cand = candList.get(candNdx)).getMatchedFieldCount()) >= prefectFieldsForBest) {
                block12: {
                    int perfectWords;
                    block11: {
                        if (perfectFields != prefectFieldsForBest) break block11;
                        int addrNumComp = bestAddressNumScore.compareTo(this.getNonNullAddressNumberScore(cand.getMatchedRange()));
                        if (addrNumComp > 0) break;
                        if (addrNumComp < 0) break block12;
                    }
                    if ((perfectWords = CGGECandidateFilter.perfectWordCount(cand)) < prefectWordsForBest) break;
                    if (perfectWords <= prefectWordsForBest) {
                        int c = CGGECandidateFilter.compareWeightsOfMatchedFields(bestCand, cand);
                        if (c > 0) break;
                        if (c >= 0) {
                            int candFieldCount;
                            int n2 = candFieldCount = cand.getFields() != null ? cand.getFields().size() : 0;
                            if (bestCandFieldCount < candFieldCount && !"true".equalsIgnoreCase(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS")) || bestCand.getDictionaryUsagePriority() < cand.getDictionaryUsagePriority()) break;
                        }
                    }
                }
                ++candNdx;
                ++newCloseMatchCount;
            }
            if (newCloseMatchCount < closeMatchCount) {
                for (candNdx = newCloseMatchCount; candNdx < closeMatchCount; ++candNdx) {
                    cand = candList.get(candNdx);
                    cand.setCloseMatch(false);
                }
            }
            internalCandList.setNumberOfCloseMatches(newCloseMatchCount);
            if (addr.isNearByFeature() && internalCandList.getCandidateList().size() > 1) {
                internalCandList.setNumberOfCloseMatches(1);
                for (int i = 1; i < internalCandList.getCandidateList().size(); ++i) {
                    internalCandList.getCandidateList().get(i).setCloseMatch(false);
                }
            }
        }
    }

    private AddressNumberScore getNonNullAddressNumberScore(InternalScoringRange range) {
        AddressNumberScore addrNumScore = range == null ? null : (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        return addrNumScore == null ? UNSCORED_ADDRESS_NUM_SCORE : addrNumScore;
    }

    private static int compareWeightsOfMatchedFields(InternalScoringAddress c1, InternalScoringAddress c2) {
        Comparator<FieldScore> comparator = MMUtils.getReverseComparator(new Comparator<FieldScore>(){

            @Override
            public int compare(FieldScore fs1, FieldScore fs2) {
                if (fs1 != null && fs2 != null) {
                    if (fs1.m_fieldWeight > fs2.m_fieldWeight) {
                        return 1;
                    }
                    if (fs1.m_fieldWeight < fs2.m_fieldWeight) {
                        return -1;
                    }
                    return 0;
                }
                if (fs1 != null) {
                    return 1;
                }
                if (fs2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        Collection<FieldScore> s1 = c1.getFieldScoreList();
        Collection<FieldScore> s2 = c2.getFieldScoreList();
        if (s1 != null && s2 != null) {
            ArrayList<FieldScore> scores1 = new ArrayList<FieldScore>(s1);
            ArrayList<FieldScore> scores2 = new ArrayList<FieldScore>(s2);
            Collections.sort(scores1, comparator);
            Collections.sort(scores2, comparator);
            int size1 = scores1.size();
            int size2 = scores2.size();
            boolean j = false;
            for (int i = 0; i < size1 && i < size2; ++i) {
                FieldScore score1 = (FieldScore)scores1.get(i);
                FieldScore score2 = (FieldScore)scores2.get(i);
                if (score1 == null || score2 == null) continue;
                if (score1.m_fieldWeight > score2.m_fieldWeight) {
                    return 1;
                }
                if (!(score1.m_fieldWeight < score2.m_fieldWeight)) continue;
                return -1;
            }
        } else {
            if (s1 != null) {
                return 1;
            }
            if (s2 != null) {
                return -1;
            }
        }
        return 0;
    }

    private static int perfectWordCount(InternalScoringAddress scoringAddr) {
        InternalScoringRange range;
        int perfectWords = 0;
        Collection<FieldScore> scoreList = scoringAddr.getFieldScoreList();
        if (scoreList != null) {
            for (FieldScore score : scoreList) {
                IntArray perArray;
                if (score == null || (perArray = score.m_perfectInputWords) == null) continue;
                perfectWords += perArray.size();
            }
        }
        if (scoringAddr.getRangeCount() > 0 && (scoreList = (range = scoringAddr.getRangeAt(0)).getFieldScoreList()) != null) {
            for (FieldScore score : scoreList) {
                IntArray perArray;
                if (score == null || (perArray = score.m_perfectInputWords) == null) continue;
                perfectWords += perArray.size();
            }
        }
        return perfectWords;
    }

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        return true;
    }

    @Override
    public double getCandidateCutoff(int geocodeType) throws CGGEInternalException {
        return this.getFilter((int)geocodeType).m_candidateCutoff;
    }

    @Override
    public double getPostalAddressCutoff(int geocodeType) throws CGGEInternalException {
        return this.getFilter((int)geocodeType).m_postalCutoff;
    }

    @Override
    public double getStreetAddressCutoff(int geocodeType) throws CGGEInternalException {
        return this.getFilter((int)geocodeType).m_streetCutoff;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }
}

