/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEGeocodeResult;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.IDataSetComponent;
import com.mapinfo.mapmarker.cgge.IntersectionBuilder;
import com.mapinfo.mapmarker.cgge.ParsedInputAddressBuilder;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataManager;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.ICGGEGeocodingHelper;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.InternalNearByStreetAddress;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class CGGEGeocoder {
    private IDataManager m_dataManager;
    private InputAddress m_inputAddress;
    private InputAddress m_originalInputAddress;
    private InternalCandidateList m_candidateList = null;
    private String m_country;

    public CGGEGeocoder(String country) throws CGGEInternalException {
        try {
            this.init(country);
        }
        catch (Exception e) {
            throw new CGGEInternalException(e);
        }
    }

    void init(String country) throws CGGEDataIntializationException {
        this.m_country = country;
        this.m_candidateList = new InternalCandidateList();
        this.m_dataManager = this.getDataManagerInstance(country);
    }

    IDataManager getDataManagerInstance(String country) throws CGGEDataIntializationException {
        return DataManager.getInstance(country);
    }

    protected static ResourceBundle loadBundleForLocale(IConstraints preferences, String file) {
        if (preferences == null) {
            return MapMarkerResourceLoader.loadForLocale(null, (String)file);
        }
        return MapMarkerResourceLoader.loadForLocale((Locale)preferences.getClientLocale(), (String)file);
    }

    private CGGEGeocodeResult geocodeInternal(GeocodeOptions preferences, int type) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        GeocodeOptions internalOptions;
        this.initCandidateList();
        preferences.setGeocodeType(type);
        CGGEGeocodeResult geocodeResult = new CGGEGeocodeResult();
        Set<ICGGEParser> parserSet = this.getParserSetForSupportedLanguages(type);
        if (this.m_inputAddress != null) {
            this.m_originalInputAddress = new InputAddress();
            this.m_originalInputAddress.copy(this.m_inputAddress);
        }
        for (ICGGEParser parser : parserSet) {
            internalOptions = new GeocodeOptions(preferences);
            this.parseAndFindCandidates(parser, internalOptions);
        }
        if (!this.m_candidateList.hasCloseCandidates() && Boolean.valueOf(preferences.getGeocodeConstraints().getCustomString("CONTAINS_DUAL_ADDRESS", "false")).booleanValue()) {
            preferences.getGeocodeConstraints().setCustomString("TRY_SECONDARY_DUAL_ADDRESS", "true");
            this.m_inputAddress.copy(this.m_originalInputAddress);
            for (ICGGEParser parser : parserSet) {
                internalOptions = new GeocodeOptions(preferences);
                this.parseAndFindCandidates(parser, internalOptions);
            }
        }
        return this.finaliseResult(preferences, parserSet, geocodeResult);
    }

    private void initCandidateList() {
        this.m_candidateList = new InternalCandidateList();
    }

    void setParsedInputAddress(CGGEGeocodeResult geocodeResult, Set<ICGGEParser> parserSet) {
        try {
            ParsedInputAddressBuilder piabuilder = this.getParsedInputAddressBuilder(this.getInputAddress(), this.getCountry(), parserSet);
            geocodeResult.setParsedInput(piabuilder.buildParsedInputAddress(this.getInternalCandidateList()));
        }
        catch (CGGEInternalException e) {
            e.printStackTrace();
        }
    }

    CGGEGeocodeResult finaliseResult(GeocodeOptions preferences, Set<ICGGEParser> parserSet, CGGEGeocodeResult geocodeResult) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        CGGEGeocodeResult fallbackResult;
        InternalCandidateList candidateList = this.getInternalCandidateList();
        if (candidateList.hasCandidates()) {
            this.filterCandidates(candidateList, preferences);
        }
        this.m_candidateList = candidateList;
        this.typeSpecificFinaliseResult(preferences, geocodeResult, parserSet);
        if (candidateList.getNumberOfCloseMatches() == 0 && (fallbackResult = this.checkFallBack(preferences, geocodeResult)) != null) {
            return fallbackResult;
        }
        this.populateGeocodeResult(candidateList, geocodeResult, preferences);
        return geocodeResult;
    }

    InternalCandidateList getInternalCandidateList() {
        return this.m_candidateList;
    }

    private void populateGeocodeResult(InternalCandidateList candidateList, CGGEGeocodeResult geocodeResult, GeocodeOptions preferences) {
        geocodeResult.setGeocodeType(preferences.getGeocodeType());
        geocodeResult.setNumberOfCandidates(candidateList.getCandidateCount());
        geocodeResult.setNumberOfCloseCandidates(candidateList.getNumberOfCloseMatches());
    }

    private CGGEGeocodeResult checkFallBack(GeocodeOptions preferences, CGGEGeocodeResult geocodeResult) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        if (preferences.getGeocodeType() == 1) {
            return this.doFallBack(preferences);
        }
        return null;
    }

    private void typeSpecificFinaliseResult(GeocodeOptions preferences, CGGEGeocodeResult geocodeResult, Set<ICGGEParser> parserSet) {
        if (preferences.isReturnParsedInputAddress() && this.checkValidParserExists(parserSet) && (preferences.getGeocodeType() == 1 || preferences.getGeocodeType() == 4)) {
            this.setParsedInputAddress(geocodeResult, parserSet);
            IConstraints constraints = preferences.getGeocodeConstraints();
            if (constraints != null && Boolean.valueOf(constraints.getCustomString("CONTAINS_DUAL_ADDRESS", "false")).booleanValue()) {
                if (Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
                    geocodeResult.getParsedInput().getAdditionalFields().put("DualAddressParsedStreet", constraints.getCustomString("DualAddressParsedStreet"));
                } else {
                    geocodeResult.getParsedInput().getAdditionalFields().put("DualAddressParsedPOBox", constraints.getCustomString("DualAddressParsedPOBox"));
                }
            }
        }
        if (preferences.getGeocodeType() == 1 && this.checkValidParserExists(parserSet)) {
            this.setHnrForS4Results(preferences, geocodeResult, parserSet);
        }
    }

    private boolean checkValidParserExists(Set<ICGGEParser> parserSet) {
        boolean validParserExists = false;
        if (parserSet != null && !parserSet.isEmpty()) {
            validParserExists = true;
        }
        return validParserExists;
    }

    void setHnrForS4Results(GeocodeOptions preferences, CGGEGeocodeResult geocodeResult, Set<ICGGEParser> parserSet) {
        InternalCandidateList candidateList = this.getInternalCandidateList();
        if (InternalCandidateList.isEmpty(candidateList)) {
            return;
        }
        try {
            String hnr;
            ParsedInputAddressBuilder piaBuilder = this.getParsedInputAddressBuilder(this.getInputAddress(), this.getCountry(), parserSet);
            ParsedInputAddress pia = geocodeResult.getParsedInput();
            if (pia == null) {
                pia = piaBuilder.buildParsedInputAddressForHNROnly(candidateList);
            }
            if (pia != null && (hnr = piaBuilder.getInputHNR(pia)) != null) {
                preferences.setProperty("S4_INPUT_HOUSE_NUMBER", hnr);
            }
        }
        catch (CGGEInternalException e) {
            e.printStackTrace();
        }
    }

    String getCountry() {
        return this.m_country;
    }

    ParsedInputAddressBuilder getParsedInputAddressBuilder(InputAddress inputAddress, String country, Set<ICGGEParser> parserSet) throws CGGEInternalException {
        return new ParsedInputAddressBuilder(inputAddress, country, parserSet);
    }

    void filterCandidates(InternalCandidateList candidateList, GeocodeOptions preferences) throws CGGERuntimeException, CGGEInternalException {
        InternalScoringAddress addr = candidateList.getCandidateList().get(0);
        CGGEHandler handler = CGGEHandler.getInstance(addr.getDataSetInfo(), this.m_country, addr.getLanguage());
        ICGGECandidateFilter filter = handler.getCandidateFilter();
        ParsedAddress pAddress = addr.getParsedAddress();
        filter.filterCandidates(candidateList, pAddress, preferences);
        filter.filterMultipleCloseCandidates(candidateList, pAddress, preferences);
    }

    void parseAndFindCandidates(ICGGEParser parser, GeocodeOptions preferences) throws CGGEInternalException, DataFetchException, DataNotInitialisedException, CGGERuntimeException, IOException {
        CGGEHandler handler = this.getDataSetSpecificHandler(parser);
        this.applyTypeSpecificOptions(handler, preferences);
        if (!this.checkAndApplyDictionaryPreferences(handler, parser, preferences)) {
            return;
        }
        ParsedAddress parsedAddress = parser.parse(this.m_inputAddress, handler.getScorer())[0];
        boolean isIntersectionInput = parsedAddress.isIntersectionCase();
        ICGGEGeocodingHelper helper = this.getHelper(handler, preferences);
        ICGGEMatcher matcher = handler.getMatcher();
        if (preferences.getGeocodeConstraints().getCustomString("ORIGPOBOXNUM") == null && parsedAddress.getPoBoxNumber() != null) {
            String poNumStr = parsedAddress.getPoBoxNumber().toString();
            preferences.getGeocodeConstraints().setCustomString("ORIGPOBOXNUM", poNumStr);
        }
        InternalCandidateList candList = new InternalCandidateList();
        while (this.checkRetries(preferences, candList) && helper.hasMoreTries()) {
            InternalCandidateList currList = this.findCandidates(parsedAddress, candList, preferences, helper, matcher);
            if (currList == null) continue;
            matcher.mergeCandidates(candList, currList);
            if (!isIntersectionInput && !candList.hasCloseCandidates() && currList.getCandidateCount() > 10) {
                handler.getCandidateFilter().filterCandidates(candList, parsedAddress, preferences);
            }
            this.setBestFetchedCandidate(parsedAddress, currList);
        }
        candList = this.processResults(parsedAddress, candList, handler, preferences);
        matcher.mergeCandidates(this.m_candidateList, candList);
    }

    private void applyTypeSpecificOptions(CGGEHandler handler, GeocodeOptions preferences) {
        INearByStreet nearbyStreetHandler;
        if (preferences.getGeocodeType() == 1 && (nearbyStreetHandler = handler.getNearByStreetHandle()) != null) {
            nearbyStreetHandler.setMustMatchConstraint(preferences.getGeocodeConstraints().isMustMatchAddressNumber());
        }
    }

    private boolean checkRetries(GeocodeOptions preferences, InternalCandidateList candList) {
        if (Boolean.valueOf(preferences.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue() && candList.hasCloseCandidates()) {
            return false;
        }
        return preferences.getGeocodeType() == 1 ? true : !candList.hasCloseCandidates();
    }

    private CGGEHandler getDataSetSpecificHandler(ICGGEParser parser) {
        return CGGEHandler.getInstance(((IDataSetComponent)((Object)parser)).getDataSetInfo(), this.m_country, parser.getLanguage());
    }

    private boolean checkAndApplyDictionaryPreferences(CGGEHandler handler, ICGGEParser parser, GeocodeOptions preferences) {
        DataSetInfo dataSetInfo = ((IDataSetComponent)((Object)parser)).getDataSetInfo();
        if (this.hasMatchingCandidateFromDataSet(dataSetInfo) || handler.getVersion() == 2 && this.m_candidateList.hasCloseCandidates()) {
            return false;
        }
        IConstraints constraints = preferences.getGeocodeConstraints();
        DictionaryUsagePreference duPreference = preferences.getGeocodeConstraints().getDictionaryUsage();
        if (dataSetInfo != null) {
            boolean isUserDictionary = dataSetInfo.getMetaData().isUserDictionary();
            if (!this.canUseDataSet(duPreference, isUserDictionary)) {
                return false;
            }
            constraints.setCustomString("KEY_CAN_SEARCH_UD", isUserDictionary ? "true" : "false");
            if (handler.getVersion() != 2) {
                preferences.put("allowed_datasets_list", Collections.singletonList(dataSetInfo));
            }
        }
        return true;
    }

    private boolean hasMatchingCandidateFromDataSet(DataSetInfo dataSetInfo) {
        if (!this.m_candidateList.hasCloseCandidates()) {
            return false;
        }
        int closeCount = this.m_candidateList.getNumberOfCloseMatches();
        for (int candNdx = 0; candNdx < closeCount; ++candNdx) {
            DataSetInfo candDataSetInfo = this.m_candidateList.getIndexedCandidate(candNdx).getDataSetInfo();
            if (!dataSetInfo.equals(candDataSetInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean canUseDataSet(DictionaryUsagePreference duPreference, boolean isUserDictionary) {
        if (duPreference == DictionaryUsagePreference.AD_ONLY && isUserDictionary) {
            return false;
        }
        return duPreference != DictionaryUsagePreference.UD_ONLY || isUserDictionary;
    }

    private void setBestFetchedCandidate(ParsedAddress parsedAddr, InternalCandidateList candList) {
        if (candList.hasCandidates()) {
            InternalScoringAddress bestCurrCand = this.m_candidateList.getBestFetchedCandidate();
            InternalScoringAddress cand = candList.getIndexedCandidate(0);
            if (bestCurrCand == null || bestCurrCand.getCombinedScore() < cand.getCombinedScore()) {
                cand.setParsedAddress(parsedAddr);
                this.m_candidateList.setBestFetchedCandidate(cand);
            }
        }
    }

    private ICGGEGeocodingHelper getHelper(CGGEHandler handler, GeocodeOptions preferences) {
        int geoType = preferences.getGeocodeType();
        switch (geoType) {
            case 1: {
                return handler.getStreetGeocodingHelper();
            }
            case 3: {
                return handler.getGeographicGeocodingHelper();
            }
            case 2: {
                return handler.getPostalGeocodingHelper();
            }
            case 4: {
                return handler.getPOIGeocodingHelper();
            }
        }
        return null;
    }

    private InternalCandidateList findCandidates(ParsedAddress parsedAddr, InternalCandidateList candList, GeocodeOptions preferences, ICGGEGeocodingHelper helper, ICGGEMatcher matcher) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList currentList = helper.searchNextCase(this.m_dataManager, parsedAddr, preferences, candList);
        if (currentList != null) {
            matcher.scoreCandidates(parsedAddr, currentList, preferences, this.m_dataManager);
            matcher.matchAndOrderCandidates(parsedAddr, currentList, preferences, this.m_dataManager);
        }
        return currentList;
    }

    private InternalCandidateList processResults(ParsedAddress parsedAddr, InternalCandidateList currentList, CGGEHandler handler, GeocodeOptions preferences) throws CGGEInternalException, DataFetchException, CGGERuntimeException, IOException, DataNotInitialisedException {
        if (preferences.getGeocodeType() == 1) {
            if (parsedAddr.isIntersectionCase() && currentList.hasCandidates()) {
                IntersectionBuilder xbuilder = new IntersectionBuilder(this.getDataManager(), parsedAddr, handler.getMatcher(), preferences, this.m_candidateList);
                currentList = xbuilder.buildIntersection(currentList);
            } else {
                this.processNearbyStreet(handler, parsedAddr, currentList, preferences);
            }
        }
        if (currentList != null) {
            for (InternalScoringAddress cand : currentList.getCandidateList()) {
                cand.setParsedAddress(parsedAddr);
            }
        }
        return currentList;
    }

    private void processNearbyStreet(CGGEHandler handler, ParsedAddress parsedAddr, InternalCandidateList candidateList, GeocodeOptions preferences) throws CGGEInternalException, DataFetchException {
        INearByStreet nearByStreetHandler = handler.getNearByStreetHandle();
        if (nearByStreetHandler != null && !parsedAddr.isIntersectionCase() && parsedAddr.isNearByFeature() && candidateList.getCandidateCount() > 1) {
            List<InternalNearByStreetAddress> nearByStreetList = nearByStreetHandler.getNearByStreetSegmentList(candidateList, this.m_dataManager, parsedAddr, preferences);
            nearByStreetHandler.setModifiedRanges(nearByStreetList, candidateList);
        }
    }

    public CGGEGeocodeResult geocodeGeographic(GeocodeOptions preferences) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        return this.geocodeInternal(preferences, 3);
    }

    public CGGEGeocodeResult geocodePOI(GeocodeOptions preferences) throws Exception {
        return this.geocodeInternal(preferences, 4);
    }

    Set<ICGGEParser> getParserSetForSupportedLanguages(int dataType) {
        int dictCount = this.m_dataManager.getDictionaryCount();
        TreeSet<ICGGEParser> parserSet = new TreeSet<ICGGEParser>();
        for (int dictNum = 1; dictNum <= dictCount; ++dictNum) {
            List<DataSetInfo> dataSetInfos;
            if (!this.m_dataManager.doesDictionarySupportsGeocodeType(dictNum, dataType) || (dataSetInfos = this.m_dataManager.getDataSetInfos(dictNum, dataType)) == null) continue;
            for (DataSetInfo dataSetInfo : dataSetInfos) {
                CGGEHandler handler = CGGEHandler.getInstance(dataSetInfo, this.m_country, dataSetInfo.getMetaData().getLanguage());
                ICGGEParser parser = handler.getParser();
                if (parser != null && parser instanceof DatasetInfoComponent) {
                    ((DatasetInfoComponent)((Object)parser)).setDataSetInfo(dataSetInfo);
                }
                parserSet.add(handler.getParser());
            }
        }
        return parserSet;
    }

    public CGGEGeocodeResult geocode(GeocodeOptions preferences) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        return this.geocodeInternal(preferences, 1);
    }

    private CGGEGeocodeResult doFallBack(GeocodeOptions options) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        CGGEGeocodeResult geoResult = null;
        boolean poBoxMatchInProgress = false;
        if (!options.canFallBackToGeographic() && !options.canFallBackToPostal()) {
            return null;
        }
        if ("true".equalsIgnoreCase(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            poBoxMatchInProgress = true;
        }
        CGGEGeocoder geocoder = new CGGEGeocoder(this.m_country);
        if (poBoxMatchInProgress) {
            options.getGeocodeConstraints().setCustomString("POBOX_MATCH_IN_PROGRESS", null);
        }
        if (options.canFallBackToPostal() && options.canFallBackToGeographic()) {
            geocoder.setInputAddress(this.m_inputAddress);
            CGGEGeocodeResult cGGEGeocodeResult = geoResult = options.preferPostalFallback() ? geocoder.geocodePostal(options) : geocoder.geocodeGeographic(options);
            if (geoResult == null || geoResult.getNumberOfCloseCandidates() == 0) {
                geoResult = options.preferPostalFallback() ? geocoder.geocodeGeographic(options) : geocoder.geocodePostal(options);
            }
        } else if (options.canFallBackToPostal()) {
            geocoder.setInputAddress(this.m_inputAddress);
            geoResult = geocoder.geocodePostal(options);
        } else if (options.canFallBackToGeographic()) {
            geocoder.setInputAddress(this.m_inputAddress);
            geoResult = geocoder.geocodeGeographic(options);
        }
        if (geoResult != null && geoResult.getNumberOfCloseCandidates() > 0) {
            this.m_candidateList = geocoder.m_candidateList;
            options.getGeocodeConstraints().setCustomObject((Object)"POSTALFB_PREC_CODE_FLAG", (Object)"");
        } else {
            geoResult = null;
        }
        if (poBoxMatchInProgress) {
            options.getGeocodeConstraints().setCustomString("POBOX_MATCH_IN_PROGRESS", "true");
        }
        return geoResult;
    }

    public CGGEGeocodeResult geocodePostal(GeocodeOptions preferences) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        return this.geocodeInternal(preferences, 2);
    }

    public void setInputAddress(InputAddress inputAddress) {
        this.m_inputAddress = inputAddress;
    }

    public InputAddress getInputAddress() {
        return this.m_inputAddress;
    }

    public InternalScoringAddress getIndexedCandidate(int candIndex) {
        if (candIndex > -1 && this.m_candidateList != null && this.m_candidateList.getCandidateCount() > candIndex) {
            return this.m_candidateList.getIndexedCandidate(candIndex);
        }
        return null;
    }

    public IDataManager getDataManager() {
        return this.m_dataManager;
    }
}

