/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEHandlerPropertiesLoader;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.ICGGEHandlerFactory;
import com.mapinfo.mapmarker.cgge.ICGGEIntersectionHelper;
import com.mapinfo.mapmarker.cgge.ISettableCGGEHandler;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.helper.ICGGEGeocodingHelper;
import com.mapinfo.mapmarker.cgge.licensing.ICGGELicense;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CGGEHandler
implements ISettableCGGEHandler {
    private static Map<String, CGGEHandler> m_handlers = new HashMap<String, CGGEHandler>();
    private static ICGGEHandlerFactory m_handlerFactory;
    private ICGGEParser m_parser;
    private ICGGEScorer m_scorer;
    private ICGGESoundex m_soundex;
    private ICGGEMatcher m_matcher;
    private ICGGECandidateFilter m_candFilter;
    private ICGGECandidateConvertor m_candidateConvertor;
    private Class<ICGGEGeocodingHelper> m_streetGeocodeHelperClz;
    private Class<ICGGEGeocodingHelper> m_postGeocoderHelperClz;
    private Class<ICGGEGeocodingHelper> m_geographicGeocoderHelperClz;
    private Class<ICGGEGeocodingHelper> m_poiGeocoderHelperClz;
    private ICGGEIntersectionHelper m_intersectionHelper;
    private INearByStreet m_nearByStreetHandle;
    private ICGGELicense m_license;
    private boolean m_preferPostalFallback = true;
    private String m_country;
    private String m_language;
    private Exception m_error;
    private String m_countryDefaultLanguage;
    private int m_version = 1;
    public static final String KEY_PARSER_CLASS = "parser_class";
    public static final String KEY_SCORER_CLASS = "scorer_class";
    public static final String KEY_SOUNDEX_CLASS = "soundex_class";
    public static final String KEY_MATCHER_CLASS = "matcher_class";
    public static final String KEY_STREET_GEOCODER_HELPER_CLASS = "street_helper_class";
    public static final String KEY_POSTAL_GEOCODER_HELPER_CLASS = "postal_helper_class";
    public static final String KEY_GEOGRAPHIC_GEOCODER_HELPER_CLASS = "geographic_helper_class";
    public static final String KEY_POI_HELPER_CLASS = "poi_helper_class";
    public static final String KEY_CANDIDATE_CONVERTOR_CLASS = "candidate_convertor_class";
    public static final String KEY_CANDIDATE_FILTER_CLASS = "candidate_filter_class";
    public static final String KEY_LICENSE_CLASS = "license_class";
    public static final String KEY_REDIRECT_COUNTRY_CODE = "redirect_to_country";
    public static final String KEY_REDIRECT_COUNTRY_LANGUAGE = "redirect_to_language";
    private static final String KEY_ISNATIVE_SUPPORT = "is_native_supported";

    private CGGEHandler() {
    }

    private CGGEHandler(DataSetInfo dataSetInfo, String country, String language, Properties prop) throws CGGEInternalException {
        this.m_country = country;
        this.m_language = language;
        String propName = CGGEHandler.buildPropertiesName(country);
        CGGEHandlerPropertiesLoader loader = new CGGEHandlerPropertiesLoader(dataSetInfo, propName);
        loader.init(country, language, this);
    }

    private static String buildPropertiesName(String country) {
        StringBuilder sb = new StringBuilder("/com/mapinfo/mapmarker/");
        sb.append(country);
        sb.append("/config/");
        sb.append(country);
        sb.append("_Handler");
        return sb.toString();
    }

    protected static String buildKey(DataSetInfo dataSetInfo, String country, String language) {
        StringBuilder stringBuilder = new StringBuilder();
        if (country != null) {
            stringBuilder.append(country);
        }
        if (language != null) {
            stringBuilder.append(language);
        }
        if (dataSetInfo != null) {
            stringBuilder.append(dataSetInfo.getDataSetInfoKey());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGGEHandler getInstance(DataSetInfo dataSetInfo, String country, String language) {
        String key = CGGEHandler.buildKey(dataSetInfo, country, language);
        CGGEHandler handler = m_handlers.get(key);
        if (handler == null) {
            Map<String, CGGEHandler> map = m_handlers;
            synchronized (map) {
                handler = m_handlers.get(key);
                if (handler == null) {
                    String propName = CGGEHandler.buildPropertiesName(country);
                    Properties redirectionProperties = null;
                    try {
                        redirectionProperties = CGGEResourceBundle.getBundle(propName, language);
                        if (redirectionProperties != null) {
                            String redirectedKey;
                            if (m_handlerFactory == null || !m_handlerFactory.isCountryCodeSame(country) || !m_handlerFactory.matchesDataSetInfo(dataSetInfo)) {
                                boolean isNativeLanguageSupport = Boolean.parseBoolean(redirectionProperties.getProperty(KEY_ISNATIVE_SUPPORT, "false"));
                                m_handlerFactory = isNativeLanguageSupport ? CGGEHandler.loadNativeCGGEHandlerFactory(dataSetInfo) : CGGEHandler.loadSimpleCGGEHandlerFactory(dataSetInfo);
                            }
                            String redircountry = redirectionProperties.getProperty(KEY_REDIRECT_COUNTRY_CODE, country);
                            String redirlanguage = redirectionProperties.getProperty(KEY_REDIRECT_COUNTRY_LANGUAGE, language);
                            if (!(StringUtilities.equalStrings((String)redircountry, (String)country) && StringUtilities.equalStrings((String)redirlanguage, (String)language) || (handler = m_handlers.get(redirectedKey = CGGEHandler.buildKey(dataSetInfo, redircountry, redirlanguage))) != null)) {
                                handler = (CGGEHandler)m_handlerFactory.initializeHandler(redircountry, redirlanguage, null);
                                m_handlers.put(redirectedKey, handler);
                            }
                        }
                    }
                    catch (CGGEInternalException redircountry) {
                        // empty catch block
                    }
                    try {
                        if (handler == null) {
                            try {
                                handler = (CGGEHandler)m_handlerFactory.initializeHandler(country, language, null);
                            }
                            catch (Exception e) {
                                throw new CGGEInternalException("Input Country is null " + e.getLocalizedMessage());
                            }
                        }
                        m_handlers.put(key, handler);
                    }
                    catch (CGGEInternalException e) {
                        throw new CGGERuntimeException("CGGEHandler not initialised", e);
                    }
                }
            }
        }
        return handler;
    }

    public ICGGEParser getParser() {
        return this.m_parser;
    }

    @Override
    public void setParser(ICGGEParser parser) {
        this.m_parser = parser;
    }

    @Override
    public INearByStreet getNearByStreetHandle() {
        return this.m_nearByStreetHandle;
    }

    @Override
    public void setNearByStreetHandle(INearByStreet nearByStreetHandle) {
        this.m_nearByStreetHandle = nearByStreetHandle;
    }

    public ICGGEScorer getScorer() {
        return this.m_scorer;
    }

    @Override
    public void setScorer(ICGGEScorer scorer) {
        this.m_scorer = scorer;
    }

    public ICGGESoundex getSoundex() {
        return this.m_soundex;
    }

    @Override
    public void setSoundex(ICGGESoundex soundex) {
        this.m_soundex = soundex;
    }

    public String getCountry() {
        return this.m_country;
    }

    public ICGGECandidateFilter getCandidateFilter() {
        return this.m_candFilter;
    }

    @Override
    public void setCandidateFilter(ICGGECandidateFilter filter) {
        this.m_candFilter = filter;
    }

    public Exception getError() {
        return this.m_error;
    }

    public ICGGEMatcher getMatcher() {
        return this.m_matcher;
    }

    public ICGGECandidateConvertor getCandidateConvertor() {
        return this.m_candidateConvertor;
    }

    public ICGGEGeocodingHelper getStreetGeocodingHelper() {
        return this.loadHelperClass(this.m_streetGeocodeHelperClz);
    }

    public ICGGEGeocodingHelper getPostalGeocodingHelper() {
        return this.loadHelperClass(this.m_postGeocoderHelperClz);
    }

    public ICGGEGeocodingHelper getGeographicGeocodingHelper() {
        return this.loadHelperClass(this.m_geographicGeocoderHelperClz);
    }

    public ICGGEGeocodingHelper getPOIGeocodingHelper() {
        return this.loadHelperClass(this.m_poiGeocoderHelperClz);
    }

    @Override
    public void setIntersectionHelper(ICGGEIntersectionHelper helper) {
        this.m_intersectionHelper = helper;
    }

    public ICGGEIntersectionHelper getIntersectionHelper() {
        return this.m_intersectionHelper;
    }

    private ICGGEGeocodingHelper loadHelperClass(Class<ICGGEGeocodingHelper> helperClass) {
        try {
            ICGGEGeocodingHelper helper = helperClass.newInstance();
            helper.init(this.m_country, this.m_language);
            return helper;
        }
        catch (InstantiationException e) {
            throw new CGGERuntimeException("Error initialising helper class", e);
        }
        catch (IllegalAccessException e) {
            throw new CGGERuntimeException("Error initialising helper class", e);
        }
    }

    public ICGGELicense getLicense() {
        return this.m_license;
    }

    public boolean getPreferPostalFallback() {
        return this.m_preferPostalFallback;
    }

    @Override
    public void setMatcher(ICGGEMatcher matcher) {
        this.m_matcher = matcher;
    }

    @Override
    public void setCandidateConvertor(ICGGECandidateConvertor convertor) {
        this.m_candidateConvertor = convertor;
    }

    @Override
    public void setStreetGeocodeHelperClass(Class<ICGGEGeocodingHelper> clz) {
        this.m_streetGeocodeHelperClz = clz;
    }

    @Override
    public void setPostalGeocodeHelperClass(Class<ICGGEGeocodingHelper> clz) {
        this.m_postGeocoderHelperClz = clz;
    }

    @Override
    public void setGeographicGeocodeHelperClass(Class<ICGGEGeocodingHelper> clz) {
        this.m_geographicGeocoderHelperClz = clz;
    }

    @Override
    public void setPoiGeocoderHelperClass(Class<ICGGEGeocodingHelper> clz) {
        this.m_poiGeocoderHelperClz = clz;
    }

    @Override
    public void setLicense(ICGGELicense license) {
        this.m_license = license;
    }

    @Override
    public void setPreferPostalFallback(boolean bPrefer) {
        this.m_preferPostalFallback = bPrefer;
    }

    @Override
    public void setCountryDefaultLanguage(String countryDefaultLanguage) {
        this.m_countryDefaultLanguage = countryDefaultLanguage;
    }

    @Override
    public String getCountryDefaultLanguage() {
        return this.m_countryDefaultLanguage;
    }

    private static ICGGEHandlerFactory loadSimpleCGGEHandlerFactory(DataSetInfo dataSetInfo) {
        final DataSetInfo _dataSetInfo = dataSetInfo;
        return new ICGGEHandlerFactory(){
            private String _countryIdentifier;

            @Override
            public ISettableCGGEHandler initializeHandler(String country, String language, Properties props) throws CGGEInternalException {
                this._countryIdentifier = country;
                return new CGGEHandler(_dataSetInfo, country, language, props);
            }

            @Override
            public String getCountryIdentifier() {
                return this._countryIdentifier;
            }

            @Override
            public boolean isCountryCodeSame(String countryCode) {
                boolean isCountryCodeSame = false;
                if (!StringUtilities.isEmpty((String)this._countryIdentifier)) {
                    isCountryCodeSame = this._countryIdentifier.equalsIgnoreCase(countryCode);
                }
                return isCountryCodeSame;
            }

            @Override
            public boolean matchesDataSetInfo(DataSetInfo dataSetInfo) {
                if (dataSetInfo == null) {
                    return _dataSetInfo == null;
                }
                if (_dataSetInfo == null) {
                    return false;
                }
                return dataSetInfo.equals(_dataSetInfo);
            }
        };
    }

    private static ICGGEHandlerFactory loadNativeCGGEHandlerFactory(DataSetInfo dataSetInfo) {
        final DataSetInfo _dataSetInfo = dataSetInfo;
        return new ICGGEHandlerFactory(){
            private String _countryIdentifier;

            @Override
            public ISettableCGGEHandler initializeHandler(String country, String language, Properties props) throws CGGEInternalException {
                if (StringUtilities.isEmpty((String)language)) {
                    language = "en";
                }
                this._countryIdentifier = country;
                return new CGGEHandler(_dataSetInfo, country, language, props);
            }

            @Override
            public String getCountryIdentifier() {
                return this._countryIdentifier;
            }

            @Override
            public boolean isCountryCodeSame(String countryCode) {
                boolean isCountryCodeSame = false;
                if (!StringUtilities.isEmpty((String)this._countryIdentifier)) {
                    isCountryCodeSame = this._countryIdentifier.equalsIgnoreCase(countryCode);
                }
                return isCountryCodeSame;
            }

            @Override
            public boolean matchesDataSetInfo(DataSetInfo dataSetInfo) {
                if (dataSetInfo == null) {
                    return _dataSetInfo == null;
                }
                if (_dataSetInfo == null) {
                    return false;
                }
                return dataSetInfo.equals(_dataSetInfo);
            }
        };
    }

    @Override
    public void setVersion(int v) {
        this.m_version = v;
    }

    public int getVersion() {
        return this.m_version;
    }
}

