/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.ICGGEIntersectionHelper;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalIntersectionScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Properties;

public class CGGEIntersectionHelper
implements ICGGEIntersectionHelper {
    private static final String KEY_ALLOW_SHORT_CIRCUIT = "allowShortCircuit";
    private static final String KEY_COMBINED_SCORE_THRESHOLD = "combinedScoreThreshold";
    private static final String KEY_SINGLE_LINE_COMBINED_SCORE_THRESHOLD = "singleLineCombinedScoreThreshold";
    private static final String KEY_COMBINED_POSTAL_SCORE_THRESHOLD = "combinedPostalScoreThreshold";
    private static final String KEY_SINGLE_LINE_COMBINED_POSTAL_SCORE_THRESHOLD = "singleLineCombinedPostalScoreThreshold";
    private static final String KEY_COMBINED_STREET_SCORE_THRESHOLD = "combinedStreetScoreThreshold";
    private static final String KEY_COMBINED_STREET_SCORE_MINIMUM = "combinedStreetScoreMinimum";
    private static final String KEY_SINGLE_COMBINED_STREET_SCORE_THRESHOLD = "singleCombinedStreetScoreThreshold";
    private static final String KEY_SINGLE_COMBINED_STREET_SCORE_MINIMUM = "singleCombinedStreetScoreMinimum";
    private static final String KEY_ALLOW_MISSING_STREET_TYPE = "allowMissingStreetType";
    private static final String KEY_MAX_CANDIDATES = "maxCandidates";
    private static final double DEFAULT_COMBINED_SCORE_THRESHOLD = 0.94;
    private static final double DEFAULT_SINGLE_LINE_COMBINED_SCORE_THRESHOLD = 0.86;
    private static final double DEFAULT_COMBINED_POSTAL_SCORE_THRESHOLD = 0.98;
    private static final double DEFAULT_SINGLE_LINE_COMBINED_POSTAL_SCORE_THRESHOLD = 0.83;
    private static final double DEFAULT_COMBINED_STREET_SCORE_THRESHOLD = 0.98;
    private static final double DEFAULT_COMBINED_STREET_SCORE_MINIMUM = 0.96;
    private static final double DEFAULT_SINGLE_COMBINED_STREET_SCORE_THRESHOLD = 0.98;
    private static final double DEFAULT_SINGLE_COMBINED_STREET_SCORE_MINIMUM = 0.94;
    private static final boolean DEFAULT_ALLOW_MISSING_STREET_TYPE = true;
    private boolean m_bAllowShortCircuit = true;
    private double m_combinedScoreThreshold = 0.94;
    private double m_singleLineCombinedScoreThreshold = 0.86;
    private double m_combinedPostalScoreThreshold = 0.98;
    private double m_singleLineCombinedPostalScoreThreshold = 0.83;
    private double m_combinedStreetScoreThreshold = 0.98;
    private double m_combinedStreetScoreMinimum = 0.96;
    private double m_singleCombinedStreetScoreThreshold = 0.98;
    private double m_singleCombinedStreetMinimum = 0.94;
    private boolean m_bAllowMissingStreetType = true;
    private double m_maxCandidates = 2.147483647E9;

    @Override
    public void init(String country, String language) throws CGGEInternalException {
        Properties prop;
        try {
            prop = CGGEResourceBundle.getBundle(CGGEIntersectionHelper.buildPropertiesName(country), language);
        }
        catch (CGGEInternalException CGGEIEx) {
            return;
        }
        String value = prop.getProperty(KEY_ALLOW_SHORT_CIRCUIT);
        this.m_bAllowShortCircuit = StringUtilities.isEmpty((String)value) || Boolean.parseBoolean(value);
        try {
            value = prop.getProperty(KEY_COMBINED_SCORE_THRESHOLD);
            if (!StringUtilities.isEmpty((String)value)) {
                this.m_combinedScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_SINGLE_LINE_COMBINED_SCORE_THRESHOLD)))) {
                this.m_singleLineCombinedScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_COMBINED_POSTAL_SCORE_THRESHOLD)))) {
                this.m_combinedPostalScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_SINGLE_LINE_COMBINED_POSTAL_SCORE_THRESHOLD)))) {
                this.m_singleLineCombinedPostalScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_COMBINED_STREET_SCORE_THRESHOLD)))) {
                this.m_combinedStreetScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_COMBINED_STREET_SCORE_MINIMUM)))) {
                this.m_combinedStreetScoreMinimum = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_SINGLE_COMBINED_STREET_SCORE_THRESHOLD)))) {
                this.m_singleCombinedStreetScoreThreshold = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_SINGLE_COMBINED_STREET_SCORE_MINIMUM)))) {
                this.m_singleCombinedStreetMinimum = Double.parseDouble(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_ALLOW_MISSING_STREET_TYPE)))) {
                this.m_bAllowMissingStreetType = Boolean.parseBoolean(value);
            }
            if (!StringUtilities.isEmpty((String)(value = prop.getProperty(KEY_MAX_CANDIDATES)))) {
                this.m_maxCandidates = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException NFEx) {
            throw new CGGEInternalException(NFEx);
        }
    }

    private static String buildPropertiesName(String country) {
        StringBuilder sb = new StringBuilder("/com/mapinfo/mapmarker/");
        sb.append(country);
        sb.append("/config/");
        sb.append(country);
        sb.append("_IntersectionHelper");
        return sb.toString();
    }

    @Override
    public boolean shortCircuitIntersection(InternalIntersectionScoringAddress intersection, ParsedAddress parsed) {
        if (!this.m_bAllowShortCircuit) {
            return false;
        }
        return intersection.isCloseMatch() && this.evaluateIntersectionStreetScores(intersection) && (parsed.isSeperatePostAddressFields() ? intersection.getCombinedScore() > this.m_combinedScoreThreshold && intersection.getCombinedPostalScore() > this.m_combinedPostalScoreThreshold : intersection.getCombinedPostalScore() > this.m_singleLineCombinedPostalScoreThreshold && intersection.getCombinedScore() > this.m_singleLineCombinedScoreThreshold);
    }

    private boolean evaluateIntersectionStreetScores(InternalIntersectionScoringAddress intersection) {
        if (intersection.getCombinedStreetScore() > this.m_combinedStreetScoreThreshold) {
            return true;
        }
        return intersection.getCombinedStreetScore() > this.m_combinedStreetScoreMinimum && this.evaluateStreetScore(intersection.getFirstCandidate()) && this.evaluateStreetScore(intersection.getSecondCandidate());
    }

    private boolean evaluateStreetScore(InternalScoringAddress address) {
        AddressWord word;
        int matchedStreetWords;
        int totalStreetWords;
        if (address.getCombinedStreetScore() >= this.m_singleCombinedStreetScoreThreshold) {
            return true;
        }
        return address.getCombinedStreetScore() >= this.m_singleCombinedStreetMinimum && this.m_bAllowMissingStreetType && (totalStreetWords = ((AddressWord[])((InternalFieldValue)address.getField(FieldType.STREET_NAME_FIELD_TYPE)).getFieldValue()).length) - (matchedStreetWords = address.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_matchedCandWords.size()) <= 1 && (word = this.getUnmatchedWord(address)) != null && (word.getAttributes() & 0x200) != 0;
    }

    private AddressWord getUnmatchedWord(InternalScoringAddress address) {
        for (int i = 0; i < ((AddressWord[])((InternalFieldValue)address.getField(FieldType.STREET_NAME_FIELD_TYPE)).getFieldValue()).length; ++i) {
            if (address.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_matchedCandWords.contains(i)) continue;
            return ((AddressWord[])((InternalFieldValue)address.getField(FieldType.STREET_NAME_FIELD_TYPE)).getFieldValue())[i];
        }
        return null;
    }

    @Override
    public int computeCandidateCountForIntersection(int candidateCount) {
        return (int)Math.min((double)candidateCount, this.m_maxCandidates);
    }
}

