/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.Comparator;

public class FieldScore
implements Comparator<FieldScore>,
Comparable<FieldScore> {
    public AddressWord[] m_inputWords;
    public AddressWord[] m_candWords;
    public IntArray m_matchedInputWords;
    public IntArray m_matchedCandWords;
    public double m_value = 0.0;
    public IntArray m_perfectInputWords;
    public IntArray m_perfectCandWords;
    public boolean m_matched;
    public boolean m_candidateFieldPresent;
    public boolean m_inputFieldPresent;
    public double m_fieldWeight;
    public int m_matchedAltIndex = -1;
    public int m_altMatchedCount = 0;
    public boolean m_nonNumericCombinedWordScoreUsed;

    public void copy(FieldScore score) {
        this.m_inputWords = score.m_inputWords;
        this.m_candWords = score.m_candWords;
        this.m_matchedInputWords = score.m_matchedInputWords;
        this.m_matchedCandWords = score.m_matchedCandWords;
        this.m_value = score.m_value;
        this.m_perfectCandWords = score.m_perfectCandWords;
        this.m_perfectInputWords = score.m_perfectInputWords;
        this.m_matched = score.m_matched;
        this.m_candidateFieldPresent = score.m_candidateFieldPresent;
        this.m_inputFieldPresent = score.m_inputFieldPresent;
        this.m_fieldWeight = score.m_fieldWeight;
        this.m_matchedAltIndex = score.m_matchedAltIndex;
        this.m_altMatchedCount = score.m_altMatchedCount;
        this.m_nonNumericCombinedWordScoreUsed = score.m_nonNumericCombinedWordScoreUsed;
    }

    @Override
    public int compare(FieldScore o1, FieldScore o2) {
        if (o1.m_matched == o2.m_matched) {
            int m2;
            int m1;
            int p2;
            if (o1.m_value > o2.m_value) {
                return 1;
            }
            if (o1.m_value < o2.m_value) {
                return -1;
            }
            int p1 = o1.m_perfectCandWords == null ? 0 : o1.m_perfectCandWords.size();
            int c = p1 - (p2 = o2.m_perfectCandWords == null ? 0 : o2.m_perfectCandWords.size());
            if (c == 0 && (c = (m1 = o1.m_matchedCandWords == null ? 0 : o1.m_matchedCandWords.size()) - (m2 = o2.m_matchedCandWords == null ? 0 : o2.m_matchedCandWords.size())) == 0 && o1.m_matchedInputWords != null && o2.m_matchedInputWords != null && o1.m_matchedInputWords.size() > 0 && o2.m_matchedInputWords.size() > 0) {
                int d1 = o1.m_matchedInputWords.max() - o1.m_matchedInputWords.min() + 1 - o1.m_matchedInputWords.size();
                int d2 = o2.m_matchedInputWords.max() - o2.m_matchedInputWords.min() + 1 - o2.m_matchedInputWords.size();
                c = d2 - d1;
            }
            return c;
        }
        if (o1.m_matched) {
            return 1;
        }
        if (o2.m_matched) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("value=");
        builder.append(this.m_value);
        return builder.toString();
    }

    public boolean inputWordsMatchedInOrder() {
        int size;
        if (this.m_matchedInputWords != null && (size = this.m_matchedInputWords.size()) > 0) {
            int lastMatched = this.m_matchedInputWords.get(0);
            for (int ndx = 0; ndx < size; ++ndx) {
                int curMatched = this.m_matchedInputWords.get(ndx);
                if (curMatched > lastMatched && lastMatched + 1 != curMatched) {
                    for (int i = lastMatched + 1; i < curMatched; ++i) {
                        if (this.m_inputWords[i].getSoundex() == 0) continue;
                        return false;
                    }
                }
                lastMatched = curMatched;
            }
            return true;
        }
        return false;
    }

    public boolean candWordsMatchedInOrder() {
        int size;
        if (this.m_matchedCandWords != null && (size = this.m_matchedCandWords.size()) > 0) {
            int lastMatched = -1;
            int ndx = 0;
            while (ndx < size) {
                int curMatched;
                if ((curMatched = this.m_matchedCandWords.get(ndx++)) > lastMatched && lastMatched + 1 != curMatched) {
                    for (int i = lastMatched + 1; i < curMatched; ++i) {
                        if (this.m_candWords[i].m_weight == 0) continue;
                        return false;
                    }
                }
                lastMatched = curMatched;
            }
            return true;
        }
        return false;
    }

    public boolean isPerfectCandWordMatch(int candWordIndex) {
        return this.m_perfectCandWords != null && this.m_perfectCandWords.contains(candWordIndex);
    }

    private static boolean matchedInOrder(IntArray matchArray) {
        return matchArray.max() - matchArray.min() + 1 == matchArray.size();
    }

    public boolean inputWordsMatchedInOrderforComparison() {
        int size;
        IntArray a = this.m_matchedInputWords;
        int n = size = a == null ? 0 : a.size();
        if (size > 0) {
            int lastMatch = a.get(0);
            int ndx = 1;
            while (ndx < size) {
                int match = a.get(ndx);
                if (match < lastMatch) {
                    return false;
                }
                if (lastMatch + 1 != match && lastMatch + 1 < this.m_inputWords.length) {
                    if (this.m_inputWords[lastMatch + 1].getSoundex() != 0) {
                        return false;
                    }
                    ++lastMatch;
                    continue;
                }
                lastMatch = match;
                ++ndx;
            }
            return true;
        }
        return false;
    }

    public int matchedCandidateWordCount() {
        return IntArray.size(this.m_matchedCandWords);
    }

    public int candidateWordCount() {
        return AddressWordArray.size(this.m_candWords);
    }

    public AddressWord[] getCandidateWords() {
        return this.m_candWords == null ? AddressWordArray.EMPTY_ARRAY : this.m_candWords;
    }

    public AddressWord[] getInputWords() {
        return this.m_inputWords == null ? AddressWordArray.EMPTY_ARRAY : this.m_inputWords;
    }

    public int perfectCandidateWordCount() {
        return IntArray.size(this.m_perfectCandWords);
    }

    public int perfectInputWordCount() {
        return IntArray.size(this.m_perfectInputWords);
    }

    public boolean isPerfectInputWordMatch(int inputWordIndex) {
        return this.m_perfectInputWords != null && this.m_perfectInputWords.contains(inputWordIndex);
    }

    @Override
    public int compareTo(FieldScore other) {
        return this.compare(this, other);
    }

    public void resetFieldMatch() {
        this.m_value = 0.0;
        this.m_perfectCandWords = null;
        this.m_perfectInputWords = null;
        this.m_matchedCandWords = null;
        this.m_matchedInputWords = null;
        this.m_matched = false;
    }
}

