/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GeocodeOptions
extends Properties {
    public static final String RETURN_POI_WITH_STREET = "ReturnPOIWithStreet";
    public static final String PREFER_POI_OVER_STREET = "PreferPOIOverStreet";
    public static final String S4_INPUT_HOUSE_NUMBER = "S4_INPUT_HOUSE_NUMBER";
    public static final String KEY_DATA_SET_KEY = "DATASETINFO_KEY";
    public static final String KEY_CAN_SEARCH_UD = "KEY_CAN_SEARCH_UD";
    public static final String TRY_SECONDARY_DUAL_ADDRESS = "TRY_SECONDARY_DUAL_ADDRESS";
    public static final String CONTAINS_DUAL_ADDRESS = "CONTAINS_DUAL_ADDRESS";
    private IConstraints m_geocodeConstraints;
    private HashMap<Integer, DictionaryUsage> m_dictionarySearchOrderMap;
    private int m_geocodeType = 0;
    private Set<FieldType> m_mustMatchFields;
    private boolean m_preferPostalFallback = true;

    public int getGeocodeType() {
        return this.m_geocodeType;
    }

    public void setGeocodeType(int type) {
        this.m_geocodeType = type;
    }

    public GeocodeOptions(IConstraints constraints) {
        IDictionarySearchOrder searchOrder;
        this.m_geocodeConstraints = constraints;
        if (constraints != null && (searchOrder = constraints.getDictionarySearchOrder()) != null) {
            int dictCount = searchOrder.getDictionaryCount();
            this.m_dictionarySearchOrderMap = new HashMap(dictCount);
            for (int dictNdx = 0; dictNdx < dictCount; ++dictNdx) {
                DictionaryUsage du = new DictionaryUsage();
                du.setDictionaryNumber(dictNdx + 1);
                du.setSearchOrder(searchOrder.getSearchOrderForDictionary(dictNdx + 1));
                du.setUsed(searchOrder.isDictionaryAvailableForSearch(dictNdx + 1));
                this.m_dictionarySearchOrderMap.put(dictNdx + 1, du);
            }
        }
    }

    public GeocodeOptions(GeocodeOptions copy) {
        this.m_geocodeConstraints = copy.m_geocodeConstraints;
        if (copy.m_dictionarySearchOrderMap != null) {
            this.m_dictionarySearchOrderMap = new HashMap(copy.m_dictionarySearchOrderMap.size());
            for (Map.Entry<Integer, DictionaryUsage> entry : copy.m_dictionarySearchOrderMap.entrySet()) {
                this.m_dictionarySearchOrderMap.put(entry.getKey(), new DictionaryUsage(entry.getValue()));
            }
        }
        this.m_geocodeType = copy.m_geocodeType;
        this.m_preferPostalFallback = copy.m_preferPostalFallback;
        this.putAll((Map<?, ?>)copy);
    }

    public DictionaryUsage getDictionaryUsageForDictionary(int dictNum) {
        DictionaryUsage du = null;
        if (this.m_dictionarySearchOrderMap != null) {
            du = this.m_dictionarySearchOrderMap.get(dictNum);
        }
        return du;
    }

    public void setDictionaryUsageForDictionary(int dictNum, DictionaryUsage usage) {
        DictionaryUsage old;
        if (this.m_dictionarySearchOrderMap == null) {
            this.m_dictionarySearchOrderMap = new HashMap();
        }
        if ((old = this.m_dictionarySearchOrderMap.put(dictNum, usage)) != null) {
            throw new CGGERuntimeException("Dictionary already present");
        }
    }

    public IConstraints getGeocodeConstraints() {
        return this.m_geocodeConstraints;
    }

    public static GeocodeOptions defaultProperties() {
        GeocodeOptions options = new GeocodeOptions((IConstraints)null);
        return options;
    }

    public boolean isReturnParsedInputAddress() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isReturnParsedInputAddress();
    }

    public boolean isMustMatchAreaName1() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchArea1() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchAreaName2() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchArea2() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchAreaName3() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchArea3() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchAreaName4() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchArea4() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchPostCode() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchPostalCode() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchAddressNumber() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchAddressNumber() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchStreetName() {
        return this.m_geocodeConstraints == null ? false : this.m_geocodeConstraints.isMustMatchMainAddress() || this.m_geocodeConstraints.isMustMatchInput();
    }

    public boolean isMustMatchCountry() {
        return this.m_geocodeConstraints != null && (this.m_geocodeConstraints.isMustMatchCountry() || this.m_geocodeConstraints.isMustMatchInput());
    }

    public String getMatchMode() {
        return this.m_geocodeConstraints == null ? null : this.m_geocodeConstraints.getMatchMode();
    }

    public boolean canUseUserDictionaries() {
        DictionaryUsagePreference dup;
        return this.m_geocodeConstraints == null || (dup = this.m_geocodeConstraints.getDictionaryUsage()) != DictionaryUsagePreference.AD_ONLY;
    }

    public boolean canUseStandardDictionaries() {
        DictionaryUsagePreference dup;
        return this.m_geocodeConstraints == null || (dup = this.m_geocodeConstraints.getDictionaryUsage()) != DictionaryUsagePreference.UD_ONLY;
    }

    public boolean preferUserDictionaries() {
        DictionaryUsagePreference dup;
        return this.m_geocodeConstraints != null && (dup = this.m_geocodeConstraints.getDictionaryUsage()) == DictionaryUsagePreference.PREFER_UD;
    }

    public boolean preferAddressDictionaries() {
        DictionaryUsagePreference dup;
        return this.m_geocodeConstraints != null && (dup = this.m_geocodeConstraints.getDictionaryUsage()) == DictionaryUsagePreference.PREFER_AD;
    }

    public boolean canFallBackToGeographic() {
        if (this.m_geocodeConstraints != null) {
            return this.m_geocodeConstraints.isFallbackToGeographic();
        }
        return false;
    }

    public boolean canFallBackToPostal() {
        if (this.m_geocodeConstraints != null) {
            return this.m_geocodeConstraints.isFallbackToPostal();
        }
        return false;
    }

    public boolean preferPostalFallback() {
        return this.m_preferPostalFallback;
    }

    public void setPreferPostalFallback(boolean bPrefer) {
        this.m_preferPostalFallback = bPrefer;
    }

    public static String getGeocodeTypeName(int geocodeType) {
        String typeName = null;
        switch (geocodeType) {
            case 1: {
                typeName = "street";
                break;
            }
            case 2: {
                typeName = "postal";
                break;
            }
            case 3: {
                typeName = "geographic";
                break;
            }
            case 4: {
                typeName = "poi";
            }
        }
        return typeName;
    }

    public void setStandardMatchModeSettings(List<FieldType> fieldList) {
        if ("DefaultMode".equals(this.m_geocodeConstraints.getMatchMode()) && fieldList != null) {
            for (FieldType element : fieldList) {
                switch (element.getKey()) {
                    case 8: {
                        this.m_geocodeConstraints.setMustMatchMainAddress(true);
                        break;
                    }
                    case 16: {
                        this.m_geocodeConstraints.setMustMatchArea1(true);
                        break;
                    }
                    case 17: {
                        this.m_geocodeConstraints.setMustMatchArea2(true);
                        break;
                    }
                    case 18: {
                        this.m_geocodeConstraints.setMustMatchArea3(true);
                        break;
                    }
                    case 19: {
                        this.m_geocodeConstraints.setMustMatchArea4(true);
                        break;
                    }
                    case 15: {
                        this.m_geocodeConstraints.setMustMatchPostalCode(true);
                        break;
                    }
                    case 4: {
                        this.m_geocodeConstraints.setMustMatchAddressNumber(true);
                        break;
                    }
                }
            }
        }
    }
}

