/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.ICGGEIntersectionHelper;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalIntersectionScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryItemUtils;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class IntersectionBuilder {
    private final ParsedAddress parsedAddress;
    private final GeocodeOptions options;
    private final ICGGEMatcher matcher;
    private final IDataManager dataManager;
    private InternalCandidateList m_candidateList = null;
    protected static final int ADJUST_VAL = 50;

    public IntersectionBuilder(IDataManager dataManager, ParsedAddress parseAddr, ICGGEMatcher matcher, GeocodeOptions options, InternalCandidateList candidateList) {
        this.parsedAddress = parseAddr;
        this.matcher = matcher;
        this.options = options;
        this.dataManager = dataManager;
        this.m_candidateList = candidateList;
    }

    public InternalCandidateList buildIntersection(InternalCandidateList candListList) throws CGGERuntimeException, CGGEInternalException, DataFetchException, IOException, DataNotInitialisedException {
        InternalCandidateList internalCandidateList = candListList;
        if (candListList != null) {
            internalCandidateList = this.buildIntersection(candListList, this.matcher, this.parsedAddress, this.options);
        }
        return internalCandidateList;
    }

    private InternalCandidateList buildIntersection(InternalCandidateList candListList, ICGGEMatcher matcher, ParsedAddress parseAddr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException, DataFetchException, IOException, DataNotInitialisedException {
        InternalCandidateList intersectionCandList = null;
        InternalScoringAddress firstStreetCand = null;
        InternalScoringAddress secondStreetCand = null;
        int candsFound = 0;
        int closeMatchFound = 0;
        ICGGEIntersectionHelper helper = CGGEHandler.getInstance(null, parseAddr.getCountry(), parseAddr.getLanguage()).getIntersectionHelper();
        int candCount = helper.computeCandidateCountForIntersection(candListList.getCandidateCount());
        candCount = this.adjustProcessingCount(candListList, candCount);
        block0: for (int candNdx = 0; candNdx < candCount - 1; ++candNdx) {
            firstStreetCand = candListList.getIndexedCandidate(candNdx);
            MatchingOptions matchOptions = matcher.getMatchingOptions(options, firstStreetCand.getDataSetInfo());
            boolean firstIsGood = firstStreetCand.isCloseMatch();
            if (!firstIsGood && !(firstStreetCand.getCombinedPostalScore() >= matchOptions.getAreaFieldCutoff())) continue;
            for (int candNdx1 = candNdx + 1; candNdx1 < candCount; ++candNdx1) {
                InternalScoringAddress firstStreetCandCopy;
                secondStreetCand = candListList.getIndexedCandidate(candNdx1);
                if (!DictionaryItemUtils.fromSameDataSet(firstStreetCand, secondStreetCand) || firstStreetCand.getDictionaryNumber() != secondStreetCand.getDictionaryNumber()) continue;
                boolean possibleIntersection = false;
                boolean secondIsGood = secondStreetCand.isCloseMatch();
                boolean candReMatched = false;
                if (firstIsGood && secondIsGood) {
                    possibleIntersection = true;
                } else if (firstIsGood) {
                    InternalScoringAddress secondStreetCandCopy = this.rematchCandidateAddress(secondStreetCand, firstStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE), parseAddr, matcher, options);
                    if (secondStreetCandCopy != null && (secondStreetCandCopy.isCloseMatch() || secondStreetCandCopy.getCombinedScore() >= matchOptions.getCloseMatchCutoff() || secondStreetCandCopy.getCombinedPostalScore() >= matchOptions.getAreaFieldCutoff() && secondStreetCandCopy.getCombinedStreetScore() >= matchOptions.getStreetFieldCutoff())) {
                        secondStreetCand = secondStreetCandCopy;
                        possibleIntersection = true;
                        candReMatched = true;
                    }
                } else if (secondIsGood && (firstStreetCandCopy = this.rematchCandidateAddress(firstStreetCand, secondStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE), parseAddr, matcher, options)) != null && (firstStreetCandCopy.isCloseMatch() || firstStreetCandCopy.getCombinedScore() >= matchOptions.getCloseMatchCutoff() && firstStreetCandCopy.getCombinedPostalScore() >= matchOptions.getAreaFieldCutoff() && firstStreetCandCopy.getCombinedStreetScore() >= matchOptions.getStreetFieldCutoff())) {
                    firstStreetCand = firstStreetCandCopy;
                    possibleIntersection = true;
                    candReMatched = true;
                }
                if (!possibleIntersection) continue;
                InternalIntersectionScoringAddress intersection = this.getPossibleIntersection(firstStreetCand, secondStreetCand, !candReMatched, matchOptions);
                if (intersection == null && !candReMatched) {
                    InternalScoringAddress firstStreetCandCopy2;
                    FieldScore firstScore = firstStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    FieldScore secondScore = secondStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    int comp = 0;
                    if (firstScore != null && secondScore != null) {
                        comp = firstScore.compare(firstScore, secondScore);
                    }
                    if (comp > 0) {
                        InternalScoringAddress secondStreetCandCopy = this.rematchCandidateAddress(secondStreetCand, firstStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE), parseAddr, matcher, options);
                        if (secondStreetCandCopy != null && (secondStreetCandCopy.isCloseMatch() || secondStreetCandCopy.getCombinedScore() >= matchOptions.getCloseMatchCutoff() && secondStreetCandCopy.getCombinedPostalScore() >= matchOptions.getAreaFieldCutoff() && secondStreetCandCopy.getCombinedStreetScore() >= matchOptions.getStreetFieldCutoff())) {
                            secondStreetCand = secondStreetCandCopy;
                            candReMatched = true;
                        }
                    } else if (comp < 0 && (firstStreetCandCopy2 = this.rematchCandidateAddress(firstStreetCand, secondStreetCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE), parseAddr, matcher, options)) != null && (firstStreetCandCopy2.isCloseMatch() || firstStreetCandCopy2.getCombinedScore() >= matchOptions.getCloseMatchCutoff() && firstStreetCandCopy2.getCombinedPostalScore() >= matchOptions.getAreaFieldCutoff() && firstStreetCandCopy2.getCombinedStreetScore() >= matchOptions.getStreetFieldCutoff())) {
                        firstStreetCand = firstStreetCandCopy2;
                        candReMatched = true;
                    }
                    if (candReMatched) {
                        intersection = this.getPossibleIntersection(firstStreetCand, secondStreetCand, !candReMatched, matchOptions);
                    }
                }
                if (intersection != null) {
                    int curCandCount;
                    int n = curCandCount = intersectionCandList != null ? this.m_candidateList.getCandidateCount() : 0;
                    if (curCandCount > 0) {
                        for (int curCandNdx = 0; curCandNdx < curCandCount; ++curCandNdx) {
                            InternalScoringAddress candidateToCheck = this.m_candidateList.getIndexedCandidate(curCandNdx);
                            if (!(candidateToCheck instanceof InternalIntersectionScoringAddress) || !intersection.isSameIntersection((InternalIntersectionScoringAddress)candidateToCheck)) continue;
                            intersection = null;
                            break;
                        }
                    }
                }
                if (intersection == null) continue;
                if (intersectionCandList == null) {
                    intersectionCandList = new InternalCandidateList();
                }
                intersectionCandList.addCandidate(intersection);
                ++candsFound;
                if (intersection.isCloseMatch()) {
                    ++closeMatchFound;
                }
                intersectionCandList.setNumberOfCloseMatches(closeMatchFound);
                if (helper.shortCircuitIntersection(intersection, parseAddr)) break block0;
            }
        }
        if (candsFound > 1) {
            List<InternalScoringAddress> cands = intersectionCandList.getCandidateList();
            Comparator<InternalScoringAddress> comp = new Comparator<InternalScoringAddress>(){

                @Override
                public int compare(InternalScoringAddress o1, InternalScoringAddress o2) {
                    if (o1.isCloseMatch() == o2.isCloseMatch()) {
                        double diff = o1.getCombinedScore() - o2.getCombinedScore();
                        if (diff > 0.0) {
                            return -1;
                        }
                        if (diff < 0.0) {
                            return 1;
                        }
                        return 0;
                    }
                    if (o1.isCloseMatch()) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(cands, comp);
        }
        return intersectionCandList;
    }

    private InternalScoringAddress rematchCandidateAddress(InternalScoringAddress candAddr, FieldScore score, ParsedAddress parseAddr, ICGGEMatcher matcher, GeocodeOptions options) throws CGGEInternalException {
        InternalScoringAddress returnAddr = null;
        if (score != null && score.m_matchedInputWords != null && score.m_inputWords == parseAddr.getField(FieldType.STREET_NAME_FIELD_TYPE)) {
            int len;
            ParsedAddress parsedAddrCopy = new ParsedAddress(parseAddr.getCountry(), parseAddr.getLanguage());
            parsedAddrCopy.copy(parseAddr);
            AddressWord[] words = (AddressWord[])parsedAddrCopy.getField(FieldType.STREET_NAME_FIELD_TYPE);
            int n = len = words == null ? 0 : words.length;
            if (len > 0) {
                int firstMatchedWordNdx = score.m_matchedInputWords.min();
                int lastMatchedWordNdx = score.m_matchedInputWords.max();
                int removed = 0;
                ArrayList<AddressWord> filterWordList = new ArrayList<AddressWord>(len);
                for (int wordNdx = 0; wordNdx < len; ++wordNdx) {
                    if (wordNdx < firstMatchedWordNdx || wordNdx > lastMatchedWordNdx) {
                        filterWordList.add(words[wordNdx]);
                        continue;
                    }
                    ++removed;
                }
                if (filterWordList.size() > 0) {
                    List<AddressNumber> probableNums;
                    int[] pos;
                    AddressWord[] filteredWords = filterWordList.toArray(new AddressWord[filterWordList.size()]);
                    parsedAddrCopy.setField(FieldType.STREET_NAME_FIELD_TYPE, filteredWords);
                    List<PostCode> probablePcs = parsedAddrCopy.getProbablePostcodes();
                    if (probablePcs != null) {
                        Iterator<PostCode> pcIt = probablePcs.iterator();
                        ArrayList<PostCode> newPcs = new ArrayList<PostCode>(probablePcs.size());
                        while (pcIt.hasNext()) {
                            PostCode pc = pcIt.next();
                            pos = pc.getPositionInInputStreet();
                            if (pos != null && firstMatchedWordNdx < pos[1]) {
                                if (lastMatchedWordNdx < pos[0]) {
                                    int[] newPos = new int[]{pos[0] - removed, pos[1] - removed};
                                    PostCode pc1 = new PostCode(pc.getWords(), newPos);
                                    newPcs.add(pc1);
                                    continue;
                                }
                                pcIt.remove();
                                continue;
                            }
                            newPcs.add(pc);
                        }
                        if (newPcs.size() > 0) {
                            parsedAddrCopy.setProbablePostcodes(newPcs);
                        } else {
                            parsedAddrCopy.setProbablePostcodes(null);
                        }
                    }
                    if ((probableNums = parsedAddrCopy.getProbableAddressNumbers()) != null) {
                        Iterator<AddressNumber> numIt = probableNums.iterator();
                        while (numIt.hasNext()) {
                            AddressNumber num = numIt.next();
                            pos = num.getPositionInInputStreet();
                            if (pos == null || firstMatchedWordNdx >= pos[1]) continue;
                            if (lastMatchedWordNdx < pos[0]) {
                                pos[0] = pos[0] - removed;
                                pos[1] = pos[1] - removed;
                                continue;
                            }
                            numIt.remove();
                        }
                    }
                    int currentWord = 0;
                    for (AddressWord word : (AddressWord[])parsedAddrCopy.getField(FieldType.STREET_NAME_FIELD_TYPE)) {
                        word.setData(new Integer(currentWord++));
                    }
                    InternalScoringAddress candAddrCopy = new InternalScoringAddress(candAddr.getInternalStreetAddress());
                    InternalCandidateList candList = new InternalCandidateList();
                    candList.addCandidate(candAddrCopy);
                    matcher.scoreCandidates(parsedAddrCopy, candList, options, this.dataManager);
                    returnAddr = candList.getIndexedCandidate(0);
                }
            }
        }
        return returnAddr;
    }

    private InternalIntersectionScoringAddress getPossibleIntersection(InternalScoringAddress firstCand, InternalScoringAddress secondCand, boolean checkMatchedWords, MatchingOptions matchOptions) throws CGGERuntimeException, CGGEInternalException, DataFetchException, IOException, DataNotInitialisedException {
        FieldScore firstCandStreetScore = firstCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        FieldScore sndCandStreetScore = secondCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        InternalIntersectionScoringAddress intersection = null;
        if (firstCandStreetScore != null && sndCandStreetScore != null) {
            IntArray firstMatchedWordNdx = firstCandStreetScore.m_matchedInputWords;
            IntArray sndMatchedWordNdx = sndCandStreetScore.m_matchedInputWords;
            if (!(firstMatchedWordNdx == null || firstMatchedWordNdx.size() <= 0 || sndMatchedWordNdx == null || sndMatchedWordNdx.size() <= 0 || checkMatchedWords && sndMatchedWordNdx.max() >= firstMatchedWordNdx.min() && sndMatchedWordNdx.min() <= firstMatchedWordNdx.max() || (intersection = firstMatchedWordNdx.min() > sndMatchedWordNdx.min() ? new InternalIntersectionScoringAddress(secondCand, firstCand) : new InternalIntersectionScoringAddress(firstCand, secondCand)).hasIntersection(this.dataManager))) {
                intersection = null;
            }
        }
        return intersection;
    }

    protected int adjustProcessingCount(InternalCandidateList candList, int count) {
        int closeCnt = candList.getNumberOfCloseMatches();
        if (count - closeCnt > 50) {
            return closeCnt + 50;
        }
        return count;
    }
}

