/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatchingOptions {
    private GeocodeOptions m_geocodeOptions;
    private double m_streetFieldCutoff;
    private double m_areaFieldCutoff;
    private double m_rangeFieldCutoff;
    private double m_closeMatchCutoff;
    private Map<String, Object> m_additionalOptions;
    private double m_postAddressWeight;
    private double m_streetAddressWeight;
    private double m_rangeAddressWeight;
    private int m_maxAddressNumberOffsetAllowed;
    private Map<FieldType, Double> m_fieldWeightMap;
    private double m_matchedWordWeight;
    private double m_matchedFieldWeight;
    private double m_candidateCutoff;
    private double m_relativeCutoff;
    private Map<FieldType, List<FieldType>> m_compareFieldMap;
    private List<FieldType> m_singleLineCompareFields;
    private List<FieldType> m_postAddressCompareFields;
    private boolean m_adjustScoreForMissingWords;
    private List<FieldType> m_mmStndFields;
    private List<FieldType> m_optionalFields;
    private boolean m_adjustMatchForCandsWithoutSignificantSearchWord;
    private Map<FieldType, Double> m_minimumScoreForSignificantWordMatch;

    public MatchingOptions() {
        this((GeocodeOptions)null);
        this.m_adjustScoreForMissingWords = false;
    }

    public MatchingOptions(GeocodeOptions options) {
        this.m_geocodeOptions = options;
        this.m_additionalOptions = new HashMap<String, Object>();
        this.m_fieldWeightMap = new HashMap<FieldType, Double>(50);
        this.m_minimumScoreForSignificantWordMatch = new HashMap<FieldType, Double>(5);
        this.m_singleLineCompareFields = new ArrayList<FieldType>(7);
        this.m_singleLineCompareFields.add(FieldType.STREET_NAME_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.POST_CODE_FIELD_TYPE);
        this.m_singleLineCompareFields.add(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        this.m_postAddressCompareFields = new ArrayList<FieldType>(5);
        this.m_postAddressCompareFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
        this.m_postAddressCompareFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
        this.m_postAddressCompareFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
        this.m_postAddressCompareFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
        this.m_postAddressCompareFields.add(FieldType.POST_CODE_FIELD_TYPE);
        this.m_adjustScoreForMissingWords = false;
        this.m_adjustMatchForCandsWithoutSignificantSearchWord = false;
    }

    public MatchingOptions(MatchingOptions copy) {
        this(copy.m_geocodeOptions);
        this.m_streetFieldCutoff = copy.m_streetFieldCutoff;
        this.m_areaFieldCutoff = copy.m_areaFieldCutoff;
        this.m_rangeFieldCutoff = copy.m_rangeFieldCutoff;
        this.m_postAddressWeight = copy.m_postAddressWeight;
        this.m_streetAddressWeight = copy.m_streetAddressWeight;
        this.m_rangeAddressWeight = copy.m_rangeAddressWeight;
        this.m_closeMatchCutoff = copy.m_closeMatchCutoff;
        this.m_maxAddressNumberOffsetAllowed = copy.m_maxAddressNumberOffsetAllowed;
        this.m_matchedWordWeight = copy.m_matchedWordWeight;
        this.m_matchedFieldWeight = copy.m_matchedFieldWeight;
        this.m_geocodeOptions = copy.m_geocodeOptions;
        this.m_fieldWeightMap.putAll(copy.m_fieldWeightMap);
        this.m_candidateCutoff = copy.m_candidateCutoff;
        this.m_relativeCutoff = copy.m_relativeCutoff;
        this.m_additionalOptions.putAll(copy.m_additionalOptions);
        if (copy.m_compareFieldMap == null) {
            this.m_compareFieldMap = null;
        } else {
            this.m_compareFieldMap = new HashMap<FieldType, List<FieldType>>(copy.m_compareFieldMap.size());
            this.m_compareFieldMap.putAll(copy.m_compareFieldMap);
        }
        if (copy.m_singleLineCompareFields == null) {
            this.m_singleLineCompareFields = null;
        } else {
            this.m_singleLineCompareFields = new ArrayList<FieldType>(copy.m_singleLineCompareFields.size());
            this.m_singleLineCompareFields.addAll(copy.m_singleLineCompareFields);
        }
        if (copy.m_postAddressCompareFields == null) {
            this.m_postAddressCompareFields = null;
        } else {
            this.m_postAddressCompareFields = new ArrayList<FieldType>(copy.m_postAddressCompareFields.size());
            this.m_postAddressCompareFields.addAll(copy.m_postAddressCompareFields);
        }
        if (copy.m_mmStndFields == null) {
            this.m_mmStndFields = null;
        } else {
            this.m_mmStndFields = new ArrayList<FieldType>(copy.m_mmStndFields.size());
            this.m_mmStndFields.addAll(copy.m_mmStndFields);
        }
        if (copy.m_optionalFields != null) {
            this.m_optionalFields = new ArrayList<FieldType>(copy.m_optionalFields.size());
            this.m_optionalFields.addAll(copy.m_optionalFields);
        } else {
            this.m_optionalFields = null;
        }
        if (copy.m_minimumScoreForSignificantWordMatch != null) {
            this.m_minimumScoreForSignificantWordMatch = new HashMap<FieldType, Double>(copy.m_minimumScoreForSignificantWordMatch.size());
            this.m_minimumScoreForSignificantWordMatch.putAll(copy.m_minimumScoreForSignificantWordMatch);
        } else {
            this.m_minimumScoreForSignificantWordMatch = null;
        }
        this.m_adjustScoreForMissingWords = copy.m_adjustScoreForMissingWords;
        this.m_adjustMatchForCandsWithoutSignificantSearchWord = copy.m_adjustMatchForCandsWithoutSignificantSearchWord;
    }

    public GeocodeOptions getGeocodeOptions() {
        return this.m_geocodeOptions;
    }

    public void setGeocodeOptions(GeocodeOptions options) {
        this.m_geocodeOptions = options;
    }

    public double getCloseMatchCutoff() {
        return this.m_closeMatchCutoff;
    }

    public void setCloseMatchCutoff(double cutoff) {
        this.m_closeMatchCutoff = cutoff;
    }

    public double getPostAddressWeight() {
        return this.m_postAddressWeight;
    }

    public void setPostAddressWeight(double w) {
        this.m_postAddressWeight = w;
    }

    public double getStreetAddressWeight() {
        return this.m_streetAddressWeight;
    }

    public void setStreetAddressWeight(double w) {
        this.m_streetAddressWeight = w;
    }

    public double getRangeAddressWeight() {
        return this.m_rangeAddressWeight;
    }

    public void setRangeAddressWeight(double w) {
        this.m_rangeAddressWeight = w;
    }

    public double getFieldWeight(FieldType fieldType) {
        Double weight = this.m_fieldWeightMap.get(fieldType);
        if (weight != null) {
            return weight;
        }
        return 0.0;
    }

    public double getMinimumScoreForSignificantWordMatch(FieldType fieldType) {
        Double minValue = this.m_minimumScoreForSignificantWordMatch.get(fieldType);
        if (minValue != null) {
            return minValue;
        }
        return 0.0;
    }

    public void addFieldWeight(FieldType type, double weight) {
        this.m_fieldWeightMap.put(type, weight);
    }

    public void setAdditionalOption(String key, Object value) {
        this.m_additionalOptions.put(key, value);
    }

    public Object getAdditionalOption(String key) {
        return this.m_additionalOptions.get(key);
    }

    public int getMaxAddressNumberOffsetAllowed() {
        return this.m_maxAddressNumberOffsetAllowed;
    }

    public void setMaxAddressNumberOffsetAllowed(int i) {
        this.m_maxAddressNumberOffsetAllowed = i;
    }

    public double getAreaFieldCutoff() {
        return this.m_areaFieldCutoff;
    }

    public double getStreetFieldCutoff() {
        return this.m_streetFieldCutoff;
    }

    public void setAreaFieldCutoff(double d) {
        this.m_areaFieldCutoff = d;
    }

    public void setStreetFieldCutoff(double d) {
        this.m_streetFieldCutoff = d;
    }

    public double getRangeFieldCutoff() {
        return this.m_rangeFieldCutoff;
    }

    public void setRangeFieldCutoff(double rangeFieldCutoff) {
        this.m_rangeFieldCutoff = rangeFieldCutoff;
    }

    public double getMatchedWordWeight() {
        return this.m_matchedWordWeight;
    }

    public void setMatchedWordWeight(double wordWeight) {
        this.m_matchedWordWeight = wordWeight;
    }

    public double getMatchedFieldWeight() {
        return this.m_matchedFieldWeight;
    }

    public void setMatchedFieldWeight(double fieldWeight) {
        this.m_matchedFieldWeight = fieldWeight;
    }

    public double getCandidateCutoff() {
        return this.m_candidateCutoff;
    }

    public void setCandidateCutoff(double d) {
        this.m_candidateCutoff = d;
    }

    public double getRelativeCutoff() {
        return this.m_relativeCutoff;
    }

    public void setRelativeCutoff(double d) {
        this.m_relativeCutoff = d;
    }

    public void setSingleLineCompareFields(List<FieldType> fieldTypes) {
        this.m_singleLineCompareFields = fieldTypes;
    }

    public List<FieldType> getSingleLineCompareFields() {
        return this.m_singleLineCompareFields;
    }

    public boolean isSingleLineCompareField(FieldType type) {
        return this.m_singleLineCompareFields != null && this.m_singleLineCompareFields.contains(type);
    }

    public void setPostAddressCompareFields(List<FieldType> fieldTypes) {
        this.m_postAddressCompareFields = fieldTypes;
    }

    public List<FieldType> getPostAddressCompareFields() {
        return this.m_postAddressCompareFields;
    }

    public boolean isPostAddressCompareField(FieldType type) {
        return this.m_postAddressCompareFields != null && this.m_postAddressCompareFields.contains(type);
    }

    public List<FieldType> getCompareFieldsForField(FieldType type) {
        return this.m_compareFieldMap == null ? null : this.m_compareFieldMap.get(type);
    }

    public void setCompareFieldsForField(FieldType type, List<FieldType> compareFieldList) {
        if (this.m_compareFieldMap == null) {
            this.m_compareFieldMap = new HashMap<FieldType, List<FieldType>>();
        }
        this.m_compareFieldMap.put(type, compareFieldList);
    }

    public void setAdjustScoresForMissingWords(boolean b) {
        this.m_adjustScoreForMissingWords = b;
    }

    public boolean getAdjustMatchForCandsWithoutSignificantSearchWord() {
        return this.m_adjustMatchForCandsWithoutSignificantSearchWord;
    }

    public void setAdjustMatchForCandsWithoutSignificantSearchWord(boolean b) {
        this.m_adjustMatchForCandsWithoutSignificantSearchWord = b;
    }

    public boolean getAdjustScoresForMissingWords() {
        return this.m_adjustScoreForMissingWords;
    }

    public List<FieldType> getStandardMatchModeFields() {
        return this.m_mmStndFields;
    }

    public void setStandardMatchModeFields(List<FieldType> fieldList) {
        this.m_mmStndFields = fieldList;
    }

    public void setOptionalFieldList(List<FieldType> optionalFields) {
        this.m_optionalFields = optionalFields;
    }

    public List<FieldType> getOptionalFieldList() {
        return this.m_optionalFields;
    }

    public boolean isOptionalField(FieldType type) {
        int c = this.m_optionalFields == null ? 0 : this.m_optionalFields.size();
        for (int i = 0; i < c; ++i) {
            if (this.m_optionalFields.get(i) != type) continue;
            return true;
        }
        return false;
    }

    public double getMinScoreForFieldWithMatchedSignificantWord(FieldType type) {
        Double d = this.m_minimumScoreForSignificantWordMatch.get(type);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void setMinScoreForFieldWithMatchedSignificantWord(FieldType type, double d) {
        this.m_minimumScoreForSignificantWordMatch.put(type, d);
    }
}

