/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public abstract class Address<T> {
    private Map<FieldType, T> m_fieldMap = new HashMap<FieldType, T>();

    public Address() {
    }

    public Address(Address<T> address) {
        this.copy(address);
    }

    public void copy(Address<T> address) {
        this.m_fieldMap.clear();
        this.m_fieldMap.putAll(address.m_fieldMap);
    }

    public void setField(FieldType key, T value) {
        this.m_fieldMap.put(key, value);
    }

    public T getField(FieldType key) {
        return this.m_fieldMap.get(key);
    }

    public Map<FieldType, T> getFields() {
        return this.m_fieldMap;
    }

    public boolean isEmpty(FieldType fieldType) {
        return this.m_fieldMap.get(fieldType) == null;
    }

    public static <T extends Comparable<T>> int compareFieldValues(Map<FieldType, T> fieldMap1, Map<FieldType, T> fieldMap2) {
        TreeSet<FieldType> fieldTypes = new TreeSet<FieldType>(fieldMap1.keySet());
        fieldTypes.addAll(fieldMap2.keySet());
        for (FieldType type : fieldTypes) {
            int c = Address.compareFieldValues((Comparable)fieldMap1.get(type), (Comparable)fieldMap2.get(type));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static <T extends Comparable<T>> int compareFieldValues(T fv1, T fv2) {
        if (fv1 != null && fv2 != null) {
            return fv1.compareTo(fv2);
        }
        if (fv1 != null) {
            return 1;
        }
        if (fv2 != null) {
            return -1;
        }
        return 0;
    }

    public boolean hasFields() {
        return !this.m_fieldMap.isEmpty();
    }

    public String toString() {
        return this.m_fieldMap.toString();
    }
}

