/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import java.util.Comparator;

public class AddressNumber
implements Comparator<AddressNumber> {
    private int[] m_positionInInputAdd;
    protected int m_number1;
    protected int m_number2;
    protected String m_suffix1;
    protected String m_suffix2;
    protected int m_separatorType;
    protected AddressNumber m_secondAddressNumber;
    public static final int SEPERATOR_HYPHEN = 0;
    public static final int SEPERATOR_SLASH = 1;
    public static final int SEPARATOR_NONE = 2;
    public static final int TYPE_NUMERIC = 1;
    public static final int TYPE_ALPHANUMERIC = 2;
    public static final int TYPE_RANGE = 3;

    public AddressNumber() {
        this.m_number1 = 0;
        this.m_number2 = 0;
        this.m_suffix1 = null;
        this.m_suffix2 = null;
        this.m_separatorType = 0;
        this.m_secondAddressNumber = null;
    }

    public AddressNumber(int hnr) {
        this.m_number1 = hnr;
        this.m_number2 = 0;
        this.m_suffix1 = null;
        this.m_suffix2 = null;
        this.m_separatorType = 0;
        this.m_secondAddressNumber = null;
    }

    public int getType() {
        if (this.m_number2 < 1 && this.m_secondAddressNumber == null) {
            if (this.m_suffix1 == null) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    public boolean isRange() {
        return this.m_number1 > 0 && this.m_number2 > 0;
    }

    @Override
    public int compare(AddressNumber hnr1, AddressNumber hnr2) {
        int diff = hnr1.m_number1 - hnr2.m_number1;
        if (diff == 0) {
            if (hnr1.m_suffix1 == hnr2.m_suffix1 || hnr1.m_suffix1 != null && hnr2.m_suffix1 != null) {
                if (hnr1.m_suffix1 != null) {
                    diff = hnr1.m_suffix1.compareTo(hnr2.m_suffix1);
                }
                if (diff == 0) {
                    diff = hnr1.m_number2 - hnr2.m_number2;
                }
                if (diff == 0) {
                    if (hnr1.m_suffix2 != null && hnr2.m_suffix2 != null) {
                        diff = hnr1.m_suffix2.compareTo(hnr2.m_suffix2);
                    } else if (hnr1.m_suffix2 != null) {
                        diff = 1;
                    } else if (hnr2.m_suffix2 != null) {
                        diff = -1;
                    }
                }
            } else if (hnr1.m_suffix1 != null) {
                diff = 1;
            } else if (hnr2.m_suffix1 != null) {
                diff = -1;
            }
        }
        return diff;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AddressNumber) {
            return this.compare(this, (AddressNumber)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int value = 17;
        value = 31 * value + this.m_number1;
        value = 31 * value + this.m_number2;
        value = 31 * value + (this.m_suffix1 == null ? 0 : this.m_suffix1.hashCode());
        value = 31 * value + (this.m_suffix2 == null ? 0 : this.m_suffix2.hashCode());
        return value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(8);
        if (this.m_number1 > 0 || this.m_separatorType == 1 && (this.m_number2 > 0 || this.m_suffix2 != null)) {
            buf.append(this.m_number1);
        }
        if (this.m_suffix1 != null) {
            buf.append(this.m_suffix1);
        }
        if (this.m_separatorType == 2 && this.m_suffix1 != null && this.m_number2 > 0) {
            buf.append(this.m_number2);
        }
        if (this.m_separatorType != 2 && (this.m_number2 > 0 || this.m_suffix2 != null)) {
            if (this.m_separatorType == 1) {
                buf.append('/');
            } else {
                buf.append('-');
            }
            if (this.m_number2 > 0) {
                buf.append(this.m_number2);
            }
            if (this.m_suffix2 != null) {
                buf.append(this.m_suffix2);
            }
        } else if (this.m_separatorType == 2 && this.m_suffix2 != null) {
            buf.append(this.m_suffix2);
        }
        if (this.m_secondAddressNumber != null) {
            buf.append('-');
            buf.append(this.m_secondAddressNumber.toString());
        }
        return buf.toString();
    }

    public int getHnrNumber1() {
        return this.m_number1;
    }

    public void setHnrNumber1(int hnrNumber1) {
        this.m_number1 = hnrNumber1;
    }

    public int getHnrNumber2() {
        return this.m_number2;
    }

    public void setHnrNumber2(int hnrNumber2) {
        this.m_number2 = hnrNumber2;
    }

    public String getHnrSuffix1() {
        return this.m_suffix1;
    }

    public void setHnrSuffix1(String hnrSuffix1) {
        this.m_suffix1 = hnrSuffix1;
    }

    public String getHnrSuffix2() {
        return this.m_suffix2;
    }

    public void setHnrSuffix2(String hnrSuffix2) {
        this.m_suffix2 = hnrSuffix2;
    }

    public AddressNumber getSecondHNR() {
        return this.m_secondAddressNumber;
    }

    public void setSecondHNR(AddressNumber secondHNR) {
        this.m_secondAddressNumber = secondHNR;
    }

    public int getSeperatorType() {
        return this.m_separatorType;
    }

    public void setSeperatorType(int seperatorType) {
        this.m_separatorType = seperatorType;
    }

    public int[] getPositionInInputStreet() {
        return this.m_positionInInputAdd;
    }

    public void setPositionInInputStreet(int[] pos) {
        this.m_positionInInputAdd = pos;
    }
}

