/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.List;

public class AddressWord
implements Comparable<AddressWord> {
    private CodedWord m_codedWord;
    public byte m_weight;
    public double m_quality;
    public FieldType m_wordType;
    private Object m_data;
    private byte m_attributes;
    List<WordAlternate> m_alternates;

    public AddressWord(CodedWord codedWord) {
        this.m_codedWord = codedWord;
        this.m_weight = 0;
        this.m_quality = 0.0;
        this.m_wordType = FieldType.UNKNOWN_FIELD_TYPE;
    }

    public boolean hasAlternates() {
        return this.m_alternates != null && this.m_alternates.size() > 0;
    }

    public void setAlternates(List<WordAlternate> alternates) {
        this.m_alternates = alternates;
    }

    public List<WordAlternate> getAlternates() {
        return this.m_alternates;
    }

    public void addAlternate(WordAlternate alternate) {
        if (alternate != null) {
            if (this.m_alternates == null) {
                this.m_alternates = new ArrayList<WordAlternate>(2);
            }
            this.m_alternates.add(alternate);
        }
    }

    public AddressWord(String word) {
        this(new CodedWord(word));
    }

    public int hashCode() {
        if (this.m_codedWord != null) {
            return this.m_codedWord.getSoundex() ^ this.m_codedWord.getOffset();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof AddressWord) {
            return this.compareTo((AddressWord)obj) == 0;
        }
        return false;
    }

    public boolean equals(AddressWord word) {
        if (this.m_wordType == word.m_wordType) {
            if (this.m_codedWord == word.m_codedWord) {
                return true;
            }
            if (this.m_codedWord != null && word.m_codedWord != null) {
                return this.m_codedWord.equals(word.m_codedWord);
            }
        }
        return false;
    }

    @Override
    public int compareTo(AddressWord addrWord) {
        int comp = 0;
        if (this.m_wordType != null && addrWord.m_wordType != null) {
            comp = this.m_wordType.compare(this.m_wordType, addrWord.m_wordType);
        } else if (this.m_wordType != null) {
            comp = 1;
        } else if (addrWord.m_wordType != null) {
            comp = -1;
        }
        if (comp == 0) {
            CodedWord w1 = this.getCodedWord();
            CodedWord w2 = addrWord.getCodedWord();
            if (w1 != null && w2 != null) {
                comp = w1.compareTo(w2);
            } else if (w1 != null) {
                comp = 1;
            } else if (w2 != null) {
                comp = -1;
            }
        }
        return comp;
    }

    public AddressWord(AddressWord addressWord) {
        this.m_codedWord = addressWord.m_codedWord;
        this.m_quality = addressWord.m_quality;
        this.m_weight = addressWord.m_weight;
        this.m_wordType = addressWord.m_wordType;
        this.m_data = addressWord.m_data;
        this.m_attributes = addressWord.m_attributes;
        this.m_alternates = addressWord.m_alternates;
    }

    public AddressWord(char[] chars, int soundex, int offset, FieldType wordType, byte weight) {
        this(new CodedWord(chars, soundex, offset));
        this.m_wordType = wordType;
        this.m_weight = weight;
    }

    public AddressWord(String word, int soundex, int offset, FieldType wordType, byte weight) {
        this(new CodedWord(word, soundex, offset));
        this.m_wordType = wordType;
        this.m_weight = weight;
    }

    public CodedWord getCodedWord() {
        return this.m_codedWord;
    }

    public void setCodedWord(CodedWord codedWord) {
        this.m_codedWord = codedWord;
    }

    public boolean isRelatedWord(AddressWord addrWord) {
        if (this.m_alternates != null) {
            CodedWord checkWord = addrWord.getCodedWord();
            for (WordAlternate alt : this.m_alternates) {
                WordAlternate.ALT_TYPE type = alt.getAltType();
                if (type == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                AddressWord altWord = alt.getAltWord();
                if (CodedWord.compareNormalizedBytes(checkWord, altWord.getCodedWord()) == 0) {
                    return true;
                }
                if (!CodedWord.isThoroughfareTypeWord(altWord.getAttributes()) || addrWord.m_alternates == null || !addrWord.isRelatedWord(altWord)) continue;
                return true;
            }
        }
        return false;
    }

    public int getNumberValue() {
        if (!this.isNumeral()) {
            throw new NumberFormatException("Word is not a number or numeral");
        }
        if (CodedWord.isNumber(this.getAttributes())) {
            return MMUtils.parseInteger(this.getNormalizedChars());
        }
        if (this.m_alternates != null) {
            for (WordAlternate alt : this.m_alternates) {
                if (alt.getAltType() != WordAlternate.ALT_TYPE.TYPE_NUMER) continue;
                return MMUtils.parseInteger(alt.getAltWord().getNormalizedChars());
            }
        }
        throw new NumberFormatException("Word is set as a numeric, but no alternate number was provided");
    }

    public String getWord() {
        return this.m_codedWord != null ? this.m_codedWord.getWord() : null;
    }

    public int getWordLength() {
        return this.m_codedWord != null ? this.m_codedWord.getWordLength() : 0;
    }

    public char[] getWordChars() {
        return this.m_codedWord != null ? this.m_codedWord.getChars() : null;
    }

    public int getSoundex() {
        return this.m_codedWord != null ? this.m_codedWord.getSoundex() : 0;
    }

    public void setSoundex(int soundex) {
        if (this.m_codedWord == null) {
            this.m_codedWord = new CodedWord();
        }
        this.m_codedWord.setSoundex(soundex);
    }

    public void setWordChars(char[] chars) {
        if (this.m_codedWord == null) {
            this.m_codedWord = new CodedWord();
        }
        this.m_codedWord.setChars(chars);
    }

    public void setWord(String word) {
        if (this.m_codedWord == null && word != null) {
            this.m_codedWord = new CodedWord();
        }
        this.setWordChars(word == null ? null : word.toCharArray());
    }

    public void setNormalizedChars(char[] chars) {
        if (this.m_codedWord == null) {
            this.m_codedWord = new CodedWord();
        }
        this.m_codedWord.setNormalizedChars(chars);
    }

    public char[] getNormalizedChars() {
        return this.m_codedWord != null ? this.m_codedWord.getNormalizedChar() : null;
    }

    public static int compareWords(AddressWord[] words1, AddressWord[] words2) {
        int size1 = words1 == null ? 0 : words1.length;
        int size2 = words2 == null ? 0 : words2.length;
        int minSize = size1 < size2 ? size1 : size2;
        for (int i = 0; i < minSize; ++i) {
            int diff = words1[i].compareTo(words2[i]);
            if (diff == 0) continue;
            return diff;
        }
        return size1 - size2;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_codedWord == null ? "" : this.m_codedWord.toString());
        buf.append(" :weight=");
        buf.append(this.m_weight);
        buf.append(" :wordType=");
        buf.append(this.m_wordType);
        return buf.toString();
    }

    public short getAttributes() {
        if (this.m_codedWord != null) {
            return this.m_codedWord.getAttributes();
        }
        return 0;
    }

    public void setAttribute(short wordAttribs) {
        if (this.m_codedWord == null) {
            this.m_codedWord = new CodedWord();
        }
        this.m_codedWord.setAttributes(wordAttribs);
    }

    public boolean isNumeral() {
        return this.m_codedWord == null ? false : this.m_codedWord.isNumeral();
    }

    public static boolean isSignificantWord(AddressWord word) {
        short wordAttribs = word.getAttributes();
        return !CodedWord.isArticleWord(wordAttribs) && !CodedWord.isNumber(wordAttribs) && !CodedWord.isNumeric(wordAttribs) && !CodedWord.isDirectionalWord(wordAttribs) && !CodedWord.isCommonWord(wordAttribs) && !CodedWord.isThoroughfareTypeWord(wordAttribs) && !CodedWord.isDelimiter(wordAttribs);
    }
}

