/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import java.util.Arrays;

public final class CodedWord
implements Comparable<CodedWord> {
    public static final short ATTRIBUTE_ABBREVIATABLE = 2;
    public static final short ATTRIBUTE_NUMBER = 4;
    public static final short ATTRIBUTE_NUMERIC = 8;
    public static final short ATTRIBUTE_DELIMITER = 16;
    public static final short ATTRIBUTE_PROBABLE_ROMAN_NUMERAL = 32;
    public static final short ATTRIBUTE_ABBREVIATION = 64;
    public static final short ATTRIBUTE_PART_OF_MULTI_WORD_ABBREVIATABLE = 128;
    public static final short ATTRIBUTE_COMMON_WORD = 256;
    public static final short ATTRIBUTE_THOROUGHFARE_TYPE_WORD = 512;
    public static final short ATTRIBUTE_ARTICLE = 1024;
    public static final short ATTRIBUTE_DIRECTIONAL = 2048;
    private char[] m_normalizedChars;
    private short m_attributes;
    private char[] m_chars;
    private int m_soundex;
    private int m_offset;
    private long m_wordCode;

    public CodedWord() {
        this((String)null);
    }

    public CodedWord(String word) {
        this(word == null ? null : word.toCharArray(), 0, 0);
    }

    public CodedWord(String word, int soundex, int offset) {
        this(word == null ? null : word.toCharArray(), soundex, offset);
    }

    public CodedWord(char[] chars, int soundex, int offset) {
        this.m_chars = chars;
        this.m_soundex = soundex;
        this.m_offset = offset;
        this.m_wordCode = -1L;
    }

    public char[] getChars() {
        return this.m_chars;
    }

    public void setChars(char[] chars) {
        if (this.m_normalizedChars == null && !Arrays.equals(chars, this.m_chars)) {
            this.m_normalizedChars = this.m_chars;
        }
        this.m_chars = chars;
    }

    public CodedWord(CodedWord copy) {
        this.m_soundex = copy.m_soundex;
        this.m_offset = copy.m_offset;
        this.m_chars = copy.m_chars;
        this.m_wordCode = copy.m_wordCode;
        this.m_normalizedChars = copy.m_normalizedChars;
        this.m_attributes = copy.m_attributes;
    }

    public CodedWord(int soundex, int offset) {
        this.m_soundex = soundex;
        this.m_offset = offset;
    }

    @Override
    public int compareTo(CodedWord codedWord) {
        if (this.m_soundex == codedWord.m_soundex) {
            if (this.m_offset == codedWord.m_offset) {
                return CodedWord.compareBytes(this, codedWord);
            }
            return this.m_offset - codedWord.m_offset;
        }
        return this.m_soundex - codedWord.m_soundex;
    }

    public static final int compareBytes(CodedWord w1, CodedWord w2) {
        int b2Len;
        int b1Len = w1.m_chars == null ? 0 : w1.m_chars.length;
        int n = b2Len = w2.m_chars == null ? 0 : w2.m_chars.length;
        if (b1Len != b2Len || b1Len == 0) {
            return b1Len - b2Len;
        }
        for (int i = 0; i < b1Len; ++i) {
            int diff = w1.m_chars[i] - w2.m_chars[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public static final int compareNormalizedBytes(CodedWord w1, CodedWord w2) {
        int len2;
        char[] c1 = w1.getNormalizedChar();
        char[] c2 = w2.getNormalizedChar();
        int len1 = c1 == null ? 0 : c1.length;
        int n = len2 = c2 == null ? 0 : c2.length;
        if (len1 != len2 || len1 == 0) {
            return len1 - len2;
        }
        for (int i = 0; i < len1; ++i) {
            int diff = c1[i] - c2[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_chars == null ? " " : new String(this.m_chars));
        buf.append(" :Sndx=");
        buf.append(this.m_soundex);
        buf.append(" :Offset=");
        buf.append(this.m_offset);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CodedWord) {
            return this.equals((CodedWord)obj);
        }
        return false;
    }

    public boolean equals(CodedWord codedWord) {
        if (this.m_soundex == codedWord.m_soundex && this.m_offset == codedWord.m_offset) {
            return CodedWord.compareBytes(this, codedWord) == 0;
        }
        return false;
    }

    public boolean isSameWordString(CodedWord theCodedWord) {
        if (theCodedWord.m_chars != null && this.m_chars != null) {
            return Arrays.equals(this.m_chars, theCodedWord.m_chars);
        }
        return false;
    }

    public boolean isSameSoundex(int theSoundex) {
        return this.m_soundex == theSoundex;
    }

    public boolean isSameSoundex(CodedWord theCodedWord) {
        return this.m_soundex == theCodedWord.m_soundex;
    }

    public boolean isSameWord(int theSoundex, int theOffset) {
        return this.m_soundex == theSoundex && this.m_offset == theOffset;
    }

    public boolean isSameWord(CodedWord theCodedWord) {
        return this.m_soundex == theCodedWord.m_soundex && this.m_offset == theCodedWord.m_offset;
    }

    public boolean isSameStartLetter(CodedWord compareToWord) {
        if (compareToWord != null) {
            char[] chars = this.getNormalizedChar();
            char c1 = chars != null && chars.length > 0 ? chars[0] : (char)'\u0000';
            chars = compareToWord.getNormalizedChar();
            char c2 = chars != null && chars.length > 0 ? chars[0] : (char)'\u0000';
            return c1 == c2;
        }
        return false;
    }

    public String getWord() {
        if (this.m_chars != null) {
            return new String(this.m_chars);
        }
        return null;
    }

    public void setNormalizedChars(char[] normalizedChars) {
        if (normalizedChars != null && this.m_chars != null && Arrays.equals(this.m_chars, normalizedChars)) {
            this.m_normalizedChars = null;
            return;
        }
        this.m_normalizedChars = normalizedChars;
    }

    public char[] getNormalizedChar() {
        if (this.m_normalizedChars == null) {
            return this.m_chars;
        }
        return this.m_normalizedChars;
    }

    public void setSoundex(int soundex) {
        this.m_soundex = soundex;
    }

    public int getSoundex() {
        return this.m_soundex;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setWordCode(long wordCode) {
        this.m_wordCode = wordCode;
    }

    public long getWordCode() {
        return this.m_wordCode;
    }

    public int getWordLength() {
        return this.m_chars == null ? 0 : this.m_chars.length;
    }

    public static boolean isCommonWord(short wordAttrib) {
        return (wordAttrib & 0x100) == 256;
    }

    public static boolean isArticleWord(short wordAttrib) {
        return (wordAttrib & 0x400) == 1024;
    }

    public static boolean isThoroughfareTypeWord(short wordAttrib) {
        return (wordAttrib & 0x200) == 512;
    }

    public static boolean isDirectionalWord(short wordAttrib) {
        return (wordAttrib & 0x800) == 2048;
    }

    public static boolean isDelimiter(short wordAttrib) {
        return (wordAttrib & 0x10) == 16;
    }

    public static boolean isAbbreviation(short wordAttrib) {
        return (wordAttrib & 0x40) == 64;
    }

    public static boolean isAbbreviatable(short wordAttrib) {
        return (wordAttrib & 2) == 2;
    }

    public static boolean isProbableRomanNumeral(short wordAttrib) {
        return (wordAttrib & 0x20) == 32;
    }

    public void setAttributes(short attribs) {
        this.m_attributes = attribs;
    }

    public short getAttributes() {
        return this.m_attributes;
    }

    public static boolean isNumeric(short wordAttrib) {
        return (wordAttrib & 8) == 8;
    }

    public static boolean isNumber(short wordAttrib) {
        return (wordAttrib & 4) == 4;
    }

    public boolean isNumeral() {
        return (this.m_attributes & 4) == 4 || (this.m_attributes & 8) == 8 || (this.m_attributes & 0x20) == 32;
    }

    public static boolean isPartOfMultiWordAbbreviatable(short wordAttrib) {
        return (wordAttrib & 0x80) == 128;
    }

    public int hashCode() {
        return this.m_soundex ^ this.m_offset * 31;
    }
}

