/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryItem;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InternalAddress
extends Address<InternalFieldValue>
implements IDictionaryItem {
    private AdditionalFields m_additionalFields;
    private long m_offset = -1L;
    protected long m_coordOffset = -1L;
    private DataSetInfo m_dataSetInfo;
    private AreaMetaData m_areaMetaData;

    public void copy(InternalAddress addr) {
        super.copy(addr);
        this.m_coordOffset = addr.getCoordinateOffset();
        this.m_offset = addr.getOffset();
        this.m_dataSetInfo = addr.getDataSetInfo();
        this.m_areaMetaData = addr.getAreaMetaData();
        AdditionalFields addFields = addr.getAdditionalFields();
        if (addFields != null) {
            this.m_additionalFields = new AdditionalFields(addFields);
        }
    }

    public int compareFields(InternalAddress other) {
        int c = this.compareNormalFields(other);
        return c == 0 ? this.compareAdditionalFields(other.getAdditionalFields()) : c;
    }

    private int compareNormalFields(Address<InternalFieldValue> other) {
        boolean hasFields1 = this.hasFields();
        boolean hasFields2 = other.hasFields();
        if (hasFields1 && hasFields2) {
            return Address.compareFieldValues(this.getFields(), other.getFields());
        }
        if (hasFields1) {
            return 1;
        }
        if (hasFields2) {
            return -1;
        }
        return 0;
    }

    private int compareAdditionalFields(AdditionalFields addFields2) {
        Map<FieldType, String> addFieldsMap2;
        Map<FieldType, String> addFieldsMap1 = this.m_additionalFields == null ? null : this.m_additionalFields.getAdditionalFields();
        Map<FieldType, String> map = addFieldsMap2 = addFields2 == null ? null : addFields2.getAdditionalFields();
        if (addFieldsMap1 != null && addFieldsMap2 != null) {
            return Address.compareFieldValues(addFieldsMap1, addFieldsMap2);
        }
        if (addFieldsMap1 != null) {
            return 1;
        }
        if (addFields2 != null) {
            return -1;
        }
        return 0;
    }

    public List<AddressWord> getAddressWords(FieldType.FieldLevel level, IDictionaryMetaData metaData) {
        ArrayList<AddressWord> addrWordList = null;
        List<FieldType> streetFieldTypeList = metaData.getFieldsAtLevel(level);
        if (streetFieldTypeList != null && streetFieldTypeList.size() > 0) {
            addrWordList = new ArrayList<AddressWord>(10);
            Iterator<FieldType> fieldIt = streetFieldTypeList.iterator();
            while (fieldIt.hasNext()) {
                AddressWord[][] altValues;
                InternalFieldValue fieldValue = (InternalFieldValue)this.getField(fieldIt.next());
                if (fieldValue == null) continue;
                AddressWord[] addrWords = (AddressWord[])fieldValue.getFieldValue();
                if (addrWords != null) {
                    int size = addrWords == null ? 0 : addrWords.length;
                    for (int i = 0; i < size; ++i) {
                        addrWordList.add(addrWords[i]);
                    }
                }
                int altCount = (altValues = (AddressWord[][])fieldValue.getAlternateValues()) == null ? 0 : altValues.length;
                for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                    addrWords = altValues[altNdx];
                    if (addrWords == null) continue;
                    int size = addrWords == null ? 0 : addrWords.length;
                    for (int i = 0; i < size; ++i) {
                        addrWordList.add(addrWords[i]);
                    }
                }
            }
        }
        if (addrWordList.size() > 0) {
            return addrWordList;
        }
        return null;
    }

    public List<AddressWord> getAddressWords(FieldType type, IDictionaryMetaData metaData) {
        ArrayList<AddressWord> addrWordList = null;
        addrWordList = new ArrayList<AddressWord>(10);
        InternalFieldValue fieldValue = (InternalFieldValue)this.getField(type);
        if (fieldValue != null) {
            AddressWord[][] altValues;
            AddressWord[] addrWords = (AddressWord[])fieldValue.getFieldValue();
            if (addrWords != null) {
                int size = addrWords == null ? 0 : addrWords.length;
                for (int i = 0; i < size; ++i) {
                    addrWordList.add(addrWords[i]);
                }
            }
            int altCount = (altValues = (AddressWord[][])fieldValue.getAlternateValues()) == null ? 0 : altValues.length;
            for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                addrWords = altValues[altNdx];
                if (addrWords == null) continue;
                int size = addrWords == null ? 0 : addrWords.length;
                for (int i = 0; i < size; ++i) {
                    addrWordList.add(addrWords[i]);
                }
            }
        }
        if (addrWordList.size() > 0) {
            return addrWordList;
        }
        return null;
    }

    public AdditionalFields getAdditionalFields() {
        return this.m_additionalFields;
    }

    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.m_additionalFields = additionalFields;
    }

    public long getOffset() {
        return this.m_offset;
    }

    public void setOffset(long l) {
        this.m_offset = l;
    }

    public void setCoordinateOffset(long offset) {
        this.m_coordOffset = offset;
    }

    public long getCoordinateOffset() {
        return this.m_coordOffset;
    }

    @Override
    public DataSetInfo getDataSetInfo() {
        return this.m_dataSetInfo;
    }

    public void setDataSetInfo(DataSetInfo dataSetInfo) {
        this.m_dataSetInfo = dataSetInfo;
    }

    public boolean hasAdditionalFields() {
        return this.m_additionalFields != null && (this.m_additionalFields.getOffset() > -1L || this.m_additionalFields.size() > 0);
    }

    public int getAddressType() {
        DataSetInfo info = this.getDataSetInfo();
        return info != null ? info.getGeocodeType() : 0;
    }

    public int getDictionaryNumber() {
        DataSetInfo info = this.getDataSetInfo();
        return info != null ? info.getDictionaryNumber() : 0;
    }

    public void setAreaMetaData(AreaMetaData metaData) {
        this.m_areaMetaData = metaData;
    }

    public AreaMetaData getAreaMetaData() {
        return this.m_areaMetaData;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fields : ");
        sb.append(super.toString());
        if (this.hasAdditionalFields()) {
            sb.append("Additional Fields : ");
            sb.append(this.getAdditionalFields().getAdditionalFields().toString());
        }
        return sb.toString();
    }
}

