/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import java.io.IOException;
import java.util.Collection;

public class InternalIntersectionScoringAddress
extends InternalScoringAddress {
    private InternalScoringAddress m_add1;
    private InternalScoringAddress m_add2;
    private DirectPosition m_intersectionPoint;
    static final double COORDINATE_FUDGE_FACTOR = 1.0000100000000001E-5;

    public InternalIntersectionScoringAddress(InternalScoringAddress add1, InternalScoringAddress add2) {
        this.m_add1 = add1;
        this.m_add2 = add2;
        this.setCombinedScore((this.m_add1.getCombinedScore() + this.m_add2.getCombinedScore()) / 2.0);
        this.setCombinedPostalScore((this.m_add1.getCombinedPostalScore() + this.m_add2.getCombinedPostalScore()) / 2.0);
        this.setCombinedStreetScore((this.m_add1.getCombinedStreetScore() + this.m_add2.getCombinedStreetScore()) / 2.0);
        this.setCloseMatch(add1.isCloseMatch());
    }

    public boolean hasIntersection(IDataManager dataManager) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        return this.privateHasIntersection(dataManager);
    }

    public boolean isSameIntersection(InternalIntersectionScoringAddress that) {
        return this.m_intersectionPoint.equals((Object)that.m_intersectionPoint);
    }

    public InternalScoringAddress getFirstCandidate() {
        return this.m_add1;
    }

    public InternalScoringAddress getSecondCandidate() {
        return this.m_add2;
    }

    @Override
    public InternalStreetAddress getInternalAddress() {
        return this.m_add1.getInternalStreetAddress();
    }

    @Override
    public DataSetInfo getDataSetInfo() {
        return this.getInternalAddress().getDataSetInfo();
    }

    private boolean isStreetnameSame() {
        InternalFieldValue street1name = (InternalFieldValue)this.m_add1.getField(FieldType.STREET_NAME_FIELD_TYPE);
        InternalFieldValue street2name = (InternalFieldValue)this.m_add2.getField(FieldType.STREET_NAME_FIELD_TYPE);
        return street1name.equals(street2name);
    }

    protected DirectPosition isValidPointIntersection(Collection<DirectPosition> candidate1Pnt, Collection<DirectPosition> candidate2Pnt) {
        for (DirectPosition p1 : candidate1Pnt) {
            for (DirectPosition p2 : candidate2Pnt) {
                double yDelta;
                double xDelta = Math.abs(p1.getX() - p2.getX());
                if (!(xDelta <= 1.0000100000000001E-5) || !((yDelta = Math.abs(p1.getY() - p2.getY())) <= 1.0000100000000001E-5)) continue;
                return p1;
            }
        }
        return null;
    }

    @Override
    public int getAddressType() {
        return this.m_add1.getAddressType();
    }

    private boolean privateHasIntersection(IDataManager dataManager) throws CGGEInternalException, IOException, DataFetchException, DataNotInitialisedException {
        Collection<DirectPosition> geom2;
        if (this.isStreetnameSame()) {
            return false;
        }
        Envelope envelope1 = this.m_add1.getInternalStreetAddress().getIntersectionEnvelope(dataManager);
        if (envelope1 == null) {
            return false;
        }
        this.expandEnvelope(envelope1);
        Envelope envelope2 = this.m_add2.getInternalStreetAddress().getIntersectionEnvelope(dataManager);
        if (envelope2 == null) {
            return false;
        }
        this.expandEnvelope(envelope2);
        if (!this.intersectionPossible() || !envelope1.intersects(envelope2)) {
            return false;
        }
        Collection<DirectPosition> geom1 = this.m_add1.getInternalStreetAddress().getIntersectionGeometry(dataManager);
        if (geom1.equals(geom2 = this.m_add2.getInternalStreetAddress().getIntersectionGeometry(dataManager))) {
            return false;
        }
        this.m_intersectionPoint = this.isValidPointIntersection(geom1, geom2);
        return this.m_intersectionPoint != null;
    }

    private boolean intersectionPossible() {
        return this.m_add1.getInternalStreetAddress().hasRangesWithLineGeometryForIntersection() || this.m_add2.getInternalStreetAddress().hasRangesWithLineGeometryForIntersection();
    }

    private void expandEnvelope(Envelope envelope) {
        envelope.expand(1.0000100000000001E-5, 1.0000100000000001E-5);
    }

    @Override
    public String getCountry() {
        return this.m_add1.getCountry();
    }

    @Override
    public String getLanguage() {
        return this.m_add1.getLanguage();
    }

    public DirectPosition getIntersectionLocation() {
        return this.m_intersectionPoint;
    }
}

