/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.midev.geometry.DirectPosition;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InternalRangeAddress
extends InternalAddress
implements Comparable<InternalRangeAddress> {
    protected AddressNumber m_from;
    protected AddressNumber m_to;
    protected int m_rangeSide;
    protected int m_oddEvenType;
    protected List<InternalUnitAddress> m_units;
    private List<DirectPosition> m_Points;
    private int m_reverseGeocodedNumber;
    private double m_distance = Double.MAX_VALUE;
    private boolean m_bPointsAssigned;
    ByteBuffer buf;

    public InternalRangeAddress() {
    }

    public InternalRangeAddress(AddressNumber from, AddressNumber to, int rangeSide, int oddEvenType) {
        this();
        this.m_from = from;
        this.m_to = to;
        this.m_rangeSide = (byte)rangeSide;
        this.m_oddEvenType = (byte)oddEvenType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InternalRangeAddress)) {
            return false;
        }
        InternalRangeAddress target = (InternalRangeAddress)o;
        return this.compareTo(target) == 0;
    }

    public int hashCode() {
        int value = 17;
        value = 31 * value + (this.m_from != null ? 0 : this.m_from.hashCode());
        value = 31 * value + (this.m_to != null ? 0 : this.m_to.hashCode());
        value = 31 * value + this.m_rangeSide;
        value = 31 * value + this.m_oddEvenType;
        return value;
    }

    public boolean isSameRange(InternalRangeAddress other) {
        if (this.getCoordinateOffset() != other.getCoordinateOffset()) {
            return false;
        }
        if (!this.hasSameRangeNumbers(other)) {
            return false;
        }
        return this.compareFields(other) == 0;
    }

    private boolean hasSameRangeNumbers(InternalRangeAddress other) {
        return this.compareAddressNumbers(this.getFrom(), other.getFrom()) == 0 && this.compareAddressNumbers(this.getTo(), other.getTo()) == 0;
    }

    public void setHnr(AddressNumber hnr) {
        this.m_from = hnr;
    }

    public void merge(InternalRangeAddress range) {
        if (this.m_units != null && range.m_units != null) {
            this.m_units.addAll(range.m_units);
        } else if (range.m_units != null) {
            this.m_units = range.m_units;
        }
    }

    public List<InternalUnitAddress> getUnits() {
        return this.m_units;
    }

    public void setUnits(List<InternalUnitAddress> list) {
        this.m_units = list;
    }

    public AddressNumber getFrom() {
        return this.m_from;
    }

    public void setFrom(AddressNumber from) {
        this.m_from = from;
    }

    public AddressNumber getTo() {
        return this.m_to;
    }

    public void setTo(AddressNumber to) {
        this.m_to = to;
    }

    public int getRangeSide() {
        return this.m_rangeSide;
    }

    public void setRangeSide(int side) {
        this.m_rangeSide = side;
    }

    public int getOddEvenType() {
        return this.m_oddEvenType;
    }

    public void setOddEvenType(int evenType) {
        this.m_oddEvenType = evenType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("from=");
        sb.append(this.getFrom() != null ? this.getFrom().toString() : "");
        sb.append(" to=");
        sb.append(this.getTo() != null ? this.getTo().toString() : "");
        sb.append(" side=");
        sb.append(this.getRangeSideString());
        sb.append(" type=");
        sb.append(this.getOddEvenTypeString());
        sb.append(" ");
        sb.append(super.toString());
        return sb.toString();
    }

    private String getRangeSideString() {
        switch (this.getRangeSide()) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        return "unknown";
    }

    private String getOddEvenTypeString() {
        switch (this.getOddEvenType()) {
            case 2: {
                return "even";
            }
            case 3: {
                return "odd";
            }
            case 4: {
                return "mixed";
            }
            case 5: {
                return "irregular";
            }
        }
        return "unknown";
    }

    @Override
    public int compareTo(InternalRangeAddress other) {
        int c = this.compareAddressNumbers(this.getFrom(), other.getFrom());
        if (c == 0) {
            c = this.compareAddressNumbers(this.getTo(), other.getTo());
        }
        if (c == 0) {
            c = (int)(this.getCoordinateOffset() - other.getCoordinateOffset());
        }
        if (c == 0) {
            c = this.compareFields(other);
        }
        if (c == 0) {
            c = this.getRangeSide() - other.getRangeSide();
        }
        if (c == 0) {
            c = this.getOddEvenType() - other.getOddEvenType();
        }
        return c;
    }

    private int compareAddressNumbers(AddressNumber num1, AddressNumber num2) {
        if (num1 != null && num2 != null) {
            return num1.compare(num1, num2);
        }
        if (num1 != null) {
            return 1;
        }
        if (num2 != null) {
            return -1;
        }
        return 0;
    }

    public long getAdditionalFieldsOffset() {
        AdditionalFields addFields = this.getAdditionalFields();
        if (addFields != null) {
            return addFields.getOffset();
        }
        return -1L;
    }

    public void addInternalUnit(InternalUnitAddress unit) {
        if (this.m_units == null) {
            this.m_units = new ArrayList<InternalUnitAddress>();
        }
        this.m_units.add(unit);
    }

    public boolean isAddressPointData() {
        return this.isAddressPointData(this.getPoints());
    }

    private boolean isAddressPointData(List<DirectPosition> geometry) {
        return geometry.size() == 1;
    }

    public List<AddressNumber> computeAddressNumbers() {
        ArrayList<AddressNumber> addressNumbers = new ArrayList<AddressNumber>();
        this.addElementToList(addressNumbers, this.m_from);
        if (this.m_from != null && this.m_to != null) {
            List<Integer> hnrlist = this.getHnrs(this.getHnrNumberFromAddressNumber(this.m_from), this.getHnrNumberFromAddressNumber(this.m_to));
            for (Integer hnr : hnrlist) {
                this.addElementToList(addressNumbers, new AddressNumber(hnr));
            }
        }
        this.addElementToList(addressNumbers, this.m_to);
        return addressNumbers;
    }

    private int getHnrNumberFromAddressNumber(AddressNumber number) {
        if (number != null) {
            return number.m_number1;
        }
        return 0;
    }

    private List<Integer> getHnrs(int from, int to) {
        boolean bDescending = from > to;
        int num = from < to ? from : to;
        int comparedNum = from < to ? to : from;
        int divisionFactor = this.computeDivisionFactor();
        ArrayList<Integer> hnrList = new ArrayList<Integer>();
        int endPoint = comparedNum - divisionFactor;
        while (num < endPoint) {
            hnrList.add(new Integer(num += divisionFactor));
        }
        if (bDescending) {
            Collections.reverse(hnrList);
        }
        return hnrList;
    }

    private int getNumberOfHnrsInRange(int from, int to) {
        return Math.abs(from - to) / this.computeDivisionFactor();
    }

    private int computeDivisionFactor() {
        if (this.m_oddEvenType == 2 || this.m_oddEvenType == 3) {
            return 2;
        }
        return 1;
    }

    private void addElementToList(List<AddressNumber> addressNumberList, AddressNumber number) {
        if (number != null) {
            addressNumberList.add(number);
        }
    }

    public void setPoints(List<DirectPosition> points) {
        this.m_bPointsAssigned = true;
        this.m_Points = points != null ? new ArrayList<DirectPosition>(points) : Collections.emptyList();
    }

    public List<DirectPosition> getPoints() {
        return Collections.unmodifiableList(this.m_Points);
    }

    public boolean arePointsAssigned() {
        return this.m_bPointsAssigned;
    }

    public void setReverseGeocdedNumber(int number) {
        this.m_reverseGeocodedNumber = number;
    }

    public int getReverseGeocdedNumber() {
        return this.m_reverseGeocodedNumber;
    }

    public double calculateMatchedAddressNumPosition(InternalRangeAddress rangeAddress, AddressNumber addrNum) {
        double hnrPercentage = 0.0;
        hnrPercentage = this.calculateHNRPercentage(rangeAddress, addrNum.m_number1);
        if (hnrPercentage > 1.0 && addrNum.getHnrNumber2() > 0) {
            hnrPercentage = this.calculateHNRPercentage(rangeAddress, addrNum.m_number2);
        }
        if (hnrPercentage > 1.0) {
            MMJLog.getLog().debug("Percentage calculation is wrong for addressnum==============" + addrNum.toString());
        }
        return hnrPercentage;
    }

    private double calculateHNRPercentage(InternalRangeAddress rangeAddress, int addrNum) {
        double hnrPercentage = 0.0;
        int oddEvenType = rangeAddress.getOddEvenType();
        if (oddEvenType != 0) {
            int noOfAddressInRange = this.getNumberOfHnrsInRange(rangeAddress.getFrom().m_number1, rangeAddress.getTo().m_number1);
            if (noOfAddressInRange == 0) {
                return 0.5;
            }
            int matchAddressPosition = Math.abs(rangeAddress.getFrom().m_number1 - addrNum) / this.computeDivisionFactor();
            hnrPercentage = (double)matchAddressPosition / (double)noOfAddressInRange;
        }
        return hnrPercentage;
    }

    public void setDistance(double distance) {
        this.m_distance = distance;
    }

    public double getDistance() {
        return this.m_distance;
    }

    public boolean hasUnits() {
        return this.m_units != null && !this.m_units.isEmpty();
    }
}

