/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringUnit;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import java.util.List;

public class InternalScoringRange
extends ScoringItem {
    private InternalScoringUnit[] m_units;
    private InternalRangeAddress m_range;

    public InternalScoringRange(InternalRangeAddress range) {
        int unitCount;
        this.copy(range);
        this.setInternalAddress(range);
        List<InternalUnitAddress> internalUnits = range.getUnits();
        int n = unitCount = internalUnits == null ? 0 : internalUnits.size();
        if (unitCount > 0) {
            this.m_units = new InternalScoringUnit[unitCount];
            for (int i = 0; i < unitCount; ++i) {
                this.m_units[i] = new InternalScoringUnit(internalUnits.get(i));
            }
        }
    }

    public InternalScoringUnit getMatchedUnit() {
        if (this.getUnitCount() > 0 && this.m_units[0].isCloseMatch()) {
            return this.m_units[0];
        }
        return null;
    }

    public InternalScoringUnit[] getUnits() {
        return this.m_units;
    }

    public InternalRangeAddress getRange() {
        return (InternalRangeAddress)this.getInternalAddress();
    }

    public int getUnitCount() {
        return this.m_units == null ? 0 : this.m_units.length;
    }

    public InternalScoringUnit getUnitAt(int ndx) {
        if (ndx < 0 || ndx >= this.getUnitCount()) {
            throw new IndexOutOfBoundsException("Unit count is " + this.getUnitCount());
        }
        return this.m_units[ndx];
    }

    public AddressNumber getFrom() {
        InternalRangeAddress range = this.getRange();
        return range != null ? range.getFrom() : null;
    }

    public AddressNumber getTo() {
        InternalRangeAddress range = this.getRange();
        return range != null ? range.getTo() : null;
    }

    public int getOddEvenIndicator() {
        InternalRangeAddress range = this.getRange();
        return range != null ? range.m_oddEvenType : 0;
    }

    public int getRangeSide() {
        InternalRangeAddress range = this.getRange();
        return range != null ? range.getRangeSide() : 0;
    }

    public long getAdditionalFieldsOffset() {
        AdditionalFields addFields;
        if (this.m_range != null && (addFields = this.m_range.getAdditionalFields()) != null) {
            return addFields.getOffset();
        }
        return -1L;
    }

    public int getReverseGeocodingAddressNumber() {
        InternalRangeAddress range = this.getRange();
        return range.getReverseGeocdedNumber();
    }
}

