/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AreaTerm;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class InternalStreetAddress
extends InternalAddress
implements Comparable<InternalStreetAddress> {
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private List<Integer> m_areaTermNdxList;
    private AreaTerm[] m_terms;
    private List<InternalRangeAddress> m_rangeList = new ArrayList<InternalRangeAddress>();
    private String m_country;
    private String m_language;
    private double m_distance;
    private int m_closestRangeFromReverseGeocodePoint;
    private Collection<DirectPosition> m_intersectionGeometry;
    private boolean m_bGeometryAssigned;
    private Envelope m_intersectionEnvelope;
    private boolean m_bIntersectionEnvelopeAssigned;
    private boolean m_hasLineGeom;

    public void addInternalRange(InternalRangeAddress range) {
        if (this.m_rangeList == null) {
            this.m_rangeList = new ArrayList<InternalRangeAddress>(50);
        }
        this.m_rangeList.add(range);
    }

    public void merge(InternalStreetAddress addr) {
        if (addr.getRangeList() != null) {
            this.m_rangeList.addAll(addr.getRangeList());
        }
    }

    public void sortAndMergeRanges() {
        int rangeSize;
        int n = rangeSize = this.m_rangeList == null ? 0 : this.m_rangeList.size();
        if (rangeSize > 0) {
            Collections.sort(this.m_rangeList);
            ArrayList<InternalRangeAddress> newList = new ArrayList<InternalRangeAddress>(rangeSize);
            InternalRangeAddress lastRange = this.m_rangeList.get(0);
            newList.add(lastRange);
            for (int i = 1; i < rangeSize; ++i) {
                InternalRangeAddress range = this.m_rangeList.get(i);
                if (lastRange.isSameRange(range)) {
                    lastRange.merge(range);
                    continue;
                }
                newList.add(range);
                lastRange = range;
            }
            this.m_rangeList = newList;
        }
    }

    public static final int dataNumericValue(String str) {
        if (str != null && str.length() > 0 && Character.digit(str.charAt(0), 10) == 0) {
            return 0;
        }
        if (MMUtils.isNumber(str)) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException ne) {
                return 0;
            }
        }
        return 0;
    }

    public List<InternalRangeAddress> getRangeList() {
        return this.m_rangeList;
    }

    public AreaTerm[] getTerms() {
        return this.m_terms;
    }

    public void setRangeList(List<InternalRangeAddress> ranges) {
        this.m_rangeList = ranges;
    }

    public void setTerms(AreaTerm[] terms) {
        this.m_terms = terms;
    }

    public boolean isSameStreet(InternalStreetAddress other) {
        return this.isSameArea(other) && this.compareFields(other) == 0;
    }

    private boolean isSameArea(InternalStreetAddress other) {
        AreaTerm[] terms1 = this.getTerms();
        AreaTerm[] terms2 = other.getTerms();
        if (terms1 != null && terms2 != null) {
            return terms1.length == terms2.length && Arrays.asList(terms1).containsAll(Arrays.asList(terms2));
        }
        return terms1 == null && terms2 == null;
    }

    @Override
    public int compareTo(InternalStreetAddress other) {
        int c = this.compareAreaTerms(other);
        if (c == 0) {
            return this.compareFields(other);
        }
        return c;
    }

    private int compareAreaTerms(InternalStreetAddress a2) {
        AreaTerm[] terms2;
        AreaTerm[] terms1 = this.getTerms();
        if (terms1 == (terms2 = a2.getTerms())) {
            return 0;
        }
        if (terms1 != null && terms2 != null) {
            ArrayList<AreaTerm> termList1 = new ArrayList<AreaTerm>(Arrays.asList(terms1));
            ArrayList<AreaTerm> termList2 = new ArrayList<AreaTerm>(Arrays.asList(terms2));
            Collections.sort(termList1);
            Collections.sort(termList2);
            int minCheck = Math.min(termList1.size(), termList2.size());
            for (int i = 0; i < minCheck; ++i) {
                int c = ((AreaTerm)termList1.get(i)).compareTo((AreaTerm)termList2.get(i));
                if (c == 0) continue;
                return c;
            }
            return termList1.size() - termList2.size();
        }
        if (terms1 != null) {
            return 1;
        }
        return -1;
    }

    public List<Integer> getAreaTermIndexes() {
        return this.m_areaTermNdxList;
    }

    public void setAreaTermIndexes(List<Integer> ndxList) {
        this.m_areaTermNdxList = ndxList;
    }

    public int getRangeCount() {
        return this.m_rangeList == null ? 0 : this.m_rangeList.size();
    }

    public String getCountry() {
        return this.m_country;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setDistance(double distance) {
        this.m_distance = distance;
    }

    public double getDistance() {
        return this.m_distance;
    }

    public int getClosestNumberRangeForReverseGeocode() {
        return this.m_closestRangeFromReverseGeocodePoint;
    }

    public void setClosestNumberRangeForReverseGeocode(int number) {
        this.m_closestRangeFromReverseGeocodePoint = number;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append(lineSeparator);
        builder.append(lineSeparator);
        builder.append(this.getClass().getSimpleName());
        builder.append(lineSeparator);
        builder.append("country: ");
        builder.append(this.getCountry());
        builder.append(lineSeparator);
        builder.append("language: ");
        builder.append(this.getLanguage());
        builder.append(lineSeparator);
        builder.append(super.toString());
        builder.append(lineSeparator);
        builder.append("areaTerms: ");
        if (this.getTerms() != null) {
            builder.append(lineSeparator);
            for (AreaTerm term : this.getTerms()) {
                builder.append('\t');
                builder.append(term.toString());
                builder.append(lineSeparator);
            }
        } else {
            builder.append("none");
            builder.append(lineSeparator);
        }
        builder.append("areaTermIndexes: ");
        if (this.getAreaTermIndexes() != null) {
            builder.append(lineSeparator);
            for (Integer index : this.getAreaTermIndexes()) {
                builder.append('\t');
                builder.append(index.toString());
                builder.append(lineSeparator);
            }
        } else {
            builder.append("none");
            builder.append(lineSeparator);
        }
        return builder.toString();
    }

    public InternalStreetAddress createCopyWithoutRanges() {
        InternalStreetAddress copy = new InternalStreetAddress();
        copy.copy(this);
        copy.setCountry(this.getCountry());
        copy.setLanguage(this.getLanguage());
        copy.setClosestNumberRangeForReverseGeocode(this.getClosestNumberRangeForReverseGeocode());
        copy.setDistance(this.getDistance());
        if (this.getAreaTermIndexes() != null) {
            copy.setAreaTermIndexes(new ArrayList<Integer>(this.getAreaTermIndexes()));
        }
        copy.setTerms(this.getTerms());
        return copy;
    }

    public Collection<DirectPosition> getIntersectionGeometry(IDataManager dataManager) throws DataFetchException {
        if (!this.m_bGeometryAssigned) {
            this.m_bGeometryAssigned = true;
            this.m_intersectionGeometry = new LinkedHashSet<DirectPosition>();
            for (InternalRangeAddress range : this.m_rangeList) {
                if (!range.arePointsAssigned()) {
                    range.setPoints(dataManager.getGeometry(range));
                }
                List<DirectPosition> rangePoints = range.getPoints();
                this.addEndPoints(rangePoints, this.m_intersectionGeometry);
                this.checkForLineGeom(rangePoints);
            }
        }
        return this.m_intersectionGeometry;
    }

    private void checkForLineGeom(List<DirectPosition> source) {
        if (!this.m_hasLineGeom && source != null) {
            this.m_hasLineGeom = source.size() > 1;
        }
    }

    private void addEndPoints(List<DirectPosition> source, Collection<DirectPosition> destination) {
        if (source != null && !source.isEmpty()) {
            destination.add(source.get(0));
            if (source.size() > 1) {
                destination.add(source.get(source.size() - 1));
            }
        }
    }

    public Envelope getIntersectionEnvelope(IDataManager dataManager) throws DataFetchException {
        if (!this.m_bIntersectionEnvelopeAssigned) {
            this.m_bIntersectionEnvelopeAssigned = true;
            boolean bFirst = true;
            Collection<DirectPosition> points = this.getIntersectionGeometry(dataManager);
            if (points.isEmpty()) {
                return null;
            }
            for (DirectPosition point : this.getIntersectionGeometry(dataManager)) {
                if (bFirst) {
                    bFirst = false;
                    this.m_intersectionEnvelope = new Envelope(point, point, SPATIAL_INFO);
                    continue;
                }
                if (this.m_intersectionEnvelope.contains(point)) continue;
                this.m_intersectionEnvelope.extend(point);
            }
        }
        return this.m_intersectionEnvelope;
    }

    public boolean hasRangesWithLineGeometryForIntersection() {
        return this.m_hasLineGeom;
    }
}

