/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.UnitInfo;
import java.util.ArrayList;
import java.util.List;

public class ParsedAddress
extends Address<AddressWord[]> {
    protected InputAddress m_inputAddress;
    protected AddressNumber m_addressNumber;
    protected ArrayList<AddressNumber> m_probableAddressNumbers;
    protected ArrayList<PostCode> m_probablePostcodes;
    private AddressWord[] poBoxType;
    private AddressWord[] SingleLIne_NonPoBoxMain;
    private AddressNumber poBoxNumber;
    private boolean poBoxInMainAddress;
    private boolean poBoxInSingleLine;
    private boolean parseAlwaysDeterminesHnr;
    private String SingleLIne_NonPoBoxMainString;
    protected UnitInfo m_unitInfo;
    protected ArrayList<UnitInfo> m_probableUnitInfos;
    private int m_flags;
    private static final int FLAG_SEPERATE_POSTADDRESS = 1;
    private static final int FLAG_SEPERATE_COMPANY_NAME = 2;
    private static final int FLAG_SEPERATE_PLACENAME = 4;
    private static final int FLAG_SEPERATE_AREA_INPUTS = 8;
    private static final int FLAG_PREFER_HOUSENUMBER_AT_START = 16;
    public static final int FLAG_CUSTOM_1 = 0x1000000;
    public static final int FLAG_CUSTOM_2 = 0x2000000;
    public static final int FLAG_CUSTOM_3 = 0x4000000;
    public static final int FLAG_CUSTOM_4 = 0x8000000;
    public static final int FLAG_CUSTOM_5 = 0x10000000;
    public static final int FLAG_CUSTOM_6 = 0x20000000;
    public static final int FLAG_CUSTOM_7 = 0x40000000;
    public static final int FLAG_CUSTOM_8 = Integer.MIN_VALUE;
    private String m_country;
    private String m_language;
    private boolean m_isIntersectionAddress;
    private boolean m_isNearByFeature;
    private String probablePrimaryStreet = null;
    private String nearByStreetHNR = null;

    public ParsedAddress(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_flags = 0;
    }

    public void copy(ParsedAddress pAddr) {
        super.copy(pAddr);
        this.m_inputAddress = pAddr.m_inputAddress;
        this.m_addressNumber = pAddr.m_addressNumber;
        this.m_probableAddressNumbers = pAddr.m_probableAddressNumbers != null ? new ArrayList<AddressNumber>(pAddr.m_probableAddressNumbers) : null;
        this.m_probablePostcodes = pAddr.m_probablePostcodes != null ? new ArrayList<PostCode>(pAddr.m_probablePostcodes) : null;
        this.m_unitInfo = pAddr.m_unitInfo;
        this.m_flags = pAddr.m_flags;
        this.m_language = pAddr.m_language;
        this.m_country = pAddr.m_country;
        this.m_isIntersectionAddress = pAddr.m_isIntersectionAddress;
        this.m_isNearByFeature = pAddr.m_isNearByFeature;
    }

    public AddressNumber getAddressNumber() {
        return this.m_addressNumber;
    }

    public void setAddressNumber(AddressNumber hnr) {
        this.m_addressNumber = hnr;
    }

    public List<AddressNumber> getProbableAddressNumbers() {
        return this.m_probableAddressNumbers;
    }

    public void setProbableAddressNumbers(List<AddressNumber> hnr) {
        this.m_probableAddressNumbers = (ArrayList)hnr;
    }

    public List<PostCode> getProbablePostcodes() {
        return this.m_probablePostcodes;
    }

    public void setProbablePostcodes(List<PostCode> pcs) {
        this.m_probablePostcodes = (ArrayList)pcs;
    }

    public String getCountry() {
        return this.m_country;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public UnitInfo getUnitInfo() {
        return this.m_unitInfo;
    }

    public void setUnitInfo(UnitInfo unitInfo) {
        this.m_unitInfo = unitInfo;
    }

    public List<UnitInfo> getProbableUnitInfos() {
        return this.m_probableUnitInfos;
    }

    public void setProbableUnitInfos(List<UnitInfo> unitInfo) {
        this.m_probableUnitInfos = (ArrayList)unitInfo;
    }

    public InputAddress getInputAddress() {
        return this.m_inputAddress;
    }

    public void setInputAddress(InputAddress inputAddress) {
        this.m_inputAddress = inputAddress;
    }

    public void setFlagSeparatePostAddressFields() {
        this.m_flags |= 1;
    }

    public boolean isSeperatePostAddressFields() {
        return (this.m_flags & 1) == 1;
    }

    public void setFlagSeperateAreaFields() {
        this.m_flags |= 8;
    }

    public boolean isSeparateAreaFields() {
        return (this.m_flags & 8) == 8;
    }

    public void setFlagSeperatePlaceName() {
        this.m_flags |= 4;
    }

    public boolean isSeparatePlaceName() {
        return (this.m_flags & 4) == 4;
    }

    public void setPreferHouseNumberAtStart() {
        this.m_flags |= 0x10;
    }

    public void setCustomFlag(int flag) {
        if (flag == 0x1000000 || flag == 0x2000000 || flag == 0x4000000 || flag == 0x8000000 || flag == 0x10000000 || flag == 0x20000000 || flag == 0x40000000 || flag == Integer.MIN_VALUE) {
            this.m_flags |= flag;
        } else {
            throw new IllegalArgumentException("Not a custom flag value");
        }
    }

    public void unsetCustomFlag(int flag) {
        if (flag == 0x1000000 || flag == 0x2000000 || flag == 0x4000000 || flag == 0x8000000 || flag == 0x10000000 || flag == 0x20000000 || flag == 0x40000000 || flag == Integer.MIN_VALUE) {
            this.m_flags ^= flag;
        } else {
            throw new IllegalArgumentException("Not a custom flag value");
        }
    }

    public boolean isCustomFlagSet(int flag) {
        if (flag == 0x1000000 || flag == 0x2000000 || flag == 0x4000000 || flag == 0x8000000 || flag == 0x10000000 || flag == 0x20000000 || flag == 0x40000000 || flag == Integer.MIN_VALUE) {
            return (this.m_flags & flag) == flag;
        }
        throw new IllegalArgumentException("Not a custom flag value");
    }

    public boolean preferHouseNumberAtStart() {
        return (this.m_flags & 0x10) == 16;
    }

    public String getProbablePostcodesAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_probablePostcodes != null) {
            for (PostCode postcode : this.m_probablePostcodes) {
                builder.append(postcode.toString());
            }
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        if (this.m_addressNumber != null) {
            buf.append("hnr=");
            buf.append(this.m_addressNumber);
            buf.append("\n");
        }
        if (this.m_unitInfo != null) {
            buf.append(this.m_unitInfo);
            buf.append(' ');
            buf.append("\n");
        }
        this.modifyAddressBuffer(buf, (AddressWord[])super.getField(FieldType.STREET_NAME_FIELD_TYPE), "street words=");
        this.modifyAddressBuffer(buf, (AddressWord[])super.getField(FieldType.POST_ADDRESS_FIELD_TYPE), "area words=");
        this.modifyAddressBuffer(buf, (AddressWord[])super.getField(FieldType.POST_CODE_FIELD_TYPE), "postcode=");
        return buf.toString();
    }

    private void modifyAddressBuffer(StringBuffer buf, AddressWord[] words, String fieldTypeWord) {
        if (words != null) {
            buf.append(fieldTypeWord);
            for (int i = 0; i < words.length; ++i) {
                buf.append(words[i]);
                buf.append(",");
            }
            buf.append("\n");
        }
    }

    public void setIntersectionAddress(boolean intersectionCase) {
        this.m_isIntersectionAddress = intersectionCase;
    }

    public boolean isIntersectionCase() {
        return this.m_isIntersectionAddress && !this.poBoxInMainAddress;
    }

    public boolean isNearByFeature() {
        return this.m_isNearByFeature;
    }

    public void setNearByFeature(boolean m_isNearByFeature) {
        this.m_isNearByFeature = m_isNearByFeature;
    }

    public String getProbablePrimaryStreet() {
        return this.probablePrimaryStreet;
    }

    public void setProbablePrimaryStreet(String probablePrimaryStreet) {
        this.probablePrimaryStreet = probablePrimaryStreet;
    }

    public String getNearByStreetHNR() {
        return this.nearByStreetHNR;
    }

    public void setNearByStreetHNR(String nearByStreetHNR) {
        this.nearByStreetHNR = nearByStreetHNR;
    }

    public AddressWord[] getPoBoxType() {
        return this.poBoxType;
    }

    public void setPoBoxType(AddressWord[] poBoxType) {
        this.poBoxType = poBoxType;
    }

    public AddressNumber getPoBoxNumber() {
        return this.poBoxNumber;
    }

    public void setPoBoxNumber(AddressNumber poBoxNumber) {
        this.poBoxNumber = poBoxNumber;
    }

    public boolean isPoBoxInMainAddress() {
        return this.poBoxInMainAddress;
    }

    public void setPoBoxInMainAddress(boolean poBoxInMainAddress) {
        this.poBoxInMainAddress = poBoxInMainAddress;
    }

    public boolean isPoBoxInSingleLine() {
        return this.poBoxInSingleLine;
    }

    public void setPoBoxInSingleLine(boolean flag) {
        this.poBoxInSingleLine = flag;
    }

    public AddressWord[] getSL_NonPoBoxMain() {
        return this.SingleLIne_NonPoBoxMain;
    }

    public void setSL_NonPoBoxMain(AddressWord[] words) {
        this.SingleLIne_NonPoBoxMain = words;
    }

    public String getSL_NonPoBoxMainString() {
        return this.SingleLIne_NonPoBoxMainString;
    }

    public void setSL_NonPoBoxMainString(String str) {
        this.SingleLIne_NonPoBoxMainString = str;
    }

    public void setParseAlwaysDeterminesHnr(boolean flag) {
        this.parseAlwaysDeterminesHnr = flag;
    }

    public boolean getParseAlwaysDeterminesHnr() {
        return this.parseAlwaysDeterminesHnr;
    }
}

