/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.DatasetInfoComponent;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalIntersectionScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalScoringUnit;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.CandidateS3Determinator;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CGGECandidateConvertor
extends DatasetInfoComponent
implements ICGGECandidateConvertor {
    protected String m_country;
    protected String m_language;
    private ICGGEParser m_parser;
    private ICGGEScorer m_bestAlternateValueScorer;
    public static final String ALT_STREET_NAME = "alt_street_name";
    public static final String ALT_POST_CODE = "alt_post_code";
    public static final String ALT_PLACE_NAME = "alt_place_name";
    public static final String ALT_AN1 = "alt_area_name_1";
    public static final String ALT_AN2 = "alt_area_name_2";
    public static final String ALT_AN3 = "alt_area_name_3";
    public static final String ALT_AN4 = "alt_area_name_4";
    public static final String ALT_GENERIC_AN1 = "alt_generic_field_1";
    public static final String ALT_GENERIC_AN2 = "alt_generic_field_2";
    public static final String ALT_GENERIC_AN3 = "alt_generic_field_3";
    public static final String ALT_GENERIC_AN4 = "alt_generic_field_4";
    public static final String DO_S3_FOR_THIS_CAND = "DO_S3_FOR_THIS_CAND";
    public static final String HASGEOM = "HASGEOM";
    public static final String POSTALFB_PREC_CODE_FLAG = "POSTALFB_PREC_CODE_FLAG";

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        return true;
    }

    protected ICGGEParser getParser() {
        if (this.m_parser == null) {
            this.m_parser = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getParser();
        }
        return this.m_parser;
    }

    private ICGGEScorer getAlternateValueScorer() {
        if (this.m_bestAlternateValueScorer == null) {
            this.m_bestAlternateValueScorer = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getScorer();
        }
        return this.m_bestAlternateValueScorer;
    }

    @Override
    public CandidateAddress covertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, GeocodeOptions options) throws Exception {
        CGGEFormatter formatter = null;
        IConstraints constraints = options.getGeocodeConstraints();
        formatter = CGGEFormatter.getInstance(scoringAddress.getDataSetInfo(), this.getCountry(), this.getLanguage());
        if (scoringAddress instanceof InternalIntersectionScoringAddress) {
            return this.convertIntersectionCandidate((InternalIntersectionScoringAddress)scoringAddress, dataManager, formatter, constraints);
        }
        CandidateAddress candAddr = this.convertCandidate(scoringAddress, dataManager, formatter, constraints);
        if (constraints.getCustomString(DO_S3_FOR_THIS_CAND) != null) {
            options.put(DO_S3_FOR_THIS_CAND, "true");
        }
        return candAddr;
    }

    protected CandidateAddress convertIntersectionCandidate(InternalIntersectionScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        CandidateAddress[] candAddr = new CandidateAddress[2];
        for (int i = 0; i < candAddr.length; ++i) {
            candAddr[i] = new CandidateAddress();
        }
        boolean isIntersection = true;
        InternalScoringAddress candTemp = null;
        for (int i = 0; i < candAddr.length; ++i) {
            candTemp = i == 0 ? scoringAddress.getFirstCandidate() : scoringAddress.getSecondCandidate();
            this.prepareCandidate(candAddr[i], candTemp, constraints, dataManager, formatter, isIntersection);
        }
        candAddr[0].setLocation(scoringAddress.getIntersectionLocation());
        candAddr[0].setFormattedStreetAddress(candAddr[0].getFormattedStreetAddress() + " && " + candAddr[1].getFormattedStreetAddress());
        candAddr[0].setMainAddress(candAddr[0].getFormattedStreetAddress());
        candAddr[0].setLocationPrecision(6);
        this.reprocessFieldsForIntersection(candAddr[0]);
        this.reprocessFlagsForIntersection(candAddr, scoringAddress);
        this.setPrecisionCode(candAddr[0]);
        return candAddr[0];
    }

    protected int getGeocodeTypeForPrecisionBuilder(IConstraints constraints) {
        if (constraints.getCustomString(POSTALFB_PREC_CODE_FLAG) != null) {
            return 1;
        }
        return constraints.getGeocodeType();
    }

    protected boolean isS3WithPointDataCase(CGGEFormatter formatter, IConstraints constraints) {
        return formatter.getS3ForPointData() && this.getGeocodeTypeForPrecisionBuilder(constraints) == 0;
    }

    protected CandidateAddress convertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        CandidateAddress candAddr = new CandidateAddress();
        this.prepareCandidate(candAddr, scoringAddress, constraints, dataManager, formatter, false);
        int geocodeTypeForPrecisionBuilder = this.getGeocodeTypeForPrecisionBuilder(constraints);
        int conf = (int)Math.round(scoringAddress.getCombinedScore() * 100.0);
        candAddr.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(conf));
        if (constraints.getCustomString(DO_S3_FOR_THIS_CAND) != null) {
            this.setPrecisionCode(candAddr, geocodeTypeForPrecisionBuilder);
            return candAddr;
        }
        if (geocodeTypeForPrecisionBuilder == 1 && candAddr.getLocationPrecision() < 7) {
            this.setPrecisionCode(candAddr, geocodeTypeForPrecisionBuilder);
        } else {
            this.setPrecisionCode(candAddr);
        }
        return candAddr;
    }

    public ReverseGeocodeCandidateAddress convertToReverseGeocodeCandidateAddress(InternalStreetAddress streetAddress, IDataManager dataManager, GeocodeOptions options, IReverseGeocodeConstraints constraints) {
        try {
            DataSetInfo dataSetinfo = streetAddress.getDataSetInfo();
            IDictionaryMetaData metaData = dataSetinfo.getMetaData();
            CandidateAddress address = new CandidateAddress();
            InternalScoringAddress scoringAddress = new InternalScoringAddress(streetAddress);
            this.populateRGRanges(address, scoringAddress, constraints, dataManager);
            this.copyAddressFields(address, scoringAddress, CGGEFormatter.getInstance(streetAddress.getDataSetInfo(), this.m_country, this.m_language), dataManager, false);
            ReverseGeocodeCandidateAddress candidate = new ReverseGeocodeCandidateAddress((Address)address, dataSetinfo.getDictionaryNumber(), new Length(streetAddress.getDistance(), LinearUnit.METER));
            candidate.setPrecisionCode(this.buildRGResultCode(streetAddress));
            if (metaData.isUserDictionary()) {
                candidate.setFromUserDictionary();
                String resultCode = candidate.getPrecisionCode();
                resultCode = resultCode.replace("A", "U");
                candidate.setPrecisionCode(resultCode);
            }
            candidate.setNumberOfReturnableRanges(1);
            candidate.setFormattedStreetAddress(address.getFormattedStreetAddress());
            candidate.setFormattedLocationAddress(address.getFormattedLocationAddress());
            candidate.addCandidateRange(address.getRangeAt(0));
            InternalScoringRange range = scoringAddress.getRangeAt(0);
            int houseNumber = range.getReverseGeocodingAddressNumber();
            if (houseNumber != 0) {
                AddressNumberScore score = new AddressNumberScore();
                score.setMatched(true);
                score.setNumber1Matched(true);
                score.setInputAddressNumber(new AddressNumber(range.getReverseGeocodingAddressNumber()));
                range.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, score);
            }
            CandidateAddress tempCandidate = new CandidateAddress();
            this.interpolate(tempCandidate, scoringAddress, dataManager, range, options.getGeocodeConstraints());
            candidate.setLocation(tempCandidate.getLocationPoint());
            candidate.setLocationPrecision(tempCandidate.getLocationPrecision());
            candidate.setCoordSysString(tempCandidate.getCoordSysString());
            return candidate;
        }
        catch (Exception e) {
            throw new DataAccessRuntimeException(new DataAccessException(2404, (Throwable)e));
        }
    }

    protected void populateRGRanges(CandidateAddress candidate, InternalScoringAddress scoringAddress, IReverseGeocodeConstraints constraints, IDataManager dataManager) throws DataFetchException {
        InternalScoringRange range = scoringAddress.getRangeAt(scoringAddress.getInternalStreetAddress().getClosestNumberRangeForReverseGeocode());
        CandidateRange candRange = this.convertRange(range, dataManager);
        candRange.setNumberOfReturnableRangeUnits(constraints.getMaxRangeUnits());
        candidate.addCandidateRange(candRange);
        if (range.getTo() == null && range.getFrom() != null) {
            candidate.setAddressNumber(range.getFrom().toString());
        } else {
            int hnr = range.getReverseGeocodingAddressNumber();
            if (hnr > 0 && range.getFrom() != null) {
                if (range.getFrom().getType() == 2 && range.getTo().getType() == 2) {
                    if (range.getTo() != null && range.getTo().getHnrSuffix1().equals(range.getFrom().getHnrSuffix1())) {
                        candidate.setAddressNumber(String.valueOf(hnr) + range.getFrom().getHnrSuffix1());
                    } else if (hnr == range.getFrom().getHnrNumber1()) {
                        candidate.setAddressNumber(range.getFrom().toString());
                    } else if (hnr == range.getTo().getHnrNumber1()) {
                        candidate.setAddressNumber(range.getTo().toString());
                    } else {
                        candidate.setAddressNumber(String.valueOf(hnr));
                    }
                } else {
                    candidate.setAddressNumber(String.valueOf(hnr));
                }
            }
        }
    }

    protected String buildRGResultCode(InternalStreetAddress streetAddress) {
        InternalRangeAddress range = streetAddress.getRangeList().get(streetAddress.getClosestNumberRangeForReverseGeocode());
        List<DirectPosition> points = range.getPoints();
        int numberOfPoints = points.size();
        if (numberOfPoints == 1) {
            return "RS8A";
        }
        if (range.getReverseGeocdedNumber() != 0 && range.getReverseGeocdedNumber() > 0) {
            return "RS5A";
        }
        return "RS4A";
    }

    protected void prepareCandidate(CandidateAddress candAddr, InternalScoringAddress scoringAddr, IConstraints constraints, IDataManager dataManager, CGGEFormatter formatter, boolean isIntersection) throws Exception {
        int totalRanges = scoringAddr.getRangeCount();
        if (this.doS3(candAddr, dataManager, scoringAddr, this.isS3WithPointDataCase(formatter, constraints))) {
            constraints.setCustomString(DO_S3_FOR_THIS_CAND, "");
        } else if (totalRanges > 0) {
            InternalScoringRange range = scoringAddr.getRangeAt(0);
            this.interpolate(candAddr, scoringAddr, dataManager, range, constraints);
        }
        candAddr.setConfiguredDictionaryNumber(scoringAddr.getDictionaryNumber());
        if (scoringAddr.getDataSetInfo().getMetaData().isUserDictionary()) {
            candAddr.setFromUserDictionary();
        }
        if (Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
            scoringAddr.setAdditionalInfo("POBOX_MATCH_IN_PROGRESS", "true");
        }
        this.copyAddressFields(candAddr, scoringAddr, formatter, dataManager, isIntersection);
        String prelinRescode = InternalCandidateAddress.buildPrecisionCodeFromCandidate((CandidateAddress)candAddr);
        AddressNumber num = null;
        FieldScore Fscore = scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (Fscore instanceof AddressNumberScore) {
            num = ((AddressNumberScore)Fscore).getInputAddressNumber();
        }
        if (!isIntersection && prelinRescode.startsWith("S4") && (constraints.getCustomString("S4_INPUT_HOUSE_NUMBER") != null || num != null) && StringUtilities.isEmpty((String)candAddr.getAddressNumber())) {
            String numToUse = null;
            String S4HnrFromPIACalc = constraints.getCustomString("S4_INPUT_HOUSE_NUMBER");
            if (num == null || num != null && !StringUtilities.isEmpty((String)S4HnrFromPIACalc) && !num.toString().equals(S4HnrFromPIACalc)) {
                boolean sgpTypecase;
                StringWithTokens toks = new StringWithTokens(candAddr.getFormattedStreetAddress());
                boolean bl = sgpTypecase = StringUtilities.isNumeric((String)toks.getLastToken()) && toks.getLastToken().equalsIgnoreCase(S4HnrFromPIACalc);
                if (!sgpTypecase) {
                    numToUse = S4HnrFromPIACalc;
                }
            } else {
                numToUse = num.toString();
            }
            if (numToUse != null && numToUse.length() > 1 && candAddr.getFormattedStreetAddress().startsWith(numToUse)) {
                numToUse = null;
            }
            if (numToUse != null) {
                CandidateAddress dummy = new CandidateAddress((Address)candAddr);
                InternalFieldValue value = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                AddressWord[] fieldWords = this.getFieldValue(value, scoringAddr, FieldType.POST_THOROUGHFARE_FIELD_TYPE, formatter, ALT_STREET_NAME);
                if (dummy.getPostThoroughfareType() != null) {
                    dummy.setPostThoroughfareType(this.getParser().getPostThoroughFareName(fieldWords));
                }
                if (dummy.getPreThoroughfareType() != null) {
                    dummy.setPreThoroughfareType(this.getParser().getPreThoroughFareName(fieldWords));
                }
                dummy.setAddressNumber(numToUse);
                Map<String, String> map = formatter.applyFieldMappings(dummy, scoringAddr, null, null, null);
                formatter.setFields(dummy, map);
                candAddr.setFormattedStreetAddress(dummy.getFormattedStreetAddress());
                candAddr.setAddressNumber(dummy.getAddressNumber());
            }
        }
        this.copyMatchFlags(candAddr, scoringAddr, isIntersection);
        if (scoringAddr.getAddressType() != 1 || isIntersection) {
            candAddr.setNumberOfReturnableRanges(0);
        } else {
            candAddr.setNumberOfReturnableRanges(totalRanges);
            int maxRanges = constraints.getMaxRanges();
            if (maxRanges == -1 || maxRanges > totalRanges) {
                maxRanges = totalRanges;
            }
            if (scoringAddr.getAddressType() == 1) {
                for (int r = 0; r < maxRanges; ++r) {
                    InternalScoringRange internalRange = scoringAddr.getRangeAt(r);
                    CandidateRange candRange = this.convertRange(internalRange, dataManager);
                    int totalUnits = internalRange.getUnitCount();
                    candRange.setNumberOfReturnableRangeUnits(totalUnits);
                    int maxUnits = constraints.getMaxRangeUnits();
                    int unitsToReturn = maxUnits == -1 ? totalUnits : Math.min(maxUnits, totalUnits);
                    for (int u = 0; u < unitsToReturn; ++u) {
                        CandidateRangeUnit candUnit = this.convertUnit(internalRange.getUnitAt(u), dataManager);
                        candRange.addRangeUnit(candUnit);
                    }
                    candAddr.addCandidateRange(candRange);
                }
            }
        }
    }

    private void reprocessFlagsForIntersection(CandidateAddress[] candAddr, InternalIntersectionScoringAddress scoringAddr) {
        InternalScoringAddress firstCand = scoringAddr.getFirstCandidate();
        InternalScoringAddress secondCand = scoringAddr.getSecondCandidate();
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE))) {
            candAddr[0].setPostalCode1Matched();
        } else if (this.isFieldMatch(secondCand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE))) {
            candAddr[0].setPostCode1(candAddr[1].getPostCode1());
            candAddr[0].setPostalCode1Matched();
        }
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            candAddr[0].setAreaName1Matched();
        } else if (this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            candAddr[0].setAreaName1(candAddr[1].getAreaName1());
            candAddr[0].setAreaName1Matched();
        }
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            candAddr[0].setAreaName2Matched();
        } else if (this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            candAddr[0].setAreaName2(candAddr[1].getAreaName2());
            candAddr[0].setAreaName2Matched();
        }
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            candAddr[0].setAreaName3Matched();
        } else if (this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            candAddr[0].setAreaName3(candAddr[1].getAreaName3());
            candAddr[0].setAreaName3Matched();
        }
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            candAddr[0].setAreaName4Matched();
        } else if (this.isFieldMatch(secondCand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            candAddr[0].setAreaName4(candAddr[1].getAreaName4());
            candAddr[0].setAreaName4Matched();
        }
        if (this.isFieldMatch(firstCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)) && this.isFieldMatch(secondCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE))) {
            candAddr[0].setStreetNameMatched();
        }
    }

    private void reprocessFieldsForIntersection(CandidateAddress candAddr) {
        candAddr.setPreThoroughfareType(null);
        candAddr.setPostThoroughfareType(null);
        candAddr.setPreDirectional(null);
        candAddr.setPostDirectional(null);
    }

    private AddressWord[] getFieldWords(InternalFieldValue fieldValue) {
        if (fieldValue != null) {
            return (AddressWord[])fieldValue.getFieldValue();
        }
        return null;
    }

    protected AddressWord[] getFieldValue(InternalFieldValue fieldValue, InternalScoringAddress scoringAddress, FieldType type, CGGEFormatter formatter, String typeKey) {
        if (fieldValue != null) {
            FieldScore score = scoringAddress.getFieldScore(type);
            AddressWord[] fieldWords = score != null ? (score.m_value > 0.0 && fieldValue.hasAlternates() && formatter.getAlternateProperty(typeKey) ? this.getBestAlternateValue(fieldValue, score, scoringAddress, type) : (AddressWord[])fieldValue.getFieldValue()) : (AddressWord[])fieldValue.getFieldValue();
            return fieldWords;
        }
        return null;
    }

    private AddressWord[] getBestAlternateValue(InternalFieldValue fieldValue, FieldScore origScore, InternalScoringAddress scoringAddress, FieldType type) {
        int suggestedMatchIdx = origScore.m_matchedAltIndex;
        AddressWord[] suggestedFieldWords = (AddressWord[])fieldValue.getFieldValue();
        if (suggestedMatchIdx != -1) {
            suggestedFieldWords = ((AddressWord[][])fieldValue.getAlternateValues())[suggestedMatchIdx];
        }
        String normalizedSuggestedStr = this.makeNormalizedString(suggestedFieldWords);
        AddressWord[] nonNormalizableInputFieldWords = null;
        FieldScore bestScore = null;
        for (int i = 0; i < ((AddressWord[][])fieldValue.getAlternateValues()).length; ++i) {
            AddressWord[] testAlternates = ((AddressWord[][])fieldValue.getAlternateValues())[i];
            String testNormalizedStr = this.makeNormalizedString(testAlternates);
            if (!testNormalizedStr.equals(normalizedSuggestedStr)) continue;
            if (nonNormalizableInputFieldWords == null) {
                if (scoringAddress.getFieldScore((FieldType)type).m_inputWords == null) break;
                nonNormalizableInputFieldWords = this.makeNonNormalizableCopy(scoringAddress.getFieldScore((FieldType)type).m_inputWords);
                AddressWord[] nonNormalizedSuggestedStr = this.makeNonNormalizableCopy(suggestedFieldWords);
                bestScore = this.getAlternateValueScorer().scoreAddressWords(nonNormalizableInputFieldWords, nonNormalizedSuggestedStr, type, null);
            }
            AddressWord[] nonNormalizableTestAlternates = this.makeNonNormalizableCopy(testAlternates);
            FieldScore testScore = this.getAlternateValueScorer().scoreAddressWords(nonNormalizableInputFieldWords, nonNormalizableTestAlternates, type, null);
            if (testScore.compare(testScore, bestScore) <= 0) continue;
            bestScore = testScore;
            suggestedFieldWords = testAlternates;
            origScore.m_matchedAltIndex = i;
        }
        return suggestedFieldWords;
    }

    private String makeNormalizedString(AddressWord[] words) {
        if (words == null || words.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AddressWord word : words) {
            sb.append(word.getNormalizedChars());
        }
        return sb.toString();
    }

    private AddressWord[] makeNonNormalizableCopy(AddressWord[] words) {
        AddressWord[] copy = new AddressWord[words.length];
        int idx = 0;
        for (AddressWord word : words) {
            AddressWord copied = new AddressWord(word);
            copied.setCodedWord(new CodedWord(word.getCodedWord()));
            copied.setNormalizedChars(null);
            copy[idx] = copied;
            ++idx;
        }
        return copy;
    }

    protected void copyAddressFields(CandidateAddress candAddr, InternalScoringAddress scoringAddr, CGGEFormatter formatter, IDataManager dataManager, boolean intersection) throws DataFetchException, CGGEInternalException {
        AdditionalFields unitAdditionalFields;
        AdditionalFields rangeAdditionalFields;
        AdditionalFields streetAdditionalFields;
        candAddr.setCountry(this.m_country);
        if (scoringAddr.getLanguage() != null) {
            candAddr.addKeyValueToAdditionalFields("LANGUAGE", scoringAddr.getLanguage());
        }
        ICGGEParser parser = CGGEHandler.getInstance(scoringAddr.getInternalAddress().getDataSetInfo(), this.m_country, this.m_language).getParser();
        Map fields = scoringAddr.getFields();
        if (fields != null && fields.size() > 0) {
            Iterator fieldsIt = fields.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            builder.append("alt_");
            while (fieldsIt.hasNext()) {
                Map.Entry entry = fieldsIt.next();
                FieldType type = entry.getKey();
                InternalFieldValue value = (InternalFieldValue)entry.getValue();
                if (builder.length() > 4) {
                    builder.delete(4, builder.length()).append(type.getName());
                } else {
                    builder.append(type.getName());
                }
                AddressWord[] fieldWords = this.getFieldValue(value, scoringAddr, type, formatter, builder.toString());
                if (type == FieldType.STREET_NAME_FIELD_TYPE) {
                    String preType = parser.getPreThoroughFareName(fieldWords);
                    String postType = parser.getPostThoroughFareName(fieldWords);
                    String streetName = parser.getStreetNamePartOnly(fieldWords);
                    String preDir = parser.getPreDirectional(fieldWords);
                    String postDir = parser.getPostDirectional(fieldWords);
                    candAddr.setPreThoroughfareType(preType);
                    candAddr.setPostThoroughfareType(postType);
                    candAddr.setPreDirectional(preDir);
                    candAddr.setPostDirectional(postDir);
                    candAddr.setMainAddress(streetName);
                    continue;
                }
                String fieldValue = null;
                if (fieldWords != null) {
                    fieldValue = parser.reconstructFieldValue(fieldWords);
                }
                switch (type.getKey()) {
                    case 15: {
                        candAddr.setPostCode1(fieldValue);
                        break;
                    }
                    case 16: {
                        candAddr.setAreaName1(fieldValue);
                        break;
                    }
                    case 17: {
                        candAddr.setAreaName2(fieldValue);
                        break;
                    }
                    case 18: {
                        candAddr.setAreaName3(fieldValue);
                        break;
                    }
                    case 19: {
                        candAddr.setAreaName4(fieldValue);
                        break;
                    }
                    case 7: {
                        candAddr.setPlaceName(fieldValue);
                        break;
                    }
                    case 24: {
                        candAddr.setGenericField1(fieldValue);
                        break;
                    }
                    case 25: {
                        candAddr.setGenericField2(fieldValue);
                        break;
                    }
                    case 26: {
                        candAddr.setGenericField3(fieldValue);
                        break;
                    }
                    case 27: {
                        candAddr.setGenericField4(fieldValue);
                        break;
                    }
                    case 28: {
                        candAddr.setCountry(fieldValue);
                    }
                }
            }
        }
        boolean s3HasGeom = candAddr.getAdditionalFieldForKey(HASGEOM) != null;
        candAddr.getAdditionalFields().remove(HASGEOM);
        if (s3HasGeom) {
            streetAdditionalFields = null;
            rangeAdditionalFields = null;
            unitAdditionalFields = null;
            scoringAddr.setIgnoreRangeLevel(true);
        } else {
            streetAdditionalFields = CGGECandidateConvertor.getAdditionalFields(scoringAddr, FieldType.FieldLevel.LEVEL_STREET, dataManager);
            rangeAdditionalFields = CGGECandidateConvertor.getAdditionalFields(scoringAddr, FieldType.FieldLevel.LEVEL_RANGE, dataManager);
            unitAdditionalFields = CGGECandidateConvertor.getAdditionalFields(scoringAddr, FieldType.FieldLevel.LEVEL_UNIT, dataManager);
        }
        if (scoringAddr.getRangeCount() > 0 && !(scoringAddr instanceof InternalIntersectionScoringAddress)) {
            AddressWord[] placeNameAddressWords;
            String placeName;
            InternalFieldValue placeNameFieldtype;
            InternalScoringRange range = scoringAddr.getRangeAt(0);
            if (!intersection) {
                AddressNumber pointRangeHouseNumber;
                AddressNumberScore score = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (score != null) {
                    if (candAddr.getLocationPrecision() == 16) {
                        candAddr.setAddressNumber(this.getMatchedAddressNumber(range, score.getInputAddressNumber(), score));
                    } else if (candAddr.getLocationPrecision() == 1) {
                        candAddr.setAddressNumber(this.getMatchedAddressNumberForRangedCandidate(range, score.getInputAddressNumber(), score, formatter));
                    } else if (!scoringAddr.getIgnoreRangeLevel() && range.getFrom() != null && range.getTo() == null) {
                        candAddr.setAddressNumber(this.getMatchedAddressNumber(range, score.getInputAddressNumber(), score));
                    } else if (range.getFrom() != null && range.getTo() != null) {
                        candAddr.setAddressNumber(this.getMatchedAddressNumberForRangedCandidate(range, score.getInputAddressNumber(), score, formatter));
                    }
                } else if (candAddr.getLocationPrecision() == 16 && (pointRangeHouseNumber = range.getFrom()) != null) {
                    candAddr.setAddressNumber(pointRangeHouseNumber.toString());
                }
            }
            if ((placeNameFieldtype = (InternalFieldValue)range.getField(FieldType.RANGE_PLACE_NAME_FIELD_TYPE)) != null && (placeName = parser.reconstructFieldValue(placeNameAddressWords = (AddressWord[])placeNameFieldtype.getFieldValue())) != null) {
                candAddr.setPlaceName(placeName);
            }
        }
        Map<String, String> map = formatter.applyFieldMappings(candAddr, scoringAddr, unitAdditionalFields, rangeAdditionalFields, streetAdditionalFields);
        if (candAddr.fromUserDictionary() && streetAdditionalFields != null && streetAdditionalFields.getAdditionalFields() != null) {
            Set<Map.Entry<FieldType, String>> udAdditionalFiledsEntries = streetAdditionalFields.getAdditionalFields().entrySet();
            for (Map.Entry<FieldType, String> udAdditionalFiledsEntry : udAdditionalFiledsEntries) {
                map.put(udAdditionalFiledsEntry.getKey().toString(), udAdditionalFiledsEntry.getValue());
            }
        }
        formatter.setFields(candAddr, map);
        INearByStreet nearByStreetHandler = CGGEHandler.getInstance(this.getDataSetInfo(), this.m_country, this.m_language).getNearByStreetHandle();
        if (null != nearByStreetHandler) {
            nearByStreetHandler.setAdditionalFiledValuesRanges(candAddr, scoringAddr, parser);
        }
    }

    protected static AdditionalFields getAdditionalFields(InternalScoringAddress addr, FieldType.FieldLevel level, IDataManager dataManager) throws DataFetchException {
        if (level == FieldType.FieldLevel.LEVEL_STREET || level == FieldType.FieldLevel.LEVEL_POSTAL) {
            return CGGECandidateConvertor.getAdditionalFields(addr, dataManager);
        }
        if (addr.getRangeCount() > 0) {
            InternalScoringRange range = addr.getRangeAt(0);
            if (level == FieldType.FieldLevel.LEVEL_RANGE) {
                return CGGECandidateConvertor.getAdditionalFields(range, dataManager);
            }
            if (level == FieldType.FieldLevel.LEVEL_UNIT && range.getUnitCount() > 0) {
                return CGGECandidateConvertor.getAdditionalFields(range.getUnitAt(0), dataManager);
            }
        }
        return null;
    }

    @Override
    public String getMatchedAddressNumberS3(InternalScoringRange range, AddressNumber inputNum, AddressNumberScore addrNumScore) {
        return this.getMatchedAddressNumber(range, inputNum, addrNumScore);
    }

    protected String getMatchedAddressNumber(InternalScoringRange range, AddressNumber inputNum, AddressNumberScore addrNumScore) {
        StringBuilder builder = new StringBuilder();
        if (addrNumScore.isMatched()) {
            boolean separator = false;
            if (addrNumScore.isNumber1Matched()) {
                builder.append(inputNum.getHnrNumber1());
                separator = true;
            }
            if (addrNumScore.isSuffix1Matched()) {
                builder.append(inputNum.getHnrSuffix1());
                separator = true;
            }
            if (addrNumScore.isNumber2Matched()) {
                if (separator) {
                    if (range.getFrom().getSeperatorType() == 1) {
                        builder.append("/");
                    } else if (range.getFrom().getSeperatorType() == 0) {
                        builder.append("-");
                    }
                    separator = false;
                }
                builder.append(inputNum.getHnrNumber2());
            }
            if (addrNumScore.isSuffix2Matched()) {
                if (separator) {
                    if (range.getFrom().getSeperatorType() == 1) {
                        builder.append("/");
                    } else if (range.getFrom().getSeperatorType() == 0) {
                        builder.append("-");
                    }
                    separator = false;
                }
                builder.append(inputNum.getHnrSuffix2());
            }
        } else if (addrNumScore.getOffset() > 0) {
            if (addrNumScore.getOffsetPosition() == 1) {
                builder.append(range.getFrom());
            } else {
                builder.append(range.getTo());
            }
        } else if (range.getFrom() != null) {
            builder.append(range.getFrom());
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    protected String getMatchedAddressNumberForRangedCandidate(InternalScoringRange range, AddressNumber inputNum, AddressNumberScore addrNumScore, CGGEFormatter formatter) {
        StringBuilder builder = new StringBuilder();
        if (addrNumScore.isMatched()) {
            boolean separator = false;
            if (addrNumScore.isNumber1Matched()) {
                builder.append(inputNum.getHnrNumber1());
                builder.append(formatter.isHNRSuffixToBeAppended() && inputNum.getHnrSuffix1() != null ? inputNum.getHnrSuffix1() : "");
                separator = true;
            }
            if (addrNumScore.isNumber2Matched()) {
                if (separator) {
                    if (range.getFrom().getSeperatorType() == 1) {
                        builder.append("/");
                    } else if (range.getFrom().getSeperatorType() == 0) {
                        builder.append("-");
                    }
                    separator = false;
                }
                builder.append(inputNum.getHnrNumber2());
                builder.append(formatter.isHNRSuffixToBeAppended() && inputNum.getHnrSuffix2() != null ? inputNum.getHnrSuffix2() : "");
            }
        } else if (addrNumScore.getOffset() > 0) {
            if (addrNumScore.getOffsetPosition() == 1) {
                builder.append(range.getFrom());
            } else {
                builder.append(range.getTo());
            }
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    private boolean isFieldMatch(FieldScore score) {
        return score != null ? score.m_matched : false;
    }

    protected void handleCountryMatchedFlag(CandidateAddress candidate, InternalScoringAddress scoringAddress) {
        candidate.setCountryMatched();
    }

    protected void copyMatchFlags(CandidateAddress candAddr, InternalScoringAddress scoringAddr, boolean isIntersection) {
        AddressNumberScore addrNumScore;
        InternalScoringRange range;
        this.handleCountryMatchedFlag(candAddr, scoringAddr);
        if (scoringAddr.isCloseMatch()) {
            candAddr.setCloseMatch();
        }
        if (this.isFieldMatch(scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE))) {
            candAddr.setPostalCode1Matched();
        }
        if (this.isFieldMatch(scoringAddr.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            candAddr.setAreaName1Matched();
        }
        if (this.isFieldMatch(scoringAddr.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            candAddr.setAreaName2Matched();
        }
        if (this.isFieldMatch(scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            candAddr.setAreaName3Matched();
        }
        if (this.isFieldMatch(scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            candAddr.setAreaName4Matched();
        }
        if ((range = scoringAddr.getMatchedRange()) != null) {
            addrNumScore = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (addrNumScore != null && addrNumScore.isMatched()) {
                candAddr.setAddressNumberMatched();
            }
        } else if (scoringAddr.getRangeCount() > 0) {
            addrNumScore = (AddressNumberScore)scoringAddr.getRangeAt(0).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            AddressNumber num = null;
            FieldScore Fscore = scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (Fscore instanceof AddressNumberScore) {
                num = ((AddressNumberScore)Fscore).getInputAddressNumber();
            }
            if ((addrNumScore == null || addrNumScore.getOffset() == 0 && num == null) && candAddr.getLocationPrecision() == 2) {
                candAddr.setAddressNumberMatched();
            }
        }
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        this.handleStreetNameMatchFlags(score, candAddr, isIntersection);
    }

    protected void handleStreetNameMatchFlags(FieldScore score, CandidateAddress candAddr, boolean isIntersection) {
        if (score != null) {
            if (score.m_matched && !isIntersection) {
                candAddr.setStreetNameMatched();
                candAddr.setStreetPrefixAndSuffixMatched();
                candAddr.setPostDirectionalMatched();
                candAddr.setPreDirectionalMatched();
                candAddr.setThoroughfareTypeMatched();
            } else {
                AddressWord[] streetWords = score.m_candWords;
                int wordCount = streetWords == null ? 0 : streetWords.length;
                IntArray perfectMatches = score.m_perfectCandWords;
                ICGGEParserTerms parserTerms = this.getParser().getParserTerms();
                boolean streetNameMatched = true;
                boolean preDirectionalMatched = true;
                boolean postDirectionalMatched = true;
                boolean tftFound = false;
                if (perfectMatches != null && perfectMatches.size() > 0) {
                    for (int i = 0; i < wordCount; ++i) {
                        AddressWord word = streetWords[i];
                        if (CodedWord.isDelimiter(word.getAttributes())) continue;
                        boolean wordMatched = perfectMatches.contains(i);
                        if (word.m_wordType == FieldType.POST_THOROUGHFARE_FIELD_TYPE) {
                            if (wordMatched) {
                                candAddr.setThoroughfareTypeMatched();
                            }
                            tftFound = true;
                            continue;
                        }
                        if (i == 0 && parserTerms.isDirectionalWord(word.getWord())) {
                            if (wordMatched) continue;
                            preDirectionalMatched = false;
                            continue;
                        }
                        if (i == wordCount - 1 && parserTerms.isDirectionalWord(word.getWord())) {
                            if (wordMatched) continue;
                            postDirectionalMatched = false;
                            continue;
                        }
                        if (wordMatched || word.m_weight <= 0) continue;
                        streetNameMatched = false;
                    }
                    if (streetNameMatched && !isIntersection) {
                        candAddr.setStreetNameMatched();
                        candAddr.setStreetPrefixAndSuffixMatched();
                    }
                    if (preDirectionalMatched) {
                        candAddr.setPreDirectionalMatched();
                    }
                    if (postDirectionalMatched) {
                        candAddr.setPostDirectionalMatched();
                    }
                }
            }
        }
    }

    protected CandidateRange convertRange(InternalScoringRange range, IDataManager dataManager) throws DataFetchException {
        AdditionalFields fields;
        CandidateRange candRange = new CandidateRange();
        AddressNumber from = range.getFrom();
        ICGGEParser parser = this.getParser();
        if (from != null) {
            candRange.setLowAddress(from.toString());
        } else {
            candRange.setLowAddress("");
        }
        AddressNumber to = range.getTo();
        if (to != null) {
            candRange.setHighAddress(to.toString());
        } else {
            candRange.setHighAddress("");
        }
        switch (range.getOddEvenIndicator()) {
            case 3: {
                candRange.setOddEvenIndicator(1);
                break;
            }
            case 2: {
                candRange.setOddEvenIndicator(2);
                break;
            }
            case 4: {
                candRange.setOddEvenIndicator(0);
                break;
            }
            default: {
                candRange.setOddEvenIndicator(-1);
            }
        }
        switch (range.getRangeSide()) {
            case 1: {
                candRange.setLeftRightIndicator(1);
                break;
            }
            case 2: {
                candRange.setLeftRightIndicator(2);
                break;
            }
            default: {
                candRange.setLeftRightIndicator(0);
            }
        }
        AddressWord[] placeNameWords = this.getFieldWords((InternalFieldValue)range.getField(FieldType.RANGE_PLACE_NAME_FIELD_TYPE));
        if (placeNameWords != null) {
            String placeName = parser.reconstructFieldValue(placeNameWords);
            candRange.setPlaceName(placeName);
        }
        if ((fields = CGGECandidateConvertor.getAdditionalFields(range, dataManager)) != null && fields.size() > 0) {
            CGGECandidateConvertor.setAdditionalFields(candRange, fields);
        }
        return candRange;
    }

    private static AdditionalFields getAdditionalFields(ScoringItem addr, IDataManager dataManager) throws DataFetchException {
        InternalAddress internalAddress = addr.getInternalAddress();
        if (internalAddress.hasAdditionalFields()) {
            return dataManager.getAdditionalFields(internalAddress);
        }
        return null;
    }

    private static void setAdditionalFields(CandidateRange range, AdditionalFields addFields) {
        for (Map.Entry<FieldType, String> en : addFields.getAdditionalFields().entrySet()) {
            range.setAdditionalField(en.getKey().getName(), (Object)en.getValue());
        }
    }

    private static void setAdditionalFields(CandidateRangeUnit unit, AdditionalFields addFields) {
        for (Map.Entry<FieldType, String> en : addFields.getAdditionalFields().entrySet()) {
            unit.setAdditionalField(en.getKey().getName(), (Object)en.getValue());
        }
    }

    private CandidateRangeUnit convertUnit(InternalScoringUnit unit, IDataManager dataManager) throws DataFetchException {
        AdditionalFields fields;
        CandidateRangeUnit candidateRangeUnit = new CandidateRangeUnit();
        ICGGEParser parser = this.getParser();
        AddressWord[] placeNameWords = this.getFieldWords((InternalFieldValue)unit.getField(FieldType.UNIT_PLACE_NAME_FIELD_TYPE));
        if (placeNameWords != null) {
            String placeName = parser.reconstructFieldValue(placeNameWords);
            candidateRangeUnit.setPlaceName(placeName);
        }
        if ((fields = CGGECandidateConvertor.getAdditionalFields(unit, dataManager)) != null && fields.size() > 0) {
            CGGECandidateConvertor.setAdditionalFields(candidateRangeUnit, fields);
        }
        return candidateRangeUnit;
    }

    protected boolean doS3(CandidateAddress cand, IDataManager dataManager, InternalScoringAddress scoringAddress, boolean doS3) throws Exception {
        if (!doS3) {
            return false;
        }
        if (CandidateS3Determinator.isS3(dataManager, scoringAddress)) {
            cand.setLocationPrecision(5);
            if (scoringAddress.getRangeCount() > 0 && CandidateS3Determinator.getPointCount(dataManager, scoringAddress.getRangeAt(0).getRange()) > 0) {
                cand.getAdditionalFields().put(HASGEOM, "");
            }
            return true;
        }
        return false;
    }

    protected void interpolate(CandidateAddress candAddr, InternalScoringAddress scoringAddress, IDataManager dataManager, InternalScoringRange scoringRange, IConstraints constraints) throws Exception {
        int points;
        List<DirectPosition> geom;
        Length streetOffset = constraints.getStreetOffsetAsLength();
        Length cornerOffset = constraints.getCornerOffsetAsLength();
        if (!scoringRange.getRange().arePointsAssigned()) {
            geom = dataManager.getGeometry(scoringRange.getRange());
            scoringRange.getRange().setPoints(geom);
        } else {
            geom = scoringRange.getRange().getPoints();
        }
        int n = points = geom == null ? 0 : geom.size();
        if (scoringAddress.getAddressType() == 1) {
            if (points == 1) {
                candAddr.setLocation(geom.get(0));
                candAddr.setLocationPrecision(16);
            } else if (points > 1) {
                DirectPosition point;
                AddressNumberScore addrNumScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (addrNumScore != null && (addrNumScore.isMatched() || addrNumScore.getOffset() > 0)) {
                    AddressNumber result = addrNumScore.isMatched() ? (addrNumScore.getInputAddressNumber().getHnrNumber1() != 0 && addrNumScore.getInputAddressNumber().getHnrNumber2() != 0 ? (addrNumScore.isNumber1Matched() && addrNumScore.isNumber2Matched() ? addrNumScore.getInputAddressNumber() : (addrNumScore.isNumber1Matched() ? new AddressNumber(addrNumScore.getInputAddressNumber().getHnrNumber1()) : new AddressNumber(addrNumScore.getInputAddressNumber().getHnrNumber2()))) : addrNumScore.getInputAddressNumber()) : (addrNumScore.getOffsetPosition() == 1 ? scoringRange.getRange().getFrom() : scoringRange.getRange().getTo());
                    double percentage = scoringRange.getRange().calculateMatchedAddressNumPosition(scoringRange.getRange(), result);
                    point = Interpolator.interpolate(geom, (scoringRange.getRangeSide() == 1 ? 1 : 0) != 0, (double)percentage, (Length)cornerOffset, (Length)streetOffset);
                    candAddr.setLocationPrecision(1);
                } else {
                    point = Interpolator.interpolateShapePath(geom);
                    candAddr.setLocationPrecision(2);
                }
                candAddr.setLocation(point);
            }
        } else if (scoringAddress.getAddressType() == 2) {
            if (scoringRange.getDataSetInfo().getMetaData().getGlobalLocationPrecision() != 0) {
                candAddr.setLocationPrecision(scoringRange.getDataSetInfo().getMetaData().getGlobalLocationPrecision());
            } else {
                candAddr.setLocationPrecision(3);
            }
            if (points > 0) {
                candAddr.setLocation(geom.get(0));
            }
        } else if (scoringAddress.getAddressType() == 3) {
            if (!scoringAddress.isEmpty(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                candAddr.setLocationPrecision(11);
            } else if (!scoringAddress.isEmpty(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                candAddr.setLocationPrecision(10);
            } else if (!scoringAddress.isEmpty(FieldType.AREA_NAME_2_FIELD_TYPE)) {
                candAddr.setLocationPrecision(9);
            } else if (!scoringAddress.isEmpty(FieldType.AREA_NAME_1_FIELD_TYPE)) {
                candAddr.setLocationPrecision(8);
            }
            if (points > 0) {
                candAddr.setLocation(geom.get(0));
            }
        } else if (scoringAddress.getAddressType() == 4) {
            if (points > 0) {
                candAddr.setLocationPrecision(16);
                candAddr.setLocation(geom.get(0));
            }
        } else if (points > 0) {
            candAddr.setLocation(geom.get(0));
        }
        if (candAddr.getLocationPrecision() != 0) {
            CoordSys toSys = constraints.getClientCoordinateSystemObject();
            CoordSys fromSys = scoringAddress.getDataSetInfo().getMetaData().getSourceCoordSysObject();
            if (!fromSys.equivalent(toSys)) {
                DirectPosition newPoint = this.transformPoint(candAddr.getLocationPoint(), fromSys, toSys);
                candAddr.setLocation(newPoint);
            }
            candAddr.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)toSys));
        }
    }

    private final DirectPosition transformPoint(DirectPosition point, CoordSys fromSys, CoordSys toSys) {
        DirectPosition outPoint = new DirectPosition();
        CoordTransform transformer = new CoordTransform(fromSys, toSys);
        transformer.transform(point, outPoint);
        return outPoint;
    }

    public void setPrecisionCode(CandidateAddress cand) {
        this.setPrecisionCode(cand, 0);
    }

    public void setPrecisionCode(CandidateAddress cand, int flag) {
        cand.addKeyValueToAdditionalFields("RESULT_CODE", InternalCandidateAddress.buildPrecisionCodeFromCandidateHandleStreetWithPostCentroid((CandidateAddress)cand, (int)flag));
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public void setCountry(String countryCode) {
        this.m_country = countryCode;
    }

    public static String getDataTypeString(int dataType, String defaultValue) {
        switch (dataType) {
            case 3: {
                return "geographic";
            }
            case 4: {
                return "poi";
            }
            case 2: {
                return "postal";
            }
            case 1: {
                return "street";
            }
        }
        return defaultValue;
    }
}

