/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CGGEFormatter {
    public static final String SET_ADDRESS_NUMBER = "set_address_number";
    public static final String SET_MAIN_ADDRESS = "set_main_address";
    public static final String SET_PRE_THOROUGHFARE = "set_pre_thoroughfare";
    public static final String SET_POST_THOROUGHFARE = "set_post_thoroughfare";
    public static final String SET_POST_CODE = "set_post_code";
    public static final String SET_PLACE_NAME = "set_place_name";
    public static final String SET_PRE_DIRECTIONAL = "set_pre_directional";
    public static final String SET_POST_DIRECTIONAL = "set_post_directional";
    public static final String SET_PRE_ADDRESS = "set_pre_address";
    public static final String SET_POST_ADDRESS = "set_post_address";
    public static final String SET_AREA_NAME_1 = "set_area_name_1";
    public static final String SET_AREA_NAME_2 = "set_area_name_2";
    public static final String SET_AREA_NAME_3 = "set_area_name_3";
    public static final String SET_AREA_NAME_4 = "set_area_name_4";
    public static final String SET_GENERIC_FIELD_1 = "set_generic_field_1";
    public static final String SET_GENERIC_FIELD_2 = "set_generic_field_2";
    public static final String SET_GENERIC_FIELD_3 = "set_generic_field_3";
    public static final String SET_GENERIC_FIELD_4 = "set_generic_field_4";
    public static final String SET_FORMATTED_LOCATION = "set_formatted_location";
    public static final String SET_FORMATTED_STREET = "set_formatted_street";
    public static final String SET_ADDITIONAL_FIELD = "set_additional_field";
    public static final String LEFT_ASSOCIATION = "left";
    public static final String RIGHT_ASSOCIATION = "right";
    public static final String SET_PREFIX = "set_";
    public static final String ADITIONAL_FIELD = "additional:";
    public static final String META_CHARS_ASSOCIATION = "meta_chars_association";
    private final String APPEND_HNR_SUFFIX = "set_input_hnr_suffix_ranged_candidate";
    private final String SET_CANDIDATE_CASE = "set_candidate_case";
    private final String REMOVE_SUCCESSIVE_AREANAMES = "remove_successiveAreaNames";
    private static final String KEY_THOROUGHFARETYPE_NON_DELIMITED = "thoroughfaretype_non_delimited";
    private final String HISTORICAL_POST_CODE = "HistoricalPostCode";
    private final String S3_WITH_POINT_DATA = "s3_with_point_data";
    private static String POBOX_FORMATTED_STREET = "set_pobox_formatted_street";
    private boolean m_isLeftAssociativity;
    private boolean m_removeSuccessiveAreaName;
    private Properties m_props;
    private ArrayList<String> m_fieldMappings;
    private ICGGEParser m_parser;
    private int m_casing;
    private static Map<DataSetInfo, CGGEFormatter> m_formatters;
    private boolean m_isDefault;
    private boolean m_ishnrToBeappended = true;
    private boolean m_s3WithPointData;
    private String m_country;
    private String m_language;
    private String[] m_poBoxFormat;

    private CGGEFormatter(String country, String language, DataSetInfo dataSetInfo) {
        this.m_country = country;
        this.m_language = language;
        this.m_parser = CGGEHandler.getInstance(dataSetInfo, country, language).getParser();
    }

    public static CGGEFormatter getInstance(DataSetInfo dataSetInfo, String cntry, String lang) throws Exception {
        IDictionaryMetaData metaData = dataSetInfo.getMetaData();
        if (m_formatters == null) {
            m_formatters = new HashMap<DataSetInfo, CGGEFormatter>();
        }
        CGGEFormatter formatter = null;
        if (m_formatters.containsKey(dataSetInfo)) {
            formatter = m_formatters.get(dataSetInfo);
        } else {
            formatter = new CGGEFormatter(cntry, lang, dataSetInfo);
            formatter.init(dataSetInfo);
            formatter.setDefault();
            m_formatters.put(dataSetInfo, formatter);
        }
        return formatter;
    }

    private void init(DataSetInfo dataSetInfo) throws Exception {
        String val;
        String key;
        this.m_props = null;
        String baseName = CGGEResourceBundle.buildBaseConfigName(this.m_country, "_CandidateConvertor.properties");
        String typeName = GeocodeOptions.getGeocodeTypeName(dataSetInfo.getGeocodeType());
        this.m_props = CGGEResourceBundle.getBundle(baseName, dataSetInfo.getName(), this.m_language, typeName);
        if (null != dataSetInfo && dataSetInfo.getDataSetConfiguration() != null) {
            Properties prop = dataSetInfo.getDataSetConfiguration();
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (!key.startsWith("_CandidateConvertorSettings")) continue;
                String value = prop.getProperty(key);
                this.m_props.put(key.substring(key.indexOf(".") + 1), value);
            }
        }
        if ((val = (String)this.m_props.get(META_CHARS_ASSOCIATION)) != null && val.trim().length() > 0) {
            if (val.equalsIgnoreCase(LEFT_ASSOCIATION)) {
                this.m_isLeftAssociativity = true;
            }
        } else {
            this.m_isLeftAssociativity = true;
        }
        if (Boolean.parseBoolean((String)this.m_props.get("remove_successiveAreaNames"))) {
            this.m_removeSuccessiveAreaName = true;
        }
        if (Boolean.parseBoolean((String)this.m_props.get("s3_with_point_data"))) {
            this.m_s3WithPointData = true;
        }
        this.m_fieldMappings = new ArrayList();
        Iterator<Object> itr = this.m_props.keySet().iterator();
        key = null;
        Object temp = null;
        while (itr.hasNext()) {
            key = (String)itr.next();
            temp = this.m_props.get(key);
            if (!(temp instanceof String) || !key.startsWith(SET_PREFIX) || temp == null || ((String)temp).trim().length() <= 0) continue;
            if ("set_input_hnr_suffix_ranged_candidate".equalsIgnoreCase(key)) {
                this.m_ishnrToBeappended = Boolean.parseBoolean(((String)temp).trim());
                continue;
            }
            if ("set_candidate_case".equalsIgnoreCase(key)) {
                String casingProperty = temp.toString().trim().toUpperCase();
                if (casingProperty.equalsIgnoreCase("UPPERCASE")) {
                    this.m_casing = 1;
                    continue;
                }
                if (casingProperty.equalsIgnoreCase("LOWERCASE")) {
                    this.m_casing = 2;
                    continue;
                }
                if (!casingProperty.equalsIgnoreCase("TITLECASE")) continue;
                this.m_casing = 3;
                continue;
            }
            if (key.equals(POBOX_FORMATTED_STREET)) {
                this.m_poBoxFormat = this.parseFormatString((String)temp);
                continue;
            }
            this.m_fieldMappings.add(key);
            this.m_props.put(key, this.parseFormatString((String)temp));
        }
    }

    private void addToPossibleDeleteChars(ArrayList<int[]> possibles, int[] toAdd) {
        for (int[] contained : possibles) {
            if (contained[0] != toAdd[0] || contained[1] != toAdd[1]) continue;
            return;
        }
        possibles.add(toAdd);
    }

    private String applyFormat(CandidateAddress candAddr, InternalScoringAddress scoringAddr, String formatName, String[] origformat, AdditionalFields unitAddFields, AdditionalFields rangeAddFields, AdditionalFields streetAddFields, Locale locale) {
        if (origformat == null) {
            return null;
        }
        boolean usePoBoxFormat = Boolean.valueOf((String)scoringAddr.getAdditionalInfo("POBOX_MATCH_IN_PROGRESS"));
        String[] format = formatName.equals(SET_FORMATTED_STREET) && usePoBoxFormat && this.m_poBoxFormat != null && this.m_poBoxFormat.length > 1 ? this.m_poBoxFormat : origformat;
        StringBuilder builder = new StringBuilder();
        String processed = null;
        String prev = null;
        String lastAppended = "";
        StringBuilder rightAssochelper = new StringBuilder();
        int[] remChars = null;
        ArrayList<int[]> possibleRemChars = new ArrayList<int[]>();
        char lastDownStreamMeta = '\u0000';
        char metaQuestion = '?';
        char metaPercent = '%';
        char metaAsteric = '*';
        char metaInvertedV = '^';
        char metaPlus = '+';
        int metaParent = 40;
        char metaAddFirstOnly = '!';
        String metaCharStart = "{";
        String metaCharEnd = "}";
        String lastSignificantWord = null;
        boolean lastSingnificant = false;
        boolean bInAddFirstOnly = false;
        boolean bFirstAdded = false;
        boolean bAddNextToken = true;
        IDictionaryMetaData metaData = scoringAddr.getDataSetInfo().getMetaData();
        if (this.m_isLeftAssociativity) {
            for (String t : format) {
                FieldType fieldType = this.getFieldForName(t, metaData);
                if (fieldType == null && !this.containsAdditionalFieldIndicator(t)) {
                    processed = t;
                } else {
                    processed = this.getField(candAddr, scoringAddr, fieldType, t, unitAddFields, rangeAddFields, streetAddFields, locale);
                    if (processed.length() == 0 && lastDownStreamMeta == metaPercent) {
                        builder.delete(builder.length() - lastAppended.length(), builder.length());
                        lastDownStreamMeta = '\u0000';
                    } else if (lastDownStreamMeta == metaInvertedV && processed.length() == 0) {
                        remChars = new int[]{builder.lastIndexOf(lastAppended), remChars[0] + lastAppended.length()};
                        this.addToPossibleDeleteChars(possibleRemChars, remChars);
                    } else if (lastDownStreamMeta == metaPercent && processed.length() > 0) {
                        lastDownStreamMeta = '\u0000';
                    } else if (lastDownStreamMeta == metaInvertedV && processed.length() > 0) {
                        if (possibleRemChars.size() > 0) {
                            possibleRemChars = new ArrayList();
                        }
                        lastDownStreamMeta = '\u0000';
                    }
                }
                if (processed.length() == 0) {
                    if (bInAddFirstOnly) continue;
                    prev = processed;
                    continue;
                }
                if (processed.startsWith(metaCharStart) && processed.endsWith(metaCharEnd)) {
                    bInAddFirstOnly = false;
                    bAddNextToken = true;
                    if (prev == null) {
                        prev = "";
                    }
                    if (lastSingnificant) {
                        lastSingnificant = false;
                        continue;
                    }
                    int metaNdx = processed.indexOf(metaParent);
                    char meta = '\u0000';
                    char secondaryMeta = '\u0000';
                    if (metaNdx > 0) {
                        meta = processed.charAt(metaNdx + 1);
                        secondaryMeta = processed.charAt(metaNdx + 2);
                        if (meta == metaQuestion && prev.length() > 0 || meta == metaAsteric && builder.length() > 0 || meta == metaPlus) {
                            if (secondaryMeta == metaInvertedV && meta != metaPlus) {
                                lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                                builder.append(lastAppended);
                                lastDownStreamMeta = secondaryMeta;
                                continue;
                            }
                            if (secondaryMeta == metaPercent && meta != metaPlus) {
                                lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                                builder.append(lastAppended);
                                lastDownStreamMeta = secondaryMeta;
                                continue;
                            }
                            builder.append(processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx));
                            continue;
                        }
                        if (meta == metaInvertedV) {
                            lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                            builder.append(lastAppended);
                            lastDownStreamMeta = meta;
                            continue;
                        }
                        if (meta == metaPercent) {
                            lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                            builder.append(lastAppended);
                            lastDownStreamMeta = meta;
                            continue;
                        }
                        if (meta != metaAddFirstOnly) continue;
                        bInAddFirstOnly = true;
                        bFirstAdded = false;
                        continue;
                    }
                    builder.append(processed.substring(1, processed.length() - 1));
                    continue;
                }
                if (this.containsAdditionalFieldIndicator(processed) || !bAddNextToken) continue;
                if (bInAddFirstOnly && !bFirstAdded) {
                    bFirstAdded = true;
                    bAddNextToken = false;
                }
                if (this.shouldRemoveSuccessiveAreaName(formatName, processed, lastSignificantWord)) {
                    prev = processed;
                    lastSingnificant = true;
                    continue;
                }
                lastSignificantWord = processed;
                builder.append(processed);
                prev = processed;
            }
            if (possibleRemChars.size() > 0) {
                rightAssochelper.delete(0, rightAssochelper.length());
                int lastNdx = 0;
                for (int[] elem : possibleRemChars) {
                    rightAssochelper.append(builder.substring(lastNdx, elem[0]));
                    lastNdx = elem[1];
                }
                builder.delete(0, builder.length());
                builder.append(rightAssochelper.toString());
            }
        } else {
            for (int i = format.length - 1; i >= 0; --i) {
                FieldType fieldType = metaData.getFieldForName(format[i]);
                if (fieldType == null && !format[i].startsWith(ADITIONAL_FIELD)) {
                    processed = format[i];
                } else {
                    processed = this.getField(candAddr, scoringAddr, fieldType, format[i], unitAddFields, rangeAddFields, streetAddFields, locale);
                    if (processed.length() == 0 && lastDownStreamMeta == metaPercent) {
                        builder.delete(0, lastAppended.length());
                        lastDownStreamMeta = '\u0000';
                    } else if (lastDownStreamMeta == metaInvertedV && processed.length() == 0) {
                        builder.reverse();
                        rightAssochelper.delete(0, rightAssochelper.length()).append(lastAppended).reverse();
                        String temp = rightAssochelper.toString();
                        remChars = new int[]{builder.lastIndexOf(temp), remChars[0] + lastAppended.length()};
                        this.addToPossibleDeleteChars(possibleRemChars, remChars);
                        builder.reverse();
                    } else if (lastDownStreamMeta == metaPercent && processed.length() > 0) {
                        lastDownStreamMeta = '\u0000';
                    } else if (lastDownStreamMeta == metaInvertedV && processed.length() > 0) {
                        if (possibleRemChars.size() > 0) {
                            possibleRemChars = new ArrayList();
                        }
                        lastDownStreamMeta = '\u0000';
                    }
                }
                if (processed.length() == 0) {
                    if (bInAddFirstOnly) continue;
                    prev = processed;
                    continue;
                }
                if (processed.startsWith(metaCharStart) && processed.endsWith(metaCharEnd)) {
                    bInAddFirstOnly = false;
                    bAddNextToken = true;
                    if (prev == null) {
                        prev = "";
                    }
                    if (lastSingnificant) {
                        lastSingnificant = false;
                        continue;
                    }
                    int metaNdx = processed.indexOf(metaParent);
                    char meta = '\u0000';
                    char secondaryMeta = '\u0000';
                    if (metaNdx > 0) {
                        meta = processed.charAt(metaNdx + 1);
                        secondaryMeta = processed.charAt(metaNdx + 2);
                        if (meta == metaQuestion && prev.length() > 0 || meta == metaAsteric && builder.length() > 0 || meta == metaPlus) {
                            if (secondaryMeta == metaInvertedV && meta != metaPlus) {
                                lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                                builder.insert(0, lastAppended);
                                lastDownStreamMeta = secondaryMeta;
                                continue;
                            }
                            if (secondaryMeta == metaPercent && meta != metaPlus) {
                                lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                                builder.insert(0, lastAppended);
                                lastDownStreamMeta = secondaryMeta;
                                continue;
                            }
                            builder.insert(0, processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx));
                            continue;
                        }
                        if (meta == metaInvertedV) {
                            lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                            builder.insert(0, lastAppended);
                            lastDownStreamMeta = meta;
                            continue;
                        }
                        if (meta == metaPercent) {
                            lastAppended = processed.substring(processed.indexOf(metaCharStart) + 1, metaNdx);
                            builder.insert(0, lastAppended);
                            lastDownStreamMeta = meta;
                            continue;
                        }
                        if (meta != metaAddFirstOnly) continue;
                        bInAddFirstOnly = true;
                        bFirstAdded = false;
                        continue;
                    }
                    builder.append(processed.substring(1, processed.length() - 1));
                    continue;
                }
                if (!bAddNextToken) continue;
                if (bInAddFirstOnly && !bFirstAdded) {
                    bFirstAdded = true;
                    bAddNextToken = false;
                }
                if (this.shouldRemoveSuccessiveAreaName(formatName, processed, lastSignificantWord)) {
                    prev = processed;
                    continue;
                }
                lastSignificantWord = processed;
                builder.insert(0, processed);
                prev = processed;
            }
            if (possibleRemChars.size() > 0) {
                builder.reverse();
                rightAssochelper.delete(0, rightAssochelper.length());
                int lastNdx = 0;
                for (int[] elem : possibleRemChars) {
                    rightAssochelper.append(builder.substring(lastNdx, elem[0]));
                    lastNdx = elem[1];
                }
                if (lastNdx > builder.length()) {
                    rightAssochelper.append(builder.substring(lastNdx));
                }
                rightAssochelper.reverse();
                builder.delete(0, builder.length());
                builder.append(rightAssochelper.toString());
            }
        }
        boolean isThoroughfareDelimited = Boolean.parseBoolean(metaData.getAdditionalInfo(KEY_THOROUGHFARETYPE_NON_DELIMITED));
        if (SET_FORMATTED_STREET.equalsIgnoreCase(formatName) && isThoroughfareDelimited) {
            return this.setFormatForNonDelimitedThoroughfare(candAddr, builder.toString().trim());
        }
        return builder.toString().trim();
    }

    private FieldType getFieldForName(String name, IDictionaryMetaData metaData) {
        return this.containsAdditionalFieldIndicator(name) ? metaData.getFieldForName(name.substring(ADITIONAL_FIELD.length())) : metaData.getFieldForName(name);
    }

    private boolean containsAdditionalFieldIndicator(String str) {
        return str.startsWith(ADITIONAL_FIELD);
    }

    private boolean shouldRemoveSuccessiveAreaName(String formatName, String processed, String lastSignificantWord) {
        return this.m_removeSuccessiveAreaName && SET_FORMATTED_LOCATION.equalsIgnoreCase(formatName) && lastSignificantWord != null && lastSignificantWord.equalsIgnoreCase(processed);
    }

    public void setFields(CandidateAddress candAddr, Map<String, String> keyFieldsMap) {
        if (keyFieldsMap == null) {
            return;
        }
        Iterator<String> itr = keyFieldsMap.keySet().iterator();
        String key = null;
        String value = null;
        while (itr.hasNext()) {
            key = itr.next();
            value = keyFieldsMap.get(key);
            this.setField(candAddr, key, value);
        }
    }

    private InternalFieldValue getInternalFieldValue(InternalScoringAddress addr, FieldType fieldType) {
        FieldType.FieldLevel level = fieldType.getLevel();
        switch (level) {
            case LEVEL_STREET: 
            case LEVEL_POSTAL: {
                return (InternalFieldValue)addr.getField(fieldType);
            }
            case LEVEL_RANGE: {
                if (addr.getRangeCount() > 0 && !addr.getIgnoreRangeLevel()) {
                    return (InternalFieldValue)addr.getRangeAt(0).getField(fieldType);
                }
            }
            case LEVEL_UNIT: {
                InternalScoringRange range;
                if (addr.getRangeCount() <= 0 || (range = addr.getRangeAt(0)).getUnitCount() <= 0) break;
                return (InternalFieldValue)range.getUnitAt(0).getField(fieldType);
            }
        }
        return null;
    }

    protected String getField(CandidateAddress candAddr, InternalScoringAddress scoringAddr, FieldType fieldType, String fieldName, AdditionalFields unitAddFields, AdditionalFields rangeAddFields, AdditionalFields streetAddFields, Locale locale) {
        String value = null;
        if (fieldType != null) {
            if (fieldType == FieldType.ADDRESS_NUMBER_FIELD_TYPE) {
                value = candAddr.getAddressNumber();
            } else if (fieldType == FieldType.STREET_NAME_FIELD_TYPE) {
                value = candAddr.getMainAddress();
            } else if (fieldType == FieldType.PRE_THOROUGHFARE_FIELD_TYPE) {
                value = candAddr.getPreThoroughfareType();
            } else if (fieldType == FieldType.POST_THOROUGHFARE_FIELD_TYPE) {
                value = candAddr.getPostThoroughfareType();
            } else if (fieldType == FieldType.PRE_DIRECTIONAL_FIELD_TYPE) {
                value = candAddr.getPreDirectional();
            } else if (fieldType == FieldType.POST_DIRECTIONAL_FIELD_TYPE) {
                value = candAddr.getPostDirectional();
            } else if (fieldType == FieldType.PRE_ADDRESS_FIELD_TYPE) {
                value = candAddr.getPreAddress();
            } else if (fieldType == FieldType.POST_ADDRESS_FIELD_TYPE) {
                value = candAddr.getPostAddress();
            } else if (fieldType == FieldType.COUNTRY_FIELD_TYPE) {
                value = candAddr.getCountry();
            } else if (fieldType != null) {
                InternalFieldValue fv = this.getInternalFieldValue(scoringAddr, fieldType);
                AddressWord[] words = fv == null ? null : this.getFieldValue(fv, scoringAddr.getFieldScore(fieldType), "alt_" + fieldType.getName());
                value = words != null ? this.m_parser.reconstructFieldValue(words) : null;
            }
        } else if (this.containsAdditionalFieldIndicator(fieldName) && "HistoricalPostCode".equals(fieldName = fieldName.substring(ADITIONAL_FIELD.length()))) {
            value = this.getHistoricalPostCodeAdditionalFieldValue(scoringAddr);
        }
        if (value != null) {
            value = this.formatCandidateCase(value, locale);
        } else if (fieldType != null && !FieldType.isPredefinedType(fieldType)) {
            value = this.getAdditionalFieldValue(fieldType, unitAddFields, rangeAddFields, streetAddFields);
        }
        return value != null ? value : "";
    }

    private String getHistoricalPostCodeAdditionalFieldValue(InternalScoringAddress scoringAddress) {
        InternalFieldValue fv = (InternalFieldValue)scoringAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        FieldScore fs = scoringAddress.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        int altValNdx = fs == null ? -1 : fs.m_matchedAltIndex;
        AddressWord[] words = fv == null || altValNdx < 0 ? null : ((AddressWord[][])fv.getAlternateValues())[altValNdx];
        return this.m_parser.reconstructFieldValue(words);
    }

    private String getAdditionalFieldValue(FieldType type, AdditionalFields unitFields, AdditionalFields rangeFields, AdditionalFields streetFields) {
        Map<FieldType, String> addFields = null;
        switch (type.getLevel()) {
            case LEVEL_UNIT: {
                addFields = unitFields == null ? null : unitFields.getAdditionalFields();
                break;
            }
            case LEVEL_RANGE: {
                addFields = rangeFields == null ? null : rangeFields.getAdditionalFields();
                break;
            }
            case LEVEL_STREET: 
            case LEVEL_POSTAL: {
                addFields = streetFields == null ? null : streetFields.getAdditionalFields();
            }
        }
        return addFields == null ? null : addFields.get(type);
    }

    private String[] parseFormatString(String format) {
        String[] parsed = null;
        if (format != null && format.trim().length() > 0) {
            parsed = format.split("\\[|\\]");
        }
        return parsed;
    }

    private Locale getLocale(InternalScoringAddress scoringAddr) {
        Locale locale = null;
        String lang = scoringAddr.getDataSetInfo().getMetaData().getLanguage();
        if (lang != null) {
            locale = new Locale(lang);
        }
        return locale;
    }

    public Map<String, String> applyFieldMappings(CandidateAddress candAddr, InternalScoringAddress scoringAddr, AdditionalFields unit, AdditionalFields range, AdditionalFields street) {
        HashMap<String, String> candKeysAndValues = null;
        if (this.m_fieldMappings.size() > 0) {
            candKeysAndValues = new HashMap<String, String>();
            Locale locale = this.getLocale(scoringAddr);
            String value = null;
            String[] format = null;
            for (String t : this.m_fieldMappings) {
                format = (String[])this.m_props.get(t);
                if (t.equalsIgnoreCase(SET_ADDITIONAL_FIELD)) {
                    String[] temp = new String[1];
                    for (String add : format) {
                        if (add.length() == 0) continue;
                        temp[0] = add;
                        value = this.applyFormat(candAddr, scoringAddr, t, temp, unit, range, street, locale);
                        if (value.length() <= 0) continue;
                        candKeysAndValues.put(add, value);
                    }
                    continue;
                }
                value = this.applyFormat(candAddr, scoringAddr, t, format, unit, range, street, locale);
                candKeysAndValues.put(t, value);
            }
        }
        return candKeysAndValues;
    }

    private void setField(CandidateAddress candAddr, String fieldKey, String value) {
        if (fieldKey.equalsIgnoreCase(SET_ADDRESS_NUMBER)) {
            candAddr.setAddressNumber(value);
        } else if (fieldKey.equalsIgnoreCase(SET_MAIN_ADDRESS)) {
            candAddr.setMainAddress(value);
        } else if (fieldKey.equalsIgnoreCase(SET_PRE_THOROUGHFARE)) {
            candAddr.setPreThoroughfareType(value);
        } else if (fieldKey.equalsIgnoreCase(SET_POST_THOROUGHFARE)) {
            candAddr.setPostThoroughfareType(value);
        } else if (fieldKey.equalsIgnoreCase(SET_PRE_DIRECTIONAL)) {
            candAddr.setPreDirectional(value);
        } else if (fieldKey.equalsIgnoreCase(SET_POST_DIRECTIONAL)) {
            candAddr.setPostDirectional(value);
        } else if (fieldKey.equalsIgnoreCase(SET_PRE_ADDRESS)) {
            candAddr.setPreAddress(value);
        } else if (fieldKey.equalsIgnoreCase(SET_POST_ADDRESS)) {
            candAddr.setPostAddress(value);
        } else if (fieldKey.equalsIgnoreCase(SET_PLACE_NAME)) {
            candAddr.setPlaceName(value);
        } else if (fieldKey.equalsIgnoreCase(SET_POST_CODE)) {
            candAddr.setPostCode1(value);
        } else if (fieldKey.equalsIgnoreCase(SET_AREA_NAME_1)) {
            candAddr.setAreaName1(value);
        } else if (fieldKey.equalsIgnoreCase(SET_AREA_NAME_2)) {
            candAddr.setAreaName2(value);
        } else if (fieldKey.equalsIgnoreCase(SET_AREA_NAME_3)) {
            candAddr.setAreaName3(value);
        } else if (fieldKey.equalsIgnoreCase(SET_AREA_NAME_4)) {
            candAddr.setAreaName4(value);
        } else if (fieldKey.equalsIgnoreCase(SET_GENERIC_FIELD_1)) {
            candAddr.setGenericField1(value);
        } else if (fieldKey.equalsIgnoreCase(SET_GENERIC_FIELD_2)) {
            candAddr.setGenericField2(value);
        } else if (fieldKey.equalsIgnoreCase(SET_GENERIC_FIELD_3)) {
            candAddr.setGenericField3(value);
        } else if (fieldKey.equalsIgnoreCase(SET_GENERIC_FIELD_4)) {
            candAddr.setGenericField4(value);
        } else if (fieldKey.equalsIgnoreCase(SET_FORMATTED_STREET)) {
            candAddr.setFormattedStreetAddress(value);
        } else if (fieldKey.equalsIgnoreCase(SET_FORMATTED_LOCATION)) {
            candAddr.setFormattedLocationAddress(value);
        } else if (fieldKey.startsWith(ADITIONAL_FIELD)) {
            candAddr.addKeyValueToAdditionalFields(fieldKey.substring(ADITIONAL_FIELD.length()), value);
        } else if (candAddr.fromUserDictionary()) {
            candAddr.addKeyValueToAdditionalFields(fieldKey, value);
        }
    }

    public boolean getAlternateProperty(String key) {
        String found = this.m_props.getProperty(key, "true");
        if (!(found = found.trim()).equalsIgnoreCase("true") && !found.equalsIgnoreCase("false")) {
            return true;
        }
        return found.equals("true");
    }

    private AddressWord[] getFieldValue(InternalFieldValue fieldValue, FieldScore score, String typeKey) {
        if (fieldValue != null) {
            AddressWord[] fieldWords = null;
            if (score != null) {
                int altValNdx = -1;
                fieldWords = fieldValue.hasAlternates() && (altValNdx = score.m_matchedAltIndex) > -1 && this.getAlternateProperty(typeKey) ? ((AddressWord[][])fieldValue.getAlternateValues())[altValNdx] : (AddressWord[])fieldValue.getFieldValue();
            } else {
                fieldWords = (AddressWord[])fieldValue.getFieldValue();
            }
            return fieldWords;
        }
        return null;
    }

    private boolean isDefault() {
        return this.m_isDefault;
    }

    private void setDefault() {
        this.m_isDefault = true;
    }

    public boolean isHNRSuffixToBeAppended() {
        return this.m_ishnrToBeappended;
    }

    private String formatCandidateCase(String string, Locale locale) {
        String formatedValue = null;
        switch (this.m_casing) {
            case 1: {
                formatedValue = this.getUpperCase(string, locale);
                break;
            }
            case 2: {
                formatedValue = this.getLowerCase(string, locale);
                break;
            }
            case 3: {
                formatedValue = this.getTitleCase(string, locale);
                break;
            }
            default: {
                formatedValue = string;
            }
        }
        return formatedValue;
    }

    private String getUpperCase(String string, Locale locale) {
        if (string != null) {
            return locale != null ? string.toUpperCase(locale) : string.toUpperCase();
        }
        return null;
    }

    private String getLowerCase(String string, Locale locale) {
        if (string != null) {
            return locale != null ? string.toLowerCase(locale) : string.toLowerCase();
        }
        return null;
    }

    private String getTitleCase(String string, Locale locale) {
        if (string != null) {
            StringBuilder builder = new StringBuilder("");
            String delimiters = " .-\t\n\r\f";
            string = this.getLowerCase(string, locale);
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters, true);
            while (tokenizer.hasMoreElements()) {
                String temp = tokenizer.nextToken();
                builder.append(temp.substring(0, 1).toUpperCase());
                if (temp.length() <= 1) continue;
                builder.append(temp.substring(1));
            }
            return builder.toString();
        }
        return null;
    }

    private String setFormatForNonDelimitedThoroughfare(CandidateAddress candAddr, String fmtStreet) {
        String post_thoroughfare = candAddr.getPostThoroughfareType();
        String pre_thoroughfare = candAddr.getPreThoroughfareType();
        if (!StringUtilities.isEmpty((String)fmtStreet) && !StringUtilities.isEmpty((String)post_thoroughfare)) {
            fmtStreet = fmtStreet.replace(" " + post_thoroughfare, post_thoroughfare);
            candAddr.setPostThoroughfareType(post_thoroughfare.trim());
        }
        if (!StringUtilities.isEmpty((String)fmtStreet) && !StringUtilities.isEmpty((String)pre_thoroughfare)) {
            fmtStreet = fmtStreet.replace(pre_thoroughfare, pre_thoroughfare.trim());
            pre_thoroughfare = pre_thoroughfare.trim();
            candAddr.setPreThoroughfareType(pre_thoroughfare);
        }
        return fmtStreet;
    }

    protected boolean getS3ForPointData() {
        return this.m_s3WithPointData;
    }

    protected void setS3ForPointData(boolean flag) {
        this.m_s3WithPointData = flag;
    }
}

