/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.AddressDictionary;
import com.mapinfo.mapmarker.cgge.dp.AddressHandle;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataVersionInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.ISAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.SAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.SAFileIndexEntryCompact;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AddressTableLookup {
    private RandomAccessFile m_mainAddressFile;
    private Map<Integer, ISAFileIndexEntry> m_indexEntryMap;
    private final DataVersionInfo m_dataVersionInfo;
    private final IDictionaryMetaData m_metaData;

    AddressTableLookup(DataVersionInfo dataVersionInfo, IDictionaryMetaData metaData) {
        this.m_dataVersionInfo = dataVersionInfo;
        this.m_metaData = metaData;
    }

    public static AddressTableLookup getInstance(String fileName) throws Exception {
        ICGGEDataStream s = DataStreamFactory.getDataStream(fileName);
        DataVersionInfo dataVersionInfo = new DataVersionInfo();
        dataVersionInfo.read(s);
        DictionaryMetaData metaData = new DictionaryMetaData();
        metaData.read(s);
        AddressTableLookup addressTableLookup = null;
        addressTableLookup = new AddressTableLookup(dataVersionInfo, metaData);
        addressTableLookup.loadAddressIndexes(s);
        return addressTableLookup;
    }

    void setIndexEntries(Map<Integer, ISAFileIndexEntry> indexMap) {
        this.m_indexEntryMap = indexMap;
    }

    void loadAddressIndexes(ICGGEDataStream in) throws DataFetchException {
        try {
            long nSize = in.readLong();
            this.m_indexEntryMap = new HashMap<Integer, ISAFileIndexEntry>((int)nSize);
            int i = 0;
            while ((long)i < nSize) {
                SAFileIndexEntry tempEntry = new SAFileIndexEntry();
                tempEntry.read(in);
                IntArray sacs = tempEntry.getSacs();
                int sacSize = sacs.size();
                SAFileIndexEntryCompact compactEntry = null;
                if (SAFileIndexEntryCompact.canBeCompacted(tempEntry)) {
                    compactEntry = SAFileIndexEntryCompact.getInstance(tempEntry);
                }
                for (int j = 0; j < sacSize; ++j) {
                    this.m_indexEntryMap.put(new Integer(sacs.get(j)), compactEntry == null ? tempEntry : compactEntry);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new DataFetchException(e);
        }
    }

    public boolean loadMainAddressTable(String fileName) throws Exception {
        this.m_mainAddressFile = new RandomAccessFile(fileName, "r");
        return true;
    }

    public AddressHandle getAddressHandleForSAC(int sac, AddressDictionary addressDictionary) throws CGGEInternalException {
        ISAFileIndexEntry indexEntry = this.m_indexEntryMap.get(sac);
        AddressHandle addressHandle = null;
        if (indexEntry != null) {
            addressHandle = new AddressHandle(indexEntry, this.m_metaData);
            addressHandle.setAddressDictionary(addressDictionary);
            addressHandle.read(this.m_mainAddressFile);
        }
        return addressHandle;
    }

    public final IDictionaryMetaData getMetaData() {
        return this.m_metaData;
    }

    public DataVersionInfo getDataVersionInfo() {
        return this.m_dataVersionInfo;
    }

    public Collection<Integer> getSacs() {
        return this.m_indexEntryMap.keySet();
    }

    ISAFileIndexEntry getSAFileIndexEntry(int sac) {
        return this.m_indexEntryMap.get(sac);
    }
}

