/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.reverseGeocode.CGGEInternalReverseGeocodeCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CGGEReverseGeocodeDataManager
implements IReverseGeocodeDataManager {
    private IDataManager m_dataManager;

    public CGGEReverseGeocodeDataManager(IDataManager cggeDataManager) {
        this.m_dataManager = cggeDataManager;
    }

    public IRetrievedCandidates retrieveReverseGeocodeCandidates(ReverseGeocodeLocation location, IConstraints constraints) throws DataAccessRuntimeException {
        GeocodeOptions options = new GeocodeOptions(constraints);
        DirectPosition position = CoordConvertor.transformPointToWGS84((CoordSys)location.getCoordSysObject(), (DirectPosition)location.getPositionPoint());
        if (position.getX() < -180.0 || position.getX() > 180.0 || position.getY() < -90.0 || position.getY() > 90.0) {
            return new CoreRetrievedCandidates(new ArrayList());
        }
        ArrayList<CGGEInternalReverseGeocodeCandidate> internalCandidateAddress = new ArrayList<CGGEInternalReverseGeocodeCandidate>();
        try {
            List<InternalStreetAddress> streetAddress = this.m_dataManager.retrieveReverseGeocodeCandidates(0, position, location.getDistanceAsLength(), options);
            for (InternalStreetAddress internalStreetAddress : streetAddress) {
                DictionaryUsage du = options.getDictionaryUsageForDictionary(internalStreetAddress.getDictionaryNumber());
                int userPriority = du != null ? du.getSearchOrder() : internalStreetAddress.getDictionaryNumber();
                internalCandidateAddress.add(new CGGEInternalReverseGeocodeCandidate(internalStreetAddress, options, this.m_dataManager, userPriority));
            }
        }
        catch (CGGEInternalException e) {
            throw new DataAccessRuntimeException(new DataAccessException(2102, (Object[])new String[]{"CGGE internal exception caused " + e.getMessage()}, (Throwable)e));
        }
        Collections.sort(internalCandidateAddress, new CGGEInternalReverseGeocodeCandidate.ReverseGeococodeCandidateComparator());
        return new CoreRetrievedCandidates(internalCandidateAddress);
    }
}

