/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.IOUtil;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataAddressWordsIOHandler {
    public static void writeAddressWords(Address<InternalFieldValue> addr, DataOutput out) throws IOException, DataCreationException {
        AddressWord addrWord;
        int i;
        int size;
        List<AddressWord> addrWordList = DataAddressWordsIOHandler.getAddressMainWords(addr);
        int n = size = addrWordList == null ? 0 : addrWordList.size();
        if (size > 256) {
            throw new DataCreationException("An address object can have only a maximum of 256 words from all the fields");
        }
        out.writeByte(size);
        for (i = 0; i < size; ++i) {
            addrWord = addrWordList.get(i);
            try {
                int fieldKey = addrWord.m_wordType.getKey();
                out.writeByte(fieldKey);
                short ndx = ((Integer)addrWord.getData()).shortValue();
                out.writeShort(ndx);
                out.writeByte(addrWord.m_weight);
                continue;
            }
            catch (NullPointerException ne) {
                throw new DataCreationException("Writer expects AddressWord object containing a Integer offset but got null", ne);
            }
            catch (ClassCastException ce) {
                throw new DataCreationException("Writer expects AddressWord object data to be of type Integer, but got a different type", ce);
            }
        }
        addrWordList = DataAddressWordsIOHandler.getAddressAltWords(addr);
        int n2 = size = addrWordList == null ? 0 : addrWordList.size();
        if (size > 256) {
            throw new DataCreationException("An address object can have only a maximum of 256 words from all the fields");
        }
        out.writeByte(size);
        for (i = 0; i < size; ++i) {
            addrWord = addrWordList.get(i);
            if (addrWord != null) {
                try {
                    short ndx = ((Integer)addrWord.getData()).shortValue();
                    int fieldKey = addrWord.m_wordType.getKey();
                    out.writeByte(fieldKey);
                    out.writeShort(ndx);
                    out.writeByte(addrWord.m_weight);
                    continue;
                }
                catch (NullPointerException ne) {
                    throw new DataCreationException("Writer expects AddressWord object containing a Integer offset but got null", ne);
                }
                catch (ClassCastException ce) {
                    throw new DataCreationException("Writer expects AddressWord object data to be of type Integer, but got a different type", ce);
                }
            }
            out.writeByte(FieldType.UNKNOWN_FIELD_TYPE.getKey());
        }
    }

    public static void readAddressWords(Address<InternalFieldValue> addr, ICGGEDataInput in, IDictionaryMetaData metaData) throws IOException {
        int size = IOUtil.readUnsignedByte(in);
        ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(10);
        FieldType prevType = FieldType.UNKNOWN_FIELD_TYPE;
        for (int i = 0; i < size; ++i) {
            AddressWord addrWord = new AddressWord((String)null);
            int fieldkey = IOUtil.readUnsignedByte(in);
            FieldType type = metaData.getFieldType(fieldkey);
            int ndx = IOUtil.readUnsignedShort(in);
            addrWord.setData(ndx);
            addrWord.m_weight = in.readByte();
            addrWord.m_wordType = type;
            if (prevType != FieldType.UNKNOWN_FIELD_TYPE && !DataAddressWordsIOHandler.isSameField(prevType, type)) {
                InternalFieldValue fieldvalue = new InternalFieldValue(addrWordList.toArray(new AddressWord[addrWordList.size()]));
                addr.setField(prevType, fieldvalue);
                addrWordList.clear();
            }
            addrWordList.add(addrWord);
            prevType = DataAddressWordsIOHandler.isSameField(FieldType.STREET_NAME_FIELD_TYPE, type) ? FieldType.STREET_NAME_FIELD_TYPE : type;
        }
        if (prevType != FieldType.UNKNOWN_FIELD_TYPE && addrWordList.size() > 0) {
            InternalFieldValue fieldvalue = new InternalFieldValue(addrWordList.toArray(new AddressWord[addrWordList.size()]));
            addr.setField(prevType, fieldvalue);
        }
        size = IOUtil.readUnsignedByte(in);
        ArrayList<AddressWord[]> wordList = new ArrayList<AddressWord[]>(10);
        prevType = FieldType.UNKNOWN_FIELD_TYPE;
        addrWordList.clear();
        for (int i = 0; i < size; ++i) {
            AddressWord addrWord = new AddressWord((String)null);
            int fieldkey = IOUtil.readUnsignedByte(in);
            if (fieldkey != FieldType.UNKNOWN_FIELD_TYPE.getKey()) {
                FieldType type = metaData.getFieldType(fieldkey);
                int ndx = IOUtil.readUnsignedShort(in);
                addrWord.setData(ndx);
                addrWord.m_weight = in.readByte();
                addrWord.m_wordType = type;
                if (prevType != FieldType.UNKNOWN_FIELD_TYPE && !DataAddressWordsIOHandler.isSameField(prevType, type)) {
                    InternalFieldValue fieldValue = addr.getField(prevType);
                    if (fieldValue == null) {
                        fieldValue = new InternalFieldValue(null);
                        addr.setField(prevType, fieldValue);
                    }
                    fieldValue.setAlternateValues(wordList.toArray((T[])new AddressWord[wordList.size()][]));
                    wordList.clear();
                }
                addrWordList.add(addrWord);
                if (DataAddressWordsIOHandler.isSameField(FieldType.STREET_NAME_FIELD_TYPE, type)) {
                    prevType = FieldType.STREET_NAME_FIELD_TYPE;
                    continue;
                }
                prevType = type;
                continue;
            }
            if (prevType == FieldType.UNKNOWN_FIELD_TYPE) continue;
            wordList.add(addrWordList.toArray(new AddressWord[addrWordList.size()]));
            addrWordList.clear();
        }
        if (prevType != FieldType.UNKNOWN_FIELD_TYPE && addrWordList.size() > 0) {
            InternalFieldValue fieldValue = addr.getField(prevType);
            if (fieldValue == null) {
                fieldValue = new InternalFieldValue(null);
                addr.setField(prevType, fieldValue);
            }
            if (addrWordList.size() > 0) {
                wordList.add(addrWordList.toArray(new AddressWord[addrWordList.size()]));
            }
            fieldValue.setAlternateValues(wordList.toArray((T[])new AddressWord[wordList.size()][]));
        }
    }

    private static List<AddressWord> getAddressMainWords(Address<InternalFieldValue> addr) {
        Map<FieldType, InternalFieldValue> fieldMap = addr.getFields();
        ArrayList<AddressWord> retList = null;
        if (fieldMap != null) {
            for (InternalFieldValue fieldValue : fieldMap.values()) {
                AddressWord[] words;
                if (fieldValue == null || (words = (AddressWord[])fieldValue.getFieldValue()) == null) continue;
                if (retList == null) {
                    retList = new ArrayList<AddressWord>(10);
                }
                for (int i = 0; i < words.length; ++i) {
                    retList.add(words[i]);
                }
            }
        }
        return retList;
    }

    private static List<AddressWord> getAddressAltWords(Address<InternalFieldValue> addr) {
        Map<FieldType, InternalFieldValue> fieldMap = addr.getFields();
        ArrayList<AddressWord> retList = null;
        if (fieldMap != null) {
            for (InternalFieldValue fieldValue : fieldMap.values()) {
                if (fieldValue == null) continue;
                AddressWord[][] altValues = (AddressWord[][])fieldValue.getAlternateValues();
                int altCount = altValues == null ? 0 : altValues.length;
                for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                    AddressWord[] words = altValues[altNdx];
                    if (words == null) continue;
                    if (retList == null) {
                        retList = new ArrayList<AddressWord>(10);
                    }
                    for (int i = 0; i < words.length; ++i) {
                        retList.add(words[i]);
                    }
                    retList.add(null);
                }
            }
            if (retList != null && retList.size() > 0 && retList.get(retList.size() - 1) == null) {
                retList.remove(retList.size() - 1);
            }
        }
        return retList;
    }

    private static boolean isSameField(FieldType type1, FieldType type2) {
        if (type1 != type2) {
            if (type1 == FieldType.STREET_NAME_FIELD_TYPE || type1 == FieldType.PRE_DIRECTIONAL_FIELD_TYPE || type1 == FieldType.PRE_THOROUGHFARE_FIELD_TYPE || type1 == FieldType.POST_THOROUGHFARE_FIELD_TYPE || type1 == FieldType.PRE_DIRECTIONAL_FIELD_TYPE) {
                return type2 == FieldType.STREET_NAME_FIELD_TYPE || type2 == FieldType.PRE_DIRECTIONAL_FIELD_TYPE || type2 == FieldType.PRE_THOROUGHFARE_FIELD_TYPE || type2 == FieldType.POST_THOROUGHFARE_FIELD_TYPE || type2 == FieldType.PRE_DIRECTIONAL_FIELD_TYPE;
            }
            return false;
        }
        return true;
    }
}

