/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.DictionaryUsage;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.DataDictionary;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSet;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.DictionaryItemUtils;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryItem;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DataManager
implements IDataManager {
    private static final String NO_DICTIONARY_PATH = "exception.no.data.path";
    private String m_country;
    private DataDictionary[] m_dataDictionaries;
    private int m_dictCount;
    private static Map<String, DataManager> m_dataManagers = new HashMap<String, DataManager>(3);
    private static Comparator<IDictionaryItem> m_dictionaryItemComparator = DictionaryItemUtils.getDictionaryItemComparator();

    private DataManager(String country) {
        this.m_country = country;
        this.m_dataDictionaries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataManager getInstance(String country) throws CGGEDataIntializationException {
        DataManager dm = null;
        Map<String, DataManager> map = m_dataManagers;
        synchronized (map) {
            String redirectedCountryCode;
            dm = m_dataManagers.get(country);
            if (dm == null && (dm = m_dataManagers.get(redirectedCountryCode = CGGEHandler.getInstance(null, country, null).getCountry())) == null) {
                dm = new DataManager(redirectedCountryCode);
                dm.initData();
                m_dataManagers.put(redirectedCountryCode, dm);
            }
        }
        return dm;
    }

    @Override
    public DataDictionary getDictionaryAt(int ndx) {
        this.checkDictionaryNumber(ndx + 1);
        return this.m_dataDictionaries[ndx];
    }

    private void initData() throws CGGEDataIntializationException {
        try {
            Properties dataManagerProperties = DataManagerSettingsProvider.getInstance().getSettingsForCountry(this.m_country);
            int dictCount = 1;
            try {
                dictCount = Integer.parseInt(dataManagerProperties.getProperty("DICTIONARY_COUNT"));
                if (dictCount < 1) {
                    dictCount = 1;
                }
            }
            catch (NumberFormatException e) {
                dictCount = 1;
            }
            this.m_dataDictionaries = new DataDictionary[dictCount];
            for (int dictNdx = 0; dictNdx < dictCount; ++dictNdx) {
                int dictNum = dictNdx + 1;
                String path = dataManagerProperties.getProperty("DICTIONARY_PATH" + dictNum);
                if (path == null || path.trim().length() == 0) {
                    throw new CGGEDataIntializationException(NO_DICTIONARY_PATH);
                }
                String dictPath = MMUtils.appendToPath(path, null);
                DataDictionary dictionary = new DataDictionary();
                dictionary.loadDictionary(dictPath, dictNum);
                this.m_dataDictionaries[dictNdx] = dictionary;
            }
            this.m_dictCount = dictCount;
        }
        catch (Exception e) {
            if (e instanceof CGGEDataIntializationException) {
                throw (CGGEDataIntializationException)e;
            }
            throw new CGGEDataIntializationException(e);
        }
    }

    private void checkDictionaryNumber(int dictNum) {
        if (dictNum < 1 || dictNum > this.m_dictCount) {
            throw new CGGERuntimeException("Dictionary Number " + dictNum + " does not exist");
        }
    }

    @Override
    public void resetData() throws CGGEDataIntializationException {
        DataManager dm = new DataManager(this.m_country);
        dm.initData();
        m_dataManagers.put(this.m_country, dm);
    }

    private boolean canSearchDictionary(DataDictionary dictionary, GeocodeOptions options) {
        return dictionary.isUserDictionary() ? options.canUseUserDictionaries() : options.canUseStandardDictionaries();
    }

    private boolean isDictionaryUsed(int dictNum, GeocodeOptions options) {
        DictionaryUsage du = options.getDictionaryUsageForDictionary(dictNum);
        return du == null || du.isUsed();
    }

    private boolean canSearchDictionary(int dictNum, int dictType, GeocodeOptions options) {
        if (!this.isDictionaryUsed(dictNum, options)) {
            return false;
        }
        DataDictionary dataDictionary = this.getDictionary(dictNum);
        if (!this.canSearchDictionary(dataDictionary, options)) {
            return false;
        }
        return dataDictionary.isSupportedType(dictType);
    }

    @Override
    public List<DictionaryAreaTermItem> findAreaTerms(int dictType, AddressWord[] searchWords, FieldType type, double minQuality, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        List<DictionaryAreaTermItem> areaItems = null;
        if (DebugLevel.getDebugLevel((int)3) >= 1) {
            MMJLog.getLog().debug("DataManager::findAreaTerms() searchWords");
            MMJLog.getLog().debug("fieldType: " + type);
            MMJLog.getLog().debug("minQuality: " + minQuality);
            MMJLog.getLog().debug("searchWords:");
            for (AddressWord word : searchWords) {
                MMJLog.getLog().debug("\t" + word.toString());
            }
        }
        for (int dictNum = 1; dictNum <= this.m_dictCount; ++dictNum) {
            List<DictionaryAreaTermItem> dictAreaItems = null;
            boolean canSearchDict = this.canSearchDictionary(dictNum, dictType, options);
            if (!canSearchDict) continue;
            try {
                dictAreaItems = this.getDictionary(dictNum).findAreaTerms(dictType, searchWords, type, minQuality, options);
                if (DebugLevel.getDebugLevel((int)3) >= 2) {
                    boolean bHasItems;
                    boolean bl = bHasItems = dictAreaItems != null;
                    if (bHasItems) {
                        MMJLog.getLog().debug("DataManager::findAreaTerms() areaTerms");
                        for (DictionaryAreaTermItem item : dictAreaItems) {
                            MMJLog.getLog().debug(item.toString());
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new DataFetchException(e);
            }
            if (dictAreaItems == null) continue;
            if (areaItems == null) {
                areaItems = dictAreaItems;
                continue;
            }
            areaItems.addAll(dictAreaItems);
        }
        return areaItems;
    }

    @Override
    public int getDictionaryCount() {
        return this.m_dictCount;
    }

    @Override
    public boolean doesDictionarySupportsGeocodeType(int dictNum, int type) {
        this.checkDictionaryNumber(dictNum);
        return this.getDictionary(dictNum).isSupportedType(type);
    }

    @Override
    public List<DictionaryAreaSacs> getSacsForAreas(int dictType, List<DictionaryAreaTermItem> areas, GeocodeOptions options) throws DataNotInitialisedException {
        if (DebugLevel.getDebugLevel((int)3) >= 3) {
            MMJLog.getLog().debug("DataManager::getSacsForAreas() areas");
            for (DictionaryAreaTermItem word : areas) {
                MMJLog.getLog().debug(word.toString());
            }
        }
        ArrayList<DictionaryAreaSacs> dictionarySacList = null;
        if (areas != null) {
            for (DictionaryAreaTermItem area : areas) {
                int dictNum = area.getDictionaryNumber();
                DictionaryAreaSacs dictAreaSacs = this.getDictionary(dictNum).getSacsForArea(dictType, area, options);
                if (dictAreaSacs == null) continue;
                if (DebugLevel.getDebugLevel((int)3) >= 3) {
                    MMJLog.getLog().debug("DataManager::getSacsForAreas() dictAreaSacs");
                    MMJLog.getLog().debug(dictAreaSacs.toString());
                }
                if (dictionarySacList == null) {
                    dictionarySacList = new ArrayList<DictionaryAreaSacs>(areas.size());
                }
                dictionarySacList.add(dictAreaSacs);
            }
        }
        return dictionarySacList;
    }

    @Override
    public final List<DictionaryAddressWord> findMatchingWords(int dictType, AddressWord word, FieldType type, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException {
        if (DebugLevel.getDebugLevel((int)3) >= 3) {
            MMJLog.getLog().debug("DataManager::findMatchingWords() fieldType: " + type);
            MMJLog.getLog().debug("DataManager::findMatchingWords() minQuality " + minQuality);
            MMJLog.getLog().debug("DataManager::findMatchingWords() word");
            MMJLog.getLog().debug(word.toString());
        }
        List<DictionaryAddressWord> retAddrWordList = null;
        for (int dictNum = 1; dictNum <= this.m_dictCount; ++dictNum) {
            List<DictionaryAddressWord> addrWordList;
            boolean canSearchDict = this.canSearchDictionary(dictNum, dictType, options);
            if (!canSearchDict || (addrWordList = this.getDictionary(dictNum).getMatchingWords(dictType, word, type, minQuality, options)) == null) continue;
            if (DebugLevel.getDebugLevel((int)3) >= 3) {
                MMJLog.getLog().debug("DataManager::findMatchingWords() words");
                for (DictionaryAddressWord wordFound : addrWordList) {
                    MMJLog.getLog().debug(wordFound.toString());
                }
            }
            if (retAddrWordList == null) {
                retAddrWordList = addrWordList;
                continue;
            }
            retAddrWordList.addAll(addrWordList);
        }
        return retAddrWordList;
    }

    private <T extends IDictionaryItem> List<T> filterMatchingItemsFromSortedList(List<T> list, IDictionaryItem t) {
        int n = list.size();
        List<IDictionaryItem> filteredList = null;
        for (int i = 0; i < n; ++i) {
            IDictionaryItem item = (IDictionaryItem)list.get(i);
            int c = m_dictionaryItemComparator.compare(item, t);
            if (c == 0) {
                filteredList = ListUtils.addToList(filteredList, item);
                continue;
            }
            if (c > 0) break;
        }
        return filteredList;
    }

    @Override
    public Collection<InternalScoringAddress> findCandidates(int dataType, List<DictionaryAreaSacs> dictAreaSacsList, List<DictionaryAddressWord> dictAddrWordList, GeocodeOptions options) throws DataFetchException {
        List<InternalScoringAddress> cands = null;
        if (dictAreaSacsList != null && dictAddrWordList != null) {
            int sacItemCount = dictAreaSacsList.size();
            Collections.sort(dictAreaSacsList, m_dictionaryItemComparator);
            Collections.sort(dictAddrWordList, m_dictionaryItemComparator);
            for (int sacItemNdx = 0; sacItemNdx < sacItemCount; ++sacItemNdx) {
                DictionaryAreaSacs areaSacs = dictAreaSacsList.get(sacItemNdx);
                DataSetInfo dataSetInfo = areaSacs.getDataSetInfo();
                List<DictionaryAddressWord> filteredWords = this.filterMatchingItemsFromSortedList(dictAddrWordList, areaSacs);
                if (filteredWords == null) continue;
                IntArray sacArray = new IntArray(10);
                do {
                    DictionaryAreaSacs nextAreaSac;
                    sacArray.add(areaSacs.getAreaSac());
                    DictionaryAreaSacs curAreaSac = areaSacs;
                    areaSacs = null;
                    if (sacItemNdx + 1 >= sacItemCount || m_dictionaryItemComparator.compare(curAreaSac, nextAreaSac = dictAreaSacsList.get(sacItemNdx + 1)) != 0) continue;
                    ++sacItemNdx;
                    areaSacs = nextAreaSac;
                } while (areaSacs != null);
                sacArray.removeDuplicates();
                DataDictionary dataDict = this.getDictionary(dataSetInfo.getDictionaryNumber());
                try {
                    Collection<InternalScoringAddress> curCands = dataDict.findCandidates(dataSetInfo, sacArray.asArray(), filteredWords, options);
                    cands = ListUtils.addToList(cands, curCands);
                    continue;
                }
                catch (CGGEInternalException e) {
                    throw new DataFetchException(e);
                }
                catch (IOException e) {
                    throw new DataFetchException(e);
                }
            }
        }
        return cands;
    }

    @Override
    public final List<DirectPosition> getGeometry(InternalAddress internalAddress) throws DataFetchException {
        DataSetInfo dataSetInfo = internalAddress.getDataSetInfo();
        int dictnum = dataSetInfo.getDictionaryNumber();
        try {
            return this.getDictionary(dictnum).getGeometry(dataSetInfo, internalAddress);
        }
        catch (CGGEInternalException e) {
            throw new DataFetchException(e);
        }
        catch (IOException e) {
            throw new DataFetchException(e);
        }
    }

    @Override
    public AdditionalFields getAdditionalFields(InternalAddress internalAddress) throws DataFetchException {
        DataSetInfo dataSetInfo = internalAddress.getDataSetInfo();
        int dictnum = dataSetInfo.getDictionaryNumber();
        this.checkDictionaryNumber(dictnum);
        try {
            this.getDictionary(dictnum).readAdditionalFields(dataSetInfo, internalAddress);
            return internalAddress.getAdditionalFields();
        }
        catch (CGGEInternalException e) {
            throw new DataFetchException(e);
        }
        catch (IOException e) {
            throw new DataFetchException(e);
        }
    }

    @Override
    public IDictionaryMetaData getMetaData(int dictionaryNumber, int type) throws CGGEInternalException {
        this.checkDictionaryNumber(dictionaryNumber);
        return this.getDictionary(dictionaryNumber).getMetaData(type);
    }

    @Override
    public IDictionaryMetaData getMetaData(DataSetInfo dataSetInfo) throws CGGEInternalException {
        int dictNum = dataSetInfo.getDictionaryNumber();
        this.checkDictionaryNumber(dictNum);
        return this.getDictionary(dictNum).getMetaData(dataSetInfo);
    }

    @Override
    public List<InternalStreetAddress> retrieveReverseGeocodeCandidates(int dictionaryType, DirectPosition position, Length distance, GeocodeOptions options) throws DataAccessRuntimeException, FatalDataAccessRuntimeException, CGGEInternalException {
        ArrayList<InternalStreetAddress> streetAddress = new ArrayList<InternalStreetAddress>();
        for (int dictNum = 1; dictNum <= this.m_dictCount; ++dictNum) {
            DataDictionary dict = this.getDictionary(dictNum);
            if (!dict.isReverseGeocodeSupported(dictionaryType) || !this.canSearchDictionary(dict, options) || !this.isDictionaryUsed(dictNum, options)) continue;
            streetAddress.addAll(dict.retrieveReverseGeocodeCandidates(dictionaryType, position, distance, options, (IDataManager)this));
        }
        return streetAddress;
    }

    @Override
    public boolean doesDictionarySupportsReverseGeocodeType(int dictionaryIndex, int dataType) {
        return this.getDictionaryAt(dictionaryIndex).isReverseGeocodeSupported(dataType);
    }

    private final DataDictionary getDictionary(int dictNum) {
        return this.m_dataDictionaries[dictNum - 1];
    }

    @Override
    public List<DataSetInfo> getDataSetInfos(int dictionaryNumber, int dictionaryType) {
        this.checkDictionaryNumber(dictionaryNumber);
        List<DataSet> dataSets = this.getDictionary(dictionaryNumber).getDataSets(dictionaryType);
        List<DataSetInfo> dataSetInfos = null;
        if (dataSets != null) {
            for (DataSet dataSet : dataSets) {
                dataSetInfos = ListUtils.addToList(dataSetInfos, dataSet.getDataSetInfo());
            }
        }
        return dataSetInfos;
    }

    @Override
    public List<FieldType> getSACSearchFields(int dictionaryNumber, int dictionaryType) {
        this.checkDictionaryNumber(dictionaryNumber);
        return this.getDictionary(dictionaryNumber).getSACSearchFields(dictionaryType);
    }

    @Override
    public List<FieldType> getAddressSearchFields(int dictionaryNumber, int dictionaryType) {
        this.checkDictionaryNumber(dictionaryNumber);
        return this.getDictionary(dictionaryNumber).getAddressSearchFields(dictionaryType);
    }

    public boolean isUserDictionaryConfigured() {
        boolean flag = false;
        for (int i = 1; i <= this.getDictionaryCount(); ++i) {
            if (!this.getDictionary(i).isUserDictionary()) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

