/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.AddressDictionary;
import com.mapinfo.mapmarker.cgge.dp.AddressHandle;
import com.mapinfo.mapmarker.cgge.dp.AddressTableLookup;
import com.mapinfo.mapmarker.cgge.dp.AreaNameDictionary;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSet;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DataVersionInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.WordDictionary;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class DataSetReader {
    DataSet m_dataSet;
    AddressDictionary m_addrDictionary = null;
    AreaNameDictionary m_areaDictionary = null;
    DataSetInfo m_dataSetInfo = null;
    IDictionaryMetaData m_metaData = null;
    ICGGEParser m_parser = null;
    ICGGESoundex m_soundex = null;
    AddressTableLookup m_addressLookupTable = null;
    AddressHandle m_lastAddressHandle = null;
    int m_lastSac = -1;

    public void loadData(String path, String name) throws Exception {
        this.m_dataSet = DataSet.getInstance(path, name, 0, 1);
        this.m_dataSet.loadData(path, name);
        this.m_addrDictionary = this.m_dataSet.getAddressDictionary();
        this.m_areaDictionary = this.m_dataSet.getAreaNameDictionary();
        this.m_addressLookupTable = this.m_addrDictionary.getAddressLookupTable();
        this.m_metaData = this.m_dataSet.getMetaData();
        this.m_dataSetInfo = new DataSetInfo(this.m_metaData, name, 1, 1, this.m_metaData.getDictionaryType());
    }

    public Collection<Integer> getSacs() {
        return this.m_addressLookupTable.getSacs();
    }

    public Iterator<InternalStreetAddress> getAddressIterator(int sac) throws CGGEInternalException {
        return this.getAddressIterator(sac, true);
    }

    public Iterator<InternalStreetAddress> getAddressIterator(int sac, boolean includeAdditionalFields) throws CGGEInternalException {
        AddressHandle handle = this.getAddressHandle(sac);
        return new AddressIterator(handle, includeAdditionalFields);
    }

    public Iterator<InternalStreetAddress> getAddressIterator(int sac, IntArray addrNdxs) throws CGGEInternalException, DataNotInitialisedException {
        AddressHandle handle = this.getAddressHandle(sac);
        return new AddressIterator(handle, addrNdxs, false);
    }

    private AddressHandle getAddressHandle(int sac) throws CGGEInternalException {
        if (this.m_lastSac == sac && this.m_lastAddressHandle != null) {
            return this.m_lastAddressHandle;
        }
        AddressHandle handle = this.m_addrDictionary.findAddressHandleForSAC(sac);
        handle.setAreaNameDictionary(this.m_areaDictionary);
        this.m_lastSac = sac;
        this.m_lastAddressHandle = handle;
        return handle;
    }

    public final ICGGEParser getParser() {
        if (this.m_parser == null) {
            this.m_parser = CGGEHandler.getInstance(this.m_dataSetInfo, this.m_metaData.getCountry(), this.m_metaData.getLanguage()).getParser();
        }
        return this.m_parser;
    }

    public IDictionaryMetaData getMetaData() {
        return this.m_metaData;
    }

    final ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            this.m_soundex = CGGEHandler.getInstance(this.m_dataSetInfo, this.m_metaData.getCountry(), this.m_metaData.getLanguage()).getSoundex();
        }
        return this.m_soundex;
    }

    public Map<Integer, String> getFieldMap() {
        HashMap<Integer, String> fieldmap = null;
        if (this.m_metaData != null) {
            fieldmap = new HashMap<Integer, String>(100);
            FieldType[] fieldTypes = FieldType.getPredefinedFieldTypes();
            this.addToMap(fieldmap, this.m_metaData, Arrays.asList(fieldTypes));
            this.addToMap(fieldmap, this.m_metaData, this.m_metaData.getAdditionalFields());
        }
        return fieldmap;
    }

    private void addToMap(Map<Integer, String> fieldmap, IDictionaryMetaData metadata, List<FieldType> types) {
        if (types != null && !types.isEmpty()) {
            for (FieldType type : types) {
                int id = type.getKey();
                String name = metadata.getFieldNameForKey(id);
                if (name == null) continue;
                fieldmap.put(id, name);
            }
        }
    }

    public InternalStreetAddress getAddressRecord(int sac, int addrNdx) throws CGGEInternalException {
        AddressHandle handle = this.getAddressHandle(sac);
        return handle.getAddressAtIndex(addrNdx, this.getParser(), this.getSoundex(), this.m_dataSetInfo);
    }

    public List<InternalStreetAddress> getAddressRecords(int sac, List<Integer> addrNdxs) throws CGGEInternalException {
        AddressHandle handle = this.getAddressHandle(sac);
        ArrayList<InternalStreetAddress> addrs = new ArrayList<InternalStreetAddress>(addrNdxs.size());
        for (Integer addrNdx : addrNdxs) {
            addrs.add(handle.getAddressAtIndex(addrNdx, this.getParser(), this.getSoundex(), this.m_dataSetInfo));
        }
        return addrs;
    }

    void populateAdditionalFields(InternalStreetAddress addr) throws CGGEInternalException {
        this.readAdditionalFields(addr);
        for (InternalRangeAddress range : addr.getRangeList()) {
            this.readAdditionalFields(range);
        }
    }

    private void readAdditionalFields(InternalAddress addr) throws CGGEInternalException {
        try {
            this.m_dataSet.readAdditionalFields(addr);
        }
        catch (IOException e) {
            throw new CGGEInternalException(e);
        }
    }

    public List<DirectPosition> getGeometry(InternalAddress internalAddress) throws CGGEInternalException {
        try {
            return this.m_dataSet.getGeometry(internalAddress);
        }
        catch (IOException e) {
            throw new CGGEInternalException(e);
        }
    }

    public String getDataName() {
        return this.m_dataSetInfo.getName();
    }

    public DataVersionInfo getDataVersionInfo() {
        return this.m_addressLookupTable.getDataVersionInfo();
    }

    public WordDictionary getAddressWordDictionary() {
        return this.m_dataSet.getAddressDictionary().getWordDictionary();
    }

    public WordDictionary getAreaWordDictionary() {
        return this.m_dataSet.getAreaNameDictionary().getWordDictionary();
    }

    private class AddressIterator
    implements Iterator<InternalStreetAddress> {
        final AddressHandle m_handle;
        int m_nextSacNdx = 0;
        InternalStreetAddress m_nextAddress = null;
        final Iterator<Integer> m_addrNdxIt;
        final boolean readAddFields;

        AddressIterator(AddressHandle handle, boolean readAddFields) throws CGGEInternalException {
            this(handle, null, readAddFields);
        }

        public AddressIterator(AddressHandle handle, IntArray addrNdxs, boolean readAddFields) throws CGGEInternalException {
            this.m_handle = handle;
            this.readAddFields = readAddFields;
            this.m_addrNdxIt = addrNdxs != null && !addrNdxs.isEmpty() ? addrNdxs.iterator() : null;
            this.m_nextAddress = this.getNextAddress(readAddFields);
        }

        @Override
        public boolean hasNext() {
            return this.m_nextAddress != null;
        }

        @Override
        public InternalStreetAddress next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            InternalStreetAddress retAddress = this.m_nextAddress;
            try {
                this.m_nextAddress = this.getNextAddress(this.readAddFields);
            }
            catch (CGGEInternalException e) {
                throw new RuntimeException(e);
            }
            return retAddress;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private InternalStreetAddress getNextAddress(boolean readAdditionalFields) throws CGGEInternalException {
            InternalStreetAddress addr = null;
            if (this.m_addrNdxIt != null && this.m_addrNdxIt.hasNext()) {
                addr = this.m_handle.getAddressAtIndex(this.m_addrNdxIt.next(), DataSetReader.this.getParser(), DataSetReader.this.getSoundex(), DataSetReader.this.m_dataSetInfo);
            } else {
                try {
                    addr = this.m_handle.getAddressAtIndex(this.m_nextSacNdx++, DataSetReader.this.getParser(), DataSetReader.this.getSoundex(), DataSetReader.this.m_dataSetInfo);
                }
                catch (IndexOutOfBoundsException ne) {
                    addr = null;
                }
            }
            if (addr != null && readAdditionalFields) {
                DataSetReader.this.populateAdditionalFields(addr);
            }
            return addr;
        }
    }
}

