/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DictionaryMetaData
implements IDictionaryMetaData {
    public static final String VERSION_KEY = "version";
    public static final int CURRENT_VERSION = 2;
    public static final String DEFAULT_COORD_SYS_STRING = "epsg:4326";
    public static final int DEFAULT_COORD_PRECISION = 5;
    private static final int DEFAULT_VERSION = 1;
    private static final Map<Integer, FieldType> DEFINED_FIELDTYPES_MAP = DictionaryMetaData.getPredefinedFields();
    private boolean m_userDictionary;
    private int m_dictionaryType = 1;
    private String m_srcCoordSys;
    private List<FieldType> m_searchFields;
    private List<FieldType> m_sacSearchFields;
    private Map<Integer, FieldType> m_additionalFields;
    private String m_country;
    private String m_language;
    private int m_coordDecimalPrecision;
    private Properties m_additionalInfo;
    private CoordSys m_srcCoordSysObject;
    private int version = 2;

    public DictionaryMetaData() {
        this.setSourceCoordinateSys(DEFAULT_COORD_SYS_STRING);
        this.m_searchFields = new ArrayList<FieldType>(5);
        this.m_sacSearchFields = new ArrayList<FieldType>(5);
        this.m_additionalFields = new HashMap<Integer, FieldType>(5);
        this.m_userDictionary = false;
        this.m_country = null;
        this.m_language = null;
        this.m_coordDecimalPrecision = 5;
        this.m_additionalInfo = new Properties();
        this.m_additionalInfo.setProperty(VERSION_KEY, Integer.toString(2));
    }

    @Override
    public int getDictionaryType() {
        return this.m_dictionaryType;
    }

    @Override
    public void setDictionaryType(int dictType) {
        this.m_dictionaryType = dictType;
    }

    @Override
    public void setUserDictionary(boolean b) {
        this.m_userDictionary = b;
    }

    @Override
    public boolean isUserDictionary() {
        return this.m_userDictionary;
    }

    @Override
    public String getSourceCoordinateSys() {
        return this.m_srcCoordSys;
    }

    @Override
    public CoordSys getSourceCoordSysObject() {
        return this.m_srcCoordSysObject;
    }

    @Override
    public void setSourceCoordinateSys(String coordSys) {
        if (coordSys == null) {
            throw new IllegalArgumentException();
        }
        this.m_srcCoordSys = coordSys;
        try {
            this.m_srcCoordSysObject = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys);
        }
        catch (RuntimeException ex) {
            MMJLog.getLog().error("problem coord sys string is " + coordSys + ".");
            this.m_srcCoordSysObject = MidevConversionUtils.getCoordSysFromLegacyString((String)coordSys);
        }
    }

    @Override
    public void setCountry(String country) {
        this.m_country = country;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public void setLanguage(String lang) {
        this.m_language = lang;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.m_dictionaryType);
        out.writeInt(this.m_userDictionary ? 1 : 0);
        this.writeChars(out, this.m_srcCoordSys);
        this.writeChars(out, this.m_country);
        this.writeChars(out, this.m_language);
        out.writeInt(this.m_additionalFields.size());
        for (FieldType additionalField : this.m_additionalFields.values()) {
            out.writeInt(additionalField.getKey());
            this.writeChars(out, additionalField.getName());
            FieldType.FieldLevel level = additionalField.getLevel();
            out.write(level.getLevelAsInt());
        }
        out.writeInt(this.m_searchFields.size());
        for (i = 0; i < this.m_searchFields.size(); ++i) {
            out.writeInt(this.m_searchFields.get(i).getKey());
        }
        out.writeInt(this.m_sacSearchFields.size());
        for (i = 0; i < this.m_sacSearchFields.size(); ++i) {
            out.writeInt(this.m_sacSearchFields.get(i).getKey());
        }
        out.writeInt(this.m_coordDecimalPrecision);
        int addInfoCount = this.m_additionalInfo == null ? 0 : this.m_additionalInfo.size();
        out.writeInt(addInfoCount);
        if (addInfoCount > 0) {
            for (Map.Entry<Object, Object> entry : this.m_additionalInfo.entrySet()) {
                this.writeChars(out, (String)entry.getKey());
                this.writeChars(out, (String)entry.getValue());
            }
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        int i;
        this.m_dictionaryType = in.readInt();
        this.m_userDictionary = in.readInt() == 1;
        String coordSys = this.readChars(in);
        if (!MMUtils.isEmpty(coordSys)) {
            this.setSourceCoordinateSys(coordSys);
        }
        this.m_country = this.readChars(in);
        this.m_language = this.readChars(in);
        int addFieldSize = in.readInt();
        for (int i2 = 0; i2 < addFieldSize; ++i2) {
            int key = in.readInt();
            String name = this.readChars(in);
            byte levelValue = in.readByte();
            FieldType.FieldLevel level = null;
            level = FieldType.FieldLevel.getLevelAsEnum(levelValue);
            FieldType fieldType = new FieldType(key, level, name);
            this.m_additionalFields.put(key, fieldType);
        }
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            int typeValue = in.readInt();
            this.m_searchFields.add(this.getFieldType(typeValue));
        }
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            int typeValue = in.readInt();
            this.m_sacSearchFields.add(this.getFieldType(typeValue));
        }
        this.m_coordDecimalPrecision = in.readInt();
        this.m_additionalInfo = new Properties();
        int addInfoCount = in.readInt();
        for (int addInfoNdx = 0; addInfoNdx < addInfoCount; ++addInfoNdx) {
            String key = this.readChars(in);
            String value = this.readChars(in);
            this.setAdditionalInfo(key, value);
        }
        this.setProperVersion();
    }

    private void writeChars(DataOutput out, String str) throws IOException {
        if (str == null) {
            out.writeInt(0);
        } else {
            out.writeInt(str.length());
            out.writeChars(str);
        }
    }

    private String readChars(DataInput in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            char[] chars = new char[size];
            for (int i = 0; i < size; ++i) {
                chars[i] = in.readChar();
            }
            return new String(chars);
        }
        return null;
    }

    private void setProperVersion() {
        String v = this.getAdditionalInfo(VERSION_KEY);
        this.version = MMUtils.isEmpty(v) ? 1 : Integer.parseInt(v);
    }

    @Override
    public int getKeyForField(String fieldName) {
        FieldType ft = this.getFieldForName(fieldName);
        return ft == null ? -1 : ft.getKey();
    }

    @Override
    public String getFieldNameForKey(int key) {
        FieldType ft = this.getFieldType(key);
        return ft == null ? null : ft.getName();
    }

    @Override
    public FieldType getFieldForName(String fieldName) {
        FieldType[] types;
        if (this.m_additionalFields != null) {
            for (FieldType type : this.m_additionalFields.values()) {
                if (!fieldName.equals(type.getName())) continue;
                return type;
            }
        }
        int typeCount = (types = FieldType.getPredefinedFieldTypes()) == null ? 0 : types.length;
        for (int typeNdx = 0; typeNdx < typeCount; ++typeNdx) {
            FieldType type = types[typeNdx];
            if (!fieldName.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    @Override
    public FieldType getFieldType(int key) {
        FieldType ft;
        Integer keyObj = key;
        if (key >= 29 && this.m_additionalFields != null && (ft = this.m_additionalFields.get(keyObj)) != null) {
            return ft;
        }
        return DEFINED_FIELDTYPES_MAP.get(keyObj);
    }

    @Override
    public FieldType generateNewFieldTypeFromName(String fieldName, FieldType.FieldLevel level) {
        FieldType resultField = null;
        FieldType type = this.getFieldForName(fieldName);
        if (type != null) {
            throw new IllegalArgumentException("Specified field name already exits");
        }
        int nextId = 29;
        if (this.m_additionalFields != null) {
            for (int key : this.m_additionalFields.keySet()) {
                if (key < nextId) continue;
                nextId = key + 1;
            }
        }
        if (nextId > 200) {
            throw new IndexOutOfBoundsException("Maximum allowed IDs used. No more additional fields possible.");
        }
        resultField = new FieldType(nextId, level, fieldName);
        this.m_additionalFields.put(nextId, resultField);
        return resultField;
    }

    @Override
    public List<FieldType> getFieldsAtLevel(FieldType.FieldLevel level) {
        FieldType[] types;
        ArrayList<FieldType> fieldList = new ArrayList<FieldType>();
        if (this.m_additionalFields != null) {
            for (FieldType type : this.m_additionalFields.values()) {
                if (level != type.getLevel()) continue;
                fieldList.add(type);
            }
        }
        int typeCount = (types = FieldType.getPredefinedFieldTypes()) == null ? 0 : types.length;
        for (int typeNdx = 0; typeNdx < typeCount; ++typeNdx) {
            FieldType type = types[typeNdx];
            if (level != type.getLevel()) continue;
            fieldList.add(type);
        }
        return fieldList;
    }

    @Override
    public void setSearchFields(List<FieldType> fields) {
        this.m_searchFields = fields;
    }

    @Override
    public void setSacSearchField(List<FieldType> fields) {
        this.m_sacSearchFields = fields;
    }

    @Override
    public List<FieldType> getSearchFields() {
        return this.m_searchFields;
    }

    @Override
    public List<FieldType> getSacSearchFields() {
        return this.m_sacSearchFields;
    }

    @Override
    public void setAdditionalFields(List<FieldType> addFields) {
        if (addFields == null) {
            this.m_additionalFields = Collections.emptyMap();
        } else {
            this.m_additionalFields = new HashMap<Integer, FieldType>(addFields.size());
            for (FieldType type : addFields) {
                this.m_additionalFields.put(type.getKey(), type);
            }
        }
    }

    @Override
    public List<FieldType> getAdditionalFields() {
        return this.m_additionalFields == null ? null : new ArrayList<FieldType>(this.m_additionalFields.values());
    }

    @Override
    public int getCoordDecimalPrecision() {
        return this.m_coordDecimalPrecision;
    }

    @Override
    public void setCoordDecimalPrecision(int numOfDecimalPlaces) {
        if (numOfDecimalPlaces < 0 || numOfDecimalPlaces > 10) {
            throw new IllegalArgumentException("Value should be between 0 and 10");
        }
        this.m_coordDecimalPrecision = numOfDecimalPlaces;
    }

    @Override
    public String getAdditionalInfo(String key) {
        return this.m_additionalInfo.getProperty(key);
    }

    @Override
    public void setAdditionalInfo(String key, String info) {
        this.m_additionalInfo.setProperty(key, info);
    }

    @Override
    public boolean isReverseGeocodingSupported() {
        return Boolean.valueOf(this.getAdditionalInfo("supports_reversegeocoding"));
    }

    @Override
    public boolean isFallBackToPOIWithStreetAllowed() {
        return Boolean.valueOf(this.getAdditionalInfo("fallback_to_poi_with_street"));
    }

    @Override
    public int getGlobalLocationPrecision() {
        String v = this.getAdditionalInfo("global_location_precision");
        if (v != null && v.length() > 0) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public void setGlobalLocationPrecision(int precision) {
        this.setAdditionalInfo("global_location_precision", String.valueOf(precision));
    }

    public void setVersion(int v) {
        this.version = v;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private static Map<Integer, FieldType> getPredefinedFields() {
        FieldType[] types = FieldType.getPredefinedFieldTypes();
        HashMap<Integer, FieldType> typeMap = new HashMap<Integer, FieldType>(types.length);
        for (FieldType type : types) {
            typeMap.put(type.getKey(), type);
        }
        return typeMap;
    }
}

