/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.dp.AddressNumberIOHandler;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.CompressedSegment;
import com.mapinfo.mapmarker.cgge.dp.DataAddressWordsIOHandler;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler1;
import com.mapinfo.mapmarker.cgge.utils.IOUtil;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalAddressIOHandler {
    private static final int MASK_HAS_WORDS = 1;
    private static final int MASK_HAS_TERMS = 2;
    private static final int MASK_HAS_RANGES = 4;
    private static final int MASK_HAS_ADDITIONALFIELDS = 8;
    private static final int MASK_RANGE_COUNT_IN_BYTE = 16;
    private static final int MASK_ADD_FIELD_OFFSET_IN_INT = 32;
    private static final int MASK_TERMS_OFFSET_IN_BYTE = 64;
    private static final int MASK_RANGE_FROM = 3;
    private static final int MASK_RANGE_TO = 12;
    private static final int MASK_RANGE_SIDE = 48;
    private static final int MASK_RANGE_TYPE = 448;
    private static final int MASK_RANGE_HAS_WORDS = 1024;
    private static final int MASK_RANGE_HAS_UNITS = 2048;
    private static final int MASK_RANGE_HAS_ADDITIONALFIELDS = 4096;
    private static final int MASK_RANGE_ADD_FIELD_OFFSET_IN_INT = 8192;
    private static final int MASK_RANGE_HAS_COORD_OFFSET = 16384;
    private static final int MASK_RANGE_COORD_OFFSET_IN_INT = 32768;
    private static final int MASK_UNIT_HAS_WORDS = 1;
    static final AreaMetaData EMPTY_AREA_META_DATA = new AreaMetaData();

    InternalAddressIOHandler() {
    }

    public static InternalAddressIOHandler getInstance(int version) {
        if (version < 2) {
            return new InternalAddressIOHandler();
        }
        return new InternalAddressIOHandler1();
    }

    public void write(InternalStreetAddress addr, ICGGEDataOutput out) throws IOException, DataCreationException {
        AdditionalFields addFields;
        List<InternalRangeAddress> rangeList;
        int rangeSize;
        List<Integer> termNdxList;
        int termSize;
        byte mask = 0;
        if (addr.getFields().size() > 0) {
            mask = (byte)(mask | 1);
        }
        int n = termSize = (termNdxList = addr.getAreaTermIndexes()) == null ? 0 : termNdxList.size();
        if (termSize > 0) {
            if (termSize > 256) {
                throw new DataCreationException("Only supports maximum of 256 areas, there are " + termSize + " areas in this address object");
            }
            mask = (byte)(mask | 2);
            boolean termsInByte = true;
            for (int termNdx = 0; termNdx < termSize; ++termNdx) {
                if (termNdxList.get(termNdx) < 256) continue;
                termsInByte = false;
                break;
            }
            if (termsInByte) {
                mask = (byte)(mask | 0x40);
            }
        }
        int n2 = rangeSize = (rangeList = addr.getRangeList()) == null ? 0 : rangeList.size();
        if (rangeSize > 0) {
            mask = (byte)(mask | 4);
            if (rangeSize < 254) {
                mask = (byte)(mask | 0x10);
            }
        }
        if ((addFields = addr.getAdditionalFields()) != null && addFields.size() > 0) {
            mask = (byte)(mask | 8);
            long offset = addFields.getOffset();
            if (offset < 0xFFFFFFFEL) {
                mask = (byte)(mask | 0x20);
            }
        }
        out.write(mask);
        if (InternalAddressIOHandler.isMaskBitSet(mask, 1)) {
            this.writeAddressWords(addr, out);
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 2)) {
            this.writeAreaTermIndexes(out, termNdxList, !InternalAddressIOHandler.isMaskBitSet(mask, 64));
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 4)) {
            if ((mask & 0x10) == 16) {
                out.write(rangeSize);
            } else {
                out.writeShort(rangeSize);
            }
            for (int i = 0; i < rangeSize; ++i) {
                InternalRangeAddress range = rangeList.get(i);
                this.writeRange(range, out);
            }
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 8)) {
            this.writeOffset(out, addFields.getOffset(), !InternalAddressIOHandler.isMaskBitSet(mask, 32));
        }
    }

    void writeAddressWords(InternalAddress addr, DataOutput out) throws IOException, DataCreationException {
        DataAddressWordsIOHandler.writeAddressWords(addr, out);
    }

    void writeAreaTermIndexes(DataOutput out, List<Integer> areaTermNdxList, boolean writeShortValues) throws IOException {
        out.writeByte(areaTermNdxList.size());
        for (int atNdx : areaTermNdxList) {
            if (writeShortValues) {
                out.writeShort(atNdx);
                continue;
            }
            out.writeByte(atNdx);
        }
    }

    public void read(InternalStreetAddress addr, ICGGEDataInput in, IDictionaryMetaData metaData) throws IOException {
        byte mask = in.readByte();
        if (InternalAddressIOHandler.isMaskBitSet(mask, 1)) {
            this.readAddressWords(addr, in, metaData);
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 2)) {
            addr.setAreaTermIndexes(this.readAreaTermIndexes(in, !InternalAddressIOHandler.isMaskBitSet(mask, 64)));
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 4)) {
            int rangeSize = 0;
            rangeSize = (mask & 0x10) == 16 ? IOUtil.readUnsignedByte(in) : IOUtil.readUnsignedShort(in);
            ArrayList<InternalRangeAddress> rangeList = new ArrayList<InternalRangeAddress>(rangeSize);
            for (int i = 0; i < rangeSize; ++i) {
                InternalRangeAddress range = new InternalRangeAddress();
                this.readRange(range, in, metaData);
                rangeList.add(range);
            }
            addr.setRangeList(rangeList);
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 8)) {
            addr.setAdditionalFields(this.readAdditionalFields(in, !InternalAddressIOHandler.isMaskBitSet(mask, 32)));
        }
    }

    void readAddressWords(InternalAddress addr, ICGGEDataInput in, IDictionaryMetaData metaData) throws IOException {
        DataAddressWordsIOHandler.readAddressWords(addr, in, metaData);
    }

    List<Integer> readAreaTermIndexes(ICGGEDataInput in, boolean readShortValues) throws IOException {
        int count = in.readUnsignedByte();
        ArrayList<Integer> termNdxList = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            termNdxList.add(readShortValues ? in.readUnsignedShort() : in.readUnsignedByte());
        }
        return termNdxList;
    }

    void readRange(InternalRangeAddress range, ICGGEDataInput in, IDictionaryMetaData metaData) throws IOException {
        int mask = IOUtil.readUnsignedShort(in);
        int m = mask & 3;
        if (m > 0) {
            range.setFrom(this.readAddressNumber(m, in));
        }
        if ((m = (mask & 0xC) >> 2) > 0) {
            range.setTo(this.readAddressNumber(m, in));
        }
        byte rangeSide = (byte)((mask & 0x30) >> 4);
        range.setRangeSide(rangeSide);
        byte rangeType = (byte)((mask & 0x1C0) >> 6);
        range.setOddEvenType(rangeType);
        if (InternalAddressIOHandler.isMaskBitSet(mask, 1024)) {
            this.readAddressWords(range, in, metaData);
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 2048)) {
            int unitSize = IOUtil.readUnsignedByte(in);
            ArrayList<InternalUnitAddress> unitList = new ArrayList<InternalUnitAddress>(unitSize);
            for (int i = 0; i < unitSize; ++i) {
                InternalUnitAddress unit = new InternalUnitAddress();
                this.readUnit(unit, in, metaData);
                unitList.add(unit);
            }
            range.setUnits(unitList);
        }
        if (InternalAddressIOHandler.isMaskBitSet(mask, 4096)) {
            range.setAdditionalFields(this.readAdditionalFields(in, !InternalAddressIOHandler.isMaskBitSet(mask, 8192)));
        }
        long coordinateOffset = -1L;
        if (InternalAddressIOHandler.isMaskBitSet(mask, 16384)) {
            coordinateOffset = this.readOffset(in, !InternalAddressIOHandler.isMaskBitSet(mask, 32768));
        }
        range.setCoordinateOffset(coordinateOffset);
    }

    private AddressNumber readAddressNumber(int type, ICGGEDataInput in) throws IOException {
        AddressNumber addrNum = new AddressNumber();
        switch (type) {
            case 1: {
                AddressNumberIOHandler.read(addrNum, in);
                break;
            }
            case 2: {
                int f = IOUtil.readUnsignedByte(in);
                addrNum.setHnrNumber1(f);
                break;
            }
            case 3: {
                int f = IOUtil.readUnsignedShort(in);
                addrNum.setHnrNumber1(f);
            }
        }
        return addrNum;
    }

    private void writeAddressNumber(AddressNumber addrNum, int type, DataOutput out) throws IOException {
        switch (type) {
            case 1: {
                AddressNumberIOHandler.write(addrNum, out);
                break;
            }
            case 2: {
                out.write(addrNum.getHnrNumber1());
                break;
            }
            case 3: {
                out.writeShort(addrNum.getHnrNumber1());
            }
        }
    }

    AdditionalFields readAdditionalFields(ICGGEDataInput in, boolean readLongValue) throws IOException {
        AdditionalFields addFields = new AdditionalFields();
        addFields.setOffset(this.readOffset(in, readLongValue));
        return addFields;
    }

    long readOffset(ICGGEDataInput in, boolean readLongValue) throws IOException {
        long offset = readLongValue ? in.readLong() : IOUtil.readUnsignedInteger(in);
        return offset;
    }

    void writeOffset(ICGGEDataOutput out, long offset, boolean writeLongValue) throws IOException {
        if (writeLongValue) {
            out.writeLong(offset);
        } else {
            out.writeInt((int)offset);
        }
    }

    void writeRange(InternalRangeAddress range, ICGGEDataOutput out) throws IOException, DataCreationException {
        long coordOffset;
        AdditionalFields addFields;
        List<InternalUnitAddress> unitList;
        AddressNumber to;
        int mask = 0;
        AddressNumber from = range.getFrom();
        if (from != null) {
            int hnr = from.getHnrNumber1();
            mask = from.getType() == 1 && hnr < 65534 ? (hnr < 256 ? (mask |= 2) : (mask |= 3)) : (mask |= 1);
        }
        if ((to = range.getTo()) != null) {
            int hnr = to.getHnrNumber1();
            mask = to.getType() == 1 && hnr < 65534 ? (hnr < 256 ? (mask |= 8) : (mask |= 0xC)) : (mask |= 4);
        }
        mask |= range.getRangeSide() << 4;
        if (to != null) {
            mask |= range.getOddEvenType() << 6;
        }
        if (range.getFields().size() > 0) {
            mask |= 0x400;
        }
        if ((unitList = range.getUnits()) != null && unitList.size() > 0) {
            mask |= 0x800;
        }
        if ((addFields = range.getAdditionalFields()) != null && addFields.size() > 0) {
            mask |= 0x1000;
            if (addFields.getOffset() < 0xFFFFFFFEL) {
                mask |= 0x2000;
            }
        }
        if ((coordOffset = range.getCoordinateOffset()) > -1L) {
            mask |= 0x4000;
            if (coordOffset < 0xFFFFFFFEL) {
                mask |= 0x8000;
            }
        }
        out.writeShort(mask);
        int m = mask & 3;
        if (m > 0) {
            this.writeAddressNumber(from, m, out);
        }
        if ((m = (mask & 0xC) >> 2) > 0) {
            this.writeAddressNumber(to, m, out);
        }
        if ((mask & 0x400) == 1024) {
            this.writeAddressWords(range, out);
        }
        if ((mask & 0x800) == 2048) {
            int unitSize = unitList.size();
            if (unitSize >= 256) {
                throw new DataCreationException("Maximum number of supported units per range is 256. Found " + unitSize + "!");
            }
            out.writeByte(unitSize);
            for (int i = 0; i < unitSize; ++i) {
                InternalUnitAddress unit = unitList.get(i);
                this.writeUnit(unit, out);
            }
        }
        if ((mask & 0x1000) == 4096) {
            this.writeOffset(out, addFields.getOffset(), !InternalAddressIOHandler.isMaskBitSet(mask, 8192));
        }
        if ((mask & 0x4000) == 16384) {
            this.writeOffset(out, coordOffset, !InternalAddressIOHandler.isMaskBitSet(mask, 32768));
        }
    }

    void writeUnit(InternalUnitAddress unit, DataOutput out) throws IOException, DataCreationException {
        int mask = 0;
        Map fieldMap = unit.getFields();
        if (fieldMap != null && fieldMap.size() > 0) {
            mask |= 1;
        }
        out.write(mask);
        if ((mask & 1) == 1) {
            this.writeAddressWords(unit, out);
        }
    }

    void readUnit(InternalUnitAddress unit, ICGGEDataInput in, IDictionaryMetaData metaData) throws IOException {
        int mask = IOUtil.readUnsignedByte(in);
        if ((mask & 1) == 1) {
            this.readAddressWords(unit, in, metaData);
        }
    }

    public void writeAdditionalFields(Map<FieldType, String> addFields, DataOutput out) throws IOException {
        int size = addFields == null ? 0 : addFields.size();
        out.write(size);
        for (Map.Entry<FieldType, String> entry : addFields.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            out.write(entry.getKey().getKey());
            int strSize = value.length();
            out.write(strSize);
            out.writeChars(value);
        }
    }

    public void writeGeometry(DirectPosition[] geom, AreaMetaData metaData, ICGGEDataOutput out) throws IOException {
        byte coordPrecision = (byte)metaData.getCoordDecimalPrecision();
        long factor = (long)Math.pow(10.0, coordPrecision);
        CompressedSegment segment = new CompressedSegment(geom, coordPrecision, coordPrecision, factor, factor);
        byte[] bytes = segment.getValueBytes();
        out.writeShort(bytes.length);
        out.write(bytes);
    }

    public Map<FieldType, String> readAdditionalFields(DataInput in, IDictionaryMetaData metaData) throws IOException {
        int size = IOUtil.readUnsignedByte(in);
        if (size > 0) {
            HashMap<FieldType, String> addFieldMap = new HashMap<FieldType, String>(size);
            for (int i = 0; i < size; ++i) {
                int fieldKey = IOUtil.readUnsignedByte(in);
                int strSize = IOUtil.readUnsignedByte(in);
                char[] chars = new char[strSize];
                for (int j = 0; j < strSize; ++j) {
                    chars[j] = in.readChar();
                }
                String value = new String(chars);
                FieldType type = metaData.getFieldType(fieldKey);
                if (type == null) {
                    throw new CGGERuntimeException(fieldKey + " is not recognised as a additional field");
                }
                addFieldMap.put(type, value);
            }
            return addFieldMap;
        }
        return Collections.emptyMap();
    }

    public List<DirectPosition> readGeometry(ICGGEDataInput in, AreaMetaData metaData) throws IOException {
        byte coordPrecision = (byte)metaData.getCoordDecimalPrecision();
        byte[] coordData = this.readCoordinateBytes(in);
        if (coordData != null) {
            CompressedSegment segment = new CompressedSegment(coordPrecision, coordPrecision);
            segment.decode(coordData);
            DirectPosition[] points = segment.convert();
            if (points != null) {
                ArrayList<DirectPosition> list = new ArrayList<DirectPosition>();
                for (int i = 0; i < points.length; ++i) {
                    list.add(points[i]);
                }
                return list;
            }
        }
        return null;
    }

    private byte[] readCoordinateBytes(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readShort()];
        in.readFully(bytes);
        return bytes;
    }

    private static boolean isMaskBitSet(int mask, int value) {
        return (mask & value) == value;
    }

    public void writeAreaMetaData(AreaMetaData metaData, ICGGEDataOutput stream) throws IllegalArgumentException, IOException {
    }

    public AreaMetaData readAreaMetaData(IDictionaryMetaData metaData, DataInput in) throws IOException {
        return EMPTY_AREA_META_DATA;
    }
}

