/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalCandidateList {
    private GeocodeTypeCloseCandidates m_Candidates;
    private GeocodeTypeCloseCandidates m_POICandidates;
    private InternalScoringAddress m_bestFetchedCandidate;
    private byte m_CandidateType = 1;
    private Map<String, Object> m_additionalInfoMap = Collections.emptyMap();

    public InternalCandidateList() {
        this.m_Candidates = new GeocodeTypeCloseCandidates(0, new ArrayList<InternalScoringAddress>(10));
        this.m_POICandidates = new GeocodeTypeCloseCandidates(0, new ArrayList<InternalScoringAddress>(10));
    }

    public InternalCandidateList(Collection<InternalScoringAddress> cands) {
        this();
        this.disperseCandidatesAccordingtoType(cands);
    }

    public void addCandidate(InternalScoringAddress addr) {
        this.disperseCandidateAccordingtoType(addr);
    }

    public void addCandidates(Collection<InternalScoringAddress> collection) {
        this.disperseCandidatesAccordingtoType(collection);
    }

    public int getCandidateCount() {
        int count = 0;
        count += this.m_Candidates.getCandidateCount();
        return count += this.m_POICandidates.getCandidateCount();
    }

    public boolean hasCandidates() {
        return this.m_Candidates.hasCandidates() || this.m_POICandidates.hasCandidates();
    }

    public boolean hasCloseCandidates() {
        return this.m_Candidates.hasCloseCandidates() || this.m_POICandidates.hasCloseCandidates();
    }

    public List<InternalScoringAddress> getCandidateList() {
        if (this.m_CandidateType == 4) {
            return this.m_POICandidates.m_candidateList;
        }
        return this.m_Candidates.m_candidateList;
    }

    public InternalScoringAddress getIndexedCandidate(int ndx) {
        return ndx < this.m_Candidates.getCandidateCount() ? (InternalScoringAddress)this.m_Candidates.m_candidateList.get(ndx) : null;
    }

    public void setBestFetchedCandidate(InternalScoringAddress cand) {
        this.m_bestFetchedCandidate = cand;
    }

    public InternalScoringAddress getBestFetchedCandidate() {
        return this.m_bestFetchedCandidate;
    }

    public String toString() {
        String ret = "Number of candidates=";
        ret = ret + this.getCandidateCount();
        ret = ret + "\r\n";
        for (int i = 0; i < this.getCandidateCount(); ++i) {
            ret = ret + "Candidate " + i + " ";
            ret = ret + this.getIndexedCandidate(i).toString();
            ret = ret + "\r\n";
        }
        return ret;
    }

    public int getNumberOfCloseMatches() {
        int closeMatchCount = 0;
        switch (this.m_CandidateType) {
            case 4: {
                closeMatchCount = this.m_POICandidates.m_numberOfCloseMatches;
                break;
            }
            case 1: {
                closeMatchCount = this.m_Candidates.m_numberOfCloseMatches;
                break;
            }
            case 0: {
                closeMatchCount = this.m_Candidates.m_numberOfCloseMatches + this.m_POICandidates.m_numberOfCloseMatches;
            }
        }
        return closeMatchCount;
    }

    public void setNumberOfCloseMatches(int i) {
        if (this.m_CandidateType == 4) {
            this.m_POICandidates.m_numberOfCloseMatches = i;
        } else {
            this.m_Candidates.m_numberOfCloseMatches = i;
        }
    }

    public void setCandidateList(List<InternalScoringAddress> candList) {
        this.disperseCandidatesAccordingtoType(candList);
    }

    public void sortCandidatesOverPOIOrStreet(boolean preferPOI) {
        ArrayList candidates = new ArrayList(this.m_Candidates.m_candidateList);
        candidates.addAll(this.m_POICandidates.m_candidateList);
        if (preferPOI) {
            Collections.sort(candidates, new POIPreferenceSorter());
        } else {
            Collections.sort(candidates, new StreetPreferenceSorter());
        }
        Collections.sort(candidates, new CloseMatchSorter());
        this.m_Candidates.m_candidateList = candidates;
        this.m_POICandidates.m_candidateList = null;
    }

    private void disperseCandidatesAccordingtoType(Collection<InternalScoringAddress> candidates) {
        if (candidates != null) {
            for (InternalScoringAddress internalScoringAddress : candidates) {
                this.disperseCandidateAccordingtoType(internalScoringAddress);
            }
        }
    }

    private void disperseCandidateAccordingtoType(InternalScoringAddress candidate) {
        if (candidate.getAddressType() == 4) {
            this.m_POICandidates.m_candidateList.add(candidate);
        } else {
            this.m_Candidates.m_candidateList.add(candidate);
        }
    }

    public void setCandidateType(byte candidateType) {
        this.m_CandidateType = candidateType;
    }

    public void setAdditionalInfo(String key, Object info) {
        if (this.m_additionalInfoMap == Collections.EMPTY_MAP) {
            this.m_additionalInfoMap = new HashMap<String, Object>();
        }
        this.m_additionalInfoMap.put(key, info);
    }

    public <T> T getAdditionalInfo(String key) {
        return (T)this.m_additionalInfoMap.get(key);
    }

    public static boolean isEmpty(InternalCandidateList candList) {
        return candList == null || !candList.hasCandidates();
    }

    private static class GeocodeTypeCloseCandidates {
        private int m_numberOfCloseMatches;
        private List<InternalScoringAddress> m_candidateList;

        public GeocodeTypeCloseCandidates(int closeMatchCount, List<InternalScoringAddress> candidates) {
            this.m_numberOfCloseMatches = closeMatchCount;
            this.m_candidateList = candidates;
        }

        public int getCandidateCount() {
            return this.m_candidateList == null ? 0 : this.m_candidateList.size();
        }

        public boolean hasCandidates() {
            return this.m_candidateList != null && !this.m_candidateList.isEmpty();
        }

        public boolean hasCloseCandidates() {
            return this.m_numberOfCloseMatches > 0;
        }
    }

    private class CloseMatchSorter
    implements Comparator<InternalScoringAddress> {
        private CloseMatchSorter() {
        }

        @Override
        public int compare(InternalScoringAddress firstScoringAddress, InternalScoringAddress secondScoringAddress) {
            if (firstScoringAddress.isCloseMatch() && !secondScoringAddress.isCloseMatch()) {
                return -1;
            }
            if (!firstScoringAddress.isCloseMatch() && secondScoringAddress.isCloseMatch()) {
                return 1;
            }
            return 0;
        }
    }

    private class StreetPreferenceSorter
    implements Comparator<InternalScoringAddress> {
        private StreetPreferenceSorter() {
        }

        @Override
        public int compare(InternalScoringAddress firstScoringAddress, InternalScoringAddress secondScoringAddress) {
            int firstCandidateType = firstScoringAddress.getAddressType();
            int secondCandidateType = secondScoringAddress.getAddressType();
            if (firstScoringAddress.isCloseMatch() || secondScoringAddress.isCloseMatch()) {
                if (firstCandidateType == 1 && secondCandidateType == 4) {
                    return -1;
                }
                if (firstCandidateType == 4 && secondCandidateType == 1) {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class POIPreferenceSorter
    implements Comparator<InternalScoringAddress> {
        private POIPreferenceSorter() {
        }

        @Override
        public int compare(InternalScoringAddress firstScoringAddress, InternalScoringAddress secondScoringAddress) {
            int firstCandidateType = firstScoringAddress.getAddressType();
            int secondCandidateType = secondScoringAddress.getAddressType();
            if (firstScoringAddress.isCloseMatch() || secondScoringAddress.isCloseMatch()) {
                if (firstCandidateType == 4 && secondCandidateType == 1) {
                    return -1;
                }
                if (firstCandidateType == 1 && secondCandidateType == 4) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

