/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.dp.ISAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.SAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.utils.IntArray;

public class SAFileIndexEntryCompact
implements ISAFileIndexEntry {
    private int m_sac;
    private long m_dataOffset;
    private int m_dataSize;
    private int m_codedWordsStartOffset;
    private int m_addressOffsetsStartOffset;
    private int m_handleAddressEndOffset;
    private int m_areaTermsStartOffset;

    private SAFileIndexEntryCompact() {
    }

    public static boolean canBeCompacted(SAFileIndexEntry entry) {
        return entry.getSacs().size() == 1 && entry.getDataSize() <= Integer.MAX_VALUE;
    }

    public static SAFileIndexEntryCompact getInstance(SAFileIndexEntry entry) {
        if (!SAFileIndexEntryCompact.canBeCompacted(entry)) {
            throw new IllegalArgumentException("Entry cannot be compacted");
        }
        SAFileIndexEntryCompact compactEntry = new SAFileIndexEntryCompact();
        compactEntry.m_sac = entry.getSacs().get(0);
        compactEntry.m_dataSize = (int)entry.getDataSize();
        compactEntry.m_dataOffset = entry.getDataOffset();
        compactEntry.m_codedWordsStartOffset = (int)(entry.getCodedWordsStartOffset() - entry.getDataOffset());
        compactEntry.m_addressOffsetsStartOffset = (int)(entry.getAddressOffsetsStartOffset() - entry.getDataOffset());
        compactEntry.m_handleAddressEndOffset = (int)(entry.getHandleAddressEndOffset() - entry.getDataOffset());
        compactEntry.m_areaTermsStartOffset = (int)(entry.getAreaTermsStartOffset() - entry.getDataOffset());
        return compactEntry;
    }

    @Override
    public long getAddressOffsetsStartOffset() {
        return this.m_dataOffset + (long)this.m_addressOffsetsStartOffset;
    }

    @Override
    public long getAreaTermsStartOffset() {
        return this.m_dataOffset + (long)this.m_areaTermsStartOffset;
    }

    @Override
    public long getDataOffset() {
        return this.m_dataOffset;
    }

    @Override
    public long getDataSize() {
        return this.m_dataSize;
    }

    @Override
    public long getCodedWordsStartOffset() {
        return this.m_dataOffset + (long)this.m_codedWordsStartOffset;
    }

    @Override
    public long getHandleAddressEndOffset() {
        return this.m_dataOffset + (long)this.m_handleAddressEndOffset;
    }

    @Override
    public IntArray getSacs() {
        IntArray array = new IntArray(1);
        array.add(this.m_sac);
        return array;
    }
}

