/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SacCreator {
    private HashMap<String, Integer> m_sacMap = new HashMap();
    private AtomicInteger m_sacCounter = new AtomicInteger(100);
    private Pattern m_sacPattern;

    public void setPattern(String regex) throws InvalidSacException {
        try {
            this.m_sacPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException pse) {
            throw new InvalidSacException("Invalid regular expression for sac creation");
        }
        catch (NullPointerException pse) {
            throw new InvalidSacException("Invalid regular expression for sac creation");
        }
    }

    public final int getSac(String fieldVal) {
        int sac = -1;
        if (fieldVal != null && fieldVal.trim().length() > 0) {
            Integer sacObj;
            if (this.m_sacPattern != null) {
                Matcher m = this.m_sacPattern.matcher(fieldVal);
                if (m.find()) {
                    fieldVal = fieldVal.substring(m.start(), m.end());
                } else {
                    return sac;
                }
            }
            if ((sacObj = this.m_sacMap.get(fieldVal)) == null) {
                sacObj = this.m_sacCounter.incrementAndGet();
                this.m_sacMap.put(fieldVal, sacObj);
            }
            sac = sacObj;
        }
        return sac;
    }
}

