/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class WordDictionary {
    private static final int MAX_GROUPS = (int)(Math.pow(2.0, 17.0) - 1.0);
    private static final int MAX_GROUP_WORDS = (int)(Math.pow(2.0, 14.0) - 1.0);
    private static final int OFFSET_SHIFT = 15;
    private CodedWordGroupItem[] m_dictionaryItems = null;
    private boolean m_bLoaded = false;
    private HashItem[] m_hashRanges;
    private int m_soundexGroupCount;
    private int m_largestGroupWordCount;
    private ICGGESoundex m_soundex;
    private ICGGEParser m_parser;
    private static final String DATA_NOT_INIT_MSG = "Word Dictionary is not initialised";
    private static final char WORD_SEPERATOR = '|';
    private boolean m_isBigDictionary;

    protected boolean loadDictionary(InputStream stream, ICGGEParser parser, ICGGESoundex soundex) throws IOException {
        if (stream == null) {
            throw new NullPointerException("parameter stream is null");
        }
        if (parser == null) {
            throw new NullPointerException("parameter parser is null");
        }
        if (soundex == null) {
            throw new NullPointerException("parameter soundex is null");
        }
        this.m_parser = parser;
        this.m_soundex = soundex;
        InputStreamReader in = new InputStreamReader(stream, "UTF-8");
        BufferedReader r = new BufferedReader(in);
        this.m_bLoaded = false;
        ArrayList<CodedWordGroupItem> tempList = new ArrayList<CodedWordGroupItem>(5000);
        String line = null;
        int n = 0;
        while ((line = r.readLine()) != null) {
            ++n;
            String[] words = MMUtils.splitString(line, '|');
            if (words == null || words.length <= 0) continue;
            int sndx = soundex.getSoundex(words[0]);
            CodedWordGroupItem wordItem = new CodedWordGroupItem(sndx, words);
            tempList.add(wordItem);
            ++this.m_soundexGroupCount;
            if (words.length <= this.m_largestGroupWordCount) continue;
            this.m_largestGroupWordCount = words.length;
        }
        r.close();
        int size = tempList.size();
        if (size > 0) {
            this.m_dictionaryItems = tempList.toArray(new CodedWordGroupItem[size]);
            this.m_hashRanges = new HashItem[21];
            int averageSize = size / 20;
            int j = 0;
            if (averageSize < 100) {
                averageSize = 100;
            }
            int i = averageSize;
            while (i < size) {
                HashItem hashItem = new HashItem();
                hashItem.soundex = this.m_dictionaryItems[i].m_soundex;
                hashItem.endNdx = i;
                this.m_hashRanges[j] = hashItem;
                i += averageSize;
                ++j;
            }
            if (j < this.m_hashRanges.length) {
                HashItem[] temp = new HashItem[j];
                System.arraycopy(this.m_hashRanges, 0, temp, 0, j);
                this.m_hashRanges = temp;
            }
        }
        this.m_isBigDictionary = this.m_soundexGroupCount > MAX_GROUPS || this.m_largestGroupWordCount > MAX_GROUP_WORDS;
        this.m_bLoaded = true;
        return this.m_bLoaded;
    }

    public boolean loadDictionary(String fileName, CGGEHandler handler) throws Exception {
        FileInputStream stream = new FileInputStream(fileName);
        boolean loaded = this.loadDictionary(stream, handler.getParser(), handler.getSoundex());
        ((InputStream)stream).close();
        return loaded;
    }

    public final char[] getWordChars(int soundex, int offset) throws DataNotInitialisedException {
        int ndx = this.indexOf(soundex);
        if (ndx > -1) {
            CodedWordGroupItem wordGroup = this.m_dictionaryItems[ndx];
            if (wordGroup.m_groupWords.length > offset) {
                return wordGroup.m_groupWords[offset].getChars();
            }
        }
        return null;
    }

    private final ICGGEParser getParser() {
        return this.m_parser;
    }

    public final ICGGESoundex getSoundex() {
        return this.m_soundex;
    }

    private final int indexOf(int soundex) throws DataNotInitialisedException {
        if (!this.m_bLoaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        int startNdx = 0;
        int endNdx = 0;
        if (this.m_dictionaryItems != null && this.m_dictionaryItems.length > 0) {
            for (HashItem hashItem : this.m_hashRanges) {
                int soundexRange = hashItem.soundex;
                if (soundexRange >= soundex) {
                    endNdx = hashItem.endNdx;
                    break;
                }
                startNdx = hashItem.endNdx;
            }
            if (endNdx == 0) {
                endNdx = this.m_dictionaryItems.length - 1;
            }
            int low = startNdx;
            int high = endNdx;
            while (low <= high) {
                int mid = low + high >> 1;
                int current = this.m_dictionaryItems[mid].m_soundex - soundex;
                if (current < 0) {
                    low = mid + 1;
                    continue;
                }
                if (current > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
        }
        return -1;
    }

    private int getSoundexPos(String word) throws DataNotInitialisedException {
        if (!this.m_bLoaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        return this.getSoundexPos(this.getSoundex().getSoundex(word));
    }

    protected int getSoundexPos(int soundex) throws DataNotInitialisedException {
        return this.indexOf(soundex);
    }

    protected List<AddressWord> getMatchingWords(Iterator<CodedWord> codedWordIt, AddressWord searchWord, ICGGEScorer scorer, double minQuality) {
        ArrayList<AddressWord> matchedWords = null;
        while (codedWordIt.hasNext()) {
            CodedWord codedWord = codedWordIt.next();
            double score = 0.0;
            AddressWord addrWord = new AddressWord(codedWord);
            if (minQuality < 1.0) {
                score = scorer.scoreAddressWords(searchWord, addrWord);
            } else if (scorer.doWordsMatch(searchWord, addrWord)) {
                score = 1.0;
            }
            if (!(score >= minQuality)) continue;
            addrWord.m_quality = score;
            if (matchedWords == null) {
                matchedWords = new ArrayList<AddressWord>(5);
            }
            matchedWords.add(addrWord);
        }
        return matchedWords;
    }

    public List<AddressWord> getMatchingWords(AddressWord searchWord, ICGGEScorer scorer, double minQuality) throws DataNotInitialisedException {
        List<WordAlternate> altList;
        Iterator<CodedWord> groupWordIt = this.getCodedWordGroupIterator(searchWord.getSoundex());
        List<AddressWord> matchedWords = null;
        if (groupWordIt != null) {
            matchedWords = this.getMatchingWords(groupWordIt, searchWord, scorer, minQuality);
        }
        if ((altList = searchWord.getAlternates()) != null) {
            Iterator<WordAlternate> altWordIt = altList.iterator();
            short wordAttribs = searchWord.getAttributes();
            while (altWordIt.hasNext()) {
                AddressWord altSearchWord;
                WordAlternate altWord = altWordIt.next();
                WordAlternate.ALT_TYPE altType = altWord.getAltType();
                if (altType == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION || !(CodedWord.isAbbreviation(wordAttribs) && altType == WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION || CodedWord.isNumeric(wordAttribs) && altType == WordAlternate.ALT_TYPE.TYPE_NUMER || CodedWord.isThoroughfareTypeWord(wordAttribs) && altType == WordAlternate.ALT_TYPE.THOROUGHFARE_TYPE) && (CodedWord.isAbbreviatable(wordAttribs) || CodedWord.isAbbreviation(altWord.getAltWord().getAttributes())) || (groupWordIt = this.getCodedWordGroupIterator((altSearchWord = altWord.getAltWord()).getSoundex())) == null) continue;
                List<AddressWord> altMatchedWords = this.getMatchingWords(groupWordIt, altSearchWord, scorer, 1.0);
                if (matchedWords == null) {
                    matchedWords = altMatchedWords;
                    continue;
                }
                if (altMatchedWords == null) continue;
                matchedWords.addAll(altMatchedWords);
            }
        }
        return matchedWords;
    }

    public int getSoundexGroupCount() throws DataNotInitialisedException {
        if (!this.m_bLoaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        return this.m_soundexGroupCount;
    }

    public final CodedWord getCodedWord(String word) throws DataNotInitialisedException {
        Iterator<CodedWord> codedWordIt;
        if (!this.m_bLoaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        if (word != null && word.length() > 0 && (codedWordIt = this.getCodedWordGroupIterator(this.getSoundex().getSoundex(word))) != null) {
            char[] searchChars = word.toUpperCase().toCharArray();
            while (codedWordIt.hasNext()) {
                CodedWord codedWord = codedWordIt.next();
                if (!Arrays.equals(searchChars, codedWord.getChars())) continue;
                return codedWord;
            }
        }
        return null;
    }

    private final CodedWord getFromIndexAndOffset(int ndx, int offset) throws DataNotInitialisedException {
        if (!this.m_bLoaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        if (ndx > -1 && ndx < this.m_dictionaryItems.length) {
            CodedWordGroupItem wordGroup = this.m_dictionaryItems[ndx];
            if (offset > -1 && offset < wordGroup.m_groupWords.length) {
                CodedWord codedWord = wordGroup.m_groupWords[offset];
                if (codedWord.getWordCode() == -1L) {
                    codedWord.setWordCode(this.createCode(ndx, offset));
                }
                return codedWord;
            }
        }
        return null;
    }

    public final CodedWord getCodedWord(int soundex, int offset) throws DataNotInitialisedException {
        int ndx = this.getSoundexPos(soundex);
        return this.getFromIndexAndOffset(ndx, offset);
    }

    public final CodedWord getCodedWord(long wordCode) throws DataNotInitialisedException {
        int[] ndxAndOffset = this.getNdxAndOffsetFromCode(wordCode);
        return this.getFromIndexAndOffset(ndxAndOffset[0], ndxAndOffset[1]);
    }

    protected long createCode(int ndx, int offset) {
        long code = 0L;
        if (!this.isBigDictionary()) {
            if (ndx > MAX_GROUPS) {
                throw new NumberFormatException("should be less than 131071 current value is" + ndx);
            }
            code |= (long)ndx << 15;
            if (offset > MAX_GROUP_WORDS) {
                throw new NumberFormatException("should be less than 16383 current value is" + offset);
            }
            if ((long)offset > 0xFFFFFFFEL) {
                throw new NumberFormatException("Offset cannot be more than 4294967294");
            }
            code |= (long)offset;
        } else {
            code |= (long)ndx << 32;
            code |= (long)offset;
        }
        return code;
    }

    public boolean isBigDictionary() {
        return this.m_isBigDictionary;
    }

    protected int[] getNdxAndOffsetFromCode(long code) {
        int ndx = 0;
        int offset = 0;
        if (!this.isBigDictionary()) {
            ndx = (int)(code >> 15);
            offset = (int)(code & (long)MAX_GROUP_WORDS);
        } else {
            ndx = (int)(code >> 32);
            offset = (int)(code & 0xFFFFFFFFFFFFFFFFL);
        }
        return new int[]{ndx, offset};
    }

    protected void setBigDictionary(boolean b) {
        this.m_isBigDictionary = b;
    }

    public static int writeWordDictionary(OutputStream outStream, Map<Integer, List<String>> sndxToWordMap) throws Exception {
        int highestWordCount = 0;
        int totalWords = 0;
        int written = 0;
        OutputStreamWriter out = new OutputStreamWriter(outStream, "UTF-8");
        PrintWriter w = new PrintWriter(out);
        if (sndxToWordMap != null) {
            Iterator<Map.Entry<Integer, List<String>>> it = sndxToWordMap.entrySet().iterator();
            int lastSoundex = -1;
            while (it.hasNext()) {
                Map.Entry<Integer, List<String>> entry = it.next();
                int currentSoundex = entry.getKey();
                if (currentSoundex < lastSoundex) {
                    throw new Exception("Soundex is out of order.  sndxToWordMap must be order with keys in ascending order");
                }
                lastSoundex = currentSoundex;
                List<String> words = entry.getValue();
                int wordSize = words.size();
                totalWords += wordSize;
                if (wordSize > highestWordCount) {
                    highestWordCount = wordSize;
                }
                for (int j = 0; j < wordSize; ++j) {
                    w.write(words.get(j));
                    if (j == words.size() - 1) continue;
                    w.write(124);
                }
                ++written;
                w.println();
            }
        }
        w.flush();
        w.close();
        return written;
    }

    protected Iterator<CodedWord> getCodedWordGroupIterator(int soundex) throws DataNotInitialisedException {
        final int ndx = this.indexOf(soundex);
        if (ndx > -1) {
            final CodedWordGroupItem groupItem = this.m_dictionaryItems[ndx];
            return new Iterator<CodedWord>(){
                private CodedWord[] m_groupWords;
                private int m_currentOffset;
                private int m_ndx;
                {
                    this.m_groupWords = groupItem.m_groupWords;
                    this.m_currentOffset = 0;
                    this.m_ndx = ndx;
                }

                @Override
                public boolean hasNext() {
                    return this.m_currentOffset < this.m_groupWords.length;
                }

                @Override
                public CodedWord next() {
                    if (this.hasNext()) {
                        CodedWord codedWord = this.m_groupWords[this.m_currentOffset];
                        if (codedWord.getWordCode() <= 0L) {
                            codedWord.setWordCode(WordDictionary.this.createCode(this.m_ndx, this.m_currentOffset));
                        }
                        ++this.m_currentOffset;
                        return codedWord;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove items");
                }
            };
        }
        return null;
    }

    private final class CodedWordGroupItem {
        int m_soundex;
        CodedWord[] m_groupWords;

        CodedWordGroupItem(int soundex, String[] words) {
            int nWords;
            this.m_soundex = soundex;
            int n = nWords = words == null ? 0 : words.length;
            if (nWords > 0) {
                ICGGEParser parser = WordDictionary.this.getParser();
                ICGGESoundex sndxHandler = WordDictionary.this.getSoundex();
                this.m_groupWords = new CodedWord[nWords];
                for (int i = 0; i < nWords; ++i) {
                    String word = words[i];
                    CodedWord codedWord = parser.convertToCodedWord(word, sndxHandler);
                    codedWord.setSoundex(soundex);
                    codedWord.setOffset(i);
                    this.m_groupWords[i] = codedWord;
                }
            }
        }
    }

    final class HashItem {
        int soundex;
        int endNdx;

        HashItem() {
        }
    }
}

