/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.AreaTerm;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.FieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AddressKeyHandler {
    public static final String OPTIONAL_PREFIX = "?";
    private List<SearchKeyField> m_addressSearchFields = null;
    private List<SearchKeyField> m_sacSearchFields = null;

    protected AddressKeyHandler() {
    }

    public AddressKeyHandler(Properties properties, IDictionaryMetaData metadata) throws InvalidFieldException {
        if (properties == null) {
            throw new NullPointerException("Argument properties cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("Argument metadata cannot be null");
        }
        this.addAddressKeyFieldsFromString(properties.getProperty("StreetSearchFields"), metadata);
        this.addSacKeyFieldsFromString(properties.getProperty("SacSearchFields"), metadata);
    }

    public List<FieldType> getAddressSearchKeyFields(InternalAddress addr) {
        return this.getSearchKeyFields(addr, this.m_addressSearchFields);
    }

    public List<FieldType> getAddressSearchKeyFields() {
        return this.getFieldList(this.m_addressSearchFields);
    }

    public List<FieldType> getSacSearchKeyFields() {
        return this.getFieldList(this.m_sacSearchFields);
    }

    public boolean isAddressSearchKeyField(FieldType type) {
        return this.isKeyField(type, this.m_addressSearchFields);
    }

    public boolean isAddressSearchKeyField(FieldType type, InternalAddress addr) {
        List<FieldType> fields = this.getAddressSearchKeyFields(addr);
        return fields != null && fields.contains(type);
    }

    public boolean isSacSearchKeyField(FieldType type, InternalAddress addr) {
        List<FieldType> fields = this.getSacSearchKeyFields(addr);
        return fields != null && fields.contains(type);
    }

    public boolean isSacSearchKeyField(FieldType type, RawAddress addr) {
        List<FieldType> sacFields = this.getSearchKeyFields(addr, this.m_sacSearchFields);
        return sacFields != null && sacFields.contains(type);
    }

    public boolean isSacSearchKeyField(FieldType type) {
        return this.isKeyField(type, this.m_sacSearchFields);
    }

    public boolean isOptionalAddressSearchKeyField(FieldType type) {
        return this.isOptionalKeyField(type, this.m_addressSearchFields);
    }

    public boolean isOptionalSacSearchKeyField(FieldType type) {
        return this.isOptionalKeyField(type, this.m_sacSearchFields);
    }

    private boolean isOptionalKeyField(FieldType type, List<SearchKeyField> searchFieldCheckList) {
        for (SearchKeyField keyField : searchFieldCheckList) {
            if (keyField.m_type != type || !keyField.m_optional) continue;
            return true;
        }
        return false;
    }

    private boolean isKeyField(FieldType type, List<SearchKeyField> searchFieldCheckList) {
        for (SearchKeyField keyField : searchFieldCheckList) {
            if (keyField.m_type != type) continue;
            return true;
        }
        return false;
    }

    public List<FieldType> getSacSearchKeyFields(InternalAddress addr) {
        return this.getSearchKeyFields(addr, this.m_sacSearchFields);
    }

    private List<FieldType> getSearchKeyFields(RawAddress addr, List<SearchKeyField> searchFieldCheckList) {
        ArrayList<FieldType> searchFields = null;
        boolean streetSearchFieldFound = false;
        boolean rangeSearchFieldFound = false;
        boolean unitSearchFieldFound = false;
        for (SearchKeyField searchfield : searchFieldCheckList) {
            FieldType field = searchfield.m_type;
            if (!this.isFieldValueAvailable(addr, field)) continue;
            boolean add = false;
            if (this.doesLevelMatch(searchfield, FieldType.FieldLevel.LEVEL_STREET)) {
                if (!searchfield.m_optional || !streetSearchFieldFound) {
                    add = true;
                    streetSearchFieldFound = true;
                }
            } else if (this.doesLevelMatch(searchfield, FieldType.FieldLevel.LEVEL_RANGE)) {
                if (!searchfield.m_optional || !rangeSearchFieldFound) {
                    add = true;
                    rangeSearchFieldFound = true;
                }
            } else if (!(!this.doesLevelMatch(searchfield, FieldType.FieldLevel.LEVEL_UNIT) || searchfield.m_optional && unitSearchFieldFound)) {
                add = true;
                unitSearchFieldFound = true;
            }
            if (!add) continue;
            if (searchFields == null) {
                searchFields = new ArrayList<FieldType>();
            }
            searchFields.add(field);
        }
        return searchFields;
    }

    private List<FieldType> getSearchKeyFields(InternalAddress addr, List<SearchKeyField> searchFieldCheckList) {
        FieldType.FieldLevel addrLevel = this.getLevel(addr);
        ArrayList<FieldType> searchFields = null;
        for (SearchKeyField searchfield : searchFieldCheckList) {
            FieldType field = searchfield.m_type;
            if (!this.doesLevelMatch(searchfield, addrLevel)) continue;
            boolean fieldAvailable = false;
            fieldAvailable = addr instanceof InternalStreetAddress ? this.isFieldValueAvailable((InternalStreetAddress)addr, field) : this.isFieldValueAvailable(addr, field);
            if (!fieldAvailable || searchFields != null && searchfield.m_optional) continue;
            if (searchFields == null) {
                searchFields = new ArrayList<FieldType>();
            }
            searchFields.add(field);
        }
        return searchFields;
    }

    private boolean doesLevelMatch(SearchKeyField searchFieldKey, FieldType.FieldLevel addrLevel) {
        if (addrLevel == FieldType.FieldLevel.LEVEL_STREET) {
            return searchFieldKey.m_type.getLevel() == FieldType.FieldLevel.LEVEL_STREET || searchFieldKey.m_type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL;
        }
        return searchFieldKey.m_type.getLevel() == addrLevel;
    }

    private FieldType.FieldLevel getLevel(InternalAddress addr) {
        if (addr instanceof InternalStreetAddress) {
            return FieldType.FieldLevel.LEVEL_STREET;
        }
        if (addr instanceof InternalRangeAddress) {
            return FieldType.FieldLevel.LEVEL_RANGE;
        }
        if (addr instanceof InternalUnitAddress) {
            return FieldType.FieldLevel.LEVEL_UNIT;
        }
        return FieldType.FieldLevel.LEVEL_UNKNOWN;
    }

    private boolean isFieldValueAvailable(FieldValue<?> value) {
        return value != null && !value.isEmpty();
    }

    protected boolean isFieldValueAvailable(InternalAddress addr, FieldType type) {
        InternalFieldValue value = (InternalFieldValue)addr.getField(type);
        return this.isFieldValueAvailable(value);
    }

    protected boolean isFieldValueAvailable(InternalStreetAddress addr, FieldType type) {
        AreaTerm[] areas;
        boolean fieldAvailable = this.isFieldValueAvailable((FieldValue)addr.getField(type));
        if (!fieldAvailable && type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL && (areas = addr.getTerms()) != null) {
            for (AreaTerm area : areas) {
                if (area.getTermType() != type) continue;
                fieldAvailable = true;
                break;
            }
        }
        return fieldAvailable;
    }

    protected boolean isFieldValueAvailable(RawAddress addr, FieldType type) {
        AddressFieldValue value = (AddressFieldValue)addr.getField(type);
        return value != null && !value.isEmpty();
    }

    protected void addAddressKeyFieldsFromString(String fields, IDictionaryMetaData metaData) throws InvalidFieldException {
        if (fields == null) {
            throw new NullPointerException("Fields cannot be null");
        }
        this.m_addressSearchFields = this.parseFields(fields, metaData);
    }

    protected void addSacKeyFieldsFromString(String fields, IDictionaryMetaData metaData) throws InvalidFieldException {
        if (fields == null) {
            throw new NullPointerException("Fields cannot be null");
        }
        this.m_sacSearchFields = this.parseFields(fields, metaData);
    }

    private List<SearchKeyField> parseFields(String fields, IDictionaryMetaData metaData) throws InvalidFieldException {
        String[] fieldNames;
        ArrayList<SearchKeyField> searchFields = null;
        for (String fieldName : fieldNames = fields.split(",")) {
            fieldName = fieldName.trim();
            boolean optional = false;
            if (fieldName.startsWith(OPTIONAL_PREFIX)) {
                optional = true;
                fieldName = fieldName.length() > OPTIONAL_PREFIX.length() ? fieldName.substring(OPTIONAL_PREFIX.length()).trim() : null;
            }
            FieldType type = this.getFieldType(fieldName, metaData);
            SearchKeyField searchKeyField = new SearchKeyField(type, optional);
            if (searchFields == null) {
                searchFields = new ArrayList<SearchKeyField>();
            }
            searchFields.add(searchKeyField);
        }
        return searchFields;
    }

    private FieldType getFieldType(String name, IDictionaryMetaData metadata) throws InvalidFieldException {
        if (name == null) {
            throw new InvalidFieldException("Field name cannot be null");
        }
        int fieldKey = metadata.getKeyForField(name);
        if (fieldKey == -1) {
            throw new InvalidFieldException("Specified field name \"" + name + "\" is not a valid name");
        }
        return metadata.getFieldType(fieldKey);
    }

    private List<FieldType> getFieldList(List<SearchKeyField> searchKeyFields) {
        ArrayList<FieldType> fields = null;
        if (searchKeyFields != null) {
            fields = new ArrayList<FieldType>(searchKeyFields.size());
            for (SearchKeyField searchKeyField : searchKeyFields) {
                fields.add(searchKeyField.m_type);
            }
        }
        return fields;
    }

    private class SearchKeyField {
        FieldType m_type;
        boolean m_optional;

        SearchKeyField(FieldType type, boolean optional) {
            this.m_type = type;
            this.m_optional = optional;
        }
    }
}

