/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.AreaTerm;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.AddressHandleWords;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler;
import com.mapinfo.mapmarker.cgge.dp.SAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.builder.AddressKeyHandler;
import com.mapinfo.mapmarker.cgge.dp.builder.DataCreationOptions;
import com.mapinfo.mapmarker.cgge.dp.builder.InternalStreetObject;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.io.ByteArrayDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAddressHandle {
    private int m_sac;
    private List<InternalStreetAddress> m_addressList = new ArrayList<InternalStreetAddress>(100);
    private long[] m_addressOffsets;
    private int m_numberOfCodedWords;
    private int m_numberOfAreaTerms;
    private List<AreaTerm> m_handleAreaTermList;
    private AddressHandleWords m_handleWords;
    private final List<InternalStreetObject> m_internalAddressList = new ArrayList<InternalStreetObject>();
    private InternalAddressIOHandler m_addrIOHandler;
    public static Logger logger = LoggerFactory.getLogger(DataAddressHandle.class);
    private AreaMetaData m_areaMetaData;

    public void addAddress(InternalStreetAddress address) {
        this.m_addressList.add(address);
    }

    void sortAndMergeStreetAddresses() {
        if (this.m_addressList.size() == 0) {
            return;
        }
        Collections.sort(this.m_addressList);
        ArrayList<InternalStreetAddress> mergedAddressList = new ArrayList<InternalStreetAddress>();
        InternalStreetAddress lastAddr = this.m_addressList.get(0);
        for (int i = 1; i < this.m_addressList.size(); ++i) {
            InternalStreetAddress addr = this.m_addressList.get(i);
            if (lastAddr.isSameStreet(addr)) {
                lastAddr.merge(addr);
                continue;
            }
            lastAddr.sortAndMergeRanges();
            mergedAddressList.add(lastAddr);
            lastAddr = addr;
        }
        lastAddr.sortAndMergeRanges();
        mergedAddressList.add(lastAddr);
        this.m_addressList = mergedAddressList;
    }

    private void addWordsToHandle(AddressHandleWords handleWords, List<AddressWord> addrWords, InternalAddress addr, int addressNdx, DataCreationOptions options) {
        int wordCount;
        int n = wordCount = addrWords == null ? 0 : addrWords.size();
        if (wordCount > 0) {
            AddressKeyHandler handler = options.getAddressKeyHandler();
            for (int i = 0; i < wordCount; ++i) {
                List<WordAlternate> wordAlts;
                AddressWord addrWord = addrWords.get(i);
                FieldType type = addrWord.m_wordType;
                if (addrWord.m_wordType == FieldType.POST_THOROUGHFARE_FIELD_TYPE || addrWord.m_wordType == FieldType.PRE_THOROUGHFARE_FIELD_TYPE || addrWord.m_wordType == FieldType.PRE_DIRECTIONAL_FIELD_TYPE || addrWord.m_wordType == FieldType.POST_DIRECTIONAL_FIELD_TYPE) {
                    type = FieldType.STREET_NAME_FIELD_TYPE;
                }
                if (addrWord.m_quality < 0.75 || addrWord.getSoundex() == 0 || !handler.isAddressSearchKeyField(type, addr)) {
                    type = FieldType.UNKNOWN_FIELD_TYPE;
                }
                handleWords.addWordCode(addrWord.getCodedWord().getWordCode(), type, addressNdx);
                if (type == FieldType.UNKNOWN_FIELD_TYPE || (wordAlts = addrWord.getAlternates()) == null) continue;
                for (WordAlternate wordAlt : wordAlts) {
                    if (wordAlt.getAltType() == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                    AddressWord altWord = wordAlt.getAltWord();
                    handleWords.addWordCode(altWord.getCodedWord().getWordCode(), type, addressNdx);
                }
            }
        }
    }

    private AddressHandleWords createAddressHandleWords(DataCreationOptions options) {
        AddressHandleWords handleWords = new AddressHandleWords(options.getDictionaryMetaData());
        int addrCount = this.m_addressList.size();
        handleWords.setAddressCount(addrCount);
        List<AddressWord> addrWordList = null;
        AddressKeyHandler addressKeyHandler = options.getAddressKeyHandler();
        for (int addrNdx = 0; addrNdx < addrCount; ++addrNdx) {
            List<FieldType> addrKeyfields;
            InternalStreetAddress addr = this.m_addressList.get(addrNdx);
            addrWordList = addr.getAddressWords(FieldType.FieldLevel.LEVEL_STREET, options.getDictionaryMetaData());
            this.addWordsToHandle(handleWords, addrWordList, addr, addrNdx, options);
            List<InternalRangeAddress> rangeList = addr.getRangeList();
            if (rangeList != null) {
                for (int j = 0; j < rangeList.size(); ++j) {
                    InternalRangeAddress range = rangeList.get(j);
                    addrWordList = range.getAddressWords(FieldType.FieldLevel.LEVEL_RANGE, options.getDictionaryMetaData());
                    this.addWordsToHandle(handleWords, addrWordList, range, addrNdx, options);
                    List<InternalUnitAddress> units = range.getUnits();
                    int unitCount = units == null ? 0 : units.size();
                    for (int u = 0; u < unitCount; ++u) {
                        InternalUnitAddress unit = units.get(u);
                        addrWordList = unit.getAddressWords(FieldType.FieldLevel.LEVEL_UNIT, options.getDictionaryMetaData());
                        this.addWordsToHandle(handleWords, addrWordList, unit, addrNdx, options);
                    }
                }
            }
            if ((addrKeyfields = addressKeyHandler.getAddressSearchKeyFields(addr)) == null) continue;
            Iterator<FieldType> it = addrKeyfields.iterator();
            addrWordList = null;
            while (it.hasNext()) {
                List<AddressWord> termWords;
                FieldType type = it.next();
                if (type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL || (termWords = this.getTermWords(addr, type)) == null) continue;
                if (addrWordList == null) {
                    addrWordList = new ArrayList<AddressWord>(10);
                }
                addrWordList.addAll(termWords);
            }
            if (addrWordList == null) continue;
            this.addWordsToHandle(handleWords, addrWordList, addr, addrNdx, options);
        }
        return handleWords;
    }

    private List<AddressWord> getTermWords(InternalStreetAddress addr, FieldType type) {
        ArrayList<AddressWord> retList = null;
        AreaTerm[] terms = addr.getTerms();
        int termCount = terms == null ? 0 : terms.length;
        for (int termNdx = 0; termNdx < termCount; ++termNdx) {
            AreaTerm term = terms[termNdx];
            if (term.getTermType() != type) continue;
            AddressWord[] words = term.getAreaWords();
            int wordCount = words == null ? 0 : words.length;
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                if (retList == null) {
                    retList = new ArrayList<AddressWord>(10);
                }
                retList.add(words[wordNdx]);
            }
            AreaTerm[] altTerms = term.getAlternateTerms();
            if (altTerms == null) continue;
            for (int altNdx = 0; altNdx < altTerms.length; ++altNdx) {
                words = altTerms[altNdx].getAreaWords();
                wordCount = words == null ? 0 : words.length;
                for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                    if (retList == null) {
                        retList = new ArrayList(10);
                    }
                    retList.add(words[wordNdx]);
                }
            }
        }
        return retList;
    }

    private List<AreaTerm> createAreaHandle(DataCreationOptions options) {
        int addrCount = this.m_addressList.size();
        ArrayList<AreaTerm> areaTermList = new ArrayList<AreaTerm>(50);
        for (int addrNdx = 0; addrNdx < addrCount; ++addrNdx) {
            InternalStreetAddress addr = this.m_addressList.get(addrNdx);
            ArrayList<Integer> addrTermNdxList = null;
            AreaTerm[] terms = addr.getTerms();
            if (terms != null && terms.length > 0) {
                addrTermNdxList = new ArrayList<Integer>(10);
                for (int j = 0; j < terms.length; ++j) {
                    AreaTerm term = terms[j];
                    int ndx = areaTermList.lastIndexOf(term);
                    if (ndx == -1) {
                        ndx = areaTermList.size();
                        areaTermList.add(term);
                    }
                    addrTermNdxList.add(ndx);
                    AreaTerm[] altTerms = term.getAlternateTerms();
                    int altCount = altTerms == null ? 0 : altTerms.length;
                    for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                        term = altTerms[altNdx];
                        ndx = areaTermList.lastIndexOf(term);
                        if (ndx == -1) {
                            ndx = areaTermList.size();
                            areaTermList.add(term);
                        }
                        addrTermNdxList.add(ndx);
                    }
                }
            }
            addr.setAreaTermIndexes(addrTermNdxList);
        }
        return areaTermList;
    }

    public void createIndexes(DataCreationOptions options) throws Exception {
        this.m_handleAreaTermList = this.createAreaHandle(options);
        if (this.m_handleAreaTermList != null && this.m_handleAreaTermList.size() > 65534) {
            throw new DataCreationException("Can't have more than 65534 area terms in a sac handle! Got " + this.m_handleAreaTermList.size());
        }
        this.m_handleWords = this.createAddressHandleWords(options);
        this.assignHandleWordNdxToAddressWords(this.m_handleWords, options);
        this.m_addrIOHandler = InternalAddressIOHandler.getInstance(options.getDictionaryMetaData().getVersion());
    }

    private void assignHandleWordNdxToWords(List<AddressWord> words, AddressHandleWords handleWords) throws DataCreationException {
        int wordCount = words == null ? 0 : words.size();
        for (int i = 0; i < wordCount; ++i) {
            AddressWord word = words.get(i);
            long wordCode = word.getCodedWord().getWordCode();
            int ndx = handleWords.getWordCodeIndex(wordCode);
            if (ndx == -1) {
                throw new DataCreationException("Word not found in address handle...strange!");
            }
            word.setData(ndx);
        }
    }

    private void assignHandleWordNdxToAddressWords(AddressHandleWords handleWords, DataCreationOptions options) throws DataCreationException {
        int addrCount = this.m_addressList.size();
        List<AddressWord> addrWords = null;
        AddressKeyHandler addressKeyHandler = options.getAddressKeyHandler();
        for (int addrNdx = 0; addrNdx < addrCount; ++addrNdx) {
            List<FieldType> addrKeyfields;
            InternalStreetAddress addr = this.m_addressList.get(addrNdx);
            addrWords = addr.getAddressWords(FieldType.FieldLevel.LEVEL_STREET, options.getDictionaryMetaData());
            this.assignHandleWordNdxToWords(addrWords, handleWords);
            List<InternalRangeAddress> rangeList = addr.getRangeList();
            if (rangeList != null) {
                for (int j = 0; j < rangeList.size(); ++j) {
                    InternalRangeAddress range = rangeList.get(j);
                    addrWords = range.getAddressWords(FieldType.FieldLevel.LEVEL_RANGE, options.getDictionaryMetaData());
                    this.assignHandleWordNdxToWords(addrWords, handleWords);
                    List<InternalUnitAddress> units = range.getUnits();
                    int unitCount = units == null ? 0 : units.size();
                    for (int u = 0; u < unitCount; ++u) {
                        InternalUnitAddress unit = units.get(u);
                        addrWords = unit.getAddressWords(FieldType.FieldLevel.LEVEL_UNIT, options.getDictionaryMetaData());
                        this.assignHandleWordNdxToWords(addrWords, handleWords);
                    }
                }
            }
            if ((addrKeyfields = addressKeyHandler.getAddressSearchKeyFields(addr)) == null) continue;
            for (FieldType type : addrKeyfields) {
                if (type.getLevel() == FieldType.FieldLevel.LEVEL_STREET || type.getLevel() == FieldType.FieldLevel.LEVEL_RANGE || type.getLevel() == FieldType.FieldLevel.LEVEL_UNIT) continue;
                addr.setField(type, null);
            }
        }
    }

    void writeDataAndFillIndex(ICGGEDataStream stream, SAFileIndexEntry safie) throws Exception {
        stream.seekEnd();
        safie.setDataOffset(stream.offset());
        safie.setCoordsOffset(stream.offset());
        this.writeAreaMetaData(this.m_areaMetaData, stream);
        stream.writeInt(this.m_addressList.size());
        this.writeAddressHandleWords(stream, safie);
        this.writeAreaTerms(stream, safie);
        safie.setAddressOffsetsStartOffset(stream.offset());
        logger.debug("Num of Addresses : " + this.m_sac + " : " + this.m_addressList.size());
        for (int i = 0; i < this.m_addressList.size(); ++i) {
            stream.writeInt(0);
        }
        WrittenStreetObjectInfo wsoi = this.writeAddressData(stream.offset() + 1L, safie.getAddressOffsetsStartOffset());
        byte[] dataBytes = wsoi.getDataBytes();
        stream.seek(safie.getAddressOffsetsStartOffset());
        wsoi.getAddressOffsets().writeInts(stream);
        if (wsoi.getAddressCount() == 1 || dataBytes.length < 1024) {
            stream.write(1);
            stream.write(dataBytes);
            safie.setDataSize(stream.offset() - safie.getDataOffset());
        } else {
            stream.write(0);
            safie.setDataSize(stream.offset() - safie.getDataOffset());
            stream.write(dataBytes);
        }
        safie.setHandleAddressEndOffset(stream.offset());
        safie.setDataSize(safie.getHandleAddressEndOffset() - safie.getDataOffset());
        this.m_internalAddressList.addAll(wsoi.getInternalStreetObjects());
        logger.debug("SAC Handle Size : " + this.m_sac + " : " + (stream.offset() - safie.getDataOffset()));
    }

    private void writeAreaMetaData(AreaMetaData metaData, ICGGEDataStream stream) throws IOException {
        this.m_addrIOHandler.writeAreaMetaData(metaData, stream);
    }

    private void writeAddressHandleWords(ICGGEDataStream stream, SAFileIndexEntry safie) throws IOException {
        safie.setCodedWordsStartOffset(stream.offset());
        this.m_handleWords.write(stream);
    }

    private void writeAreaTerms(ICGGEDataStream stream, SAFileIndexEntry safie) throws IOException {
        safie.setAreaTermsStartOffset(stream.offset());
        int areaCount = this.m_handleAreaTermList.size();
        stream.writeInt(areaCount);
        logger.debug("Number of AreaTerms : " + this.m_sac + " : " + areaCount);
        for (int i = 0; i < areaCount; ++i) {
            AreaTerm term = this.m_handleAreaTermList.get(i);
            term.write(stream);
        }
    }

    WrittenStreetObjectInfo writeAddressData(long addressDataOffset, long offsetStart) throws IOException, DataCreationException {
        int addrCount = this.m_addressList.size();
        WrittenStreetObjectInfo wsoi = new WrittenStreetObjectInfo(addrCount);
        ByteArrayDataStream ds = DataStreamFactory.getByteArrayDataStream();
        for (int i = 0; i < addrCount; ++i) {
            long bufPos = ds.offset();
            wsoi.addAddressOffset((int)(addressDataOffset + bufPos - offsetStart));
            InternalStreetAddress address = this.m_addressList.get(i);
            this.m_addrIOHandler.write(address, ds);
            int addrSize = (int)(ds.offset() - bufPos);
            wsoi.addInternalStreetObject(new InternalStreetObject(addressDataOffset + bufPos, i, addrSize, address));
            logger.debug("Address Size : " + this.m_sac + "-" + i + " : " + addrSize);
        }
        wsoi.setDataBytes(ds.array());
        ds.close();
        return wsoi;
    }

    public int getSac() {
        return this.m_sac;
    }

    public void setSac(int sac) {
        this.m_sac = sac;
    }

    public List<InternalStreetAddress> getAddressList() {
        return this.m_addressList;
    }

    public long[] getAddressOffsets() {
        return this.m_addressOffsets;
    }

    public void setAddressOffsets(long[] offsets) {
        this.m_addressOffsets = offsets;
    }

    public int getNumberOfCodedWords() {
        return this.m_numberOfCodedWords;
    }

    public void setNumberOfCodedWords(int i) {
        this.m_numberOfCodedWords = i;
    }

    public int getNumberOfAreaTerms() {
        return this.m_numberOfAreaTerms;
    }

    public void setNumberOfAreaTerms(int i) {
        this.m_numberOfAreaTerms = i;
    }

    public List<AreaTerm> getAreaList() {
        return this.m_handleAreaTermList;
    }

    public List<InternalStreetObject> getListOfInternalAddress() {
        return Collections.unmodifiableList(this.m_internalAddressList);
    }

    void setAreaMetaData(AreaMetaData areaMetaData) {
        this.m_areaMetaData = areaMetaData;
    }

    AreaMetaData getAreaMetadata() {
        return this.m_areaMetaData;
    }

    private static final class WrittenStreetObjectInfo {
        private byte[] dataBytes;
        private final List<InternalStreetObject> streetObjects;
        private final IntArray addressOffsets;

        WrittenStreetObjectInfo(int addrCount) {
            this.dataBytes = this.dataBytes;
            this.streetObjects = new ArrayList<InternalStreetObject>(addrCount);
            this.addressOffsets = new IntArray(addrCount);
        }

        void addAddressOffset(int offset) {
            this.addressOffsets.add(offset);
        }

        void addInternalStreetObject(InternalStreetObject streetObject) {
            this.streetObjects.add(streetObject);
        }

        void setDataBytes(byte[] bytes) {
            this.dataBytes = bytes;
        }

        byte[] getDataBytes() {
            return this.dataBytes;
        }

        List<InternalStreetObject> getInternalStreetObjects() {
            return this.streetObjects;
        }

        IntArray getAddressOffsets() {
            return this.addressOffsets;
        }

        int getAddressCount() {
            return this.streetObjects.size();
        }
    }
}

