/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.VersionInfo;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.AreaTerm;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.address.UnitInfo;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.AreaNameDictionary;
import com.mapinfo.mapmarker.cgge.dp.AreaSacList;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DataTypes;
import com.mapinfo.mapmarker.cgge.dp.DataVersionInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.DictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.SALocator;
import com.mapinfo.mapmarker.cgge.dp.SacCreator;
import com.mapinfo.mapmarker.cgge.dp.WordDictionary;
import com.mapinfo.mapmarker.cgge.dp.builder.AddressKeyHandler;
import com.mapinfo.mapmarker.cgge.dp.builder.DataCreationOptions;
import com.mapinfo.mapmarker.cgge.dp.builder.DataWriter;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldException;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidPropertyException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.SpatialIndexWriter;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBuilder
implements FilenameFilter {
    static final Logger logger;
    public static final String KEY_DATA_PROVIDER = "dataProviderName";
    public static final String KEY_BUILD_NUMBER = "buildNumber";
    public static final String KEY_INPUT_PATH = "inputPath";
    public static final String KEY_OUTPUT_PATH = "outputPath";
    public static final String KEY_LANGUAGE = "dataLanguage";
    public static final String KEY_DATA_NAME = "dataName";
    public static final String KEY_DATA_READER = "dataReader";
    public static final String KEY_DATA_COUNTRY = "country";
    public static final String KEY_MAKE_WORDDICTIONARIES = "makeWordDictionaries";
    public static final String KEY_MAKE_AREASACLOOKUP = "makeAreaSacLookup";
    public static final String KEY_MAKE_MAINADDRESSDICTIONARY = "makeMainAddressDictionary";
    public static final String KEY_MAKE_POSTCODE_DATA = "makePostcodeData";
    public static final String KEY_INTERMEDIATE_FOLDER = "intermediateFolder";
    public static final String KEY_CREATE_STATS = "createStats";
    public static final String KEY_DELETE_INTERMEDIATE_FILES = "deleteTempFiles";
    public static final String KEY_DICT_TYPE = "dictionaryType";
    public static final String DICT_TYPE_STREET = "street";
    public static final String DICT_TYPE_GEOGRAPHIC = "geographic";
    public static final String DICT_TYPE_POSTAL = "postal";
    public static final String DICT_TYPE_POI = "poi";
    public static final String DICT_TYPE_CUSTOM = "custom";
    public static final String KEY_LOGGER = "logger";
    public static final String KEY_ROOT_LOGGER = "rootLogger";
    public static final String KEY_GOR_DATA = "gorData";
    public static final String KEY_COUNTRY = "country";
    public static final String KEY_USER_DICTIONARY = "userDictionary";
    public static final String KEY_UNIT_ADDITIONAL_FIELDS = "UnitAdditionalFields";
    public static final String KEY_RANGE_ADDITIONAL_FIELDS = "RangeAdditionalFields";
    public static final String KEY_STREET_ADDITIONAL_FIELDS = "StreetAdditionalFields";
    public static final String KEY_POSTAL_ADDITIONAL_FIELDS = "PostalAdditionalFields";
    public static final String KEY_SAC_SEARCH_FIELDS = "SacSearchFields";
    public static final String KEY_STREET_SEARCH_FIELDS = "StreetSearchFields";
    public static final String KEY_UNIT_ADDRESS_SCORING_FIELDS = "UnitAddressScoringFields";
    public static final String KEY_RANGE_ADDRESS_SCORING_FIELDS = "RangeAddressScoringFields";
    public static final String KEY_STREET_ADDRESS_SCORING_FIELDS = "StreetAddressScoringFields";
    public static final String KEY_GEO_SCORING_FIELDS = "GeoScoringFields";
    public static final String KEY_DESC_FILE = "desc.properties";
    public static final String KEY_COORDINATE_PRECISION = "coodinatePrecision";
    public static final String KEY_DATATYPE_INFO = "dataTypeInfo";
    public static final int KEY_NO_SAC = -1;
    public static final String KEY_SAC = "sac";
    public static final String KEY_SUPPORTS_REVERSEGOCODING = "supports_reversegeocoding";
    public static final String KEY_NUMBEROFRANGES_COMBINED_REVERSEGEOCODE = "numberofRanges_combined_ReverseGeocode";
    private static final String KEY_FALLBACK_TO_POI_WITH_STREET = "fallback_to_poi_with_street";
    private static final String KEY_THOROUGHFARETYPE_NON_DELIMITED = "thoroughfaretype_non_delimited";
    private boolean m_bMakeWordDictionaries = false;
    private boolean m_bMakeAreaSacLookup = false;
    private boolean m_bMakeMainAddressDictionary = false;
    private String m_filterName = "";
    private SacCreator m_sacCreator = null;
    private String m_intermediatePath = null;
    private String m_outputPath = null;
    public static Logger m_consoleLogger;
    private boolean m_bDeleteTempFiles;
    private String[] m_sacMapping;
    private FieldType m_sacMappingType;
    private String m_dictType;
    private CGGEHandler m_handler;
    private String m_dataName;
    private boolean m_createReverseGeocodeData;
    private boolean m_allowPoiGeocodingwithStreet;
    private static RawDataReader reader;

    private void loadLoggers(String logFile) {
        m_consoleLogger.info("Loggers initialised");
    }

    public void createData(Properties prop) throws DataCreationException {
        String inputPath = prop.getProperty(KEY_INPUT_PATH);
        this.m_outputPath = prop.getProperty(KEY_OUTPUT_PATH);
        this.m_dataName = prop.getProperty(KEY_DATA_NAME);
        String readerClz = prop.getProperty(KEY_DATA_READER);
        String dataProvider = prop.getProperty(KEY_DATA_PROVIDER);
        String buildNumber = prop.getProperty(KEY_BUILD_NUMBER);
        String logFile = prop.getProperty(KEY_DATA_NAME) + "_" + dataProvider + "_" + buildNumber + ".log";
        try {
            this.loadLoggers(logFile);
            prop.put(KEY_LOGGER, m_consoleLogger);
            prop.put(KEY_ROOT_LOGGER, logger);
            if (inputPath == null || inputPath.trim().length() == 0) {
                m_consoleLogger.error("No input path provided");
                System.exit(0);
            }
            if (this.m_outputPath == null || this.m_outputPath.trim().length() == 0) {
                m_consoleLogger.error("No output path provided");
                System.exit(0);
            }
            if (this.m_dataName == null || this.m_dataName.trim().length() == 0) {
                m_consoleLogger.error("No data name provided");
                System.exit(0);
            }
            if (readerClz == null || readerClz.trim().length() == 0) {
                m_consoleLogger.error("No data reader provided");
                System.exit(0);
            }
            if (!this.m_outputPath.endsWith("\\") && !this.m_outputPath.endsWith("/")) {
                this.m_outputPath = this.m_outputPath + "/";
                prop.setProperty(KEY_OUTPUT_PATH, this.m_outputPath);
            }
            if (!inputPath.endsWith("\\") && !inputPath.endsWith("/")) {
                inputPath = inputPath + "/";
                prop.setProperty(KEY_INPUT_PATH, inputPath);
            }
            DataCreationOptions options = this.getDictionaryOptions(prop);
            Properties m_dataSetConfiguration = null;
            File file = new File(this.m_outputPath + this.m_dataName + ".cnf");
            if (file != null && file.exists()) {
                m_dataSetConfiguration = new Properties();
                m_dataSetConfiguration.load(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            }
            DataSetInfo dataSetInfo = new DataSetInfo(options.getDictionaryMetaData(), this.m_dataName, 1, 1, options.getDictionaryMetaData().getDictionaryType());
            dataSetInfo.setDataSetConfiguration(m_dataSetConfiguration);
            this.m_handler = CGGEHandler.getInstance(dataSetInfo, options.getDictionaryMetaData().getCountry(), options.getDictionaryMetaData().getLanguage());
            this.m_bDeleteTempFiles = prop.containsKey(KEY_DELETE_INTERMEDIATE_FILES) ? new Boolean(prop.getProperty(KEY_DELETE_INTERMEDIATE_FILES)) : true;
            File intermediateFolder = new File(this.m_outputPath + "intermediate/");
            intermediateFolder.mkdirs();
            if (this.m_bDeleteTempFiles) {
                intermediateFolder.deleteOnExit();
            }
            this.m_intermediatePath = intermediateFolder.getAbsolutePath();
            if (!this.m_intermediatePath.endsWith("\\") && !this.m_intermediatePath.endsWith("/")) {
                this.m_intermediatePath = this.m_intermediatePath + "/";
            }
            prop.setProperty(KEY_INTERMEDIATE_FOLDER, this.m_intermediatePath);
            this.m_bMakeWordDictionaries = prop.containsKey(KEY_MAKE_WORDDICTIONARIES) ? Boolean.valueOf(prop.getProperty(KEY_MAKE_WORDDICTIONARIES)) : true;
            this.m_bMakeAreaSacLookup = prop.containsKey(KEY_MAKE_AREASACLOOKUP) ? Boolean.valueOf(prop.getProperty(KEY_MAKE_AREASACLOOKUP)) : true;
            this.m_bMakeMainAddressDictionary = prop.containsKey(KEY_MAKE_MAINADDRESSDICTIONARY) ? Boolean.valueOf(prop.getProperty(KEY_MAKE_MAINADDRESSDICTIONARY)) : true;
            if (prop.containsKey(KEY_SUPPORTS_REVERSEGOCODING)) {
                this.m_createReverseGeocodeData = Boolean.valueOf(prop.getProperty(KEY_SUPPORTS_REVERSEGOCODING));
            }
            if (prop.containsKey(KEY_FALLBACK_TO_POI_WITH_STREET)) {
                this.m_allowPoiGeocodingwithStreet = Boolean.valueOf(prop.getProperty(KEY_FALLBACK_TO_POI_WITH_STREET));
            }
            long startTime = System.currentTimeMillis();
            this.m_sacCreator = new SacCreator();
            if (this.m_bMakeWordDictionaries || this.m_bMakeAreaSacLookup || this.m_bMakeMainAddressDictionary) {
                Class<?> clz = Class.forName(readerClz);
                reader = (RawDataReader)clz.newInstance();
                reader.setAdditionalFields(options.getAdditionalFields());
                reader.loadData(prop);
                String coordSys = reader.getCoordSysString();
                if (coordSys != null) {
                    options.getDictionaryMetaData().setSourceCoordinateSys(coordSys);
                } else {
                    logger.warn("Reader did not return a coordinate system. Assuming the coordinate system to be WGS84");
                }
                this.m_sacCreator = new SacCreator();
                if (!reader.isSacFromFile()) {
                    String value = (String)prop.get(KEY_SAC);
                    if (value == null || value.trim().length() == 0) {
                        throw new InvalidSacException("Databuild aborted: No value provided for \"sac\" for SAC creation");
                    }
                    int sepNdx = value.indexOf(44);
                    if (sepNdx > -1) {
                        this.m_sacMapping = new String[2];
                        this.m_sacMapping[0] = value.substring(0, sepNdx).trim();
                        if (sepNdx + 1 < value.length()) {
                            this.m_sacMapping[1] = value.substring(sepNdx + 1);
                        }
                    } else {
                        this.m_sacMapping = new String[]{value.trim()};
                    }
                    if (this.m_sacMapping.length > 1 && this.m_sacMapping[this.m_sacMapping.length - 1].trim().length() > 0) {
                        this.m_sacCreator.setPattern(this.m_sacMapping[this.m_sacMapping.length - 1]);
                    }
                    this.m_sacMappingType = options.getDictionaryMetaData().getFieldForName(this.m_sacMapping[0]);
                }
            }
            if (this.m_bMakeWordDictionaries) {
                this.createWordDictionaries(options, reader);
            }
            if (this.m_bMakeAreaSacLookup) {
                this.createAreaTermsAndSacLookup(options, reader);
            }
            if (this.m_bMakeMainAddressDictionary) {
                this.createMainAddressDictionary(options, reader, prop);
            }
            long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
            int mins = (int)(totalTime / 60L);
            int hours = mins / 60;
            mins -= hours * 60;
            if (this.m_bDeleteTempFiles) {
                m_consoleLogger.info("Deleting temp files");
                try {
                    DataBuilder.deleteFolder(intermediateFolder);
                }
                catch (Exception e) {
                    logger.warn("Error deleting temp files", (Throwable)e);
                }
            }
            m_consoleLogger.info("All process finished in " + (hours > 0 ? hours + "h" : "") + mins + " m");
        }
        catch (DataCreationException dce) {
            m_consoleLogger.error(dce.getMessage(), (Throwable)dce);
            throw dce;
        }
        catch (InvalidSacException e) {
            m_consoleLogger.error(e.getMessage(), (Throwable)e);
            throw new DataCreationException(e);
        }
        catch (InvalidFieldMappingException ife) {
            m_consoleLogger.error(ife.getMessage(), (Throwable)ife);
            throw new DataCreationException(ife);
        }
        catch (Throwable t) {
            m_consoleLogger.error(t.getMessage(), t);
            throw new DataCreationException(t);
        }
    }

    public void createData(String propFileName) throws Exception {
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(propFileName));
        }
        catch (Exception e) {
            throw new DataCreationException("Error: loading file: " + propFileName, e);
        }
        this.createData(prop);
    }

    private void createWordDictionaries(DataCreationOptions options, RawDataReader reader) throws Exception {
        reader.rewind();
        long startTime = System.currentTimeMillis();
        m_consoleLogger.info("Creating word dictionaries");
        String outFileName = this.m_intermediatePath + "street_types" + ".adw";
        File file = new File(outFileName);
        if (this.m_bDeleteTempFiles) {
            file.deleteOnExit();
        }
        this.createWordsForStreetTypes(file, options);
        boolean isThroughFareAttachedtoStreetName = this.m_handler.getParser().isThroughFareAttachedtoStreetName();
        if (isThroughFareAttachedtoStreetName) {
            IDictionaryMetaData metadata = options.getDictionaryMetaData();
            metadata.setAdditionalInfo(KEY_THOROUGHFARETYPE_NON_DELIMITED, String.valueOf(isThroughFareAttachedtoStreetName));
        }
        while (reader.loadNextFileSet()) {
            m_consoleLogger.info("--Processing set " + reader.getCurrentFileSetName());
            outFileName = this.m_intermediatePath + reader.getCurrentFileSetName() + ".adw";
            File intermiateStreetDictFile = new File(outFileName);
            outFileName = this.m_intermediatePath + reader.getCurrentFileSetName() + ".arw";
            File intermiateAreaDictFile = new File(outFileName);
            if (this.m_bDeleteTempFiles) {
                intermiateStreetDictFile.deleteOnExit();
                intermiateAreaDictFile.deleteOnExit();
            }
            this.createWordDictionaries(reader, intermiateStreetDictFile, intermiateAreaDictFile, options);
        }
        m_consoleLogger.info("--Combining temperory dictionaries into .arw and .adw files");
        this.combineWordDictionaries(this.m_intermediatePath, this.m_outputPath, this.m_dataName, options);
        m_consoleLogger.info("--Finished Combining temperory dictionaries");
        long totTime = (System.currentTimeMillis() - startTime) / 1000L;
        m_consoleLogger.info("Finished creating word dictionaries in " + totTime + " secs");
    }

    private void createAreaTermsAndSacLookup(DataCreationOptions options, RawDataReader reader) throws Exception {
        reader.rewind();
        m_consoleLogger.info("Making Area Codes and SAC list");
        m_consoleLogger.info("--Loading word dictionary for area names");
        long startTime = System.currentTimeMillis();
        WordDictionary[] dicts = this.loadWordDictionaries(this.m_outputPath, this.m_dataName, options.getDictionaryMetaData());
        HashMap<FieldType, Map<DictionaryAreaTermItem, IntArray>> areaGroupMap = new HashMap<FieldType, Map<DictionaryAreaTermItem, IntArray>>(3000);
        while (reader.loadNextFileSet()) {
            m_consoleLogger.info("--Processing set " + reader.getCurrentFileSetName());
            this.createAreaNameDictionaryItemAndSac(reader, areaGroupMap, dicts[0], dicts[1], options);
        }
        this.writeAreaItemsAndSacs(areaGroupMap, this.m_outputPath + this.m_dataName, options);
        long totTime = (System.currentTimeMillis() - startTime) / 1000L;
        m_consoleLogger.info("Finished Making Area Codes and SAC list in " + totTime + " secs");
    }

    private WordDictionary[] loadWordDictionaries(String path, String dataName, IDictionaryMetaData metaData) throws Exception {
        WordDictionary areaWordDict = new WordDictionary();
        String fullFilePath = MMUtils.appendToPath(path, dataName);
        areaWordDict.loadDictionary(fullFilePath + ".arw", this.m_handler);
        WordDictionary streetWordDict = new WordDictionary();
        streetWordDict.loadDictionary(fullFilePath + ".adw", this.m_handler);
        if (areaWordDict.isBigDictionary() || streetWordDict.isBigDictionary()) {
            metaData.setAdditionalInfo("has_big_word_dictionary", "true");
        }
        return new WordDictionary[]{streetWordDict, areaWordDict};
    }

    private void createMainAddressDictionary(DataCreationOptions options, RawDataReader reader, Properties prop) throws Exception {
        reader.rewind();
        m_consoleLogger.info("Making main address dictionary and index");
        long startTime = System.currentTimeMillis();
        WordDictionary[] dicts = this.loadWordDictionaries(this.m_outputPath, this.m_dataName, options.getDictionaryMetaData());
        AreaNameDictionary areaDict = new AreaNameDictionary();
        areaDict.loadDictionary(this.m_outputPath + this.m_dataName, dicts[0], this.m_handler, options.getDictionaryMetaData());
        IDictionaryMetaData metaData = options.getDictionaryMetaData();
        SpatialIndexWriter spatialIndexWriter = null;
        if (this.m_createReverseGeocodeData) {
            metaData.setAdditionalInfo(KEY_SUPPORTS_REVERSEGOCODING, prop.getProperty(KEY_SUPPORTS_REVERSEGOCODING));
            spatialIndexWriter = new SpatialIndexWriter(this.m_intermediatePath, this.m_dataName, metaData);
        }
        if (this.m_allowPoiGeocodingwithStreet) {
            metaData.setAdditionalInfo(KEY_FALLBACK_TO_POI_WITH_STREET, prop.getProperty(KEY_FALLBACK_TO_POI_WITH_STREET));
        }
        DataWriter dataWriter = DataWriter.getInstance(options);
        dataWriter.prepareMainDataFiles(this.m_outputPath, this.m_dataName);
        dataWriter.writeMetaData(this.getDataVersionInfo(this.m_dataName, prop), metaData);
        while (reader.loadNextFileSet()) {
            m_consoleLogger.info("--Processing set " + reader.getCurrentFileSetName());
            this.createMainDataDictionary(reader, dicts[0], areaDict, dataWriter, options, spatialIndexWriter);
        }
        dataWriter.close();
        if (spatialIndexWriter != null) {
            spatialIndexWriter.close();
            String numberofRangesTobeCombined = prop.getProperty(KEY_NUMBEROFRANGES_COMBINED_REVERSEGEOCODE);
            int noofRangesToCombine = numberofRangesTobeCombined != null ? Integer.parseInt(numberofRangesTobeCombined) : 20;
            spatialIndexWriter.createFinalRGIndexes(this.m_outputPath, this.m_dataName, noofRangesToCombine);
        }
        long totTime = (System.currentTimeMillis() - startTime) / 1000L;
        m_consoleLogger.info("Finished making main address dictionary and index" + totTime + " secs");
    }

    private DataVersionInfo getDataVersionInfo(String dataName, Properties prop) {
        String providerName = prop.getProperty(KEY_DATA_PROVIDER);
        String buildNumber = prop.getProperty(KEY_BUILD_NUMBER);
        return new DataVersionInfo(VersionInfo.getFullVersion(), buildNumber, dataName, providerName);
    }

    protected DataCreationOptions getDictionaryOptions(Properties prop) throws Exception {
        String dataTypeInfo;
        String locationPrecision;
        DictionaryMetaData metaData = new DictionaryMetaData();
        DataCreationOptions options = new DataCreationOptions();
        String udStr = prop.getProperty(KEY_USER_DICTIONARY, "false");
        if ("true".equalsIgnoreCase(udStr)) {
            metaData.setUserDictionary(true);
        } else {
            metaData.setUserDictionary(false);
        }
        String[] unitAdditionalFieldNames = this.split(prop.getProperty(KEY_UNIT_ADDITIONAL_FIELDS));
        String[] rangeAdditionalFieldNames = this.split(prop.getProperty(KEY_RANGE_ADDITIONAL_FIELDS));
        String[] streetAdditionalFieldNames = this.split(prop.getProperty(KEY_STREET_ADDITIONAL_FIELDS));
        String[] postalAdditionalFieldNames = this.split(prop.getProperty(KEY_POSTAL_ADDITIONAL_FIELDS));
        HashMap<String, FieldType> additionalFieldsMap = new HashMap<String, FieldType>(10);
        options.setAdditionalFields(additionalFieldsMap);
        this.createTypeForAdditionFields(additionalFieldsMap, unitAdditionalFieldNames, FieldType.FieldLevel.LEVEL_UNIT, metaData);
        this.createTypeForAdditionFields(additionalFieldsMap, rangeAdditionalFieldNames, FieldType.FieldLevel.LEVEL_RANGE, metaData);
        this.createTypeForAdditionFields(additionalFieldsMap, streetAdditionalFieldNames, FieldType.FieldLevel.LEVEL_STREET, metaData);
        this.createTypeForAdditionFields(additionalFieldsMap, postalAdditionalFieldNames, FieldType.FieldLevel.LEVEL_POSTAL, metaData);
        int type = 1;
        String language = prop.getProperty(KEY_LANGUAGE);
        String country = prop.getProperty("country");
        if (country != null) {
            metaData.setCountry(country.trim());
        }
        if (language != null) {
            metaData.setLanguage(language.trim());
        }
        this.m_dictType = prop.getProperty(KEY_DICT_TYPE);
        if (this.m_dictType != null) {
            if (this.m_dictType.equalsIgnoreCase(DICT_TYPE_STREET)) {
                type = 1;
            } else if (this.m_dictType.equalsIgnoreCase(DICT_TYPE_GEOGRAPHIC)) {
                type = 3;
            } else if (this.m_dictType.equalsIgnoreCase(DICT_TYPE_POSTAL)) {
                type = 2;
            } else if (this.m_dictType.equalsIgnoreCase(DICT_TYPE_POI)) {
                type = 4;
            } else {
                throw new InvalidPropertyException("\"" + this.m_dictType + "\" is not a valid dictionary type");
            }
        }
        if (!StringUtilities.isEmpty((String)(locationPrecision = prop.getProperty("global_location_precision")))) {
            metaData.setGlobalLocationPrecision(Integer.parseInt(locationPrecision));
        }
        metaData.setCoordDecimalPrecision(PropertiesUtil.getIntegerPropertyValue(prop, KEY_COORDINATE_PRECISION, 5));
        ArrayList<FieldType> areaScoringFields = new ArrayList<FieldType>(5);
        ArrayList<FieldType> unitScoringFields = new ArrayList<FieldType>(5);
        ArrayList<FieldType> rangeScoringFields = new ArrayList<FieldType>(5);
        ArrayList<FieldType> streetScoringFields = new ArrayList<FieldType>(5);
        ArrayList<FieldType> additionalFields = new ArrayList<FieldType>(5);
        String keySearchFields = prop.getProperty(KEY_STREET_SEARCH_FIELDS);
        String keySacSearchFields = prop.getProperty(KEY_SAC_SEARCH_FIELDS);
        String keyUnitAddressScoringFields = prop.getProperty(KEY_UNIT_ADDRESS_SCORING_FIELDS);
        String keyRangeAddressScoringFields = prop.getProperty(KEY_RANGE_ADDRESS_SCORING_FIELDS);
        String keyStreetAddressScoringFields = prop.getProperty(KEY_STREET_ADDRESS_SCORING_FIELDS);
        String keyGeoScoringFields = prop.getProperty(KEY_GEO_SCORING_FIELDS);
        switch (type) {
            case 1: {
                String fields;
                if (MMUtils.isEmpty(keySearchFields)) {
                    prop.setProperty(KEY_STREET_SEARCH_FIELDS, FieldType.STREET_NAME_FIELD_TYPE.getName());
                }
                if (MMUtils.isEmpty(keySacSearchFields)) {
                    fields = FieldType.AREA_NAME_3_FIELD_TYPE.getName() + "," + FieldType.POST_CODE_FIELD_TYPE.getName();
                    prop.setProperty(KEY_SAC_SEARCH_FIELDS, fields);
                }
                if (!MMUtils.isEmpty(keyUnitAddressScoringFields)) {
                    this.addFields(unitScoringFields, KEY_UNIT_ADDRESS_SCORING_FIELDS, keyUnitAddressScoringFields, metaData);
                }
                if (!MMUtils.isEmpty(keyRangeAddressScoringFields)) {
                    this.addFields(rangeScoringFields, KEY_RANGE_ADDRESS_SCORING_FIELDS, keyRangeAddressScoringFields, metaData);
                }
                if (MMUtils.isEmpty(keyStreetAddressScoringFields)) {
                    streetScoringFields.add(FieldType.STREET_NAME_FIELD_TYPE);
                } else {
                    this.addFields(streetScoringFields, KEY_STREET_ADDRESS_SCORING_FIELDS, keyStreetAddressScoringFields, metaData);
                }
                if (MMUtils.isEmpty(keyGeoScoringFields)) {
                    areaScoringFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    areaScoringFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    break;
                }
                this.addFields(areaScoringFields, KEY_GEO_SCORING_FIELDS, keyGeoScoringFields, metaData);
                break;
            }
            case 3: {
                String fields;
                if (MMUtils.isEmpty(keySearchFields)) {
                    fields = FieldType.AREA_NAME_3_FIELD_TYPE.getName() + "," + FieldType.AREA_NAME_4_FIELD_TYPE.getName();
                    prop.setProperty(KEY_STREET_SEARCH_FIELDS, fields);
                }
                if (MMUtils.isEmpty(keySacSearchFields)) {
                    fields = FieldType.AREA_NAME_3_FIELD_TYPE.getName() + "," + FieldType.AREA_NAME_4_FIELD_TYPE.getName();
                    prop.setProperty(KEY_SAC_SEARCH_FIELDS, fields);
                }
                if (MMUtils.isEmpty(keyGeoScoringFields)) {
                    areaScoringFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    areaScoringFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    break;
                }
                this.addFields(areaScoringFields, KEY_GEO_SCORING_FIELDS, keyGeoScoringFields, metaData);
                break;
            }
            case 2: {
                if (MMUtils.isEmpty(keySearchFields)) {
                    prop.setProperty(KEY_STREET_SEARCH_FIELDS, FieldType.POST_CODE_FIELD_TYPE.getName());
                }
                if (MMUtils.isEmpty(keySacSearchFields)) {
                    prop.setProperty(KEY_SAC_SEARCH_FIELDS, FieldType.POST_CODE_FIELD_TYPE.getName());
                }
                if (MMUtils.isEmpty(keyGeoScoringFields)) {
                    areaScoringFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    break;
                }
                this.addFields(areaScoringFields, KEY_GEO_SCORING_FIELDS, keyGeoScoringFields, metaData);
                break;
            }
            case 4: {
                if (MMUtils.isEmpty(keySearchFields)) {
                    prop.setProperty(KEY_STREET_SEARCH_FIELDS, FieldType.PLACE_NAME_FIELD_TYPE.getName());
                }
                if (MMUtils.isEmpty(keySacSearchFields)) {
                    prop.setProperty(KEY_SAC_SEARCH_FIELDS, FieldType.PLACE_NAME_FIELD_TYPE.getName());
                }
                if (MMUtils.isEmpty(keyStreetAddressScoringFields)) {
                    streetScoringFields.add(FieldType.PLACE_NAME_FIELD_TYPE);
                } else {
                    this.addFields(streetScoringFields, KEY_STREET_ADDRESS_SCORING_FIELDS, keyStreetAddressScoringFields, metaData);
                }
                if (MMUtils.isEmpty(keyGeoScoringFields)) {
                    areaScoringFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    areaScoringFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    areaScoringFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    break;
                }
                this.addFields(areaScoringFields, KEY_GEO_SCORING_FIELDS, keyGeoScoringFields, metaData);
            }
        }
        AddressKeyHandler handler = new AddressKeyHandler(prop, metaData);
        options.setAddressKeyHandler(handler);
        options.setDictionaryMetaData(metaData);
        options.setAreaScoringFields(areaScoringFields);
        if (unitScoringFields.size() > 0) {
            options.setUnitScoringFields(unitScoringFields);
        }
        if (rangeScoringFields.size() > 0) {
            options.setRangeScoringFields(rangeScoringFields);
        }
        options.setStreetScoringFields(streetScoringFields);
        metaData.setSacSearchField(handler.getSacSearchKeyFields());
        metaData.setSearchFields(handler.getAddressSearchKeyFields());
        if (additionalFieldsMap != null) {
            for (FieldType t : additionalFieldsMap.values()) {
                additionalFields.add(t);
            }
        }
        metaData.setAdditionalFields(additionalFields);
        metaData.setDictionaryType(type);
        if (prop.containsKey(KEY_DATATYPE_INFO) && !StringUtilities.isEmpty((String)(dataTypeInfo = prop.getProperty(KEY_DATATYPE_INFO)))) {
            metaData.setAdditionalInfo(KEY_DATATYPE_INFO, DataTypes.getEnum(dataTypeInfo).getDataType());
        }
        return options;
    }

    private void confirmFieldValidity(String key, String[] fields, IDictionaryMetaData metaData) throws InvalidFieldException {
        for (String t : fields) {
            int fieldKey = metaData.getKeyForField(t);
            if (fieldKey != -1) continue;
            throw new InvalidFieldException("Field \"" + t + "\" for property \"" + key + "\" is an invalid address object field");
        }
    }

    private void addFields(List<FieldType> fields, String key, String fieldNamesVal, IDictionaryMetaData metaData) throws InvalidFieldException {
        String[] fieldNames = fieldNamesVal.split(",");
        this.confirmFieldValidity(key, fieldNames, metaData);
        for (String t : fieldNames) {
            int fieldKey = metaData.getKeyForField(t);
            if (fieldKey == -1) continue;
            fields.add(metaData.getFieldType(fieldKey));
        }
    }

    private boolean isEmpty(AddressFieldValue value) {
        return value == null ? true : MMUtils.isEmpty((String)value.getFieldValue());
    }

    private InternalFieldValue convertToInternalFieldValue(AddressFieldValue fieldValue, WordDictionary wordDict, FieldType type, ICGGEParser parser) throws DataFetchException, DataNotInitialisedException {
        int altCount;
        InternalFieldValue ifv = new InternalFieldValue(null);
        AddressWord[] words = this.getCodedWords((String)fieldValue.getFieldValue(), wordDict, type, parser);
        ifv.setFieldValue(words);
        String[] altValues = (String[])fieldValue.getAlternateValues();
        int n = altCount = altValues == null ? 0 : altValues.length;
        if (altCount > 0) {
            AddressWord[][] alts = new AddressWord[altCount][];
            for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                alts[altNdx] = this.getCodedWords(altValues[altNdx], wordDict, type, parser);
            }
            ifv.setAlternateValues((T[])alts);
        }
        return ifv;
    }

    private String combineFieldNames(AddressFieldValue fieldValue) {
        if (fieldValue.getAlternateValues() == null) {
            return (String)fieldValue.getFieldValue();
        }
        StringBuilder builder = new StringBuilder();
        builder.append((String)fieldValue.getFieldValue());
        String[] altValues = (String[])fieldValue.getAlternateValues();
        int altCount = altValues == null ? 0 : altValues.length;
        for (int altNdx = 0; altNdx < altCount; ++altNdx) {
            builder.append(altValues[altNdx]);
        }
        return builder.toString();
    }

    private void calculateQuality(AddressWord[] words) {
        int wordCount;
        int n = wordCount = words == null ? 0 : words.length;
        if (wordCount > 0) {
            if (wordCount == 1) {
                words[0].m_quality = 1.0;
            } else {
                double averageWeight = 1.0 / (double)wordCount;
                for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                    AddressWord word = words[wordNdx];
                    words[wordNdx].m_quality = (double)word.m_weight * 0.01 / averageWeight;
                }
            }
        }
    }

    private AreaTerm convertFieldValueToAreaTerm(AddressFieldValue fieldValue, FieldType type, ICGGEParser parser, AreaNameDictionary areaDict) throws DataFetchException, DataNotInitialisedException {
        int altCount;
        DictionaryAreaTermItem term = areaDict.findAreaTermOffset((String)fieldValue.getFieldValue(), type, parser);
        AreaTerm areaTerm = new AreaTerm();
        if (term == null) {
            throw new DataFetchException("Area " + (String)fieldValue.getFieldValue() + " not found in area dictionary, cannot continue.");
        }
        areaTerm.setOffset(term.getIndexCode());
        areaTerm.setTermType(type);
        AddressWord[] areaWords = term.getAreaAddressWords();
        this.calculateQuality(areaWords);
        areaTerm.setAreaWords(areaWords);
        String[] altAreas = (String[])fieldValue.getAlternateValues();
        int n = altCount = altAreas == null ? 0 : altAreas.length;
        if (altCount > 0) {
            AreaTerm[] altTerms = new AreaTerm[altCount];
            for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                term = areaDict.findAreaTermOffset(altAreas[altNdx], type, parser);
                if (term == null) {
                    throw new DataFetchException("Area " + altAreas[altNdx] + " not found in area dictionary, cannot continue.");
                }
                AreaTerm areaTerm1 = new AreaTerm();
                areaTerm1.setOffset(term.getIndexCode());
                areaTerm1.setTermType(type);
                AddressWord[] areaWords2 = term.getAreaAddressWords();
                this.calculateQuality(areaWords2);
                areaTerm1.setAreaWords(areaWords2);
                altTerms[altNdx] = areaTerm1;
            }
            areaTerm.setAlternateTerms(altTerms);
        }
        return areaTerm;
    }

    private InternalStreetAddress convertRawAddress(RawAddress inAddr, WordDictionary wordDict, AreaNameDictionary areaNameDict, DataCreationOptions options) throws DataFetchException, DataNotInitialisedException {
        ICGGEParser parser = this.m_handler.getParser();
        StringBuilder streetBuilder = new StringBuilder();
        StringBuilder areaBuilder = new StringBuilder();
        InternalStreetAddress outAddr = new InternalStreetAddress();
        InternalRangeAddress range = new InternalRangeAddress(null, null, inAddr.getStreetSide(), inAddr.getOddEvenType());
        InternalAddress unit = null;
        AdditionalFields streetAddFields = null;
        AdditionalFields rangeAddFields = null;
        AdditionalFields unitAddFields = null;
        ArrayList<AreaTerm> areaTermList = new ArrayList<AreaTerm>();
        Map fieldMap = inAddr.getFields();
        block10: for (Map.Entry entry : fieldMap.entrySet()) {
            FieldType type = entry.getKey();
            AddressFieldValue fieldValue = (AddressFieldValue)entry.getValue();
            if (this.isEmpty(fieldValue)) continue;
            boolean mainDictField = this.isFieldOfMainDictionary(type, options);
            FieldType.FieldLevel level = type.getLevel();
            if (!mainDictField) {
                switch (level) {
                    case LEVEL_UNIT: {
                        if (unitAddFields == null) {
                            unitAddFields = new AdditionalFields();
                        }
                        unitAddFields.addAdditionalField(type, (String)fieldValue.getFieldValue());
                        if (unit != null) continue block10;
                        unit = new InternalUnitAddress();
                        continue block10;
                    }
                    case LEVEL_RANGE: {
                        if (rangeAddFields == null) {
                            rangeAddFields = new AdditionalFields();
                        }
                        rangeAddFields.addAdditionalField(type, (String)fieldValue.getFieldValue());
                        continue block10;
                    }
                }
                if (streetAddFields == null) {
                    streetAddFields = new AdditionalFields();
                }
                streetAddFields.addAdditionalField(type, (String)fieldValue.getFieldValue());
                if (type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                    areaBuilder.append(this.combineFieldNames(fieldValue));
                    continue;
                }
                streetBuilder.append(this.combineFieldNames(fieldValue));
                continue;
            }
            switch (level) {
                case LEVEL_POSTAL: {
                    if (areaTermList == null) {
                        areaTermList = new ArrayList(5);
                    }
                    areaTermList.add(this.convertFieldValueToAreaTerm(fieldValue, type, parser, areaNameDict));
                    areaBuilder.append(this.combineFieldNames(fieldValue));
                    break;
                }
                case LEVEL_STREET: {
                    InternalFieldValue ifv = this.convertToInternalFieldValue(fieldValue, wordDict, type, parser);
                    outAddr.setField(type, ifv);
                    streetBuilder.append(this.combineFieldNames(fieldValue));
                    break;
                }
                case LEVEL_RANGE: {
                    if (type == FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE) {
                        AddressNumber from = parser.parserAddressNumber((String)fieldValue.getFieldValue());
                        if (from == null) {
                            logger.warn("Hnr not parsed correctly:" + fieldValue);
                        }
                        range.setFrom(from);
                        break;
                    }
                    if (type == FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE) {
                        AddressNumber to = parser.parserAddressNumber((String)fieldValue.getFieldValue());
                        if (to == null) {
                            logger.warn("Hnr not parsed correctly:" + fieldValue);
                        }
                        range.setTo(to);
                        break;
                    }
                    InternalFieldValue ifv = this.convertToInternalFieldValue(fieldValue, wordDict, type, parser);
                    range.setField(type, ifv);
                    break;
                }
                case LEVEL_UNIT: {
                    if (unit == null) {
                        unit = new InternalUnitAddress();
                    }
                    if (type == FieldType.UNIT_INFO_FIELD_TYPE) {
                        UnitInfo unitInfo = parser.convertToUnitInfo((String)fieldValue.getFieldValue());
                        if (unitInfo == null) continue block10;
                        ((InternalUnitAddress)unit).setUnitInfo(unitInfo);
                        break;
                    }
                    InternalFieldValue ifv = this.convertToInternalFieldValue(fieldValue, wordDict, type, parser);
                    unit.setField(type, ifv);
                }
            }
        }
        if (areaTermList != null) {
            outAddr.setTerms(areaTermList.toArray(new AreaTerm[areaTermList.size()]));
        }
        if (rangeAddFields != null) {
            range.setAdditionalFields(rangeAddFields);
        }
        if (unit != null) {
            if (unitAddFields != null) {
                unit.setAdditionalFields(unitAddFields);
            }
            range.addInternalUnit((InternalUnitAddress)unit);
        }
        outAddr.addInternalRange(range);
        outAddr.setAdditionalFields(streetAddFields);
        return outAddr;
    }

    private boolean acceptSac(int sac) {
        return sac != -1;
    }

    private void createMainDataDictionary(RawDataReader reader, WordDictionary streetDict, AreaNameDictionary areaNameDict, DataWriter dataWriter, DataCreationOptions options, SpatialIndexWriter spatialIndexWriter) throws Exception {
        RawAddress rawAddr = null;
        int lastSac = -1;
        String temp = null;
        while ((rawAddr = reader.getNextRecord()) != null) {
            int sac = -1;
            if (reader.isSacFromFile()) {
                temp = rawAddr.getSac();
                try {
                    sac = temp != null && temp.trim().length() > 0 ? MMUtils.convertToIntValue(rawAddr.getSac()) : -1;
                }
                catch (NumberFormatException nex) {
                    logger.warn("Invalid sac encountered in \"createMainDataDictionary\" method. Only numeric values allowed: " + temp);
                    sac = -1;
                }
            } else {
                sac = this.m_sacCreator.getSac((String)((AddressFieldValue)rawAddr.getField(this.m_sacMappingType)).getFieldValue());
            }
            if (!this.acceptSac(sac)) continue;
            if (sac != lastSac) {
                if (lastSac != -1) {
                    this.finaliseArea(dataWriter, spatialIndexWriter);
                }
                dataWriter.prepareAddressArea(sac);
                lastSac = sac;
            }
            InternalStreetAddress addr = this.convertRawAddress(rawAddr, streetDict, areaNameDict, options);
            DirectPosition[] geom = rawAddr.getCoordinates();
            dataWriter.addAddress(addr, geom);
        }
        this.finaliseArea(dataWriter, spatialIndexWriter);
    }

    private void finaliseArea(DataWriter dataWriter, SpatialIndexWriter spatialIndexWriter) throws Exception {
        dataWriter.finaliseArea();
        if (spatialIndexWriter != null) {
            spatialIndexWriter.createTemproryRGIndexes(dataWriter);
        }
    }

    private AddressWord[] getCodedWords(String str, WordDictionary dict, FieldType type, ICGGEParser parser) throws DataFetchException, DataNotInitialisedException {
        int wordCount;
        Vector<AddressWord> v = new Vector<AddressWord>();
        AddressWord[] weightedAddrWords = parser.splitIntoWeightedWords(str, type);
        int n = wordCount = weightedAddrWords == null ? 0 : weightedAddrWords.length;
        if (wordCount > 0) {
            double averageWeight = 1.0 / (double)wordCount;
            for (int i = 0; i < wordCount; ++i) {
                AddressWord weightAddressWord = weightedAddrWords[i];
                CodedWord codedWord = dict.getCodedWord(weightAddressWord.getWord());
                if (codedWord == null) {
                    throw new DataFetchException("Cannot find CodedWord for " + weightAddressWord.getWord() + ". Is the word dictionary created from the same data?");
                }
                weightAddressWord.setCodedWord(codedWord);
                weightAddressWord.m_quality = (double)weightAddressWord.m_weight * 0.01 / averageWeight;
                v.add(weightAddressWord);
                List<WordAlternate> wordAlts = weightAddressWord.getAlternates();
                if (wordAlts == null) continue;
                for (WordAlternate wordAlt : wordAlts) {
                    if (wordAlt.getAltType() == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                    AddressWord altWord = wordAlt.getAltWord();
                    codedWord = dict.getCodedWord(altWord.getWord());
                    if (codedWord != null) {
                        altWord.setCodedWord(codedWord);
                        continue;
                    }
                    throw new DataFetchException("Cannot find CodedWord for " + altWord.getWord() + ". Is the word dictionary created from the same data?");
                }
            }
        }
        if (v.size() > 0) {
            return v.toArray(new AddressWord[v.size()]);
        }
        return null;
    }

    private int combineWordDictionaries(File[] files, String path, ICGGESoundex soundex) throws Exception {
        TreeMap<Integer, List<String>> map = new TreeMap<Integer, List<String>>();
        for (int i = 0; i < files.length; ++i) {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(files[i]), "UTF-8");
            BufferedReader r = new BufferedReader(in);
            String line = null;
            while ((line = r.readLine()) != null) {
                String[] words = MMUtils.splitString(line, '|');
                if (words == null || words.length <= 0) continue;
                Integer sndx = soundex.getSoundex(words[0]);
                List<String> v = map.get(sndx);
                if (v == null) {
                    v = new ArrayList<String>();
                }
                for (int j = 0; j < words.length; ++j) {
                    if (v.contains(words[j])) continue;
                    v.add(words[j]);
                }
                map.put(sndx, v);
            }
            r.close();
        }
        File outFile = new File(path);
        return this.writeWordDictionary(outFile, map, true);
    }

    private boolean combineWordDictionaries(String inputPath, String outputPath, String dataName, DataCreationOptions options) throws Exception {
        ICGGESoundex soundex = this.m_handler.getSoundex();
        File f = new File(inputPath);
        this.m_filterName = ".adw";
        File[] files = f.listFiles(this);
        String outName = outputPath + dataName + ".adw";
        int totalSndxs = this.combineWordDictionaries(files, outName, soundex);
        logger.debug("Number of street soundexes: " + totalSndxs);
        this.m_filterName = ".arw";
        files = f.listFiles(this);
        outName = outputPath + dataName + ".arw";
        totalSndxs = this.combineWordDictionaries(files, outName, soundex);
        logger.debug("Number of area soundexes: " + totalSndxs);
        return true;
    }

    private boolean writeAreaItemsAndSacs(HashMap<FieldType, Map<DictionaryAreaTermItem, IntArray>> areaGroupMap, String outPutFileName, DataCreationOptions options) throws IOException, DataCreationException {
        FileOutputStream areaNameDictOutputStream = new FileOutputStream(outPutFileName + ".ard");
        ArrayList<DictionaryAreaTermItem> areaTermItems = new ArrayList<DictionaryAreaTermItem>(10000);
        Iterator<Map<DictionaryAreaTermItem, IntArray>> areaIt = areaGroupMap.values().iterator();
        while (areaIt.hasNext()) {
            Iterator<Map.Entry<DictionaryAreaTermItem, IntArray>> enIt = areaIt.next().entrySet().iterator();
            while (enIt.hasNext()) {
                areaTermItems.add(enIt.next().getKey());
            }
        }
        int areaCount = areaTermItems.size();
        int areasWritten = AreaNameDictionary.writeAreaNameDictionary(areaNameDictOutputStream, areaTermItems);
        assert (areaCount == areasWritten);
        ((OutputStream)areaNameDictOutputStream).close();
        FileOutputStream sacDictOutputStream = new FileOutputStream(outPutFileName + ".sac");
        HashMap<FieldType, List<AreaSacList>> typeToAreaMap = new HashMap<FieldType, List<AreaSacList>>(areaGroupMap.size());
        Iterator<Map.Entry<FieldType, Map<DictionaryAreaTermItem, IntArray>>> areaGroupEntryIt = areaGroupMap.entrySet().iterator();
        int areasWithSacsCount = 0;
        AddressKeyHandler handler = options.getAddressKeyHandler();
        while (areaGroupEntryIt.hasNext()) {
            Map.Entry<FieldType, Map<DictionaryAreaTermItem, IntArray>> areaGroupEntry = areaGroupEntryIt.next();
            FieldType type = areaGroupEntry.getKey();
            if (!handler.isSacSearchKeyField(type)) continue;
            Map<DictionaryAreaTermItem, IntArray> areaSacMap = areaGroupEntry.getValue();
            ArrayList<AreaSacList> areaSacs = new ArrayList<AreaSacList>(areaSacMap.size());
            for (Map.Entry<DictionaryAreaTermItem, IntArray> areaSacEntry : areaSacMap.entrySet()) {
                DictionaryAreaTermItem areaItem = areaSacEntry.getKey();
                IntArray sacs = areaSacEntry.getValue();
                if (sacs == null || sacs.size() <= 0) continue;
                if (areaItem.m_indexCode < -1) {
                    throw new DataCreationException("Area code is -1");
                }
                AreaSacList areaSacList = new AreaSacList(type, areaItem.m_indexCode);
                areaSacList.setSacs(sacs.asArray());
                areaSacs.add(areaSacList);
                ++areasWithSacsCount;
            }
            typeToAreaMap.put(type, areaSacs);
        }
        int written = SALocator.writeSACDictionary(sacDictOutputStream, typeToAreaMap);
        ((OutputStream)sacDictOutputStream).close();
        assert (written == areasWithSacsCount);
        return true;
    }

    private void createAreaNameDictionaryItemAndSac(RawDataReader reader, Map<FieldType, Map<DictionaryAreaTermItem, IntArray>> areaGroupMap, WordDictionary streetWordDict, WordDictionary areaWordDict, DataCreationOptions options) throws Exception {
        RawAddress rawAddr = null;
        ICGGEParser parser = this.m_handler.getParser();
        int recNum = 0;
        int numSac = -1;
        String temp = null;
        AddressKeyHandler handler = options.getAddressKeyHandler();
        while ((rawAddr = reader.getNextRecord()) != null) {
            ++recNum;
            if (reader.isSacFromFile()) {
                temp = rawAddr.getSac();
                try {
                    numSac = temp != null && temp.trim().length() > 0 ? MMUtils.convertToIntValue(rawAddr.getSac()) : -1;
                }
                catch (NumberFormatException nex) {
                    logger.warn("Invalid sac encountered in \"createAreaNameDictionaryItemAndSac\" method. Only numeric values allowed: " + temp);
                    numSac = -1;
                }
            } else {
                numSac = this.m_sacCreator.getSac((String)((AddressFieldValue)rawAddr.getField(this.m_sacMappingType)).getFieldValue());
            }
            if (!this.acceptSac(numSac)) {
                String error = reader.isSacFromFile() ? "\"SAC\" is null  at record " + recNum : "Null " + this.m_sacMapping[0] + " at record " + recNum;
                logger.warn(error);
                continue;
            }
            Map fieldMap = rawAddr.getFields();
            if (fieldMap == null || fieldMap.size() <= 0) continue;
            for (Map.Entry fieldEntry : fieldMap.entrySet()) {
                FieldType type = fieldEntry.getKey();
                AddressFieldValue fieldValue = (AddressFieldValue)fieldEntry.getValue();
                if (this.isEmpty(fieldValue) || !this.isPostalFieldOfMainDictionary(type, options)) continue;
                String areaValue = (String)fieldValue.getFieldValue();
                int altNdx = 0;
                int altCount = fieldValue.getAlternateValues() == null ? 0 : ((String[])fieldValue.getAlternateValues()).length;
                boolean addSac = handler.isSacSearchKeyField(type, rawAddr);
                while (areaValue != null) {
                    DictionaryAreaTermItem item = null;
                    item = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL ? this.createDictionaryAreaTermItem(type, areaValue, areaWordDict, parser) : this.createDictionaryAreaTermItem(type, areaValue, streetWordDict, parser);
                    this.addAreaItemToAreaGroup(areaGroupMap, item, numSac, addSac);
                    areaValue = null;
                    if (altCount <= 0 || altNdx >= altCount) continue;
                    areaValue = ((String[])fieldValue.getAlternateValues())[altNdx];
                    ++altNdx;
                }
            }
        }
    }

    protected void addAreaItemToAreaGroup(Map<FieldType, Map<DictionaryAreaTermItem, IntArray>> groupMap, DictionaryAreaTermItem item, int sac, boolean addSac) {
        Map<DictionaryAreaTermItem, IntArray> areaToSacMap = groupMap.get(item.getFieldType());
        if (areaToSacMap == null) {
            areaToSacMap = new HashMap<DictionaryAreaTermItem, IntArray>();
            groupMap.put(item.getFieldType(), areaToSacMap);
        }
        IntArray currentSacs = areaToSacMap.get(item);
        if (addSac) {
            if (currentSacs == null) {
                currentSacs = new IntArray();
                currentSacs.add(sac);
            } else if (!currentSacs.contains(sac)) {
                currentSacs.add(sac);
            }
        }
        areaToSacMap.put(item, currentSacs);
    }

    private boolean createWordsForStreetTypes(File outputFile, DataCreationOptions options) throws Exception {
        ICGGESoundex soundex = this.m_handler.getSoundex();
        ICGGEParser parser = this.m_handler.getParser();
        TreeMap<Integer, List<String>> wordGroupMap = new TreeMap<Integer, List<String>>();
        ICGGEThoroughfareTypeHandler tftHandler = this.m_handler.getParser().getThoroughfareTypeHandler();
        List<String> typeList = tftHandler.getAllThoroughfareTypes();
        if (typeList != null) {
            int i;
            ArrayList<String> v = new ArrayList<String>(100);
            for (i = 0; i < typeList.size(); ++i) {
                AddressFieldValue fieldValue = new AddressFieldValue(typeList.get(i));
                this.addWords(v, fieldValue, FieldType.UNKNOWN_FIELD_TYPE, parser);
            }
            for (i = 0; i < v.size(); ++i) {
                String word = (String)v.get(i);
                int sndx = soundex.getSoundex(word);
                Integer soundexKey = sndx;
                ArrayList<String> words = (ArrayList<String>)wordGroupMap.get(soundexKey);
                if (words != null) {
                    if (!words.contains(word)) {
                        words.add(word);
                    }
                } else {
                    words = new ArrayList<String>();
                    words.add(word);
                }
                wordGroupMap.put(soundexKey, words);
            }
        }
        this.writeWordDictionary(outputFile, wordGroupMap, false);
        return false;
    }

    public DictionaryAreaTermItem createDictionaryAreaTermItem(FieldType type, String str, WordDictionary dict, ICGGEParser parser) throws DataCreationException, DataNotInitialisedException {
        int wordCount;
        DictionaryAreaTermItem item = null;
        AddressWord[] weightedWords = parser.splitIntoWeightedWords(str, type);
        int n = wordCount = weightedWords == null ? 0 : weightedWords.length;
        if (wordCount > 0) {
            item = new DictionaryAreaTermItem(new AddressWord[wordCount], type);
            for (int i = 0; i < wordCount; ++i) {
                CodedWord word = dict.getCodedWord(weightedWords[i].getWord());
                if (word == null) {
                    throw new DataCreationException("Failed to find the word " + weightedWords[i].getWord() + " from the area words dictionary");
                }
                AddressWord scoringWord = new AddressWord(word);
                if (scoringWord == null) continue;
                item.m_areaWords[i] = scoringWord;
                item.m_areaWords[i].m_weight = weightedWords[i].m_weight;
            }
        }
        return item;
    }

    private boolean isFieldOfMainDictionary(FieldType type, DataCreationOptions options) {
        List<FieldType> fields;
        boolean mainAddressField = FieldType.isPredefinedType(type);
        AddressKeyHandler handler = options.getAddressKeyHandler();
        if (!mainAddressField) {
            mainAddressField = handler.isAddressSearchKeyField(type);
        }
        if (!mainAddressField && (fields = options.getStreetScoringFields()) != null) {
            mainAddressField = fields.contains(type);
        }
        if (!mainAddressField && (fields = options.getRangeScoringFields()) != null) {
            mainAddressField = fields.contains(type);
        }
        if (!mainAddressField && (fields = options.getUnitScoringFields()) != null) {
            mainAddressField = fields.contains(type);
        }
        if (!mainAddressField && (fields = options.getAreaScoringFields()) != null) {
            mainAddressField = fields.contains(type);
        }
        if (!mainAddressField) {
            mainAddressField = handler.isSacSearchKeyField(type);
        }
        return mainAddressField;
    }

    private boolean isPostalFieldOfMainDictionary(FieldType type, DataCreationOptions options) {
        List<FieldType> fields;
        boolean mainAddressField;
        boolean bl = mainAddressField = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL && FieldType.isPredefinedType(type);
        if (!mainAddressField && (fields = options.getAreaScoringFields()) != null) {
            mainAddressField = fields.contains(type);
        }
        if (!mainAddressField) {
            mainAddressField = options.getAddressKeyHandler().isSacSearchKeyField(type);
        }
        return mainAddressField;
    }

    private boolean createWordDictionaries(RawDataReader reader, File streetWordDictFile, File areaWordDictFile, DataCreationOptions options) throws Exception {
        ICGGESoundex soundex = this.m_handler.getSoundex();
        ICGGEParser parser = this.m_handler.getParser();
        RawAddress rawAddress = null;
        TreeMap<Integer, List<String>> sndxToStreetWordsMap = new TreeMap<Integer, List<String>>();
        TreeMap<Integer, List<String>> sndxToAreaWordsMap = new TreeMap<Integer, List<String>>();
        while ((rawAddress = reader.getNextRecord()) != null) {
            List<String> wordList;
            ArrayList<String> streetWords = new ArrayList<String>(20);
            ArrayList<String> areaWords = new ArrayList<String>(20);
            Map fieldMap = rawAddress.getFields();
            if (fieldMap != null) {
                for (Map.Entry fieldEntry : fieldMap.entrySet()) {
                    FieldType type = fieldEntry.getKey();
                    if (!this.isFieldOfMainDictionary(type, options)) continue;
                    AddressFieldValue fieldValue = (AddressFieldValue)fieldEntry.getValue();
                    if (type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
                        this.addWords(areaWords, fieldValue, type, parser);
                        continue;
                    }
                    this.addWords(streetWords, fieldValue, type, parser);
                }
            }
            for (String word : streetWords) {
                int sndx = soundex.getSoundex(word);
                wordList = (ArrayList)sndxToStreetWordsMap.get(sndx);
                if (wordList != null) {
                    if (wordList.contains(word)) continue;
                    wordList.add(word);
                    continue;
                }
                wordList = new ArrayList();
                wordList.add(word);
                sndxToStreetWordsMap.put(sndx, wordList);
            }
            for (String word : areaWords) {
                int sndx = soundex.getSoundex(word);
                wordList = (List)sndxToAreaWordsMap.get(sndx);
                if (wordList != null) {
                    if (wordList.contains(word)) continue;
                    wordList.add(word);
                    continue;
                }
                wordList = new ArrayList();
                wordList.add(word);
                sndxToAreaWordsMap.put(sndx, wordList);
            }
        }
        this.writeWordDictionary(streetWordDictFile, sndxToStreetWordsMap, false);
        this.writeWordDictionary(areaWordDictFile, sndxToAreaWordsMap, false);
        return true;
    }

    private int writeWordDictionary(File outputFile, Map<Integer, List<String>> sndxToWordMap, boolean logStats) throws Exception, FileNotFoundException {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        int groupWritten = WordDictionary.writeWordDictionary(outStream, sndxToWordMap);
        try {
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            m_consoleLogger.warn("Error closing stream", (Throwable)e);
        }
        if (logStats) {
            Iterator<Map.Entry<Integer, List<String>>> groupEntryIt = sndxToWordMap.entrySet().iterator();
            int highestGroupWordCount = 0;
            int totalWords = 0;
            while (groupEntryIt.hasNext()) {
                List<String> words = groupEntryIt.next().getValue();
                totalWords += words.size();
                if (words.size() <= highestGroupWordCount) continue;
                highestGroupWordCount = words.size();
            }
            m_consoleLogger.info("*** Stats for word dictionary " + outputFile.getName() + " *****");
            m_consoleLogger.info("Total word groups = " + groupWritten);
            m_consoleLogger.info("Highest number of words in any one group = " + highestGroupWordCount);
            m_consoleLogger.info("Average number of words per groups = " + (double)totalWords / (double)groupWritten);
        }
        return groupWritten;
    }

    private void addWords(List<String> v, AddressWord[] addrWords) {
        if (addrWords != null) {
            for (int i = 0; i < addrWords.length; ++i) {
                List<WordAlternate> alternates;
                AddressWord weightedWord = addrWords[i];
                String word = weightedWord.getWord();
                if (word.length() > 0 && !v.contains(word)) {
                    v.add(word);
                }
                if ((alternates = weightedWord.getAlternates()) == null) continue;
                for (WordAlternate alt : alternates) {
                    if (alt.getAltType() == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) {
                        AddressWord[] altWords = alt.getAltWords();
                        for (int j = 0; j < altWords.length; ++j) {
                            word = altWords[j].getWord();
                            if (word.length() <= 0 || v.contains(word)) continue;
                            v.add(word);
                        }
                        continue;
                    }
                    word = alt.getAltWord().getWord();
                    if (word.length() <= 0 || v.contains(word)) continue;
                    v.add(word);
                }
            }
        }
    }

    private void addWords(List<String> v, AddressFieldValue fieldValue, FieldType type, ICGGEParser parser) {
        if (fieldValue != null) {
            AddressWord[] weightedWords = parser.splitIntoWeightedWords((String)fieldValue.getFieldValue(), type);
            this.addWords(v, weightedWords);
            String[] altValues = (String[])fieldValue.getAlternateValues();
            int altCount = altValues == null ? 0 : altValues.length;
            for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                weightedWords = parser.splitIntoWeightedWords(altValues[altNdx], type);
                this.addWords(v, weightedWords);
            }
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.m_filterName == null || this.m_filterName.length() == 0) {
            return true;
        }
        return name.endsWith(this.m_filterName);
    }

    public boolean isMakeAreaSacLookup() {
        return this.m_bMakeAreaSacLookup;
    }

    public boolean isMakeMainAddressDictionary() {
        return this.m_bMakeMainAddressDictionary;
    }

    public boolean isMakeWordDictionaries() {
        return this.m_bMakeWordDictionaries;
    }

    public void setMakeAreaSacLookup(boolean b) {
        this.m_bMakeAreaSacLookup = b;
    }

    public void setMakeMainAddressDictionary(boolean b) {
        this.m_bMakeMainAddressDictionary = b;
    }

    public void setMakeWordDictionaries(boolean b) {
        this.m_bMakeWordDictionaries = b;
    }

    private static void deleteFolder(File folder) throws Exception {
        File[] files = folder.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    DataBuilder.deleteFolder(file);
                    continue;
                }
                if (!file.delete() && null != reader) {
                    reader.close();
                    file.delete();
                    continue;
                }
                file.delete();
            }
        }
        folder.delete();
    }

    private String[] split(String values) {
        String[] tokens = null;
        if (values != null && values.trim().length() > 0) {
            tokens = values.split(",");
        }
        return tokens;
    }

    private void createTypeForAdditionFields(Map<String, FieldType> additionalFieldNames, String[] fields, FieldType.FieldLevel level, IDictionaryMetaData metaData) {
        if (additionalFieldNames != null && fields != null) {
            for (String t : fields) {
                if (t.length() <= 0) continue;
                additionalFieldNames.put(t, metaData.generateNewFieldTypeFromName(t, level));
            }
        }
    }

    public static void main(String[] args) {
        DataBuilder db = new DataBuilder();
        if (args != null && args.length == 1) {
            try {
                db.createData(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            logger.debug("Error: No data config file specified");
            logger.debug("Usage: \n\tDataBuilder <data properties path>");
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        m_consoleLogger = logger = LoggerFactory.getLogger(DataBuilder.class);
        reader = null;
    }

    class WordDictionaryComparator
    implements Comparator<Object> {
        WordDictionaryComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof ArrayList) {
                ArrayList v1 = (ArrayList)o1;
                ArrayList v2 = (ArrayList)o2;
                if (v1.size() != 0 && v2.size() != 0) {
                    return ((String)v1.get(0)).compareTo((String)v2.get(0));
                }
                if (v1.size() == 0 && v2.size() == 0) {
                    return 0;
                }
                if (v1.size() == 0) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

