/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.CompressedSegment;
import com.mapinfo.mapmarker.cgge.dp.DataVersionInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler;
import com.mapinfo.mapmarker.cgge.dp.SAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.builder.DataAddressHandle;
import com.mapinfo.mapmarker.cgge.dp.builder.DataCreationOptions;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DataWriter {
    private final InternalAddressIOHandler ioHandler;
    private final DataCreationOptions options;
    private ICGGEDataStream mainAddressStream;
    private ICGGEDataStream mainIndexStream;
    private ICGGEDataStream additionalFileStream;
    private DataAddressHandle currentAreaHandle;
    private DirectPosition[] lastGeom;
    private long lastGeomOffset;
    private long dataStartPosition = 0L;
    private int dataAreas = 0;

    private DataWriter(InternalAddressIOHandler ioHandler, DataCreationOptions options) {
        this.ioHandler = ioHandler;
        this.options = options;
    }

    public static DataWriter getInstance(DataCreationOptions options) {
        InternalAddressIOHandler addrIOHandler = InternalAddressIOHandler.getInstance(options.getDictionaryMetaData().getVersion());
        return new DataWriter(addrIOHandler, options);
    }

    void prepareMainDataFiles(String path, String dataName) throws IOException {
        String fullPath = MMUtils.appendToPath(path, dataName);
        this.mainAddressStream = this.getDataStream(fullPath + ".adr");
        this.mainIndexStream = this.getDataStream(fullPath + ".adi");
        this.additionalFileStream = this.getDataStream(fullPath + ".afs");
    }

    ICGGEDataStream getDataStream(String fullPath) throws IOException {
        return DataStreamFactory.getDataStream(fullPath, IOUtil.IO_MODE.READ_WRITE, false);
    }

    void writeMetaData(DataVersionInfo dataVersionInfo, IDictionaryMetaData metaData) throws IOException {
        dataVersionInfo.write(this.mainIndexStream);
        metaData.write(this.mainIndexStream);
        this.dataStartPosition = this.mainIndexStream.offset();
        this.mainIndexStream.writeLong(0L);
    }

    void prepareAddressArea(int sac) throws IOException {
        this.currentAreaHandle = new DataAddressHandle();
        this.currentAreaHandle.setSac(sac);
        this.additionalFileStream.seekEnd();
        this.lastGeom = null;
        this.lastGeomOffset = 0L;
    }

    void finaliseArea() throws Exception {
        if (!this.currentAreaHandle.getAddressList().isEmpty()) {
            this.currentAreaHandle.sortAndMergeStreetAddresses();
            this.currentAreaHandle.createIndexes(this.options);
            SAFileIndexEntry sfie = new SAFileIndexEntry();
            sfie.setSacs(new IntArray(new int[]{this.currentAreaHandle.getSac()}));
            this.currentAreaHandle.writeDataAndFillIndex(this.mainAddressStream, sfie);
            sfie.write(this.mainIndexStream);
            ++this.dataAreas;
        }
    }

    void close() throws IOException {
        this.mainAddressStream.close();
        this.additionalFileStream.close();
        this.mainIndexStream.seek(this.dataStartPosition);
        this.mainIndexStream.writeLong(this.dataAreas);
        this.mainIndexStream.close();
    }

    DataAddressHandle getCurrentAreaHandle() {
        return this.currentAreaHandle;
    }

    void addAddress(InternalStreetAddress addr, DirectPosition[] geom) throws IOException {
        this.checkAreaMetaData(addr);
        this.writeAdditionalInfo(addr, geom);
        this.currentAreaHandle.addAddress(addr);
    }

    private void checkAreaMetaData(InternalStreetAddress addr) {
        AreaMetaData areaMetaData = this.currentAreaHandle.getAreaMetadata();
        if (areaMetaData == null) {
            areaMetaData = new AreaMetaData();
            areaMetaData.setCoordDecimalPrecision(this.options.getDictionaryMetaData().getCoordDecimalPrecision());
            areaMetaData.setFileOffsetAdjust(this.additionalFileStream.offset());
            this.currentAreaHandle.setAreaMetaData(areaMetaData);
        }
        addr.setAreaMetaData(areaMetaData);
        if (addr.getRangeCount() > 0) {
            for (InternalRangeAddress range : addr.getRangeList()) {
                range.setAreaMetaData(areaMetaData);
                if (!range.hasUnits()) continue;
                for (InternalUnitAddress unit : range.getUnits()) {
                    unit.setAreaMetaData(areaMetaData);
                }
            }
        }
    }

    private void writeAdditionalInfo(InternalStreetAddress addr, DirectPosition[] geom) throws IOException {
        this.writeGeometry(addr, geom);
        this.writeAddressAdditionalFields(addr);
    }

    private void writeGeometry(InternalStreetAddress addr, DirectPosition[] geom) throws IOException {
        InternalRangeAddress range = addr.getRangeList().get(0);
        if (geom != null && geom.length > 0) {
            if (!Arrays.equals(geom, this.lastGeom)) {
                this.checkPointOffset(geom);
                AreaMetaData areaMetaData = this.currentAreaHandle.getAreaMetadata();
                long geomOffset = this.additionalFileStream.offset() - areaMetaData.getFileOffsetAdjust();
                this.ioHandler.writeGeometry(geom, areaMetaData, this.additionalFileStream);
                range.setCoordinateOffset(geomOffset);
                this.lastGeom = geom;
                this.lastGeomOffset = geomOffset;
            } else {
                range.setCoordinateOffset(this.lastGeomOffset);
            }
        }
    }

    private void checkPointOffset(DirectPosition[] geom) {
        AreaMetaData areaMetaData = this.currentAreaHandle.getAreaMetadata();
        if (areaMetaData.getOffetPoint() == AreaMetaData.DEFAULT_OFFSET_POINT) {
            long multiplicationFactor = (long)Math.pow(10.0, areaMetaData.getCoordDecimalPrecision());
            DirectPosition dp = geom[0];
            LongPoint offsetPoint = new LongPoint(CompressedSegment.convertDoubleToLongAndRound(dp.getX(), multiplicationFactor), CompressedSegment.convertDoubleToLongAndRound(dp.getY(), multiplicationFactor));
            areaMetaData.setOffsetPoint(offsetPoint);
        }
    }

    private void writeAddressAdditionalFields(InternalStreetAddress addr) throws IOException {
        this.writeAdditionalFields(addr);
        InternalRangeAddress range = addr.getRangeList().get(0);
        this.writeAdditionalFields(range);
        if (range.hasUnits()) {
            this.writeAdditionalFields(range.getUnits().get(0));
        }
    }

    private void writeAdditionalFields(InternalAddress addr) throws IOException {
        AdditionalFields addFields = addr.getAdditionalFields();
        if (addFields != null && addFields.size() > 0) {
            AreaMetaData areaMetaData = this.currentAreaHandle.getAreaMetadata();
            long offset = this.additionalFileStream.offset() - areaMetaData.getFileOffsetAdjust();
            this.ioHandler.writeAdditionalFields(addFields.getAdditionalFields(), this.additionalFileStream);
            addFields.setOffset(offset);
        }
    }

    List<DirectPosition> getGeometry(InternalRangeAddress range) throws IOException {
        AreaMetaData areaMetaData = range.getAreaMetaData();
        long coordOffset = range.getCoordinateOffset();
        if (coordOffset < 0L) {
            return null;
        }
        this.additionalFileStream.seek(coordOffset += areaMetaData.getFileOffsetAdjust());
        List<DirectPosition> dpList = this.ioHandler.readGeometry(this.additionalFileStream, range.getAreaMetaData());
        return dpList;
    }
}

