/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class RawAddressReaderWriter {
    private FieldType[] m_fieldTypes = new FieldType[255];

    public void write(DataOutput stream, RawAddress address) throws IOException {
        Map fields = address.getFields();
        int fieldCount = 0;
        for (Map.Entry entry : fields.entrySet()) {
            if (entry.getValue() == null || ((AddressFieldValue)entry.getValue()).getFieldValue() == null) continue;
            ++fieldCount;
        }
        stream.writeInt(fieldCount);
        for (Map.Entry entry : fields.entrySet()) {
            if (entry.getValue() == null || ((AddressFieldValue)entry.getValue()).getFieldValue() == null) continue;
            if (this.m_fieldTypes[entry.getKey().getKey()] == null) {
                this.m_fieldTypes[entry.getKey().getKey()] = entry.getKey();
            }
            stream.writeInt(entry.getKey().getKey());
            stream.writeUTF((String)((AddressFieldValue)entry.getValue()).getFieldValue());
            stream.writeBoolean(((AddressFieldValue)entry.getValue()).hasAlternates());
            if (!((AddressFieldValue)entry.getValue()).hasAlternates()) continue;
            stream.writeInt(((String[])((AddressFieldValue)entry.getValue()).getAlternateValues()).length);
            for (String alternate : (String[])((AddressFieldValue)entry.getValue()).getAlternateValues()) {
                stream.writeUTF(alternate);
            }
        }
        DirectPosition[] geometry = address.getCoordinates();
        int geometryCount = geometry != null ? geometry.length : 0;
        stream.writeInt(geometryCount);
        for (int i = 0; i < geometryCount; ++i) {
            stream.writeDouble(geometry[i].getX());
            stream.writeDouble(geometry[i].getY());
        }
        stream.writeBoolean(address.getSac() != null);
        if (address.getSac() != null) {
            stream.writeUTF(address.getSac());
        }
        stream.writeInt(address.getOddEvenType());
        stream.writeInt(address.getStreetSide());
    }

    public void read(DataInput stream, RawAddress address) throws IOException {
        boolean bHasSAC;
        int fieldCount = stream.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            FieldType fieldType = this.m_fieldTypes[stream.readInt()];
            AddressFieldValue addressField = new AddressFieldValue(stream.readUTF());
            boolean bHasAlternates = stream.readBoolean();
            if (bHasAlternates) {
                int altCount = stream.readInt();
                String[] alternates = new String[altCount];
                for (int j = 0; j < altCount; ++j) {
                    alternates[j] = stream.readUTF();
                }
                addressField.setAlternateValues(alternates);
            }
            address.setField(fieldType, addressField);
        }
        int geometryCount = stream.readInt();
        if (geometryCount > 0) {
            DirectPosition[] geometry = new DirectPosition[geometryCount];
            for (int i = 0; i < geometryCount; ++i) {
                geometry[i] = new DirectPosition(stream.readDouble(), stream.readDouble());
            }
            address.setCoordinates(geometry);
        }
        if (bHasSAC = stream.readBoolean()) {
            address.setSac(stream.readUTF());
        }
        address.setOddEvenType(stream.readInt());
        address.setStreetSide(stream.readInt());
    }

    private FieldType getFieldType(int key) {
        return this.m_fieldTypes[key];
    }

    public void setFieldTypes(FieldType[] types) {
        this.m_fieldTypes = types;
    }
}

