/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.IRawDataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.io.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardRawDataReader
extends RawDataReader
implements Iterator<RawAddress> {
    private static final DirectPosition[] EMPTY_DOUBLE_POINT_COORDINATES = new DirectPosition[0];
    public static Logger logger = LoggerFactory.getLogger(StandardRawDataReader.class);
    protected static final Map<String, FieldType> LEFT_ADDRESS_FIELDS = new HashMap<String, FieldType>();
    protected static final Map<String, FieldType> RIGHT_ADDRESS_FIELDS = new HashMap<String, FieldType>();
    protected static final Map<String, FieldType> ALT_LEFT_VALUES = new HashMap<String, FieldType>();
    protected static final Map<String, FieldType> ALT_RIGHT_VALUES = new HashMap<String, FieldType>();
    protected static final List<FieldType> CONSIDER_RIGHT_FIELD_TYPES = Arrays.asList(FieldType.POST_CODE_FIELD_TYPE, FieldType.POST_CODE_EX_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE);
    protected static Map<String, FieldType> additionalFieldNames;
    protected Properties properties;
    protected Map<String, String> fieldLookup;
    private String coordSys;
    private RawAddress rightRecord;
    private String altValsDelim;
    protected IRawDataSource dataSource;
    private Map<String, String> currentRow;
    private boolean bIsTest;
    private boolean m_bAcceptEmptyGeometry = false;

    protected abstract boolean isValidAddressField(String var1);

    public StandardRawDataReader(IRawDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setIsTest(boolean val) {
        this.bIsTest = val;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        boolean loaded = this.dataSource.loadData(prop);
        if (loaded) {
            this.properties = this.dataSource.getProperties();
            this.setAltValsDelim((String)this.properties.get("Combine_Alt_Vals_Delim"));
            this.m_bAcceptEmptyGeometry = Boolean.parseBoolean(prop.getProperty("acceptEmptyGeometry", "false"));
            if (this.m_bAcceptEmptyGeometry) {
                logger.info("Accepting records with no geometry");
            }
        }
        return loaded;
    }

    @Override
    public boolean loadNextFileSet() {
        return this.dataSource.loadNextFileSet();
    }

    @Override
    public void rewind() {
        this.dataSource.rewind();
    }

    @Override
    public String getCurrentFileSetName() {
        return this.dataSource.getCurrentFileSetName();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    public String getCoordSysString() {
        return this.coordSys;
    }

    protected void setCoordSysString(String coordSys) {
        this.coordSys = coordSys;
    }

    protected String getAltValsDelim() {
        return this.altValsDelim;
    }

    protected void setAltValsDelim(String altValsDelim) {
        this.altValsDelim = altValsDelim;
    }

    @Override
    public void setAdditionalFields(Map<String, FieldType> map) throws InvalidFieldMappingException {
        additionalFieldNames = map;
    }

    @Override
    public boolean hasNext() {
        return this.dataSource.hasNext();
    }

    @Override
    public RawAddress next() {
        return this.getNextRecord();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void writeCurrentRowToStdOut() {
        for (Map.Entry<String, String> entry : this.currentRow.entrySet()) {
            System.out.printf("   %s -> %s\n", entry.getKey(), entry.getValue());
        }
    }

    void setCurrentRow(Map<String, String> currentRow) {
        this.currentRow = currentRow;
    }

    @Override
    public RawAddress getNextRecord() {
        if (this.rightRecord != null) {
            RawAddress record = this.rightRecord;
            this.rightRecord = null;
            return record;
        }
        RawAddress leftAddress = null;
        if (this.dataSource.hasNext()) {
            this.currentRow = (Map)this.dataSource.next();
            DirectPosition[] coordinates = EMPTY_DOUBLE_POINT_COORDINATES;
            String wkt = this.getFieldValue("Geometry");
            if (wkt != null) {
                try {
                    coordinates = StandardRawDataSource.wktToDirectPositions(wkt);
                }
                catch (ParseException e) {
                    DataBuilder.m_consoleLogger.warn("geometry format exception on '" + wkt + "'");
                }
            }
            if (coordinates == EMPTY_DOUBLE_POINT_COORDINATES) {
                if (!this.m_bAcceptEmptyGeometry) {
                    return this.getNextRecord();
                }
                coordinates = null;
            }
            leftAddress = this.getNextLeftAddress(coordinates);
            RawAddress rightAddress = this.getNextRightAddress(coordinates);
            this.populateAlternateFields(leftAddress, rightAddress, this.altValsDelim);
            boolean useRightAddress = this.considerRightAddress(leftAddress, rightAddress);
            if (!useRightAddress) {
                leftAddress.setStreetSide(0);
            } else {
                this.rightRecord = rightAddress;
            }
        }
        return leftAddress;
    }

    public RawAddress getNextLeftAddress(DirectPosition[] coordinates) {
        StandardRawAddress leftAddress = new StandardRawAddress();
        ((RawAddress)leftAddress).setStreetSide(1);
        ((RawAddress)leftAddress).setOddEvenType(this.determineOddEvenType("LeftStruct"));
        String leftFrom = null;
        String leftTo = null;
        if (this.dataSource.isPossiblePointData() || ((RawAddress)leftAddress).getOddEvenType() != 0) {
            leftFrom = this.getFieldValue("FromLeft");
            leftTo = this.getFieldValue("ToLeft");
        }
        if (leftTo != null && this.dataSource.isPossiblePointData() && (leftFrom == leftTo || leftFrom.equals(leftTo))) {
            leftTo = null;
        }
        leftAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(leftFrom));
        leftAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(leftTo));
        for (Map.Entry<String, FieldType> entry : LEFT_ADDRESS_FIELDS.entrySet()) {
            this.setAddressField(leftAddress, entry.getKey(), entry.getValue());
        }
        this.setSACtoAddress(leftAddress, "LeftSac");
        this.populateAdditionalFields(leftAddress);
        ((RawAddress)leftAddress).setCoordinates(coordinates);
        return leftAddress;
    }

    public RawAddress getNextRightAddress(DirectPosition[] coordinates) {
        StandardRawAddress rightAddress = new StandardRawAddress();
        ((RawAddress)rightAddress).setStreetSide(2);
        ((RawAddress)rightAddress).setOddEvenType(this.determineOddEvenType("RightStruct"));
        String rightFrom = null;
        String rightTo = null;
        if (this.dataSource.isPossiblePointData() || ((RawAddress)rightAddress).getOddEvenType() != 0) {
            rightFrom = this.getFieldValue("FromRight");
            rightTo = this.getFieldValue("ToRight");
        }
        if (rightTo != null && this.dataSource.isPossiblePointData() && (rightFrom == rightTo || rightFrom.equals(rightTo))) {
            rightTo = null;
        }
        rightAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(rightFrom));
        rightAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(rightTo));
        for (Map.Entry<String, FieldType> entry : RIGHT_ADDRESS_FIELDS.entrySet()) {
            this.setAddressField(rightAddress, entry.getKey(), entry.getValue());
        }
        this.setSACtoAddress(rightAddress, "RightSac");
        this.populateAdditionalFields(rightAddress);
        ((RawAddress)rightAddress).setCoordinates(coordinates);
        return rightAddress;
    }

    @Override
    public boolean isSacFromFile() {
        return this.dataSource.isSacFromFile();
    }

    @Override
    public boolean isLeftAndRightSac() {
        return this.dataSource.isLeftAndRightSac();
    }

    protected final int determineOddEvenType(String key) {
        String str = this.getFieldValue(key);
        int type = 0;
        try {
            type = str != null ? (int)Double.parseDouble(str) : type;
        }
        catch (NumberFormatException ne) {
            DataBuilder.m_consoleLogger.warn("number format exception on '" + str + "'");
        }
        return this.checkHNRType(type);
    }

    protected final int checkHNRType(int type) {
        if (type != 2 && type != 3 && type != 4 && type != 5) {
            type = 0;
        }
        return type;
    }

    @Override
    protected void confirmMappings() throws InvalidFieldMappingException {
        for (Object o : this.properties.keySet()) {
            String key = (String)o;
            if (this.isValidAddressField(key)) continue;
            throw new InvalidFieldMappingException("Property \"" + key + "\" is not a valid field");
        }
    }

    protected final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected boolean bothValuesSame(AddressFieldValue left, AddressFieldValue right) {
        if (left != null) {
            return left.equals(right);
        }
        return right == null;
    }

    protected final void setAddressField(RawAddress address, String fieldValue, FieldType fieldType) {
        String str = this.getFieldValue(fieldValue);
        address.setField(fieldType, new AddressFieldValue(str));
    }

    protected final void setSACtoAddress(RawAddress address, String sacColumnName) {
        String str = null;
        if (this.isSacFromFile()) {
            if (this.isLeftAndRightSac()) {
                str = this.getFieldValue(sacColumnName);
                str = str == null ? str : str.trim();
                address.setSac(str);
            } else {
                str = this.getFieldValue("Sac");
                str = str == null ? str : str.trim();
                address.setSac(str);
            }
        }
    }

    protected boolean considerRightAddress(RawAddress left, RawAddress right) {
        for (FieldType fieldType : CONSIDER_RIGHT_FIELD_TYPES) {
            if (this.bothValuesSame((AddressFieldValue)left.getField(fieldType), (AddressFieldValue)right.getField(fieldType))) continue;
            return true;
        }
        return left.getOddEvenType() != right.getOddEvenType();
    }

    @Override
    public void populateAdditionalFields(RawAddress addr) {
        if (additionalFieldNames != null && additionalFieldNames.size() > 0) {
            String str = null;
            String colName2 = null;
            for (String colName2 : additionalFieldNames.keySet()) {
                str = this.getFieldValue(colName2);
                addr.setField(additionalFieldNames.get(colName2), new AddressFieldValue(str));
            }
        }
    }

    protected final void populateAlternateFields(RawAddress leftAddr, RawAddress rightAddr, String altValsDelim) {
        AddressFieldValue t;
        Object[] retrieved;
        String value;
        for (Map.Entry<String, FieldType> entry : ALT_LEFT_VALUES.entrySet()) {
            if (!this.currentRow.containsKey(entry.getKey()) || this.isEmpty(value = this.currentRow.get(entry.getKey()))) continue;
            retrieved = this.getAlternates(value, altValsDelim);
            t = (AddressFieldValue)leftAddr.getField(entry.getValue());
            Arrays.sort(retrieved);
            t.setAlternateValues(retrieved);
        }
        for (Map.Entry<String, FieldType> entry : ALT_RIGHT_VALUES.entrySet()) {
            if (!this.currentRow.containsKey(entry.getKey()) || this.isEmpty(value = this.currentRow.get(entry.getKey()))) continue;
            retrieved = this.getAlternates(value, altValsDelim);
            t = (AddressFieldValue)rightAddr.getField(entry.getValue());
            Arrays.sort(retrieved);
            t.setAlternateValues(retrieved);
        }
    }

    protected String[] getAlternates(String str, String altValsDelim) {
        ArrayList<String> alternates = new ArrayList<String>();
        if (!this.isEmpty(str)) {
            if (altValsDelim == null) {
                alternates.add(str);
            } else {
                String[] strAlternates;
                for (String v : strAlternates = str.split(altValsDelim)) {
                    if (this.isEmpty(v)) continue;
                    alternates.add(v);
                }
            }
        }
        if (alternates != null && alternates.size() > 0) {
            return alternates.toArray(new String[0]);
        }
        return null;
    }

    public String getFieldValue(String name) {
        return this.currentRow.get(name);
    }

    static {
        LEFT_ADDRESS_FIELDS.put("LeftUnitPlaceName", FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftRangePlaceName", FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("PlaceName", FieldType.PLACE_NAME_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("Street", FieldType.STREET_NAME_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftPostcode", FieldType.POST_CODE_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftPostcodeEx", FieldType.POST_CODE_EX_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftAreaName1", FieldType.AREA_NAME_1_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftAreaName2", FieldType.AREA_NAME_2_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftAreaName3", FieldType.AREA_NAME_3_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftAreaName4", FieldType.AREA_NAME_4_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("RecordCountry", FieldType.COUNTRY_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftGenericField1", FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftGenericField2", FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftGenericField3", FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("LeftGenericField4", FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        LEFT_ADDRESS_FIELDS.put("Rank", FieldType.RANK_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightUnitPlaceName", FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightRangePlaceName", FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("PlaceName", FieldType.PLACE_NAME_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("Street", FieldType.STREET_NAME_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightPostcode", FieldType.POST_CODE_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightPostcodeEx", FieldType.POST_CODE_EX_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightAreaName1", FieldType.AREA_NAME_1_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightAreaName2", FieldType.AREA_NAME_2_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightAreaName3", FieldType.AREA_NAME_3_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightAreaName4", FieldType.AREA_NAME_4_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RecordCountry", FieldType.COUNTRY_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightGenericField1", FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightGenericField2", FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightGenericField3", FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("RightGenericField4", FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        RIGHT_ADDRESS_FIELDS.put("Rank", FieldType.RANK_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_PlaceName", FieldType.PLACE_NAME_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_Street", FieldType.STREET_NAME_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftPostcode", FieldType.POST_CODE_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftPostcodeEx", FieldType.POST_CODE_EX_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftAreaName1", FieldType.AREA_NAME_1_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftAreaName2", FieldType.AREA_NAME_2_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftAreaName3", FieldType.AREA_NAME_3_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftAreaName4", FieldType.AREA_NAME_4_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftGenericField1", FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftGenericField2", FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftGenericField3", FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        ALT_LEFT_VALUES.put("Alt_LeftGenericField4", FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_PlaceName", FieldType.PLACE_NAME_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_Street", FieldType.STREET_NAME_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightPostcode", FieldType.POST_CODE_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightPostcodeEx", FieldType.POST_CODE_EX_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightAreaName1", FieldType.AREA_NAME_1_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightAreaName2", FieldType.AREA_NAME_2_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightAreaName3", FieldType.AREA_NAME_3_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightAreaName4", FieldType.AREA_NAME_4_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightGenericField1", FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightGenericField2", FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightGenericField3", FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        ALT_RIGHT_VALUES.put("Alt_RightGenericField4", FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }
}

