/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.IRawDataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataReader;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardRawDataSource
implements IRawDataSource {
    static final Logger logger = LoggerFactory.getLogger(StandardRawDataSource.class);
    private Map<String, Object> columnInfo;
    private Map<String, String> currentRow;
    private String coordSysString;
    private boolean isSacFromFile;
    private boolean isLeftAndRightSac;
    private boolean possiblePointData;

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Object> getColumnInfo() {
        return this.columnInfo;
    }

    protected void setColumnInfo(Map<String, Object> columnInfo) {
        this.columnInfo = columnInfo;
    }

    protected Map<String, String> getCurrentRow() {
        return this.currentRow;
    }

    protected void setCurrentRow(Map<String, String> currentRow) {
        this.currentRow = currentRow;
    }

    @Override
    public String getCoordSysString() {
        return this.coordSysString;
    }

    protected void setCoordSysString(String coordSysString) {
        this.coordSysString = coordSysString;
    }

    @Override
    public boolean isSacFromFile() {
        return this.isSacFromFile;
    }

    @Override
    public boolean isLeftAndRightSac() {
        return this.isLeftAndRightSac;
    }

    @Override
    public boolean isPossiblePointData() {
        return this.possiblePointData;
    }

    protected void setPossiblePointData(boolean possiblePointData) {
        this.possiblePointData = possiblePointData;
    }

    private void raiseError(String key, String columnName) {
        DataBuilder.m_consoleLogger.info("Column \"" + columnName + "\" (key " + key + ") does not exist in the input table");
    }

    private String[] splitAlternateFieldNames(String value) {
        String[] tokens = null;
        if (value != null && value.trim().length() > 0) {
            tokens = value.split(",");
        }
        return tokens;
    }

    private boolean isFieldInTable(String name) {
        if (name == null) {
            return true;
        }
        return this.columnInfo == null ? false : this.columnInfo.containsKey(name.toLowerCase());
    }

    boolean checkMappedField(String key, String value) throws Exception {
        boolean isValid = this.isFieldInTable(value);
        if (!isValid) {
            this.raiseError(key, value);
        }
        return isValid;
    }

    boolean checkMappedFields(String key, String value) throws Exception {
        String[] cols = this.splitAlternateFieldNames(value);
        boolean isValid = true;
        if (cols != null) {
            for (String c : cols) {
                isValid = this.isFieldInTable(c);
                if (isValid) continue;
                this.raiseError(key, c);
                return false;
            }
        }
        return true;
    }

    protected boolean confirmMappedFields(Properties properties) throws Exception {
        boolean isValid = true;
        for (String key : StandardRawDataReader.LEFT_ADDRESS_FIELDS.keySet()) {
            isValid = isValid && !this.checkMappedField(key, properties.getProperty(key));
        }
        for (String key : StandardRawDataReader.RIGHT_ADDRESS_FIELDS.keySet()) {
            isValid = isValid && !this.checkMappedField(key, properties.getProperty(key));
        }
        for (String key : StandardRawDataReader.ALT_LEFT_VALUES.keySet()) {
            isValid = isValid && !this.checkMappedFields(key, properties.getProperty(key));
        }
        for (String key : StandardRawDataReader.ALT_RIGHT_VALUES.keySet()) {
            isValid = isValid && !this.checkMappedFields(key, properties.getProperty(key));
        }
        isValid = isValid && !this.checkMappedField("LeftStruct", properties.getProperty("LeftStruct"));
        boolean bl = isValid = isValid && !this.checkMappedField("RightStruct", properties.getProperty("RightStruct"));
        if (StandardRawDataReader.additionalFieldNames != null && StandardRawDataReader.additionalFieldNames.size() > 0) {
            for (String key : StandardRawDataReader.additionalFieldNames.keySet()) {
                isValid = isValid && !this.checkMappedField(key, properties.getProperty(key));
            }
        }
        return isValid;
    }

    public static Properties loadColumnMappings(Properties prop, String type) throws CGGEInternalException {
        String country = prop.getProperty("country");
        String dn = prop.getProperty("dataName");
        String dp = prop.getProperty("dataProviderName");
        String path = "/com/mapinfo/mapmarker/" + country + "/config/" + dn + "_" + dp + "_" + type + "ColumnMapping.properties";
        Properties properties = CGGEResourceBundle.getBundle(path);
        return properties;
    }

    protected final void prepareSacMappings(Properties properties) throws InvalidSacException {
        String value = (String)properties.get("IsSacFromFile");
        if (StandardRawDataSource.isEmpty(value)) {
            throw new InvalidSacException("Mapping for \"IsSacFromFile\" must be specified");
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw new InvalidSacException("Mapping for \"IsSacFromFile\" can only be true or false");
        }
        this.isSacFromFile = Boolean.parseBoolean(value);
        if (this.isSacFromFile && ((value = (String)properties.get("Sac")) == null || value.trim().length() == 0)) {
            value = (String)properties.get("LeftSac");
            if (value == null || value.trim().length() == 0) {
                throw new InvalidSacException("Mapping for \"LeftSac\" must be specified");
            }
            value = (String)properties.get("RightSac");
            if (value == null || value.trim().length() == 0) {
                throw new InvalidSacException("Mapping for \"RightSac\" must be specified");
            }
            this.isLeftAndRightSac = true;
        }
    }

    public static DirectPosition[] wktToDirectPositions(String wkt) throws ParseException {
        WKTReader reader = new WKTReader();
        Geometry geom = reader.read(wkt);
        Coordinate[] coords = geom.getCoordinates();
        DirectPosition[] points = new DirectPosition[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            points[i] = new DirectPosition(coords[i].x, coords[i].y);
        }
        return points;
    }

    public static String getWKT(double x, double y) throws ParseException {
        String wkt = WKTWriter.toPoint((Coordinate)new Coordinate(x, y));
        return wkt;
    }

    public static String getWKT(DirectPosition[] points) throws ParseException {
        String wkt;
        Coordinate[] coords = new Coordinate[points.length];
        for (int i = 0; i < points.length; ++i) {
            coords[i] = new Coordinate(points[i].getX(), points[i].getY());
        }
        if (coords.length == 1) {
            wkt = WKTWriter.toPoint((Coordinate)coords[0]);
        } else {
            CoordinateSequence seq = CoordinateArraySequenceFactory.instance().create(coords);
            wkt = WKTWriter.toLineString((CoordinateSequence)seq);
        }
        return wkt;
    }

    protected String getGeometryWKT() {
        String wkt = null;
        String slat = this.currentRow.get("geom.latitude");
        String slong = this.currentRow.get("geom.longitude");
        if (!StringUtilities.isEmpty((String)slat) && slat.matches("\\-?[0-9]+(\\.[0-9]*)?") && !StringUtilities.isEmpty((String)slong) && slong.matches("\\-?[0-9]+(\\.[0-9]*)?")) {
            double dlat = Double.parseDouble(slat);
            double dlong = Double.parseDouble(slong);
            Coordinate coordinates = new Coordinate(dlong, dlat);
            wkt = WKTWriter.toPoint((Coordinate)coordinates);
        }
        return wkt;
    }

    public void fixFieldLookupCase(String[] columnList, Map<String, List<String>> fieldLookup) {
        ArrayList<String> keys = new ArrayList<String>(fieldLookup.keySet());
        for (String column : columnList) {
            for (String key : keys) {
                if (column.equals(key) || !column.equalsIgnoreCase(key)) continue;
                List<String> value = fieldLookup.get(key);
                fieldLookup.put(column, value);
                fieldLookup.remove(key);
            }
        }
    }

    public static void showFieldLookup(Map<String, List<String>> fieldLookup) {
        logger.debug("-- FieldLookup --");
        ArrayList<String> keys = new ArrayList<String>(fieldLookup.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            System.out.printf("%-20.20s : %s\n", key, Arrays.toString(fieldLookup.get(key).toArray()));
        }
        logger.debug("-----------------");
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

