/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc;

import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.DataReadException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcRawDataSource
extends StandardRawDataSource {
    public static final Logger logger = LoggerFactory.getLogger(AbstractJdbcRawDataSource.class);
    public static final String KEY_CONNECTION_URL = "connection_url";
    public static final String KEY_USER_ID = "user_id";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_SELECT_STATMENT = "select_statment";
    public static final String KEY_SELECT_STATMENT_WHERE_CLAUSE = "where_clause";
    public static final String KEY_COORD_SYSTEM = "coordinate_system";
    public static final String KEY_PREFETCH = "prefetch";
    public static final String KEY_GEOMETRY_COL_NAME = "GeometryName";
    public static final String DEFAULT_GEOMETRY_NAME = "GEOM";
    public static boolean DEBUG = false;
    protected Connection conn;
    protected Statement statement;
    protected ResultSet resultSet;
    protected String sqlQuery;
    protected Properties properties;
    private Map<String, String> currentRow = new HashMap<String, String>();
    private boolean hasNext = false;
    private boolean hasNextCached = false;
    private Map<String, List<String>> fieldLookup = new HashMap<String, List<String>>();

    protected void setGeometry(Map<String, String> currentRow) {
        block8: {
            String name = this.properties.getProperty(KEY_GEOMETRY_COL_NAME);
            if (!AbstractJdbcRawDataSource.isEmpty(name)) {
                if (name.contains("/")) {
                    String[] cols = name.split("/");
                    try {
                        double x = this.resultSet.getDouble(cols[0]);
                        boolean wasNull = this.resultSet.wasNull();
                        double y = this.resultSet.getDouble(cols[1]);
                        boolean bl = wasNull = wasNull || this.resultSet.wasNull();
                        if (!wasNull) {
                            currentRow.put("Geometry", AbstractJdbcRawDataSource.getWKT(x, y));
                        }
                        break block8;
                    }
                    catch (SQLException e) {
                        if (logger.isInfoEnabled()) {
                            logger.info("sql exception retrieving geometry info: " + e.getMessage());
                        }
                        break block8;
                    }
                    catch (ParseException e) {
                        if (logger.isInfoEnabled()) {
                            logger.info("WKT parse exception: " + e.getMessage());
                        }
                        break block8;
                    }
                }
                currentRow.put("Geometry", currentRow.get(KEY_GEOMETRY_COL_NAME));
            }
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setFieldLookup(ResultSet resultSet) throws SQLException {
        HashMap<String, Object> columnInfo = new HashMap<String, Object>();
        if (DEBUG) {
            logger.info("Result Set Columns:-------");
        }
        ResultSetMetaData md = resultSet.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            columnInfo.put(md.getColumnName(i).toLowerCase(), null);
            if (!DEBUG) continue;
            logger.info(md.getColumnName(i).toLowerCase());
        }
        this.setColumnInfo(columnInfo);
        if (DEBUG) {
            logger.info("Properties Columns:-------");
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String unsplitValue = (String)entry.getValue();
            for (String string : Arrays.asList(unsplitValue.split("\\s*,\\s*"))) {
                if (string == null || string.isEmpty()) continue;
                if (DEBUG) {
                    logger.info(String.format("%-20.20s : %s", key, string));
                }
                if (columnInfo.containsKey(string.toLowerCase())) {
                    if (!this.fieldLookup.containsKey(string)) {
                        this.fieldLookup.put(string, new ArrayList());
                    }
                    this.fieldLookup.get(string).add(key);
                    continue;
                }
                if (!string.contains("/")) continue;
                String[] values = string.split("/");
                for (int i = 0; i < values.length; ++i) {
                    if (!this.fieldLookup.containsKey(values[i])) {
                        this.fieldLookup.put(values[i], new ArrayList());
                    }
                    this.fieldLookup.get(values[i]).add(key + "_" + i);
                }
            }
        }
        if (DEBUG) {
            ArrayList<String> keys = new ArrayList<String>(this.fieldLookup.keySet());
            Collections.sort(keys);
            logger.info("Field Lookups:-------");
            for (String key : keys) {
                logger.info(String.format("%-20.20s : %s", key, Arrays.toString(this.fieldLookup.get(key).toArray())));
            }
        }
        for (String string : this.properties.stringPropertyNames()) {
            String value = this.properties.getProperty(string, "");
            if (value.isEmpty() || string.equalsIgnoreCase("Combine_Alt_Vals_Delim")) continue;
            boolean found = false;
            for (Map.Entry entry : this.fieldLookup.entrySet()) {
                for (String aFieldLookup : (List)entry.getValue()) {
                    if (!aFieldLookup.equalsIgnoreCase(string)) continue;
                    found = true;
                }
            }
            if (found) continue;
            logger.warn(String.format("The column mapping key of %s with value of %s is not mapped to a result set column!", string, value));
        }
    }

    @Override
    public void rewind() {
        if (this.statement != null) {
            try {
                if (this.resultSet != null && this.resultSet.isBeforeFirst()) {
                    return;
                }
                if (this.resultSet != null && this.resultSet.getType() != 1003) {
                    this.resultSet.beforeFirst();
                } else {
                    if (this.resultSet != null) {
                        this.resultSet.close();
                        this.resultSet = null;
                    }
                    this.resultSet = this.statement.executeQuery(this.sqlQuery);
                }
            }
            catch (SQLException e) {
                throw new DataReadException(e);
            }
        }
    }

    @Override
    public boolean loadNextFileSet() {
        try {
            boolean bl = this.resultSet != null && this.resultSet.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            throw new DataReadException(e);
        }
        finally {
            this.hasNextCached = false;
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
            throw new CGGERuntimeException(sqe.getMessage());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextCached) {
            return this.hasNext;
        }
        this.hasNextCached = true;
        this.hasNext = false;
        try {
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException e) {
            throw new DataReadException(e);
        }
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> next() {
        try {
            if (this.hasNext()) {
                this.currentRow.clear();
                for (String key : this.fieldLookup.keySet()) {
                    try {
                        String value = this.resultSet.getString(key);
                        for (String k : this.fieldLookup.get(key)) {
                            String previousValue;
                            String valueToAdd;
                            String string = valueToAdd = this.resultSet.wasNull() ? null : value;
                            if (this.currentRow.containsKey(k) && valueToAdd != null && !StringUtilities.isEmpty((String)valueToAdd) && (previousValue = this.currentRow.get(k)) != null) {
                                valueToAdd = value + this.properties.getProperty("Combine_Alt_Vals_Delim") + this.currentRow.get(k);
                            }
                            if (valueToAdd == null) continue;
                            this.currentRow.put(k, valueToAdd);
                        }
                    }
                    catch (SQLException e) {
                        logger.debug("unknown column: " + this.fieldLookup.get(key) + " (" + key + ")");
                    }
                }
                this.setGeometry(this.currentRow);
                this.setCurrentRow(this.currentRow);
            }
        }
        finally {
            this.hasNextCached = false;
        }
        return this.currentRow;
    }

    @Override
    public String getCurrentFileSetName() {
        return null;
    }

    protected void fixFieldLookupCase(ResultSetMetaData rsmd, Properties properties) throws SQLException {
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i);
            if (properties.values().contains(colName)) continue;
            ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
            for (Object e : keys) {
                Object value = properties.get(e);
                if (colName.equals((String)value) || !colName.equalsIgnoreCase((String)value)) continue;
                properties.put(e, colName);
            }
        }
    }

    protected void confirmMappedFieldsLocal(ResultSetMetaData rsmd, Properties properties) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder("--- mapping from database metadata to internal field type ---");
        HashSet<Object> unmapped = new HashSet<Object>(properties.keySet());
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String string = rsmd.getColumnName(i);
            if (properties.values().contains(string)) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (string.equals(entry.getValue())) {
                        sb.append(String.format("%-20.20s : %s\n", string, entry.getKey()));
                    }
                    unmapped.remove(entry.getKey());
                }
                continue;
            }
            sb.append(String.format("%-20.20s : %s\n", string, "(unmapped column)"));
        }
        for (Object e : unmapped) {
            sb.append(String.format("%-20.20s : %s", "(unmapped property)\n", e));
        }
        sb.append("--- end of mapping ---");
        logger.info(sb.toString());
    }
}

