/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.oracle.Oracle_DataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.CSV_DataDestination;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSV_DataDestination;
import com.mapinfo.midev.data.ICursor;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.data.ITable;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import com.mapinfo.midev.table.Table;
import com.mapinfo.midev.tabledepot.TableDepot;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import oracle.sql.STRUCT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneUtils {
    static final Logger logger = LoggerFactory.getLogger(CloneUtils.class);

    private static void cloneTabToSQLHelper(IDataSourceTable miTable, PreparedStatement ps) throws SQLException, IOException, IllegalAccessException {
        ITableMetadata md = miTable.getMetadata();
        int counter = 0;
        try {
            String tableName = miTable.getDefinition().getName();
            TableDepot tableDepot = new TableDepot();
            Table table = new Table(miTable);
            tableDepot.add(tableName, (ITable)table);
            String query = "select * from " + tableName;
            ICursor record = tableDepot.search(query);
            while (record.hasNext()) {
                IFeature feature = record.next();
                AttributeDefinitionCollection cols = md.getAttributeDefinitions();
                block13: for (int i = 0; i < cols.size(); ++i) {
                    IAttributeDefinition cmd = cols.get(i);
                    switch (cmd.getDataType()) {
                        case CHAR: {
                            ps.setString(i + 1, feature.getString(i));
                            continue block13;
                        }
                        case DOUBLE: {
                            if (cmd.getDecimals() == 0 && cmd.getWidth() < 8) {
                                ps.setInt(i + 1, feature.getInt(i));
                                continue block13;
                            }
                            ps.setBigDecimal(i + 1, new BigDecimal(feature.getString(i)));
                            continue block13;
                        }
                        case FLOAT: {
                            ps.setFloat(i + 1, feature.getFloat(i));
                            continue block13;
                        }
                        case INTEGER: {
                            ps.setInt(i + 1, feature.getInt(i));
                            continue block13;
                        }
                        case SHORT_INTEGER: {
                            ps.setShort(i + 1, feature.getShort(i));
                            continue block13;
                        }
                        default: {
                            ps.setString(i + 1, feature.getString(i));
                        }
                    }
                }
                ps.addBatch();
                if (++counter % 1000 != 0) continue;
                ps.executeBatch();
                ps.getConnection().commit();
                ps.clearParameters();
            }
            record.dispose();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.debug(e.getMessage());
            logger.debug("counter: " + counter);
            throw e;
        }
        finally {
            if (counter % 1000 != 0) {
                ps.executeBatch();
                ps.getConnection().commit();
            }
        }
    }

    public static String prepareInsertStatementFromTabFile(IDataSourceTable miTable) throws IOException {
        int j;
        StringBuilder sb = new StringBuilder("insert into " + miTable.getDefinition().getName() + " (");
        AttributeDefinitionCollection md = miTable.getMetadata().getAttributeDefinitions();
        for (j = 0; j < md.size(); ++j) {
            sb.append(md.get(j).getName() + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(") values (");
        for (j = 0; j < md.size(); ++j) {
            sb.append("?,");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        String sql = sb.toString();
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cloneTabToSQL(String tabPath, final String tabName, String url, Properties connProperties) throws ClassNotFoundException, IllegalAccessException, FileNotFoundException, IOException, SQLException {
        File[] files = new File(tabPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                logger.debug("name: " + name);
                if (name.matches(tabName + "(_[0-9]+)?.*")) {
                    return name.toUpperCase().endsWith(".MAP");
                }
                return false;
            }
        });
        if (files.length == 0) {
            System.out.printf("no files found: %s, %s\n", tabPath, tabName);
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = DriverManager.getConnection(url, connProperties);
            conn.setAutoCommit(false);
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i].getName();
                NativeDataProvider dp = NativeDataProvider.getInstance();
                String tabFileName = filename.substring(0, filename.length() - 4);
                IDataSourceTable miTable = NativeDataProvider.getInstance().openTable(new File(tabPath, tabFileName));
                if (i == 0) {
                    String ddl = CloneUtils.sqlTableDdlFromTabFile(miTable);
                    try (Statement stmt = null;){
                        stmt = conn.createStatement();
                        stmt.execute("drop table if exists " + miTable.getDefinition().getName());
                        stmt.execute(ddl);
                        String sql = CloneUtils.prepareInsertStatementFromTabFile(miTable);
                        ps = conn.prepareStatement(sql);
                    }
                }
                CloneUtils.cloneTabToSQLHelper(miTable, (PreparedStatement)ps);
                miTable.close();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void cloneSqlToSql(String sourceUrl, Properties sourceConnProperties, String schemaName, String tableName, String destUrl, Properties destConnProperties) throws SQLException {
        if (sourceUrl.equals(destUrl)) {
            System.err.println("cowardly refusing to copy SQL data onto itself.");
            return;
        }
        Connection sourceConn = null;
        Statement ps = null;
        Connection destConn = null;
        try {
            sourceConn = DriverManager.getConnection(sourceUrl, sourceConnProperties);
            String ddl = CloneUtils.sqlTableDdlFromJdbc(sourceConn, schemaName, tableName);
            logger.debug(ddl);
            TreeMap<String, Integer> colInfo = new TreeMap<String, Integer>();
            int counter = 0;
            destConn = DriverManager.getConnection(destUrl, destConnProperties);
            destConn.setAutoCommit(false);
            destConn.createStatement().execute(ddl);
            destConn.commit();
            Statement stmt = destConn.createStatement();
            try {
                stmt.execute("truncate table " + tableName);
            }
            catch (SQLException e) {
                stmt.execute("delete from " + tableName);
            }
            ps = destConn.prepareStatement("select * from " + tableName + " limit 1");
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                colInfo.put(rsmd.getColumnName(i), rsmd.getColumnType(i));
            }
            rs.close();
            StringBuilder sb = new StringBuilder();
            sb.append("insert into " + tableName + " (");
            for (String colName : colInfo.keySet()) {
                sb.append(colName + ", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") values (");
            for (String colName : colInfo.keySet()) {
                sb.append("?,");
            }
            sb.setLength(sb.length() - 1);
            sb.append(")");
            String sql = sb.toString();
            logger.debug(sql);
            ps = destConn.prepareStatement(sql);
            rs = schemaName != null && !schemaName.trim().isEmpty() ? sourceConn.createStatement().executeQuery("select * from " + schemaName + "." + tableName) : sourceConn.createStatement().executeQuery("select * from " + tableName);
            destConn.setAutoCommit(false);
            while (rs.next()) {
                ArrayList keys = new ArrayList(colInfo.keySet());
                block21: for (int colno = 0; colno < colInfo.size(); ++colno) {
                    int dataType = (Integer)colInfo.get(keys.get(colno));
                    switch (dataType) {
                        case -15: 
                        case -9: 
                        case 1: 
                        case 12: {
                            String s = rs.getString((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setString(colno + 1, s);
                            continue block21;
                        }
                        case 4: {
                            int i = rs.getInt((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setInt(colno + 1, i);
                            continue block21;
                        }
                        case 5: {
                            short sm = rs.getShort((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setShort(colno + 1, sm);
                            continue block21;
                        }
                        case 2: 
                        case 3: {
                            BigDecimal bd = rs.getBigDecimal((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setBigDecimal(colno + 1, bd);
                            continue block21;
                        }
                        case 92: {
                            Time time = rs.getTime((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setTime(colno + 1, time);
                            continue block21;
                        }
                        case 91: {
                            Date date = rs.getDate((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setDate(colno + 1, date);
                            continue block21;
                        }
                        case 93: {
                            Timestamp ts = rs.getTimestamp((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setTimestamp(colno + 1, ts);
                            continue block21;
                        }
                        case 2002: {
                            STRUCT st = (STRUCT)rs.getObject((String)keys.get(colno));
                            if (rs.wasNull()) {
                                ps.setNull(colno + 1, dataType);
                                continue block21;
                            }
                            ps.setString(colno + 1, Oracle_DataSource.getWKT(st));
                            continue block21;
                        }
                        default: {
                            logger.debug("unhandled column: " + (String)keys.get(colno));
                            logger.debug("unhandled type: " + dataType);
                            ps.setNull(colno + 1, dataType);
                        }
                    }
                }
                ps.addBatch();
                if (++counter % 1000 != 0) continue;
                ps.executeBatch();
                destConn.commit();
                ps.clearParameters();
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (destConn != null) {
                destConn.close();
            }
            if (sourceConn != null) {
                sourceConn.close();
            }
        }
    }

    public static String sqlTableDdlFromTabFile(IDataSourceTable miTable) throws IOException {
        StringBuilder sb = new StringBuilder("create table if not exists " + miTable.getDefinition().getName() + " (\n");
        AttributeDefinitionCollection md = miTable.getMetadata().getAttributeDefinitions();
        for (int i = 0; i < md.size(); ++i) {
            IAttributeDefinition cmd = md.get(i);
            sb.append("  " + cmd.getName() + " ");
            switch (cmd.getDataType()) {
                case CHAR: {
                    sb.append("varchar(" + cmd.getWidth() + ")");
                    break;
                }
                case DATE: {
                    sb.append("timestamp");
                    break;
                }
                case DOUBLE: {
                    if (cmd.getDecimals() == 0 && cmd.getWidth() < 8) {
                        sb.append("int");
                        break;
                    }
                    if (cmd.getDecimals() == 0) {
                        sb.append("numeric(" + cmd.getWidth() + ")");
                        break;
                    }
                    sb.append("decimal(" + (cmd.getWidth() - cmd.getDecimals()) + "." + cmd.getDecimals() + ")");
                    break;
                }
                case FLOAT: {
                    sb.append("float");
                    break;
                }
                case INTEGER: {
                    sb.append("int");
                    break;
                }
                case BOOLEAN: {
                    sb.append("char(1)");
                    break;
                }
                case SHORT_INTEGER: {
                    sb.append("int");
                }
            }
            sb.append(",\n");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sqlTableDdlFromJdbc(Connection conn, String schemaName, String tableName) throws SQLException {
        if ("Oracle".equals(conn.getMetaData().getDatabaseProductName())) {
            return CloneUtils.sqlTableDdlFromJdbcLegacy(conn, schemaName, tableName);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (schemaName != null && !schemaName.trim().isEmpty()) {
                ps = conn.prepareStatement("select * from information_schema.columns where schema_name=? and table_name=?");
                ps.setString(1, schemaName);
                ps.setString(2, tableName);
            } else {
                ps = conn.prepareStatement("select * from information_schema.columns where table_name=?");
                ps.setString(1, tableName);
            }
            StringBuilder sb = new StringBuilder("create table if not exists " + tableName + " (");
            rs = ps.executeQuery();
            while (rs.next()) {
                sb.append("  " + rs.getString("COLUMN_NAME") + " ");
                switch (rs.getInt("DATA_TYPE")) {
                    case -9: 
                    case 12: {
                        sb.append("varchar(" + rs.getInt("CHARACTER_MAXIMUM") + ")");
                        break;
                    }
                    case 92: {
                        sb.append("time");
                        break;
                    }
                    case 91: {
                        sb.append("date");
                        break;
                    }
                    case 93: {
                        sb.append("timestamp");
                        break;
                    }
                    case 3: {
                        if (rs.getInt("NUMERIC_SCALE") > 0) {
                            sb.append("decimal(" + rs.getInt("NUMERIC_PRECISION") + "." + rs.getInt("NUMERIC_SCALE") + ")");
                            break;
                        }
                        sb.append("decimal(" + rs.getInt("NUMERIC_PRECISION") + ")");
                        break;
                    }
                    case 2: {
                        if (rs.getInt("NUMERIC_SCALE") > 0) {
                            sb.append("decimal(" + rs.getInt("NUMERIC_PRECISION") + "." + rs.getInt("NUMERIC_SCALE") + ")");
                            break;
                        }
                        sb.append("decimal(" + rs.getInt("NUMERIC_PRECISION") + ")");
                        break;
                    }
                    case 6: {
                        sb.append("float");
                        break;
                    }
                    case 4: {
                        sb.append("int");
                        break;
                    }
                    case 5: {
                        sb.append("int");
                        break;
                    }
                    case 2002: {
                        sb.append("text");
                        break;
                    }
                    default: {
                        logger.debug("unhandled type: " + rs.getInt("DATA_TYPE"));
                    }
                }
                if (rs.getInt("NULLABLE") == 0) {
                    sb.append(" not null");
                }
                String columnDefault = rs.getString("COLUMN_DEFAULT");
                if (!rs.wasNull()) {
                    switch (rs.getInt("DATA_TYPE")) {
                        case -15: 
                        case -9: 
                        case 1: 
                        case 12: {
                            sb.append("default '" + columnDefault + "'");
                            break;
                        }
                        default: {
                            sb.append("default " + columnDefault);
                        }
                    }
                }
                sb.append(",\n");
            }
        }
        catch (SQLException e) {
            logger.debug("sql exception: " + e.getMessage());
            sql = CloneUtils.sqlTableDdlFromJdbcLegacy(conn, schemaName, tableName);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sqlTableDdlFromJdbcLegacy(Connection conn, String schemaName, String tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            stmt = conn.createStatement();
            logger.debug("db: " + conn.getMetaData().getDatabaseProductName());
            String query = null;
            query = schemaName != null && !schemaName.trim().isEmpty() ? "select * from " + schemaName + "." + tableName : "select * from " + tableName;
            query = "Oracle".equals(conn.getMetaData().getDatabaseProductName()) ? query + " where rownum < 2" : query + " limit 1";
            logger.debug("query: '" + query + "'");
            rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            StringBuilder sb = new StringBuilder("create table if not exists " + tableName + " (\n");
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                switch (rsmd.getColumnType(i)) {
                    case -15: 
                    case 1: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("char(" + rsmd.getPrecision(i) + ")");
                        break;
                    }
                    case -9: 
                    case 12: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("varchar(" + rsmd.getPrecision(i) + ")");
                        break;
                    }
                    case 92: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("time");
                        break;
                    }
                    case 91: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("date");
                        break;
                    }
                    case 93: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("timestamp");
                        break;
                    }
                    case 3: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        if (rsmd.getScale(i) > 0) {
                            sb.append("decimal(" + rsmd.getPrecision(i) + "." + rsmd.getScale(i) + ")");
                            break;
                        }
                        sb.append("decimal(" + rsmd.getPrecision(i) + ")");
                        break;
                    }
                    case 2: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        if (rsmd.getScale(i) > 0) {
                            sb.append("numeric(" + rsmd.getPrecision(i) + "," + rsmd.getScale(i) + ")");
                            break;
                        }
                        if (rsmd.getPrecision(i) > 0) {
                            sb.append("numeric(" + rsmd.getPrecision(i) + ")");
                            break;
                        }
                        sb.append("int");
                        break;
                    }
                    case 6: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("float");
                        break;
                    }
                    case 4: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("int");
                        break;
                    }
                    case 5: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("int");
                        break;
                    }
                    case 2002: {
                        sb.append("  " + rsmd.getColumnName(i) + " ");
                        sb.append("text");
                        break;
                    }
                    default: {
                        logger.debug("unhandled column: " + rsmd.getColumnName(i) + " " + rsmd.getColumnTypeName(i) + " " + rsmd.getColumnType(i));
                        sb.setLength(sb.length() - 2);
                    }
                }
                sb.append(",\n");
            }
            sb.setLength(sb.length() - 2);
            sb.append(")");
            sql = sb.toString();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return sql;
    }

    private static void cloneTabToCsvHelper(IDataSourceTable miTable, CSV_DataDestination dest) throws IOException, IllegalAccessException {
        AttributeDefinitionCollection md = miTable.getMetadata().getAttributeDefinitions();
        TreeMap<String, String> data = new TreeMap<String, String>();
        String tableName = miTable.getDefinition().getName();
        TableDepot tableDepot = new TableDepot();
        Table table = new Table(miTable);
        tableDepot.add(tableName, (ITable)table);
        String query = "select * from " + tableName;
        ICursor recordSet = tableDepot.search(query);
        if (recordSet != null) {
            IFeature record = null;
            while (recordSet.hasNext()) {
                record = recordSet.next();
                data.clear();
                for (int i = 0; i < md.size(); ++i) {
                    IAttributeDefinition cmd = md.get(i);
                    String value = record.getString(i);
                    data.put(cmd.getName(), value);
                }
                dest.writeData((Map<String, String>)data);
            }
            recordSet.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cloneTabToCSV(String tabPath, final String tabName, String csvFile) throws ClassNotFoundException, IllegalAccessException, FileNotFoundException, IOException {
        File[] files = new File(tabPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                logger.debug("name: " + name);
                if (name.matches(tabName + "(_[0-9]+)?.*")) {
                    return name.toUpperCase().endsWith(".MAP");
                }
                return false;
            }
        });
        if (files.length == 0) {
            System.out.printf("no files found: %s, %s\n", tabPath, tabName);
            return;
        }
        FileOutputStream os = null;
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        DSV_DataDestination dest = null;
        try {
            File path = new File(new File(tabPath), "csv");
            path.mkdirs();
            os = new FileOutputStream(new File(path, csvFile));
            w = csvFile.endsWith(".gz") ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(os), Charset.forName("UTF-8")) : new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
            pw = new PrintWriter(w);
            dest = new CSV_DataDestination(pw);
            for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
                String filename = files[fileIndex].getName();
                IDataSourceTable miTable = NativeDataProvider.getInstance().openTable(new File(tabPath, filename.substring(0, filename.length() - 4)));
                if (fileIndex == 0) {
                    AttributeDefinitionCollection md = miTable.getMetadata().getAttributeDefinitions();
                    String[] colNames = new String[md.size()];
                    for (int colIndex = 0; colIndex < md.size(); ++colIndex) {
                        colNames[colIndex] = md.get(colIndex).getName();
                    }
                    dest.writeHeader(colNames);
                }
                CloneUtils.cloneTabToCsvHelper(miTable, (CSV_DataDestination)dest);
                miTable.close();
            }
        }
        finally {
            if (dest != null) {
                dest.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cloneSQLToCSV(String sourceUrl, Properties sourceConnProperties, String schemaName, String tableName, String csvFile) throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        FileOutputStream os = null;
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        DSV_DataDestination dest = null;
        try {
            os = new FileOutputStream(csvFile);
            w = csvFile.endsWith(".gz") ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(os), Charset.forName("UTF-8")) : new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
            pw = new PrintWriter(w);
            dest = new CSV_DataDestination(pw);
            conn = DriverManager.getConnection(sourceUrl, sourceConnProperties);
            rs = schemaName != null && !schemaName.trim().isEmpty() ? conn.createStatement().executeQuery("select * from " + schemaName + "." + tableName) : conn.createStatement().executeQuery("select * from " + tableName);
            TreeMap<String, Integer> colInfo = new TreeMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                colInfo.put(rsmd.getColumnName(i), rsmd.getColumnType(i));
            }
            dest.writeHeader(colInfo.keySet().toArray(new String[0]));
            TreeMap<String, String> data = new TreeMap<String, String>();
            while (rs.next()) {
                data.clear();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    data.put(rsmd.getColumnName(i), rs.getString(i));
                }
                dest.writeData((Map<String, String>)data);
            }
        }
        finally {
            if (dest != null) {
                dest.close();
            }
            if (pw != null) {
                pw.flush();
                pw.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

