/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.oracle;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.AbstractJdbcRawDataSource;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class Oracle_DataSource
extends AbstractJdbcRawDataSource {
    private static final DirectPosition[] EMPTY_DOUBLE_POINT_ARRAY = new DirectPosition[0];
    private String ACTUAL_KEY_GEOMETRY_COL_NAME;

    public Oracle_DataSource() throws CGGEInternalException {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException e) {
            throw new CGGEInternalException(e);
        }
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        this.properties = Oracle_DataSource.loadColumnMappings(prop, "Oracle");
        String connURL = this.properties.getProperty("connection_url");
        if (connURL == null) {
            throw new CGGEInternalException("No connection URL specified. Cannot connect to the database");
        }
        String userID = this.properties.getProperty("user_id");
        String password = this.properties.getProperty("password");
        if (userID == null || userID.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No UserID provided");
        }
        if (password == null || password.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No Password provided");
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", userID);
        connectionProperties.put("password", password);
        connectionProperties.put("prefetch", "1000");
        this.sqlQuery = this.properties.getProperty("select_statment");
        String sqlWhereClause = this.properties.getProperty("where_clause");
        if (this.sqlQuery == null || this.sqlQuery.trim().length() == 0) {
            throw new CGGEInternalException("No select statement specified");
        }
        try {
            this.prepareSacMappings(this.properties);
            this.properties.remove("IsSacFromFile");
        }
        catch (InvalidSacException e) {
            DataBuilder.m_consoleLogger.error("Data build is terminated: SAC mapping not specified or invalid.");
            DataBuilder.m_consoleLogger.error(e.getMessage());
            throw e;
        }
        this.ACTUAL_KEY_GEOMETRY_COL_NAME = this.properties.getProperty("GeometryName");
        if (StringUtilities.isEmpty((String)this.ACTUAL_KEY_GEOMETRY_COL_NAME)) {
            this.ACTUAL_KEY_GEOMETRY_COL_NAME = "GEOM";
        }
        this.properties.remove("GeometryName");
        this.setCoordSysString(prop.getProperty("coordinate_system"));
        this.properties.remove("connection_url");
        this.properties.remove("user_id");
        this.properties.remove("password");
        this.properties.remove("select_statment");
        this.properties.remove("where_clause");
        this.conn = DriverManager.getConnection(connURL, connectionProperties);
        this.statement = this.conn.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlQuery);
        this.setFieldLookup(this.resultSet);
        this.fixFieldLookupCase(this.resultSet.getMetaData(), this.properties);
        this.confirmMappedFieldsLocal(this.resultSet.getMetaData(), this.properties);
        this.confirmMappedFields(this.properties);
        boolean possiblePointData = false;
        if (Oracle_DataSource.isEmpty((String)this.properties.get("LeftStruct")) && Oracle_DataSource.isEmpty((String)this.properties.get("RightStruct"))) {
            possiblePointData = true;
        }
        this.setPossiblePointData(possiblePointData);
        return true;
    }

    @Override
    protected void setGeometry(Map<String, String> currentRow) {
        try {
            STRUCT st = (STRUCT)this.resultSet.getObject(this.ACTUAL_KEY_GEOMETRY_COL_NAME);
            currentRow.put("Geometry", Oracle_DataSource.getWKT(st));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DirectPosition[] getCoordinates() {
        DirectPosition[] points = EMPTY_DOUBLE_POINT_ARRAY;
        JGeometry geom = null;
        try {
            STRUCT st = (STRUCT)this.resultSet.getObject(this.ACTUAL_KEY_GEOMETRY_COL_NAME);
            geom = JGeometry.load((STRUCT)st);
            CoordinateSequence seq = Oracle_DataSource.getCoordinates(geom);
            points = new DirectPosition[2 * seq.size()];
            for (int i = 0; i < seq.size(); ++i) {
                points[i] = new DirectPosition(seq.getX(i), seq.getY(i));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return points;
    }

    private static CoordinateSequence getCoordinates(JGeometry jgeom) {
        if (jgeom != null) {
            int type = jgeom.getType();
            switch (type) {
                case 2: 
                case 5: {
                    int nPoints = jgeom.getNumPoints();
                    double[] ordinates = jgeom.getOrdinatesArray();
                    Coordinate[] coords = new Coordinate[nPoints];
                    for (int i = 0; i < nPoints; ++i) {
                        coords[i] = new Coordinate(ordinates[i * 2], ordinates[i * 2 + 1]);
                    }
                    return new CoordinateArraySequence(coords);
                }
                case 1: {
                    double[] p = jgeom.getPoint();
                    Coordinate[] coords = new Coordinate[]{new Coordinate(p[0], p[1])};
                    return new CoordinateArraySequence(coords);
                }
            }
            DataBuilder.m_consoleLogger.warn("Geometry type " + type + "not handled. Geometry will be ignored");
        }
        return null;
    }

    public static String getWKT(STRUCT st) throws SQLException {
        JGeometry geom = JGeometry.load((STRUCT)st);
        CoordinateSequence coordinates = Oracle_DataSource.getCoordinates(geom);
        String wkt = null;
        if (coordinates != null && coordinates.size() != 0) {
            wkt = coordinates.size() == 1 ? WKTWriter.toPoint((Coordinate)coordinates.getCoordinate(0)) : WKTWriter.toLineString((CoordinateSequence)coordinates);
        }
        return wkt;
    }
}

