/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.oracle;

import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.DataReadException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.oracle.Oracle_RecordAddress;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class Oracle_Reader
extends RawDataReader {
    public static String KEY_CONNECTION_URL = "connection_url";
    public static String KEY_USER_ID = "user_id";
    public static String KEY_PASSWORD = "password";
    public static String KEY_SELECT_STATMENT = "select_statment";
    public static String KEY_SELECT_STATMENT_WHERE_CLAUSE = "where_clause";
    public static String KEY_COORD_SYSTEM = "coordinate_system";
    public static String KEY_COUNTRY_COL_NAME = "RecordCountry";
    public static String KEY_COMBINE_ALT_VALS_DELIM = "Combine_Alt_Vals_Delim";
    public static String KEY_PLACENAME_COL_NAME = "PlaceName";
    public static String KEY_LEFT_UNIT_PLACENAME_COL_NAME = "LeftUnitPlaceName";
    public static String KEY_RIGHT_UNIT_PLACENAME_COL_NAME = "RightUnitPlaceName";
    public static String KEY_LEFT_RANGE_PLACENAME_COL_NAME = "LeftRangePlaceName";
    public static String KEY_RIGHT_RANGE_PLACENAME_COL_NAME = "RightRangePlaceName";
    public static String KEY_STREET_COL_NAME = "Street";
    public static String KEY_LEFTRANGE_FROM_COL_NAME = "FromLeft";
    public static String KEY_LEFTRANGE_TO_COL_NAME = "ToLeft";
    public static String KEY_RIGHTRANGE_FROM_COL_NAME = "FromRight";
    public static String KEY_RIGHTRANGE_TO_COL_NAME = "ToRight";
    public static String KEY_LEFT_STRUCT_COL_NAME = "LeftStruct";
    public static String KEY_RIGHT_STRUCT_COL_NAME = "RightStruct";
    public static String KEY_LEFT_PC_COL_NAME = "LeftPostcode";
    public static String KEY_RIGHT_PC_COL_NAME = "RightPostcode";
    public static String KEY_LEFT_PC_EX_COL_NAME = "LeftPostcodeEx";
    public static String KEY_RIGHT_PC_EX_COL_NAME = "RightPostcodeEx";
    public static String KEY_LEFT_AREANAME1_COL_NAME = "LeftAreaName1";
    public static String KEY_LEFT_AREANAME2_COL_NAME = "LeftAreaName2";
    public static String KEY_LEFT_AREANAME3_COL_NAME = "LeftAreaName3";
    public static String KEY_LEFT_AREANAME4_COL_NAME = "LeftAreaName4";
    public static String KEY_RIGHT_AREANAME1_COL_NAME = "RightAreaName1";
    public static String KEY_RIGHT_AREANAME2_COL_NAME = "RightAreaName2";
    public static String KEY_RIGHT_AREANAME3_COL_NAME = "RightAreaName3";
    public static String KEY_RIGHT_AREANAME4_COL_NAME = "RightAreaName4";
    private static final String KEY_LEFT_GENERIC_FIELD1_COL_NAME = "LeftGenericField1";
    private static final String KEY_RIGHT_GENERIC_FIELD1_COL_NAME = "RightGenericField1";
    private static final String KEY_LEFT_GENERIC_FIELD2_COL_NAME = "LeftGenericField2";
    private static final String KEY_RIGHT_GENERIC_FIELD2_COL_NAME = "RightGenericField2";
    public static String KEY_GENERIC_FIELD1_COL_NAME = "GenericField1";
    public static String KEY_GENERIC_FIELD2_COL_NAME = "GenericField2";
    public static String KEY_GENERIC_FIELD3_COL_NAME = "GenericField3";
    public static String KEY_GENERIC_FIELD4_COL_NAME = "GenericField4";
    public static String KEY_ALT_STREET_COL_NAME = "Alt_Street";
    public static String KEY_ALT_PLACENAME_COL_NAME = "Alt_PlaceName";
    public static String KEY_ALT_LEFT_PC_COL_NAME = "Alt_LeftPostcode";
    public static String KEY_ALT_RIGHT_PC_COL_NAME = "Alt_RightPostcode";
    public static String KEY_ALT_LEFT_PC_EX_COL_NAME = "Alt_LeftPostcodeEx";
    public static String KEY_ALT_RIGHT_PC_EX_COL_NAME = "Alt_RightPostcodeEx";
    public static String KEY_ALT_LEFT_AREANAME1_COL_NAME = "Alt_LeftAreaName1";
    public static String KEY_ALT_LEFT_AREANAME2_COL_NAME = "Alt_LeftAreaName2";
    public static String KEY_ALT_LEFT_AREANAME3_COL_NAME = "Alt_LeftAreaName3";
    public static String KEY_ALT_LEFT_AREANAME4_COL_NAME = "Alt_LeftAreaName4";
    public static String KEY_ALT_RIGHT_AREANAME1_COL_NAME = "Alt_RightAreaName1";
    public static String KEY_ALT_RIGHT_AREANAME2_COL_NAME = "Alt_RightAreaName2";
    public static String KEY_ALT_RIGHT_AREANAME3_COL_NAME = "Alt_RightAreaName3";
    public static String KEY_ALT_RIGHT_AREANAME4_COL_NAME = "Alt_RightAreaName4";
    public static String KEY_ALT_GENERIC_FIELD1_COL_NAME = "Alt_GenericField1";
    public static String KEY_ALT_GENERIC_FIELD2_COL_NAME = "Alt_GenericField2";
    public static String KEY_ALT_GENERIC_FIELD3_COL_NAME = "Alt_GenericField3";
    public static String KEY_ALT_GENERIC_FIELD4_COL_NAME = "Alt_GenericField4";
    public static String KEY_GEOMETRY_COL_NAME = "GeometryName";
    public static final String DEFAULT_GEOMETRY_NAME = "GEOM";
    private Statement m_statement;
    private ResultSet m_resultSet;
    private String m_sqlQuery;
    private boolean m_possiblePointData;
    private String m_coordSys;
    private Oracle_RecordAddress m_rightRecord;
    private String m_altValsDelim;
    private boolean m_bIsTest = false;
    protected String dataName = "";
    private Connection m_conn;

    @Override
    public boolean loadData(Properties prop) throws Exception {
        String dn;
        String country = prop.getProperty("country");
        this.dataName = dn = prop.getProperty("dataName");
        String dp = prop.getProperty("dataProviderName");
        String path = "/com/mapinfo/mapmarker/" + country + "/config/" + dn + "_" + dp + "_OracleColumnMapping.properties";
        this.m_properties = null;
        this.m_properties = CGGEResourceBundle.getBundle(path);
        try {
            this.prepareSacMappings();
            this.confirmMappings();
            this.m_possiblePointData = false;
            if (this.isEmpty((String)this.m_properties.get(KEY_LEFT_STRUCT_COL_NAME)) && this.isEmpty((String)this.m_properties.get(KEY_RIGHT_STRUCT_COL_NAME))) {
                this.m_possiblePointData = true;
            }
        }
        catch (InvalidSacException ise) {
            DataBuilder.m_consoleLogger.error("Data build terminated: SAC mapping not specified or invalid");
            DataBuilder.m_consoleLogger.error(ise.getMessage());
            throw ise;
        }
        catch (InvalidFieldMappingException ife) {
            throw new InvalidFieldMappingException(ife.getMessage() + "\n Check " + path);
        }
        this.m_altValsDelim = (String)this.m_properties.get(KEY_COMBINE_ALT_VALS_DELIM);
        this.m_coordSys = prop.getProperty(KEY_COORD_SYSTEM);
        Class.forName("oracle.jdbc.driver.OracleDriver");
        String connURL = this.m_properties.getProperty(KEY_CONNECTION_URL);
        if (connURL == null) {
            throw new Exception("No connection URL specified. Cannot connect to the database");
        }
        String userID = this.m_properties.getProperty(KEY_USER_ID);
        String password = this.m_properties.getProperty(KEY_PASSWORD);
        if (userID == null || userID.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No UserID provided");
        }
        if (password == null || password.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No Password provided");
        }
        this.m_sqlQuery = this.m_properties.getProperty(KEY_SELECT_STATMENT);
        String m_sqlWhereClause = this.m_properties.getProperty(KEY_SELECT_STATMENT_WHERE_CLAUSE);
        if (this.m_bIsTest && m_sqlWhereClause != null) {
            this.m_sqlQuery = this.m_sqlQuery + " " + m_sqlWhereClause;
        }
        if (this.m_sqlQuery == null || this.m_sqlQuery.trim().length() == 0) {
            throw new Exception("No select statment specified");
        }
        Properties props = new Properties();
        props.put("user", userID);
        props.put("password", password);
        props.put("prefetch", "1000");
        this.m_conn = DriverManager.getConnection(connURL, props);
        this.m_statement = this.m_conn.createStatement();
        this.m_resultSet = this.m_statement.executeQuery(this.m_sqlQuery);
        return true;
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public void setIsTest(boolean val) {
        this.m_bIsTest = val;
    }

    @Override
    public void close() {
        try {
            this.m_conn.close();
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
            throw new CGGERuntimeException(sqe.getMessage());
        }
    }

    @Override
    protected void confirmMappings() throws InvalidFieldMappingException {
        Iterator<Object> itr = this.m_properties.keySet().iterator();
        String key = null;
        while (itr.hasNext()) {
            key = (String)itr.next();
            if (this.isValidAddressField(key)) continue;
            throw new InvalidFieldMappingException("Property \"" + key + "\" is not a valid field");
        }
    }

    protected String getFieldValue(String fieldKey) {
        return this.getColumnValue(this.m_properties.getProperty(fieldKey));
    }

    private String getColumnValue(String colName) {
        if (colName != null && (colName = colName.trim()).length() > 0) {
            String str = null;
            try {
                str = this.m_resultSet.getString(colName);
            }
            catch (SQLException e) {
                throw new DataReadException("Problem fetching value for column: " + colName, e);
            }
            return str;
        }
        return null;
    }

    private boolean isValidAddressField(String str) {
        boolean isValid = false;
        if (str.equals(KEY_CONNECTION_URL) || str.equals(KEY_COUNTRY_COL_NAME) || str.equals(KEY_USER_ID) || str.equals(KEY_PASSWORD) || str.equals(KEY_SELECT_STATMENT) || str.equals(KEY_COORD_SYSTEM) || str.equals(KEY_LEFT_UNIT_PLACENAME_COL_NAME) || str.equals(KEY_RIGHT_UNIT_PLACENAME_COL_NAME) || str.equals(KEY_LEFT_RANGE_PLACENAME_COL_NAME) || str.equals(KEY_RIGHT_RANGE_PLACENAME_COL_NAME) || str.equals(KEY_PLACENAME_COL_NAME) || str.equals(KEY_STREET_COL_NAME) || str.equals(KEY_LEFTRANGE_FROM_COL_NAME) || str.equals(KEY_LEFTRANGE_TO_COL_NAME) || str.equals(KEY_RIGHTRANGE_FROM_COL_NAME) || str.equals(KEY_RIGHTRANGE_TO_COL_NAME) || str.equals(KEY_LEFT_STRUCT_COL_NAME) || str.equals(KEY_RIGHT_STRUCT_COL_NAME) || str.equals(KEY_LEFT_PC_COL_NAME) || str.equals(KEY_RIGHT_PC_COL_NAME) || str.equals(KEY_LEFT_PC_EX_COL_NAME) || str.equals(KEY_RIGHT_PC_EX_COL_NAME) || str.equals(KEY_LEFT_AREANAME1_COL_NAME) || str.equals(KEY_LEFT_AREANAME2_COL_NAME) || str.equals(KEY_LEFT_AREANAME3_COL_NAME) || str.equals(KEY_LEFT_AREANAME4_COL_NAME) || str.equals(KEY_RIGHT_AREANAME1_COL_NAME) || str.equals(KEY_RIGHT_AREANAME2_COL_NAME) || str.equals(KEY_RIGHT_AREANAME3_COL_NAME) || str.equals(KEY_RIGHT_AREANAME4_COL_NAME) || str.equals(KEY_ALT_PLACENAME_COL_NAME) || str.equals(KEY_ALT_STREET_COL_NAME) || str.equals(KEY_ALT_LEFT_PC_COL_NAME) || str.equals(KEY_ALT_RIGHT_PC_COL_NAME) || str.equals(KEY_ALT_LEFT_PC_EX_COL_NAME) || str.equals(KEY_ALT_RIGHT_PC_EX_COL_NAME) || str.equals(KEY_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_GENERIC_FIELD3_COL_NAME) || str.equals(KEY_GENERIC_FIELD4_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD3_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD4_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME1_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME2_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME3_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME4_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME1_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME2_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME3_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME4_COL_NAME) || str.equals("Sac") || str.equals("LeftSac") || str.equals("RightSac") || str.equals("IsSacFromFile") || str.equals(KEY_COMBINE_ALT_VALS_DELIM) || m_dditionalFieldNames != null && m_dditionalFieldNames.containsKey(str) || str.equals(KEY_GEOMETRY_COL_NAME) || str.equals(KEY_SELECT_STATMENT_WHERE_CLAUSE) || str.equals(KEY_LEFT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_RIGHT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_LEFT_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_RIGHT_GENERIC_FIELD2_COL_NAME)) {
            isValid = true;
        }
        return isValid;
    }

    public Oracle_RecordAddress getNextLeftAddress() {
        Oracle_RecordAddress leftAddress = null;
        leftAddress = new Oracle_RecordAddress();
        leftAddress.setStreetSide(1);
        String str = this.getFieldValue(KEY_LEFT_STRUCT_COL_NAME);
        int type = 0;
        try {
            type = str != null ? (int)Double.parseDouble(str) : type;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        leftAddress.setOddEvenType(this.checkHNRType(type));
        String leftFrom = null;
        String leftTo = null;
        if (this.m_possiblePointData || leftAddress.getOddEvenType() != 0) {
            leftFrom = this.getFieldValue(KEY_LEFTRANGE_FROM_COL_NAME);
            leftTo = this.getFieldValue(KEY_LEFTRANGE_TO_COL_NAME);
        }
        if (leftTo != null && this.m_possiblePointData && (leftFrom == leftTo || leftFrom.equals(leftTo))) {
            leftTo = null;
        }
        leftAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(leftFrom));
        leftAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(leftTo));
        this.setAddressField(leftAddress, KEY_LEFT_UNIT_PLACENAME_COL_NAME, FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_UNIT_PLACENAME_COL_NAME, FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_PLACENAME_COL_NAME, FieldType.PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_STREET_COL_NAME, FieldType.STREET_NAME_FIELD_TYPE);
        this.handleGenericFieldsLeftAddress(leftAddress);
        this.setCoordinates(leftAddress);
        this.setSACtoAddress(leftAddress, "LeftSac");
        this.populateAdditionalFields(leftAddress);
        this.setAddressField(leftAddress, KEY_COUNTRY_COL_NAME, FieldType.COUNTRY_FIELD_TYPE);
        return leftAddress;
    }

    protected void handleGenericFieldsLeftAddress(Oracle_RecordAddress leftAddress) {
        this.setGenericField(leftAddress, KEY_GENERIC_FIELD1_COL_NAME, KEY_LEFT_GENERIC_FIELD1_COL_NAME, FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        this.setGenericField(leftAddress, KEY_GENERIC_FIELD2_COL_NAME, KEY_LEFT_GENERIC_FIELD2_COL_NAME, FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }

    protected void setSACtoAddress(Oracle_RecordAddress address, String sacColumnName) {
        String str = null;
        if (this.isSacFromFile()) {
            if (this.isLeftAndRightSac()) {
                str = this.getFieldValue(sacColumnName);
                str = str == null ? str : str.trim();
                address.setSac(str);
            } else {
                str = this.getFieldValue("Sac");
                str = str == null ? str : str.trim();
                address.setSac(str);
            }
        }
    }

    protected void setCoordinates(Oracle_RecordAddress address) {
        String str = this.m_properties.getProperty(KEY_GEOMETRY_COL_NAME);
        if (StringUtilities.isEmpty((String)str)) {
            str = DEFAULT_GEOMETRY_NAME;
        }
        JGeometry geom = null;
        try {
            STRUCT st = (STRUCT)this.m_resultSet.getObject(str);
            geom = JGeometry.load((STRUCT)st);
        }
        catch (SQLException st) {
            // empty catch block
        }
        DirectPosition[] points = this.getCoordinates(geom);
        address.setCoordinates(points);
    }

    public Oracle_RecordAddress getNextRightAddress() {
        Oracle_RecordAddress rightAddress = null;
        rightAddress = new Oracle_RecordAddress();
        rightAddress.setStreetSide(2);
        String str = this.getFieldValue(KEY_RIGHT_STRUCT_COL_NAME);
        int type = 0;
        try {
            type = str != null ? (int)Double.parseDouble(str) : type;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        rightAddress.setOddEvenType(this.checkHNRType(type));
        String rightFrom = null;
        String rightTo = null;
        if (this.m_possiblePointData || rightAddress.getOddEvenType() != 0) {
            rightFrom = this.getFieldValue(KEY_RIGHTRANGE_FROM_COL_NAME);
            rightTo = this.getFieldValue(KEY_RIGHTRANGE_TO_COL_NAME);
        }
        if (rightTo != null && this.m_possiblePointData && (rightFrom == rightTo || rightFrom.equals(rightTo))) {
            rightTo = null;
        }
        rightAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(rightFrom));
        rightAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(rightTo));
        this.setAddressField(rightAddress, KEY_RIGHT_UNIT_PLACENAME_COL_NAME, FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_LEFT_RANGE_PLACENAME_COL_NAME, FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_PLACENAME_COL_NAME, FieldType.PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_STREET_COL_NAME, FieldType.STREET_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_COUNTRY_COL_NAME, FieldType.COUNTRY_FIELD_TYPE);
        this.handleGenericFieldsRightAddress(rightAddress);
        this.setCoordinates(rightAddress);
        this.setSACtoAddress(rightAddress, "RightSac");
        this.populateAdditionalFields(rightAddress);
        return rightAddress;
    }

    protected void handleGenericFieldsRightAddress(Oracle_RecordAddress rightAddress) {
        this.setGenericField(rightAddress, KEY_GENERIC_FIELD1_COL_NAME, KEY_RIGHT_GENERIC_FIELD1_COL_NAME, FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        this.setGenericField(rightAddress, KEY_GENERIC_FIELD2_COL_NAME, KEY_RIGHT_GENERIC_FIELD2_COL_NAME, FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }

    protected void setAddressField(RawAddress address, String fieldValue, FieldType fieldType) {
        String str = this.getFieldValue(fieldValue);
        address.setField(fieldType, new AddressFieldValue(str));
    }

    protected void setGenericField(RawAddress address, String genericFieldValue, String genericDirectionFieldValue, FieldType fieldType) {
        AddressFieldValue addFieldVal = null;
        String str = this.getFieldValue(genericFieldValue);
        if (str != null) {
            addFieldVal = new AddressFieldValue(str);
            address.setField(fieldType, addFieldVal);
        } else {
            str = this.getFieldValue(genericDirectionFieldValue);
            address.setField(fieldType, new AddressFieldValue(str));
        }
    }

    @Override
    public RawAddress getNextRecord() {
        if (this.m_rightRecord != null) {
            Oracle_RecordAddress record = this.m_rightRecord;
            this.m_rightRecord = null;
            return record;
        }
        Oracle_RecordAddress leftAddress = null;
        Oracle_RecordAddress rightAddress = null;
        try {
            if (this.m_resultSet.next()) {
                leftAddress = this.getNextLeftAddress();
                rightAddress = this.getNextRightAddress();
                this.populateAlternateFields(leftAddress, rightAddress);
                boolean useRightAddress = this.considerRightAddress(leftAddress, rightAddress);
                if (!useRightAddress) {
                    leftAddress.setStreetSide(0);
                    rightAddress = null;
                } else {
                    this.m_rightRecord = rightAddress;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return leftAddress;
    }

    protected boolean considerRightAddress(Oracle_RecordAddress left, Oracle_RecordAddress right) {
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.POST_CODE_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.POST_CODE_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.POST_CODE_EX_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.POST_CODE_EX_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_1_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_2_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_3_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_4_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            return true;
        }
        if (left.getOddEvenType() != right.getOddEvenType()) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE))) {
            return true;
        }
        return !this.bothValuesSame((AddressFieldValue)left.getField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE));
    }

    protected boolean bothValuesSame(AddressFieldValue left, AddressFieldValue right) {
        if (left != null) {
            return left.equals(right);
        }
        return right == null;
    }

    @Override
    protected void populateAdditionalFields(RawAddress addr) {
        if (m_dditionalFieldNames != null && m_dditionalFieldNames.size() > 0) {
            String str = null;
            String colName2 = null;
            for (String colName2 : m_dditionalFieldNames.keySet()) {
                str = this.getFieldValue(colName2);
                addr.setField((FieldType)m_dditionalFieldNames.get(colName2), new AddressFieldValue(str));
            }
        }
    }

    private DirectPosition[] getCoordinates(JGeometry jgeom) {
        if (jgeom != null) {
            int type = jgeom.getType();
            switch (type) {
                case 2: 
                case 5: {
                    int nPoints = jgeom.getNumPoints();
                    double[] ordinates = jgeom.getOrdinatesArray();
                    DirectPosition[] points = new DirectPosition[nPoints];
                    for (int i = 0; i < nPoints; ++i) {
                        points[i] = new DirectPosition(ordinates[i * 2], ordinates[i * 2 + 1]);
                    }
                    return points;
                }
                case 1: {
                    double[] p = jgeom.getPoint();
                    return new DirectPosition[]{new DirectPosition(p[0], p[1])};
                }
            }
            DataBuilder.m_consoleLogger.warn("Geometry type " + type + "not handled. Geometry will be ignored");
        }
        return null;
    }

    private int checkHNRType(int type) {
        if (type != 2 && type != 3 && type != 4 && type != 5) {
            type = 0;
        }
        return type;
    }

    @Override
    public boolean loadNextFileSet() {
        try {
            return this.m_resultSet != null && this.m_resultSet.isBeforeFirst();
        }
        catch (SQLException e) {
            throw new DataReadException(e);
        }
    }

    @Override
    public void rewind() {
        if (this.m_statement != null) {
            try {
                if (this.m_resultSet != null && this.m_resultSet.isBeforeFirst()) {
                    return;
                }
                if (this.m_resultSet != null && this.m_resultSet.getType() != 1003) {
                    this.m_resultSet.beforeFirst();
                } else {
                    if (this.m_resultSet != null) {
                        this.m_resultSet.close();
                        this.m_resultSet = null;
                    }
                    this.m_resultSet = this.m_statement.executeQuery(this.m_sqlQuery);
                }
            }
            catch (SQLException e) {
                throw new DataReadException(e);
            }
        }
    }

    @Override
    public String getCurrentFileSetName() {
        return null;
    }

    @Override
    public String getCoordSysString() {
        return this.m_coordSys;
    }

    protected void populateAlternateFields(RawAddress leftAddr, RawAddress rightAddr) {
        AddressFieldValue temp = null;
        String str = this.m_properties.getProperty(KEY_ALT_PLACENAME_COL_NAME);
        String[] retrieved = null;
        if (!this.isEmpty(str)) {
            retrieved = this.getAlternates(str);
            temp = (AddressFieldValue)leftAddr.getField(FieldType.PLACE_NAME_FIELD_TYPE);
            temp.setAlternateValues(retrieved);
            temp = (AddressFieldValue)rightAddr.getField(FieldType.PLACE_NAME_FIELD_TYPE);
            temp.setAlternateValues(retrieved);
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_STREET_COL_NAME))) {
            retrieved = this.getAlternates(str);
            temp = (AddressFieldValue)leftAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            temp.setAlternateValues(retrieved);
            temp = (AddressFieldValue)rightAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            temp.setAlternateValues(retrieved);
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_PC_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_PC_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_PC_EX_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_PC_EX_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_AREANAME4_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_AREANAME4_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_AREANAME3_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_AREANAME3_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_AREANAME2_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_AREANAME2_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_LEFT_AREANAME1_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_RIGHT_AREANAME1_COL_NAME))) {
            temp = (AddressFieldValue)rightAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        this.populateAlternateGenericFields(leftAddr, rightAddr);
    }

    protected void populateAlternateGenericFields(RawAddress leftAddr, RawAddress rightAddr) {
        AddressFieldValue temp = null;
        String str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD1_COL_NAME);
        if (!this.isEmpty(str)) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD2_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD3_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
        if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD4_COL_NAME))) {
            temp = (AddressFieldValue)leftAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
            temp.setAlternateValues(this.getAlternates(str));
        }
    }

    protected String[] getAlternates(String str) {
        String[] tokens = str.split(",");
        ArrayList<String> alternates = null;
        if (tokens != null && tokens.length > 0) {
            alternates = new ArrayList<String>();
            String value = null;
            for (String t : tokens) {
                value = this.getColumnValue(t);
                String[] strAlternates = null;
                if (this.isEmpty(value)) continue;
                if (this.m_altValsDelim == null) {
                    alternates.add(value);
                    continue;
                }
                for (String v : strAlternates = value.split(this.m_altValsDelim)) {
                    if (this.isEmpty(v)) continue;
                    alternates.add(v);
                }
            }
        }
        if (alternates != null && alternates.size() > 0) {
            return alternates.toArray(new String[alternates.size()]);
        }
        return null;
    }
}

