/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.AbstractJdbcRawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql.PostgreSQL_DataSource;
import com.mapinfo.midev.geometry.DirectPosition;

public class PostgreSQL_Reader
extends AbstractJdbcRawDataReader {
    public PostgreSQL_Reader() throws CGGEInternalException {
        super(new PostgreSQL_DataSource());
    }

    @Override
    protected boolean isValidAddressField(String str) {
        boolean isValid = false;
        if (str.equals("RecordCountry") || str.equals("LeftUnitPlaceName") || str.equals("RightUnitPlaceName") || str.equals("LeftRangePlaceName") || str.equals("RightRangePlaceName") || str.equals("PlaceName") || str.equals("Street") || str.equals("FromLeft") || str.equals("ToLeft") || str.equals("FromRight") || str.equals("ToRight") || str.equals("LeftStruct") || str.equals("RightStruct") || str.equals("LeftPostcode") || str.equals("RightPostcode") || str.equals("LeftPostcodeEx") || str.equals("RightPostcodeEx") || str.equals("LeftAreaName1") || str.equals("LeftAreaName2") || str.equals("LeftAreaName3") || str.equals("LeftAreaName4") || str.equals("RightAreaName1") || str.equals("RightAreaName2") || str.equals("RightAreaName3") || str.equals("RightAreaName4") || str.equals("Alt_PlaceName") || str.equals("Alt_Street") || str.equals("Alt_LeftPostcode") || str.equals("Alt_RightPostcode") || str.equals("Alt_LeftPostcodeEx") || str.equals("Alt_RightPostcodeEx") || str.equals("GenericField1") || str.equals("GenericField2") || str.equals("GenericField3") || str.equals("GenericField4") || str.equals("Alt_GenericField1") || str.equals("Alt_GenericField2") || str.equals("Alt_GenericField3") || str.equals("Alt_GenericField4") || str.equals("Alt_LeftAreaName1") || str.equals("Alt_LeftAreaName2") || str.equals("Alt_LeftAreaName3") || str.equals("Alt_LeftAreaName4") || str.equals("Alt_RightAreaName1") || str.equals("Alt_RightAreaName2") || str.equals("Alt_RightAreaName3") || str.equals("Alt_RightAreaName4") || str.equals("Sac") || str.equals("LeftSac") || str.equals("RightSac") || str.equals("IsSacFromFile") || str.equals("Combine_Alt_Vals_Delim") || m_dditionalFieldNames != null && m_dditionalFieldNames.containsKey(str) || str.equals("LeftGenericField1") || str.equals("RightGenericField1") || str.equals("LeftGenericField2") || str.equals("RightGenericField2")) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public RawAddress getNextLeftAddress(DirectPosition[] coordinates) {
        RawAddress leftAddress = super.getNextLeftAddress(coordinates);
        this.handleGenericFields(leftAddress, true);
        return leftAddress;
    }

    @Override
    public RawAddress getNextRightAddress(DirectPosition[] coordinates) {
        RawAddress rightAddress = super.getNextRightAddress(coordinates);
        this.handleGenericFields(rightAddress, false);
        return rightAddress;
    }

    private void handleGenericFields(RawAddress address, boolean isLeft) {
        String directional1ColName = isLeft ? "LeftGenericField1" : "RightGenericField1";
        String directional2ColName = isLeft ? "LeftGenericField2" : "RightGenericField2";
        this.setGenericField(address, "GenericField1", directional1ColName, FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        this.setGenericField(address, "GenericField2", directional2ColName, FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        this.setAddressField(address, "GenericField3", FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        this.setAddressField(address, "GenericField4", FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }

    private void setGenericField(RawAddress address, String genericFieldValue, String genericDirectionFieldValue, FieldType fieldType) {
        AddressFieldValue addFieldVal = null;
        String str = this.getFieldValue(genericFieldValue);
        if (str != null) {
            addFieldVal = new AddressFieldValue(str);
            address.setField(fieldType, addFieldVal);
        } else {
            str = this.getFieldValue(genericDirectionFieldValue);
            address.setField(fieldType, new AddressFieldValue(str));
        }
    }
}

