/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.sqlserver;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.AbstractJdbcRawDataSource;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.sql.DriverManager;
import java.util.Properties;
import oracle.spatial.geometry.JGeometry;

public class SQLServer_DataSource
extends AbstractJdbcRawDataSource {
    public SQLServer_DataSource() throws CGGEInternalException {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (ClassNotFoundException e) {
            throw new CGGEInternalException(e);
        }
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        this.properties = SQLServer_DataSource.loadColumnMappings(prop, "SQLServer");
        String connURL = this.properties.getProperty("connection_url");
        if (connURL == null) {
            throw new CGGEInternalException("No connection URL specified. Cannot connect to the database");
        }
        String userID = this.properties.getProperty("user_id");
        String password = this.properties.getProperty("password");
        if (userID == null || userID.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No UserID provided");
        }
        if (password == null || password.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No Password provided");
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", userID);
        connectionProperties.put("password", password);
        connectionProperties.put("prefetch", "1000");
        connectionProperties.put("prefetch", "100");
        this.sqlQuery = this.properties.getProperty("select_statment");
        String sqlWhereClause = this.properties.getProperty("where_clause");
        if (this.sqlQuery == null || this.sqlQuery.trim().length() == 0) {
            throw new CGGEInternalException("No select statment specified");
        }
        try {
            this.prepareSacMappings(this.properties);
            this.properties.remove("IsSacFromFile");
        }
        catch (InvalidSacException e) {
            DataBuilder.m_consoleLogger.error("Data build is terminated: SAC mapping not specified or invalid.");
            DataBuilder.m_consoleLogger.error(e.getMessage());
            throw e;
        }
        this.setCoordSysString(prop.getProperty("coordinate_system"));
        this.properties.remove("connection_url");
        this.properties.remove("user_id");
        this.properties.remove("password");
        this.properties.remove("select_statment");
        this.properties.remove("where_clause");
        this.conn = DriverManager.getConnection(connURL, connectionProperties);
        this.statement = this.conn.createStatement();
        this.resultSet = this.statement.executeQuery(this.sqlQuery);
        this.setFieldLookup(this.resultSet);
        this.confirmMappedFields(this.properties);
        boolean possiblePointData = false;
        if (SQLServer_DataSource.isEmpty((String)this.properties.get("LeftStruct")) && SQLServer_DataSource.isEmpty((String)this.properties.get("RightStruct"))) {
            possiblePointData = true;
        }
        this.setPossiblePointData(possiblePointData);
        return true;
    }

    private DoublePoint[] getCoordinates(JGeometry jgeom) {
        if (jgeom != null) {
            int type = jgeom.getType();
            switch (type) {
                case 2: 
                case 5: {
                    int nPoints = jgeom.getNumPoints();
                    double[] ordinates = jgeom.getOrdinatesArray();
                    DoublePoint[] points = new DoublePoint[nPoints];
                    for (int i = 0; i < nPoints; ++i) {
                        points[i] = new DoublePoint(ordinates[i * 2], ordinates[i * 2 + 1]);
                    }
                    return points;
                }
                case 1: {
                    double[] p = jgeom.getPoint();
                    return new DoublePoint[]{new DoublePoint(p)};
                }
            }
            DataBuilder.m_consoleLogger.warn("Geometry type " + type + "not handled. Geometry will be ignored");
        }
        return null;
    }

    @Override
    public DirectPosition[] getCoordinates() {
        return null;
    }
}

