/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.tab;

import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.TAB_Reader;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.data.ICursor;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.data.ITable;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.AttributeType;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.feature.IGeometryAttributeDefinition;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.table.Table;
import com.mapinfo.midev.tabledepot.TableDepot;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAB_DataSource
extends StandardRawDataSource {
    static final Logger logger = LoggerFactory.getLogger(TAB_DataSource.class);
    private Map<String, String> currentRow = new HashMap<String, String>();
    private IDataSourceTable miTable;
    private String geometryColumnName;
    private CoordSys coordSys;
    private File[] tabFiles;
    private ICursor recordSet;
    private String tabName;
    private int currentFile;
    private String tabPath;
    private String nameStartsWith;
    private boolean geometryErrorReported;
    private Properties properties;
    private Map<String, List<String>> fieldLookup = new HashMap<String, List<String>>();

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        this.properties = TAB_DataSource.loadColumnMappings(prop, "Tab");
        this.tabPath = (String)prop.get("inputPath");
        this.nameStartsWith = (String)this.properties.get(TAB_Reader.KEY_TAB_FILE);
        try {
            this.prepareSacMappings(this.properties);
            this.properties.remove("IsSacFromFile");
        }
        catch (InvalidSacException e) {
            DataBuilder.m_consoleLogger.error("Data build is terminated: SAC mapping not specified or invalid.");
            DataBuilder.m_consoleLogger.error(e.getMessage());
            throw e;
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (entry.getValue() == null) continue;
            if (this.fieldLookup.get((String)entry.getValue()) == null) {
                this.fieldLookup.put((String)entry.getValue(), new ArrayList());
            }
            this.fieldLookup.get((String)entry.getValue()).add((String)entry.getKey());
        }
        File f = new File(this.tabPath);
        FilenameFilter tabFileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String str) {
                return (str = str.toUpperCase()) != null && str.startsWith(TAB_DataSource.this.nameStartsWith.toUpperCase()) && str.endsWith(".TAB");
            }
        };
        this.tabFiles = f.listFiles(tabFileNameFilter);
        this.currentFile = -1;
        this.properties.remove(TAB_Reader.KEY_TAB_FILE);
        if (this.tabFiles == null || this.tabFiles.length == 0) {
            DataBuilder.m_consoleLogger.error("No tables found at " + this.tabPath);
            return false;
        }
        this.openDataSet(this.tabPath, this.tabFiles[0].getName());
        return true;
    }

    public void openDataSet(String tabPath, String tabName) throws Exception {
        DataBuilder.m_consoleLogger.info("Input file name: " + tabPath + "/" + tabName);
        if (this.miTable != null) {
            this.miTable.close();
            this.miTable = null;
        }
        NativeDataProvider dp = NativeDataProvider.getInstance();
        this.miTable = dp.openTable(new File(tabPath, tabName));
        this.writeMetaData(this.miTable);
        this.setColumnInfo(this.miTable);
        this.confirmMappedFieldsLocal(this.miTable, this.properties);
        this.confirmMappedFields(this.properties);
    }

    private void confirmMappedFieldsLocal(IDataSourceTable miTable, Properties properties) throws IOException {
        AttributeDefinitionCollection cols = miTable.getMetadata().getAttributeDefinitions();
        for (IAttributeDefinition col : cols) {
            String colName = col.getName();
            if (properties.values().contains(colName)) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (!colName.equals(entry.getValue())) continue;
                    System.out.printf("%-20.20s : %s\n", colName, entry.getKey());
                }
                continue;
            }
            System.out.printf("%-20.20s : %s\n", colName, "(unmapped)");
        }
    }

    public void setColumnInfo(IDataSourceTable miTable) throws IOException {
        AttributeDefinitionCollection cols = miTable.getMetadata().getAttributeDefinitions();
        HashMap<String, Object> columnInfo = new HashMap<String, Object>();
        for (IAttributeDefinition col : cols) {
            columnInfo.put(col.getName().toLowerCase(), null);
            if (col.getDataType() != AttributeType.FEATURE_GEOMETRY) continue;
            this.geometryColumnName = col.getName();
            this.coordSys = ((IGeometryAttributeDefinition)col).getSpatialInfo().getCoordSys();
            if (this.coordSys == null) continue;
            this.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)this.coordSys));
        }
        this.setColumnInfo(columnInfo);
    }

    public void writeMetaData(IDataSourceTable miTable) throws IOException {
        if (miTable != null) {
            ITableMetadata md = miTable.getMetadata();
            AttributeDefinitionCollection attributeDefinitions = md.getAttributeDefinitions();
            block9: for (IAttributeDefinition cmd : attributeDefinitions) {
                switch (cmd.getDataType()) {
                    case CHAR: {
                        logger.debug(String.format("%s char[%s]", cmd.getName(), cmd.getWidth()));
                        continue block9;
                    }
                    case DATE: {
                        logger.debug(String.format("%s date", cmd.getName()));
                        continue block9;
                    }
                    case DOUBLE: {
                        logger.debug(String.format("%s decimal[%d, %d]", cmd.getName(), cmd.getWidth() - cmd.getDecimals(), cmd.getDecimals()));
                        continue block9;
                    }
                    case FLOAT: {
                        logger.debug(String.format("%s float", cmd.getName()));
                        continue block9;
                    }
                    case INTEGER: {
                        logger.debug(String.format("%s int", cmd.getName()));
                        continue block9;
                    }
                    case BOOLEAN: {
                        logger.debug(String.format("%s bool", cmd.getName()));
                        continue block9;
                    }
                    case SHORT_INTEGER: {
                        logger.debug(String.format("%s smallint", cmd.getName()));
                        continue block9;
                    }
                }
                logger.debug(String.format("%s other", cmd.getName()));
            }
        }
    }

    @Override
    public void close() {
        if (this.miTable != null) {
            if (!this.miTable.isClosed()) {
                this.miTable.close();
            }
            this.miTable = null;
        }
    }

    @Override
    public String getCurrentFileSetName() {
        return this.tabName;
    }

    @Override
    public boolean hasNext() {
        if (this.recordSet == null) {
            return false;
        }
        return this.recordSet.hasNext();
    }

    @Override
    public Map<String, String> next() {
        if (!this.recordSet.hasNext()) {
            throw new NoSuchElementException();
        }
        IFeature feature = this.recordSet.next();
        this.currentRow.clear();
        for (String key : this.fieldLookup.keySet()) {
            if (key.isEmpty() || this.miTable.getMetadata().getAttributeDefinitions().get(key) == null || this.fieldLookup.get(key) == null) continue;
            IAttributeDefinition metadata = this.miTable.getMetadata().getAttributeDefinitions().get(key);
            if (metadata != null && metadata.getDataType() == AttributeType.DOUBLE && metadata.getDecimals() == 0) {
                for (String k : this.fieldLookup.get(key)) {
                    this.currentRow.put(k, String.valueOf((long)feature.getDouble(key)));
                }
                continue;
            }
            String value = feature.getString(key);
            for (String k : this.fieldLookup.get(key)) {
                this.currentRow.put(k, value);
            }
        }
        this.currentRow.put("Geometry", TAB_DataSource.getWKT(feature, this.geometryColumnName, this.coordSys));
        this.setCurrentRow(this.currentRow);
        return this.currentRow;
    }

    @Override
    public boolean loadNextFileSet() {
        int fileCount;
        int n = fileCount = this.tabFiles == null ? 0 : this.tabFiles.length;
        if (fileCount > 0 && ++this.currentFile < fileCount) {
            try {
                if (this.recordSet != null) {
                    this.recordSet.dispose();
                    this.recordSet = null;
                }
                if (this.miTable != null) {
                    if (!this.miTable.isClosed()) {
                        this.miTable.close();
                    }
                    this.miTable = null;
                }
                String fileName = this.tabFiles[this.currentFile].getName();
                try {
                    this.openDataSet(this.tabPath, fileName);
                    this.tabName = fileName;
                }
                catch (Exception e) {
                    DataBuilder.m_consoleLogger.error("Exception opening table " + fileName, (Throwable)e);
                    throw new RuntimeException(e);
                }
                if (this.recordSet == null && this.miTable != null) {
                    String tableName = this.miTable.getDefinition().getName();
                    TableDepot tableDepot = new TableDepot();
                    Table table = new Table(this.miTable);
                    tableDepot.add(tableName, (ITable)table);
                    String query = "select * from " + tableName;
                    this.recordSet = tableDepot.search(query);
                }
            }
            catch (Exception e) {
                DataBuilder.m_consoleLogger.error("", (Throwable)e);
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void rewind() {
        this.currentFile = -1;
        if (this.miTable != null) {
            if (this.recordSet != null) {
                this.recordSet.dispose();
            }
            this.recordSet = null;
        }
        if (this.miTable != null && !this.miTable.isClosed()) {
            this.miTable.close();
        }
    }

    @Override
    public DirectPosition[] getCoordinates() {
        return null;
    }

    public static String getWKT(IFeature feature, String geometryColumn, CoordSys coordSys) {
        IFeatureGeometry geom = feature.getFeatureGeometry(geometryColumn);
        CoordinateSequence coordinates = TAB_DataSource.getCoordinates(geom, coordSys);
        String wkt = null;
        if (coordinates != null && coordinates.size() != 0) {
            wkt = coordinates.size() == 1 ? WKTWriter.toPoint((Coordinate)coordinates.getCoordinate(0)) : WKTWriter.toLineString((CoordinateSequence)coordinates);
        }
        return wkt;
    }

    private static CoordinateSequence getCoordinates(IFeatureGeometry geom, CoordSys coordSys) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (geom.getType() == GeometryType.MULTI_CURVE) {
            ArrayList points = MidevConversionUtils.getPoints((IMultiCurve)((IMultiCurve)geom), (CoordSys)coordSys);
            for (DirectPosition point : points) {
                coordinates.add(new Coordinate(point.getX(), point.getY()));
            }
        } else if (geom.getType() == GeometryType.POINT) {
            DirectPosition point = geom.getRepresentativePoint();
            coordinates.add(new Coordinate(point.getX(), point.getY()));
        } else {
            DataBuilder.m_consoleLogger.warn("Unsupported geometry type! Only MultiCurve and Point geometry currently supported");
        }
        if (coordinates.size() > 0) {
            return new CoordinateArraySequence(coordinates.toArray(new Coordinate[coordinates.size()]));
        }
        return null;
    }
}

