/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.IRawDataDestination;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVPrinter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSV_DataDestination
implements IRawDataDestination<String> {
    private static final Logger LOG = LoggerFactory.getLogger(DSV_DataDestination.class);
    private String[] colNames;
    private DSVPrinter p;

    public DSV_DataDestination(PrintWriter pw, DSVFormat format) {
        try {
            this.p = new DSVPrinter(pw, format);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DSV_DataDestination(PrintStream ps, DSVFormat format) {
        this(new PrintWriter(new OutputStreamWriter(ps)), format);
    }

    @Override
    public void writeHeader(String[] colNames) {
        this.colNames = colNames;
        try {
            this.p.printRecord(colNames);
        }
        catch (IOException e) {
            LOG.info("error writing header: " + e.getMessage());
        }
    }

    @Override
    public void writeData(Map<String, String> data) {
        String[] values = new String[this.colNames.length];
        for (int i = 0; i < this.colNames.length; ++i) {
            String value;
            if (!data.containsKey(this.colNames[i]) || (value = data.get(this.colNames[i])) == null) continue;
            values[i] = String.valueOf(value);
        }
        try {
            this.p.printRecord(values);
        }
        catch (IOException e) {
            LOG.info("error writing values: " + e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.p.flush();
        }
        catch (IOException e) {
            LOG.info("error flushing data: " + e.getMessage());
        }
    }
}

