/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVParser;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVRecord;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DataFile;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DSV_DataSource
extends StandardRawDataSource {
    public static final Logger logger = LoggerFactory.getLogger(DSV_DataSource.class);
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected DataFile dataFile;
    protected Reader reader;
    private String[] columnList = EMPTY_STRING_ARRAY;
    private Map<String, String> currentRow = new HashMap<String, String>();
    private Properties properties = new Properties();
    private boolean hasNext;
    private boolean cachedHasNext;
    private DSVFormat format;
    private Iterator<DSVRecord> iter;
    private static final String SKIP_HEADER = "skipHeader";
    private static boolean skipHeader = false;
    private Map<String, List<String>> fieldLookup = new HashMap<String, List<String>>();

    protected DSV_DataSource(DSVFormat format) {
        this.setFormat(format);
    }

    protected void setFormat(DSVFormat format) {
        this.format = format;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        this.properties.putAll((Map<?, ?>)prop);
        this.properties.remove("inputPath");
        skipHeader = Boolean.parseBoolean((String)this.properties.get(SKIP_HEADER));
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (DSV_DataSource.isEmpty((String)entry.getValue())) continue;
            String name = ((String)entry.getValue()).trim();
            if (!this.fieldLookup.containsKey(name)) {
                this.fieldLookup.put(name, new ArrayList());
            }
            this.fieldLookup.get(name).add((String)entry.getKey());
        }
        try {
            this.prepareSacMappings(this.properties);
            this.setPossiblePointData(false);
            if (DSV_DataSource.isEmpty((String)this.properties.get("LeftStruct")) && DSV_DataSource.isEmpty((String)this.properties.get("RightStruct"))) {
                this.setPossiblePointData(true);
            }
        }
        catch (InvalidSacException ise) {
            DataBuilder.m_consoleLogger.error("Data build terminated: SAC mapping not specified or invalid");
            DataBuilder.m_consoleLogger.error(ise.getMessage());
            throw ise;
        }
        this.setCoordSysString("WSG84");
        return true;
    }

    @Override
    public boolean loadNextFileSet() {
        if (this.reader != null) {
            return false;
        }
        boolean success = true;
        try {
            this.reader = this.loadReader();
            this.columnList = new String[0];
            if (this.reader != null) {
                this.loadFieldLookup(this.reader);
                this.reader.close();
                this.reader = this.loadReader();
                this.iter = this.format.withHeader(this.columnList).withSkipHeaderRecord(skipHeader).parse(this.reader).iterator();
            }
        }
        catch (IOException e) {
            logger.debug("exception: " + e.getMessage());
            success = false;
        }
        return success;
    }

    protected Reader loadReader() throws IOException {
        return this.loadReader(this.dataFile);
    }

    protected Reader loadReader(DataFile file) throws IOException {
        return this.loadReader(file.getInputStream());
    }

    protected Reader loadReader(InputStream is) throws IOException {
        BOMInputStream bis = new BOMInputStream(is);
        String charsetName = bis.getBOM() == null ? "UTF-8" : bis.getBOM().getCharsetName();
        InputStreamReader reader = new InputStreamReader((InputStream)bis, Charset.forName(charsetName));
        return reader;
    }

    @Override
    public boolean hasNext() {
        String wkt;
        int i;
        if (this.cachedHasNext) {
            return this.hasNext;
        }
        String[] values = new String[this.columnList.length];
        this.cachedHasNext = true;
        this.hasNext = false;
        if (!this.iter.hasNext()) {
            this.cachedHasNext = false;
            return false;
        }
        this.currentRow.clear();
        DSVRecord record = null;
        while ((this.hasNext = this.iter.hasNext()) && this.columnList.length != (record = this.iter.next()).size()) {
            logger.info(String.format("error in CSV file : length: %d, expected %d", record.size(), this.columnList.length));
            logger.info(String.format("bad string: %s", record.getActualLine()));
        }
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = true;
        for (i = 0; i < values.length; ++i) {
            values[i] = (String)record.get(i);
        }
        for (i = 0; i < this.columnList.length && i < values.length; ++i) {
            if (!this.fieldLookup.containsKey(this.columnList[i])) continue;
            for (String field : this.fieldLookup.get(this.columnList[i])) {
                this.currentRow.put(field, values[i] == null ? "" : values[i]);
            }
        }
        if (this.fieldLookup.containsKey("LOW_HSE_NBR")) {
            List<String> lowList = this.fieldLookup.get("LOW_HSE_NBR");
            List<String> highList = this.fieldLookup.get("HIGH_HSE_NBR");
            if (!lowList.isEmpty() && !highList.isEmpty()) {
                String s;
                String[] ss;
                String lowStr = lowList.get(0);
                String highStr = highList.get(0);
                if (lowStr.startsWith("X") && (ss = lowStr.split(" ")).length > 1) {
                    s = Integer.valueOf(ss[1], 10).toString();
                    this.currentRow.put("FromLeft", s);
                    this.currentRow.put("FromRight", s);
                }
                if (highStr.startsWith("X") && (ss = highStr.split(" ")).length > 1) {
                    s = Integer.valueOf(ss[1], 10).toString();
                    this.currentRow.put("ToLeft", s);
                    this.currentRow.put("ToRight", s);
                }
            }
        }
        this.setCurrentRow(this.currentRow);
        if (this.currentRow.containsKey("geom.latitude") && this.currentRow.containsKey("geom.longitude") && (wkt = this.getGeometryWKT()) != null) {
            this.currentRow.put("Geometry", wkt);
        }
        return this.hasNext;
    }

    @Override
    public Map<String, String> next() {
        this.hasNext();
        this.cachedHasNext = false;
        return this.currentRow;
    }

    @Override
    public void rewind() {
        this.currentRow.clear();
        try {
            if (this.reader != null) {
                this.reader.close();
                this.loadReader();
            }
        }
        catch (IOException e) {
            this.reader = null;
        }
    }

    @Override
    public void close() {
        this.currentRow.clear();
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.reader = null;
        }
    }

    @Override
    public DirectPosition[] getCoordinates() {
        DirectPosition[] coordinates = null;
        return coordinates;
    }

    @Override
    public String getCurrentFileSetName() {
        try {
            return this.dataFile.getCurrentFileSetName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadFieldLookup(Reader reader) throws IOException {
        this.columnList = this.getColumnList(reader);
        if (this.columnList != EMPTY_STRING_ARRAY) {
            this.properties.clear();
            for (String name : this.columnList) {
                this.properties.put(name, name);
            }
            this.fixFieldLookupCase(this.columnList, this.fieldLookup);
        }
    }

    protected String[] getColumnList(Reader reader) throws IOException {
        DSVParser parser;
        Iterator<DSVRecord> iter;
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = lnr.readLine();
        String[] coloumListLocal = EMPTY_STRING_ARRAY;
        if (line != null && (iter = (parser = this.format.withSkipHeaderRecord(false).parse(new StringReader(line))).iterator()).hasNext()) {
            DSVRecord record = iter.next();
            coloumListLocal = new String[record.size()];
            for (int i = 0; i < record.size(); ++i) {
                coloumListLocal[i] = (String)record.get(i);
            }
        }
        return coloumListLocal;
    }

    @Override
    public void fixFieldLookupCase(String[] columnList, Map<String, List<String>> fieldLookup) {
        ArrayList<String> keys = new ArrayList<String>(fieldLookup.keySet());
        for (String column : columnList) {
            for (String key : keys) {
                if (column.equals(key) || !column.equalsIgnoreCase(key)) continue;
                List<String> value = fieldLookup.get(key);
                fieldLookup.put(column, value);
                fieldLookup.remove(key);
            }
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    DataFile getNewDataFile(File file) {
        return new DSVDataFile(file);
    }

    final class DSVDataFile
    implements DataFile {
        private final File file;

        DSVDataFile(File file) {
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream is = null;
            is = this.file.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(this.file)) : new FileInputStream(this.file);
            return is;
        }

        @Override
        public String getCurrentFileSetName() throws IOException {
            return this.file.getCanonicalFile().getAbsolutePath();
        }
    }
}

