/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.AbstractTextDataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DataFile;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Zip_DataSource
extends AbstractTextDataSource {
    private String zipFileName;

    public Zip_DataSource() {
        this(DSVFormat.TDF);
    }

    public Zip_DataSource(DSVFormat format) {
        super(format);
    }

    @Override
    public boolean loadDataConfigAndData(Properties dataConfig, String dataPath) throws Exception {
        this.zipFileName = dataConfig.getProperty("ZipFile");
        if (this.zipFileName == null && MMUtils.isEmpty(this.zipFileName)) {
            logger.debug("zip file not specified");
            return false;
        }
        return super.loadDataConfigAndData(dataConfig, dataPath);
    }

    @Override
    protected List<DataFile> loadFiles(String pathStr, String fileNamePat) throws Exception {
        Path path = Paths.get(MMUtils.appendToPath(pathStr, this.zipFileName), new String[0]);
        FileSystem zipFs = FileSystems.newFileSystem(path, null);
        final PathMatcher pathMatcher = zipFs.getPathMatcher("glob:" + fileNamePat);
        final ArrayList<DataFile> fileList = new ArrayList<DataFile>();
        for (Path subPath : zipFs.getRootDirectories()) {
            Files.walkFileTree(subPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (pathMatcher.matches(file)) {
                        fileList.add(new ZipDataFile(file));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return fileList;
    }

    private class ZipDataFile
    implements DataFile {
        private final Path filePath;

        ZipDataFile(Path filePath) {
            this.filePath = filePath;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }

        @Override
        public String getCurrentFileSetName() throws IOException {
            return this.filePath.toString();
        }
    }
}

